/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.seed;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.config.ContextualConfigurationProvider;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.io.GeoWebCacheXStream;
import org.geowebcache.rest.GWCRestlet;
import org.geowebcache.rest.RestletException;
import org.json.JSONObject;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public abstract class GWCSeedingRestlet
extends GWCRestlet {
    private static Log log = LogFactory.getLog(GWCSeedingRestlet.class);
    public JSONObject myrequest;
    protected XMLConfiguration xmlConfig;

    public void handle(Request request, Response response) {
        block5: {
            Method met = request.getMethod();
            try {
                if (met.equals((Object)Method.GET)) {
                    this.doGet(request, response);
                    break block5;
                }
                if (met.equals((Object)Method.POST)) {
                    this.doPost(request, response);
                    break block5;
                }
                throw new RestletException("Method not allowed", Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            }
            catch (RestletException re) {
                response.setEntity(re.getRepresentation());
                response.setStatus(re.getStatus());
            }
            catch (IOException ioe) {
                response.setEntity("Encountered IO error " + ioe.getMessage(), MediaType.TEXT_PLAIN);
                response.setStatus(Status.SERVER_ERROR_INTERNAL);
            }
        }
    }

    public abstract void doGet(Request var1, Response var2) throws RestletException;

    public void doPost(Request req, Response resp) throws RestletException, IOException {
        String formatExtension = (String)req.getAttributes().get("extension");
        XStream xs = this.configXStream((XStream)new GeoWebCacheXStream((HierarchicalStreamDriver)new DomDriver()));
        Object obj = null;
        if (formatExtension == null || formatExtension.equalsIgnoreCase("xml")) {
            obj = xs.fromXML(req.getEntity().getStream());
        } else if (formatExtension.equalsIgnoreCase("json")) {
            obj = xs.fromXML(this.convertJson(req.getEntity().getText()));
        } else {
            throw new RestletException("Format extension unknown or not specified: " + formatExtension, Status.CLIENT_ERROR_BAD_REQUEST);
        }
        this.handleRequest(req, resp, obj);
    }

    protected abstract void handleRequest(Request var1, Response var2, Object var3);

    private String convertJson(String entityText) throws IOException {
        JettisonMappedXmlDriver driver = new JettisonMappedXmlDriver();
        StringReader reader = new StringReader(entityText);
        HierarchicalStreamReader hsr = driver.createReader((Reader)reader);
        StringWriter writer = new StringWriter();
        new HierarchicalStreamCopier().copy(hsr, (HierarchicalStreamWriter)new PrettyPrintWriter((Writer)writer));
        writer.close();
        return writer.toString();
    }

    public void setXmlConfig(XMLConfiguration xmlConfig) {
        this.xmlConfig = xmlConfig;
    }

    protected XStream configXStream(XStream xs) {
        return this.xmlConfig.getConfiguredXStreamWithContext(xs, ContextualConfigurationProvider.Context.REST);
    }
}

