/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.filter;

import java.io.IOException;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.filter.request.WMSRasterFilter;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.rest.RestletException;
import org.geowebcache.rest.filter.XmlFilterUpdate;
import org.restlet.data.Status;

public class WMSRasterFilterUpdate
extends XmlFilterUpdate {
    String gridSetId;
    int zoomStart;
    int zoomStop;

    @Override
    protected void runUpdate(RequestFilter filter, TileLayer tl) throws IOException, RestletException {
        if (!(filter instanceof WMSRasterFilter)) {
            throw new RestletException("The filter " + filter.getName() + " is not a WMSRasterFilter.", Status.CLIENT_ERROR_BAD_REQUEST);
        }
        WMSRasterFilter wmsFilter = (WMSRasterFilter)filter;
        if (tl.getGridSubset(this.gridSetId) == null) {
            throw new RestletException("The filter " + wmsFilter.getName() + " is associated with a layer that does not support " + this.gridSetId, Status.CLIENT_ERROR_BAD_REQUEST);
        }
        try {
            wmsFilter.update(tl, this.gridSetId, this.zoomStart, this.zoomStop);
        }
        catch (GeoWebCacheException e) {
            throw new RestletException("Error updating " + wmsFilter.getName() + ": " + e.getMessage(), Status.SERVER_ERROR_INTERNAL);
        }
    }
}

