/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.resource.Resource;

public class GWCResource
extends Resource {
    private static Log log = LogFactory.getLog(GWCResource.class);

    public GWCResource(Context context, Request request, Response response) {
        super(context, request, response);
    }

    void checkPosMediaType(Representation entity) throws GeoWebCacheException {
        String remoteAdr = this.getRequest().getClientInfo().getAddress();
        if (entity == null || !entity.getMediaType().includes(MediaType.APPLICATION_XML) && !entity.getMediaType().includes(MediaType.APPLICATION_JSON)) {
            String message = "Request from " + remoteAdr + " did not specify MIME type" + " of the document posted. Please specify application/xml " + " or application/json";
            throw new GeoWebCacheException(message);
        }
        log.info((Object)("Received seed request from  " + remoteAdr));
    }

    void writeError(Status status, String message) {
        log.error((Object)message);
        this.getResponse().setStatus(status, message);
    }
}

