/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.lobobrowser.util.io.BufferExceededException;

public class RecordedInputStream
extends InputStream {
    private final InputStream delegate;
    private final ByteArrayOutputStream store = new ByteArrayOutputStream();
    private final int maxBufferSize;
    private boolean hasReachedEOF = false;
    private boolean hasReachedMaxBufferSize = false;
    private int markPosition = -1;
    private int readPosition = -1;
    private byte[] resetBuffer = null;

    public RecordedInputStream(InputStream inputStream, int n) {
        this.delegate = inputStream;
        this.maxBufferSize = n;
    }

    public int read() throws IOException {
        if (this.readPosition != -1 && this.readPosition < this.resetBuffer.length) {
            byte by = this.resetBuffer[this.readPosition];
            ++this.readPosition;
            return by;
        }
        int n = this.delegate.read();
        if (n != -1) {
            if (!this.hasReachedMaxBufferSize) {
                this.store.write(n);
                if (this.store.size() > this.maxBufferSize) {
                    this.hasReachedMaxBufferSize = true;
                }
            }
        } else {
            this.hasReachedEOF = true;
        }
        return n;
    }

    public int available() throws IOException {
        return this.delegate.available();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void mark(int n) {
        if (this.hasReachedMaxBufferSize) {
            throw new IllegalStateException("Maximum buffer size was already reached.");
        }
        this.markPosition = this.store.size();
    }

    public synchronized void reset() throws IOException {
        if (this.hasReachedMaxBufferSize) {
            throw new IllegalStateException("Maximum buffer size was already reached.");
        }
        int n = this.markPosition;
        byte[] byArray = this.store.toByteArray();
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        this.resetBuffer = byArray2;
        this.readPosition = 0;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.readPosition != -1 && this.readPosition < this.resetBuffer.length) {
            int n3 = Math.min(this.resetBuffer.length - this.readPosition, n2);
            System.arraycopy(this.resetBuffer, this.readPosition, byArray, n, n3);
            this.readPosition += n3;
            return n3;
        }
        int n4 = this.delegate.read(byArray, n, n2);
        if (n4 != -1) {
            if (!this.hasReachedMaxBufferSize) {
                this.store.write(byArray, n, n4);
                if (this.store.size() > this.maxBufferSize) {
                    this.hasReachedMaxBufferSize = true;
                }
            }
        } else {
            this.hasReachedEOF = true;
        }
        return n4;
    }

    public void consumeToEOF() throws IOException {
        byte[] byArray = new byte[8192];
        while (this.read(byArray) != -1) {
        }
    }

    public byte[] getBytesRead() throws BufferExceededException {
        if (this.hasReachedMaxBufferSize) {
            throw new BufferExceededException();
        }
        return this.store.toByteArray();
    }

    public String getString(String string) throws UnsupportedEncodingException, BufferExceededException {
        if (this.hasReachedMaxBufferSize) {
            throw new BufferExceededException();
        }
        byte[] byArray = this.store.toByteArray();
        return new String(byArray, string);
    }

    public boolean hasReachedEOF() {
        return this.hasReachedEOF;
    }
}

