/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ID {
    private static final Random RANDOM1;
    private static final Random RANDOM2;
    private static final Random RANDOM3;
    private static final long globalProcessID;
    private static final Logger logger;

    private ID() {
    }

    public static long generateLong() {
        return Math.abs(RANDOM1.nextLong() ^ RANDOM2.nextLong() ^ RANDOM3.nextLong());
    }

    public static int generateInt() {
        return (int)ID.generateLong();
    }

    public static byte[] getMD5Bytes(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            return messageDigest.digest(string.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(noSuchAlgorithmException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
    }

    public static String getHexString(byte[] byArray) {
        BigInteger bigInteger = BigInteger.ZERO;
        int n = 0;
        int n2 = byArray.length;
        while (--n2 >= 0) {
            BigInteger bigInteger2 = BigInteger.valueOf(byArray[n2] & 0xFF);
            bigInteger2 = bigInteger2.shiftLeft(n);
            bigInteger = bigInteger.add(bigInteger2);
            n += 8;
        }
        return bigInteger.toString(16).toUpperCase();
    }

    public static long getGlobalProcessID() {
        return globalProcessID;
    }

    public static int random(int n, int n2) {
        if (n2 <= n) {
            return n;
        }
        return Math.abs(RANDOM1.nextInt()) % (n2 - n) + n;
    }

    static {
        long l;
        logger = Logger.getLogger(ID.class.getName());
        long l2 = System.currentTimeMillis();
        long l3 = System.nanoTime();
        long l4 = Runtime.getRuntime().freeMemory();
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            l = inetAddress.getHostName().hashCode() ^ inetAddress.getHostAddress().hashCode();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Unable to get local host information.", exception);
            l = ID.class.hashCode();
        }
        globalProcessID = l2 ^ l3 ^ l4 ^ l;
        RANDOM1 = new Random(l2);
        RANDOM2 = new Random(l3);
        RANDOM3 = new Random(l ^ l4);
    }
}

