/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class History
implements Serializable {
    private static final long serialVersionUID = 2257845000800300100L;
    private transient ArrayList historySequence;
    private final SortedSet historySortedSet = new TreeSet();
    private final Map historyMap = new HashMap();
    private final SortedSet historyTimedSet = new TreeSet();
    private int sequenceCapacity;
    private int commonEntriesCapacity;
    private transient int sequenceIndex = -1;

    public History(int n, int n2) {
        this.historySequence = new ArrayList();
        this.sequenceCapacity = n;
        this.commonEntriesCapacity = n2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.historySequence = new ArrayList();
        this.sequenceIndex = -1;
        objectInputStream.defaultReadObject();
    }

    public int getCommonEntriesCapacity() {
        return this.commonEntriesCapacity;
    }

    public void setCommonEntriesCapacity(int n) {
        this.commonEntriesCapacity = n;
    }

    public int getSequenceCapacity() {
        return this.sequenceCapacity;
    }

    public void setSequenceCapacity(int n) {
        this.sequenceCapacity = n;
    }

    public String getCurrentItem() {
        if (this.sequenceIndex >= 0) {
            return (String)this.historySequence.get(this.sequenceIndex);
        }
        return null;
    }

    public String back() {
        if (this.sequenceIndex > 0) {
            --this.sequenceIndex;
            return this.getCurrentItem();
        }
        return null;
    }

    public String forward() {
        if (this.sequenceIndex + 1 < this.historySequence.size()) {
            ++this.sequenceIndex;
            return this.getCurrentItem();
        }
        return null;
    }

    public Collection getRecentItems(int n) {
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator iterator = this.historyTimedSet.iterator();
        int n2 = 0;
        while (iterator.hasNext() && n2++ < n) {
            TimedEntry timedEntry = (TimedEntry)iterator.next();
            linkedList.add(timedEntry.value);
        }
        return linkedList;
    }

    public Collection getHeadMatchItems(String string, int n) {
        String string2;
        Object[] objectArray = this.historySortedSet.toArray();
        int n2 = Arrays.binarySearch(objectArray, string);
        int n3 = n2 >= 0 ? n2 : -n2 - 1;
        int n4 = 0;
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = n3; i < objectArray.length && n4++ < n && (string2 = (String)objectArray[i]).startsWith(string); ++i) {
            linkedList.add(string2);
        }
        return linkedList;
    }

    public void addAsRecentOnly(String string) {
        TimedEntry timedEntry = (TimedEntry)this.historyMap.get(string);
        if (timedEntry != null) {
            this.historyTimedSet.remove(timedEntry);
            timedEntry.touch();
            this.historyTimedSet.add(timedEntry);
        } else {
            timedEntry = new TimedEntry(string);
            this.historyTimedSet.add(timedEntry);
            this.historyMap.put(string, timedEntry);
            this.historySortedSet.add(string);
            if (this.historyTimedSet.size() > this.commonEntriesCapacity) {
                TimedEntry timedEntry2 = (TimedEntry)this.historyTimedSet.last();
                this.historyMap.remove(timedEntry2.value);
                this.historySortedSet.remove(timedEntry2.value);
                this.historyTimedSet.remove(timedEntry2);
            }
        }
    }

    public void addItem(String string, boolean bl) {
        int n = this.sequenceIndex + 1;
        while (n >= this.historySequence.size()) {
            this.historySequence.add(null);
        }
        this.historySequence.set(n, string);
        this.sequenceIndex = n;
        int n2 = n + 1;
        while (this.historySequence.size() > n2) {
            this.historySequence.remove(n2);
        }
        while (this.historySequence.size() > this.sequenceCapacity) {
            this.historySequence.remove(0);
            --this.sequenceIndex;
        }
        if (bl) {
            this.addAsRecentOnly(string);
        }
    }

    private class TimedEntry
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = 2257845000000000200L;
        private long timestamp = System.currentTimeMillis();
        private final String value;

        public TimedEntry(String string) {
            this.value = string;
        }

        public void touch() {
            this.timestamp = System.currentTimeMillis();
        }

        public boolean equals(Object object) {
            TimedEntry timedEntry = (TimedEntry)object;
            return timedEntry.value.equals(this.value);
        }

        public int compareTo(Object object) {
            if (this.equals(object)) {
                return 0;
            }
            TimedEntry timedEntry = (TimedEntry)object;
            long l = this.timestamp;
            long l2 = timedEntry.timestamp;
            if (l > l2) {
                return -1;
            }
            if (l2 > l) {
                return 1;
            }
            int n = System.identityHashCode(this) - System.identityHashCode(timedEntry);
            if (n == 0) {
                return 1;
            }
            return n;
        }
    }
}

