/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class CollectionUtilities {
    private CollectionUtilities() {
    }

    public static Enumeration getIteratorEnumeration(final Iterator iterator) {
        return new Enumeration(){

            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            public Object nextElement() {
                return iterator.next();
            }
        };
    }

    public static Iterator iteratorUnion(final Iterator[] iteratorArray) {
        return new Iterator(){
            private int iteratorIndex = 0;
            private Iterator current = iteratorArray.length > 0 ? iteratorArray[0] : null;

            public boolean hasNext() {
                while (this.current != null) {
                    if (this.current.hasNext()) {
                        return true;
                    }
                    ++this.iteratorIndex;
                    this.current = this.iteratorIndex >= iteratorArray.length ? null : iteratorArray[this.iteratorIndex];
                }
                return false;
            }

            public Object next() {
                while (true) {
                    if (this.current == null) {
                        throw new NoSuchElementException();
                    }
                    try {
                        return this.current.next();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        ++this.iteratorIndex;
                        this.current = this.iteratorIndex >= iteratorArray.length ? null : iteratorArray[this.iteratorIndex];
                        continue;
                    }
                    break;
                }
            }

            public void remove() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                this.current.remove();
            }
        };
    }

    public static Collection reverse(Collection collection) {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            linkedList.addFirst(iterator.next());
        }
        return linkedList;
    }

    public static Iterator singletonIterator(final Object object) {
        return new Iterator(){
            private boolean gotItem = false;

            public boolean hasNext() {
                return !this.gotItem;
            }

            public Object next() {
                if (this.gotItem) {
                    throw new NoSuchElementException();
                }
                this.gotItem = true;
                return object;
            }

            public void remove() {
                if (this.gotItem) {
                    throw new NoSuchElementException();
                }
                this.gotItem = true;
            }
        };
    }
}

