/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

public final class HtmlLength {
    public static final int PIXELS = 1;
    public static final int LENGTH = 2;
    public static final int MULTI_LENGTH = 0;
    public static final HtmlLength[] EMPTY_ARRAY = new HtmlLength[0];
    private final int lengthType;
    private volatile int value;

    public HtmlLength(String string) throws IndexOutOfBoundsException, NumberFormatException {
        String string2;
        string = string.trim();
        int n = string.length();
        char c = string.charAt(n - 1);
        if (c == '%') {
            this.lengthType = 2;
            string2 = string.substring(0, n - 1).trim();
        } else if (c == '*') {
            this.lengthType = 0;
            string2 = n <= 1 ? "1" : string.substring(0, n - 1).trim();
        } else {
            this.lengthType = 1;
            string2 = string;
        }
        this.value = Integer.parseInt(string2);
    }

    public HtmlLength(int n) {
        this.lengthType = 1;
        this.value = n;
    }

    public final int getLengthType() {
        return this.lengthType;
    }

    public final int getRawValue() {
        return this.value;
    }

    public final int getLength(int n) {
        int n2 = this.lengthType;
        if (n2 == 2) {
            return n * this.value / 100;
        }
        return this.value;
    }

    public final void divideBy(int n) {
        int n2 = this.value;
        this.value = n2 /= n;
    }

    public final boolean isPreferredOver(HtmlLength htmlLength) {
        if (htmlLength == null) {
            return true;
        }
        if (this.lengthType > htmlLength.lengthType) {
            return true;
        }
        return this.value > htmlLength.value;
    }
}

