/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import org.lobobrowser.html.renderer.RTableCell;
import org.lobobrowser.html.style.HtmlLength;

class VirtualCell {
    private final RTableCell actualCell;
    private final boolean isTopLeft;
    private int column;
    private int row;

    public VirtualCell(RTableCell rTableCell, boolean bl) {
        this.actualCell = rTableCell;
        this.isTopLeft = bl;
    }

    public boolean isTopLeft() {
        return this.isTopLeft;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int n) {
        this.column = n;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int n) {
        this.row = n;
    }

    public RTableCell getActualCell() {
        return this.actualCell;
    }

    public HtmlLength getHeightLength() {
        HtmlLength htmlLength;
        RTableCell rTableCell = this.actualCell;
        String string = rTableCell.getHeightText();
        try {
            htmlLength = string == null ? null : new HtmlLength(string);
        }
        catch (Exception exception) {
            htmlLength = null;
        }
        if (htmlLength != null) {
            htmlLength.divideBy(rTableCell.getRowSpan());
        }
        return htmlLength;
    }

    public HtmlLength getWidthLength() {
        HtmlLength htmlLength;
        RTableCell rTableCell = this.actualCell;
        String string = rTableCell.getWidthText();
        try {
            htmlLength = string == null ? null : new HtmlLength(string);
        }
        catch (Exception exception) {
            htmlLength = null;
        }
        if (htmlLength != null) {
            htmlLength.divideBy(rTableCell.getColSpan());
        }
        return htmlLength;
    }
}

