/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseElementRenderable;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.DelayedPair;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.PositionedRenderable;
import org.lobobrowser.html.renderer.RUIControl;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.renderer.TableMatrix;
import org.lobobrowser.html.renderer.ZIndexComparator;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.util.Objects;

class RTable
extends BaseElementRenderable {
    private static final int MAX_CACHE_SIZE = 10;
    private final Map cachedLayout = new HashMap(5);
    private final TableMatrix tableMatrix;
    private SortedSet positionedRenderables;
    private int otherOrdinal;
    private LayoutKey lastLayoutKey = null;
    private LayoutValue lastLayoutValue = null;

    public RTable(HTMLElementImpl hTMLElementImpl, UserAgentContext userAgentContext, HtmlRendererContext htmlRendererContext, FrameContext frameContext, RenderableContainer renderableContainer) {
        super(renderableContainer, hTMLElementImpl, userAgentContext);
        this.tableMatrix = new TableMatrix(hTMLElementImpl, userAgentContext, htmlRendererContext, frameContext, this, this);
    }

    public int getVAlign() {
        return 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        RenderState renderState = this.modelNode.getRenderState();
        if (renderState != null && renderState.getVisibility() != 0) {
            return;
        }
        try {
            this.prePaint(graphics);
            Dimension dimension = this.getSize();
            TableMatrix tableMatrix = this.tableMatrix;
            tableMatrix.paint(graphics, dimension);
            SortedSet sortedSet = this.positionedRenderables;
            if (sortedSet != null) {
                Iterator iterator = sortedSet.iterator();
                while (iterator.hasNext()) {
                    PositionedRenderable positionedRenderable = (PositionedRenderable)iterator.next();
                    BoundableRenderable boundableRenderable = positionedRenderable.renderable;
                    boundableRenderable.paintTranslated(graphics);
                }
            }
        }
        finally {
            super.paint(graphics);
        }
    }

    public void doLayout(int n, int n2, boolean bl) {
        Map map = this.cachedLayout;
        RenderState renderState = this.modelNode.getRenderState();
        int n3 = renderState == null ? 0 : renderState.getWhiteSpace();
        Font font = renderState == null ? null : renderState.getFont();
        LayoutKey layoutKey = new LayoutKey(n, n2, n3, font);
        LayoutValue layoutValue = bl ? (LayoutValue)map.get(layoutKey) : (Objects.equals(layoutKey, this.lastLayoutKey) ? this.lastLayoutValue : null);
        if (layoutValue == null) {
            SortedSet sortedSet = this.positionedRenderables;
            if (sortedSet != null) {
                sortedSet.clear();
            }
            this.otherOrdinal = 0;
            this.clearGUIComponents();
            this.clearDelayedPairs();
            this.applyStyle(n, n2);
            TableMatrix tableMatrix = this.tableMatrix;
            Insets insets = this.getInsets(false, false);
            tableMatrix.reset(insets, n, n2);
            tableMatrix.build(n, n2, bl);
            tableMatrix.doLayout(insets);
            Collection collection = this.delayedPairs;
            if (collection != null) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    DelayedPair delayedPair = (DelayedPair)iterator.next();
                    if (delayedPair.targetParent != this) continue;
                    this.importDelayedPair(delayedPair);
                }
            }
            layoutValue = new LayoutValue(tableMatrix.getTableWidth(), tableMatrix.getTableHeight());
            if (bl) {
                if (map.size() > 10) {
                    map.clear();
                }
                map.put(layoutKey, layoutValue);
                this.lastLayoutKey = null;
                this.lastLayoutValue = null;
            } else {
                this.lastLayoutKey = layoutKey;
                this.lastLayoutValue = layoutValue;
            }
        }
        this.width = layoutValue.width;
        this.height = layoutValue.height;
        this.sendGUIComponentsToParent();
        this.sendDelayedPairsToParent();
    }

    public void invalidateLayoutLocal() {
        super.invalidateLayoutLocal();
        this.cachedLayout.clear();
        this.lastLayoutKey = null;
        this.lastLayoutValue = null;
    }

    public RenderableSpot getLowestRenderableSpot(int n, int n2) {
        Object object;
        SortedSet sortedSet = this.positionedRenderables;
        if (sortedSet != null) {
            object = sortedSet.iterator();
            while (object.hasNext()) {
                int n3;
                PositionedRenderable positionedRenderable = (PositionedRenderable)object.next();
                BoundableRenderable boundableRenderable = positionedRenderable.renderable;
                int n4 = n - boundableRenderable.getX();
                RenderableSpot renderableSpot = boundableRenderable.getLowestRenderableSpot(n4, n3 = n2 - boundableRenderable.getY());
                if (renderableSpot == null) continue;
                return renderableSpot;
            }
        }
        if ((object = this.tableMatrix.getLowestRenderableSpot(n, n2)) != null) {
            return object;
        }
        return new RenderableSpot(this, n, n2);
    }

    public boolean onMouseClick(MouseEvent mouseEvent, int n, int n2) {
        SortedSet sortedSet = this.positionedRenderables;
        if (sortedSet != null) {
            Iterator iterator = sortedSet.iterator();
            while (iterator.hasNext()) {
                int n3;
                int n4;
                PositionedRenderable positionedRenderable = (PositionedRenderable)iterator.next();
                BoundableRenderable boundableRenderable = positionedRenderable.renderable;
                Rectangle rectangle = boundableRenderable.getBounds();
                if (!rectangle.contains(n, n2) || boundableRenderable.onMouseClick(mouseEvent, n4 = n - boundableRenderable.getX(), n3 = n2 - boundableRenderable.getY())) continue;
                return false;
            }
        }
        return this.tableMatrix.onMouseClick(mouseEvent, n, n2);
    }

    public boolean onDoubleClick(MouseEvent mouseEvent, int n, int n2) {
        SortedSet sortedSet = this.positionedRenderables;
        if (sortedSet != null) {
            Iterator iterator = sortedSet.iterator();
            while (iterator.hasNext()) {
                int n3;
                int n4;
                PositionedRenderable positionedRenderable = (PositionedRenderable)iterator.next();
                BoundableRenderable boundableRenderable = positionedRenderable.renderable;
                Rectangle rectangle = boundableRenderable.getBounds();
                if (!rectangle.contains(n, n2) || boundableRenderable.onDoubleClick(mouseEvent, n4 = n - boundableRenderable.getX(), n3 = n2 - boundableRenderable.getY())) continue;
                return false;
            }
        }
        return this.tableMatrix.onDoubleClick(mouseEvent, n, n2);
    }

    public boolean onMouseDisarmed(MouseEvent mouseEvent) {
        return this.tableMatrix.onMouseDisarmed(mouseEvent);
    }

    public boolean onMousePressed(MouseEvent mouseEvent, int n, int n2) {
        SortedSet sortedSet = this.positionedRenderables;
        if (sortedSet != null) {
            Iterator iterator = sortedSet.iterator();
            while (iterator.hasNext()) {
                int n3;
                int n4;
                PositionedRenderable positionedRenderable = (PositionedRenderable)iterator.next();
                BoundableRenderable boundableRenderable = positionedRenderable.renderable;
                Rectangle rectangle = boundableRenderable.getBounds();
                if (!rectangle.contains(n, n2) || boundableRenderable.onMousePressed(mouseEvent, n4 = n - boundableRenderable.getX(), n3 = n2 - boundableRenderable.getY())) continue;
                return false;
            }
        }
        return this.tableMatrix.onMousePressed(mouseEvent, n, n2);
    }

    public boolean onMouseReleased(MouseEvent mouseEvent, int n, int n2) {
        SortedSet sortedSet = this.positionedRenderables;
        if (sortedSet != null) {
            Iterator iterator = sortedSet.iterator();
            while (iterator.hasNext()) {
                int n3;
                int n4;
                PositionedRenderable positionedRenderable = (PositionedRenderable)iterator.next();
                BoundableRenderable boundableRenderable = positionedRenderable.renderable;
                Rectangle rectangle = boundableRenderable.getBounds();
                if (!rectangle.contains(n, n2) || boundableRenderable.onMouseReleased(mouseEvent, n4 = n - boundableRenderable.getX(), n3 = n2 - boundableRenderable.getY())) continue;
                return false;
            }
        }
        return this.tableMatrix.onMouseReleased(mouseEvent, n, n2);
    }

    public Iterator getRenderables() {
        SortedSet sortedSet = this.positionedRenderables;
        if (sortedSet != null) {
            Object object;
            LinkedList<BoundableRenderable> linkedList = new LinkedList<BoundableRenderable>();
            Iterator iterator = sortedSet.iterator();
            while (iterator.hasNext()) {
                object = (PositionedRenderable)iterator.next();
                BoundableRenderable boundableRenderable = ((PositionedRenderable)object).renderable;
                linkedList.add(boundableRenderable);
            }
            object = this.tableMatrix.getRenderables();
            while (object.hasNext()) {
                linkedList.add((BoundableRenderable)object.next());
            }
            return linkedList.iterator();
        }
        return this.tableMatrix.getRenderables();
    }

    public void repaint(ModelNode modelNode) {
    }

    public Color getPaintedBackgroundColor() {
        return this.container.getPaintedBackgroundColor();
    }

    private final void addPositionedRenderable(BoundableRenderable boundableRenderable, boolean bl, boolean bl2) {
        TreeSet<PositionedRenderable> treeSet = this.positionedRenderables;
        if (treeSet == null) {
            this.positionedRenderables = treeSet = new TreeSet<PositionedRenderable>(new ZIndexComparator());
        }
        treeSet.add(new PositionedRenderable(boundableRenderable, bl, this.otherOrdinal++, bl2));
        boundableRenderable.setParent(this);
        if (boundableRenderable instanceof RUIControl) {
            this.container.addComponent(((RUIControl)boundableRenderable).widget.getComponent());
        }
    }

    private void importDelayedPair(DelayedPair delayedPair) {
        BoundableRenderable boundableRenderable = delayedPair.child;
        boundableRenderable.setOrigin(delayedPair.x, delayedPair.y);
        this.addPositionedRenderable(boundableRenderable, false, false);
    }

    public String toString() {
        return "RTable[this=" + System.identityHashCode(this) + ",node=" + this.modelNode + "]";
    }

    private static class LayoutValue {
        public final int width;
        public final int height;

        public LayoutValue(int n, int n2) {
            this.width = n;
            this.height = n2;
        }
    }

    private static class LayoutKey {
        public final int availWidth;
        public final int availHeight;
        public final int whitespace;
        public final Font font;

        public LayoutKey(int n, int n2, int n3, Font font) {
            this.availWidth = n;
            this.availHeight = n2;
            this.whitespace = n3;
            this.font = font;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof LayoutKey)) {
                return false;
            }
            LayoutKey layoutKey = (LayoutKey)object;
            return layoutKey.availWidth == this.availWidth && layoutKey.availHeight == this.availHeight && layoutKey.whitespace == this.whitespace && Objects.equals(layoutKey.font, this.font);
        }

        public int hashCode() {
            Font font = this.font;
            return this.availWidth * 1000 + this.availHeight ^ (font == null ? 0 : font.hashCode());
        }
    }
}

