/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseBoundableRenderable;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.html.renderer.RCollection;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;

abstract class BaseRCollection
extends BaseBoundableRenderable
implements RCollection {
    private BoundableRenderable renderableWithMouse = null;

    public BaseRCollection(RenderableContainer renderableContainer, ModelNode modelNode) {
        super(renderableContainer, modelNode);
    }

    public void focus() {
        this.container.focus();
    }

    public void blur() {
        RCollection rCollection = this.parent;
        if (rCollection != null) {
            rCollection.focus();
        }
    }

    public void updateWidgetBounds(int n, int n2) {
        Iterator iterator = this.getRenderables();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof RCollection)) continue;
                RCollection rCollection = (RCollection)e;
                rCollection.updateWidgetBounds(n + rCollection.getX(), n2 + rCollection.getY());
            }
        }
    }

    private boolean checkStartSelection(Rectangle rectangle, Point point) {
        if (rectangle.y > point.y) {
            return true;
        }
        return point.y >= rectangle.y && point.y < rectangle.y + rectangle.height && rectangle.x > point.x;
    }

    private boolean checkEndSelection(Rectangle rectangle, Point point) {
        if (rectangle.y > point.y) {
            return true;
        }
        return point.y >= rectangle.y && point.y < rectangle.y + rectangle.height && point.x < rectangle.x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean paintSelection(Graphics graphics, boolean bl, RenderableSpot renderableSpot, RenderableSpot renderableSpot2) {
        Point point = null;
        Point point2 = null;
        if (!bl) {
            boolean bl2;
            boolean bl3 = renderableSpot.renderable == this;
            boolean bl4 = bl2 = renderableSpot2.renderable == this;
            if (bl3 && bl2) {
                point = renderableSpot.getPoint();
                point2 = renderableSpot2.getPoint();
            } else if (bl3) {
                point = renderableSpot.getPoint();
            } else if (bl2) {
                point = renderableSpot2.getPoint();
            }
        } else if (renderableSpot.renderable == this) {
            point = renderableSpot.getPoint();
        } else if (renderableSpot2.renderable == this) {
            point = renderableSpot2.getPoint();
        }
        Iterator iterator = this.getRenderables();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof BoundableRenderable)) continue;
                BoundableRenderable boundableRenderable = (BoundableRenderable)e;
                Rectangle rectangle = boundableRenderable.getBounds();
                if (!bl) {
                    if (point != null && this.checkStartSelection(rectangle, point)) {
                        if (point2 != null) {
                            point = point2;
                            point2 = null;
                        } else {
                            point = null;
                        }
                        bl = true;
                    } else if (point2 != null && this.checkStartSelection(rectangle, point2)) {
                        point = null;
                        point2 = null;
                        bl = true;
                    }
                } else if (bl && point != null && this.checkEndSelection(rectangle, point)) {
                    return false;
                }
                int n = rectangle.x;
                int n2 = rectangle.y;
                graphics.translate(n, n2);
                try {
                    boolean bl5 = boundableRenderable.paintSelection(graphics, bl, renderableSpot, renderableSpot2);
                    if (bl && !bl5) {
                        boolean bl6 = false;
                        return bl6;
                    }
                    bl = bl5;
                }
                finally {
                    graphics.translate(-n, -n2);
                }
            }
        }
        if (bl && point != null) {
            return false;
        }
        if (!(bl || point == null && point2 == null || point != null && point2 != null)) {
            return true;
        }
        return bl;
    }

    public boolean extractSelectionText(StringBuffer stringBuffer, boolean bl, RenderableSpot renderableSpot, RenderableSpot renderableSpot2) {
        Point point = null;
        Point point2 = null;
        if (!bl) {
            boolean bl2;
            boolean bl3 = renderableSpot.renderable == this;
            boolean bl4 = bl2 = renderableSpot2.renderable == this;
            if (bl3 && bl2) {
                point = renderableSpot.getPoint();
                point2 = renderableSpot2.getPoint();
            } else if (bl3) {
                point = renderableSpot.getPoint();
            } else if (bl2) {
                point = renderableSpot2.getPoint();
            }
        } else if (renderableSpot.renderable == this) {
            point = renderableSpot.getPoint();
        } else if (renderableSpot2.renderable == this) {
            point = renderableSpot2.getPoint();
        }
        Iterator iterator = this.getRenderables();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof BoundableRenderable)) continue;
                BoundableRenderable boundableRenderable = (BoundableRenderable)e;
                if (!bl) {
                    Rectangle rectangle = boundableRenderable.getBounds();
                    if (point != null && this.checkStartSelection(rectangle, point)) {
                        if (point2 != null) {
                            point = point2;
                            point2 = null;
                        } else {
                            point = null;
                        }
                        bl = true;
                    } else if (point2 != null && this.checkStartSelection(rectangle, point2)) {
                        point = null;
                        point2 = null;
                        bl = true;
                    }
                } else if (bl && point != null && this.checkEndSelection(boundableRenderable.getBounds(), point)) {
                    return false;
                }
                boolean bl5 = boundableRenderable.extractSelectionText(stringBuffer, bl, renderableSpot, renderableSpot2);
                if (bl && !bl5) {
                    return false;
                }
                bl = bl5;
            }
        }
        if (bl && point != null) {
            return false;
        }
        if (!(bl || point == null && point2 == null || point != null && point2 != null)) {
            return true;
        }
        return bl;
    }

    public void invalidateLayoutDeep() {
        this.invalidateLayoutLocal();
        Iterator iterator = this.getRenderables();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof RCollection)) continue;
                ((RCollection)e).invalidateLayoutDeep();
            }
        }
    }

    public void onMouseMoved(MouseEvent mouseEvent, int n, int n2, boolean bl, ModelNode modelNode) {
        boolean bl2;
        super.onMouseMoved(mouseEvent, n, n2, bl, modelNode);
        BoundableRenderable boundableRenderable = this.renderableWithMouse;
        BoundableRenderable boundableRenderable2 = this.getRenderable(n, n2);
        BoundableRenderable boundableRenderable3 = boundableRenderable2 instanceof BoundableRenderable ? boundableRenderable2 : null;
        ModelNode modelNode2 = this.isContainedByNode() ? this.modelNode : modelNode;
        boolean bl3 = bl2 = boundableRenderable != boundableRenderable3;
        if (bl2) {
            if (boundableRenderable != null) {
                boundableRenderable.onMouseOut(mouseEvent, n - boundableRenderable.getX(), n2 - boundableRenderable.getY(), modelNode2);
            }
            this.renderableWithMouse = boundableRenderable3;
        }
        if (boundableRenderable3 != null) {
            boundableRenderable3.onMouseMoved(mouseEvent, n - boundableRenderable3.getX(), n2 - boundableRenderable3.getY(), bl2, modelNode2);
        }
    }

    public void onMouseOut(MouseEvent mouseEvent, int n, int n2, ModelNode modelNode) {
        super.onMouseOut(mouseEvent, n, n2, modelNode);
        BoundableRenderable boundableRenderable = this.renderableWithMouse;
        if (boundableRenderable != null) {
            this.renderableWithMouse = null;
            ModelNode modelNode2 = this.isContainedByNode() ? this.modelNode : modelNode;
            boundableRenderable.onMouseOut(mouseEvent, n - boundableRenderable.getX(), n2 - boundableRenderable.getY(), modelNode2);
        }
    }

    public BoundableRenderable getRenderable(int n, int n2) {
        Iterator iterator = this.getRenderables();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof BoundableRenderable)) continue;
                BoundableRenderable boundableRenderable = (BoundableRenderable)e;
                int n3 = boundableRenderable.getX();
                int n4 = boundableRenderable.getY();
                if (n2 < n4 || n2 >= n4 + boundableRenderable.getHeight() || n < n3 || n >= n3 + boundableRenderable.getWidth()) continue;
                return boundableRenderable;
            }
        }
        return null;
    }

    public boolean onRightClick(MouseEvent mouseEvent, int n, int n2) {
        BoundableRenderable boundableRenderable = this.getRenderable(n, n2);
        if (boundableRenderable == null) {
            return HtmlController.getInstance().onContextMenu(this.modelNode, mouseEvent, n, n2);
        }
        return boundableRenderable.onRightClick(mouseEvent, n - boundableRenderable.getX(), n2 - boundableRenderable.getY());
    }
}

