/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.js;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.ReadyStateChangeListener;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.js.Executor;
import org.lobobrowser.js.AbstractScriptableDelegate;
import org.lobobrowser.js.JavaScript;
import org.lobobrowser.util.Urls;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.Document;

public class XMLHttpRequest
extends AbstractScriptableDelegate {
    private static final Logger logger = Logger.getLogger(XMLHttpRequest.class.getName());
    private final HttpRequest request;
    private final UserAgentContext pcontext;
    private final Scriptable scope;
    private final URL codeSource;
    private Function onreadystatechange;
    private boolean listenerAdded;

    public XMLHttpRequest(UserAgentContext userAgentContext, URL uRL, Scriptable scriptable) {
        this.request = userAgentContext.createHttpRequest();
        this.pcontext = userAgentContext;
        this.scope = scriptable;
        this.codeSource = uRL;
    }

    public void abort() {
        this.request.abort();
    }

    public String getAllResponseHeaders() {
        return this.request.getAllResponseHeaders();
    }

    public int getReadyState() {
        return this.request.getReadyState();
    }

    public byte[] getResponseBytes() {
        return this.request.getResponseBytes();
    }

    public String getResponseHeader(String string) {
        return this.request.getResponseHeader(string);
    }

    public String getResponseText() {
        return this.request.getResponseText();
    }

    public Document getResponseXML() {
        return this.request.getResponseXML();
    }

    public int getStatus() {
        return this.request.getStatus();
    }

    public String getStatusText() {
        return this.request.getStatusText();
    }

    private URL getFullURL(String string) throws MalformedURLException {
        return Urls.createURL(this.codeSource, string);
    }

    public void open(String string, String string2, boolean bl, String string3, String string4) throws IOException {
        this.request.open(string, this.getFullURL(string2), bl, string3, string4);
    }

    public void open(String string, String string2, boolean bl, String string3) throws IOException {
        this.request.open(string, this.getFullURL(string2), bl, string3);
    }

    public void open(String string, String string2, boolean bl) throws IOException {
        this.request.open(string, this.getFullURL(string2), bl);
    }

    public void open(String string, String string2) throws IOException {
        this.request.open(string, this.getFullURL(string2));
    }

    public void send(String string) throws IOException {
        this.request.send(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function getOnreadystatechange() {
        XMLHttpRequest xMLHttpRequest = this;
        synchronized (xMLHttpRequest) {
            return this.onreadystatechange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnreadystatechange(Function function) {
        XMLHttpRequest xMLHttpRequest = this;
        synchronized (xMLHttpRequest) {
            this.onreadystatechange = function;
            if (function != null && !this.listenerAdded) {
                this.request.addReadyStateChangeListener(new ReadyStateChangeListener(){

                    public void readyStateChanged() {
                        XMLHttpRequest.this.executeReadyStateChange();
                    }
                });
                this.listenerAdded = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeReadyStateChange() {
        block5: {
            try {
                Function function = this.getOnreadystatechange();
                if (function == null) break block5;
                Context context = Executor.createContext(this.codeSource, this.pcontext);
                try {
                    Scriptable scriptable = (Scriptable)JavaScript.getInstance().getJavascriptObject(this, this.scope);
                    function.call(context, scriptable, scriptable, new Object[0]);
                }
                finally {
                    Context.exit();
                }
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Error processing ready state change.", exception);
            }
        }
    }
}

