/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.lobobrowser.html.BrowserFrame;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.domimpl.FrameNode;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.gui.DocumentNotification;
import org.lobobrowser.html.renderer.NodeRenderer;
import org.lobobrowser.html.style.HtmlLength;
import org.lobobrowser.util.gui.WrapperLayout;

public class FrameSetPanel
extends JComponent
implements NodeRenderer {
    private static final Logger logger = Logger.getLogger(FrameSetPanel.class.getName());
    private HTMLElementImpl rootNode;
    private HtmlRendererContext htmlContext;
    private Component[] frameComponents;
    private boolean domInvalid = true;

    public FrameSetPanel() {
        this.setLayout(WrapperLayout.getInstance());
        this.setPreferredSize(new Dimension(600, 400));
    }

    private HtmlLength[] getLengths(String string) {
        if (string == null) {
            return new HtmlLength[]{new HtmlLength("1*")};
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        ArrayList<HtmlLength> arrayList = new ArrayList<HtmlLength>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            try {
                arrayList.add(new HtmlLength(string2));
            }
            catch (Exception exception) {
                logger.warning("Frame rows or cols value [" + string + "] is invalid.");
            }
        }
        return arrayList.toArray(HtmlLength.EMPTY_ARRAY);
    }

    private HTMLElementImpl[] getSubFrames(HTMLElementImpl hTMLElementImpl) {
        NodeImpl[] nodeImplArray = hTMLElementImpl.getChildrenArray();
        ArrayList<NodeImpl> arrayList = new ArrayList<NodeImpl>();
        for (int i = 0; i < nodeImplArray.length; ++i) {
            String string;
            NodeImpl nodeImpl = nodeImplArray[i];
            if (!(nodeImpl instanceof HTMLElementImpl) || !"FRAME".equalsIgnoreCase(string = nodeImpl.getNodeName()) && !"FRAMESET".equalsIgnoreCase(string)) continue;
            arrayList.add(nodeImpl);
        }
        return arrayList.toArray(new HTMLElementImpl[0]);
    }

    public void setRootNode(NodeImpl nodeImpl) {
        HtmlRendererContext htmlRendererContext;
        HTMLElementImpl hTMLElementImpl;
        if (!(nodeImpl instanceof HTMLElementImpl)) {
            throw new IllegalArgumentException("node=" + nodeImpl);
        }
        this.rootNode = hTMLElementImpl = (HTMLElementImpl)nodeImpl;
        this.htmlContext = htmlRendererContext = hTMLElementImpl.getHtmlRendererContext();
        this.domInvalid = true;
        this.invalidate();
        this.validateAll();
        this.repaint();
    }

    protected void validateAll() {
        Container container;
        Container container2 = this;
        while ((container = container2.getParent()) != null && !container.isValid()) {
            container2 = container;
        }
        ((Component)container2).validate();
    }

    public final void processDocumentNotifications(DocumentNotification[] documentNotificationArray) {
        if (documentNotificationArray.length > 0) {
            this.domInvalid = true;
            this.invalidate();
            if (this.isVisible()) {
                this.validate();
                this.repaint();
            }
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
    }

    public void doLayout() {
        if (this.domInvalid) {
            this.domInvalid = false;
            this.removeAll();
            HtmlRendererContext htmlRendererContext = this.htmlContext;
            if (htmlRendererContext != null) {
                Serializable serializable;
                Object object;
                Object object2;
                HtmlLength[] htmlLengthArray;
                HTMLElementImpl hTMLElementImpl = this.rootNode;
                String string = hTMLElementImpl.getAttribute("rows");
                String string2 = hTMLElementImpl.getAttribute("cols");
                HtmlLength[] htmlLengthArray2 = this.getLengths(string);
                HtmlLength[] htmlLengthArray3 = this.getLengths(string2);
                HTMLElementImpl[] hTMLElementImplArray = this.getSubFrames(hTMLElementImpl);
                Component[] componentArray = new Component[hTMLElementImplArray.length];
                this.frameComponents = componentArray;
                for (int i = 0; i < hTMLElementImplArray.length; ++i) {
                    htmlLengthArray = hTMLElementImplArray[i];
                    if (htmlLengthArray != null && "FRAMESET".equalsIgnoreCase(htmlLengthArray.getTagName())) {
                        object2 = new FrameSetPanel();
                        ((FrameSetPanel)object2).setRootNode((NodeImpl)htmlLengthArray);
                        componentArray[i] = object2;
                        continue;
                    }
                    if (htmlLengthArray instanceof FrameNode) {
                        object2 = htmlRendererContext.createBrowserFrame();
                        ((FrameNode)htmlLengthArray).setBrowserFrame((BrowserFrame)object2);
                        object = htmlLengthArray.getAttribute("src");
                        if (object != null) {
                            try {
                                serializable = htmlLengthArray.getFullURL((String)object);
                                if (serializable != null) {
                                    object2.loadURL((URL)serializable);
                                }
                            }
                            catch (MalformedURLException malformedURLException) {
                                logger.warning("Frame URI=[" + (String)object + "] is malformed.");
                            }
                        }
                        componentArray[i] = object2.getComponent();
                        continue;
                    }
                    componentArray[i] = new JPanel();
                }
                HtmlLength[] htmlLengthArray4 = htmlLengthArray2;
                htmlLengthArray = htmlLengthArray3;
                object2 = this.frameComponents;
                if (htmlLengthArray4 != null && htmlLengthArray != null && object2 != null) {
                    object = this.getSize();
                    serializable = this.getInsets();
                    int n = ((Dimension)object).width - serializable.left - serializable.right;
                    int n2 = ((Dimension)object).height - serializable.left - serializable.right;
                    int[] nArray = this.getAbsoluteLengths(htmlLengthArray, n);
                    int[] nArray2 = this.getAbsoluteLengths(htmlLengthArray4, n2);
                    this.add(this.getSplitPane(this.htmlContext, nArray, 0, nArray.length, nArray2, 0, nArray2.length, (Component[])object2));
                }
            }
        }
        super.doLayout();
    }

    private int[] getAbsoluteLengths(HtmlLength[] htmlLengthArray, int n) {
        int n2;
        int n3;
        int[] nArray = new int[htmlLengthArray.length];
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < htmlLengthArray.length; ++n3) {
            HtmlLength htmlLength = htmlLengthArray[n3];
            int n6 = htmlLength.getLengthType();
            if (n6 == 1) {
                n2 = htmlLength.getRawValue();
                n4 += n2;
                nArray[n3] = n2;
                continue;
            }
            if (n6 == 2) {
                n2 = htmlLength.getLength(n);
                n4 += n2;
                nArray[n3] = n2;
                continue;
            }
            n5 += htmlLength.getRawValue();
        }
        n3 = n - n4;
        if (n3 > 0 && n5 > 0) {
            for (int i = 0; i < htmlLengthArray.length; ++i) {
                HtmlLength htmlLength = htmlLengthArray[i];
                if (htmlLength.getLengthType() != 0) continue;
                nArray[i] = n2 = n3 * htmlLength.getRawValue() / n5;
            }
        }
        return nArray;
    }

    private Component getSplitPane(HtmlRendererContext htmlRendererContext, int[] nArray, int n, int n2, int[] nArray2, int n3, int n4, Component[] componentArray) {
        if (n2 == 1) {
            Component component;
            int n5 = nArray.length * n3 + n;
            Component component2 = component = n5 < componentArray.length ? componentArray[n5] : null;
            if (n4 == 1) {
                return component;
            }
            Component component3 = this.getSplitPane(htmlRendererContext, nArray, n, n2, nArray2, n3 + 1, n4 - 1, componentArray);
            JSplitPane jSplitPane = new JSplitPane(0, component, component3);
            jSplitPane.setDividerLocation(nArray2[n3]);
            return jSplitPane;
        }
        Component component = this.getSplitPane(htmlRendererContext, nArray, n + 1, n2 - 1, nArray2, n3, n4, componentArray);
        Component component4 = this.getSplitPane(htmlRendererContext, nArray, n, 1, nArray2, n3, n4, componentArray);
        JSplitPane jSplitPane = new JSplitPane(1, component4, component);
        jSplitPane.setDividerLocation(nArray[n]);
        return jSplitPane;
    }
}

