/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.util.ArrayList;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLOptionElementImpl;
import org.lobobrowser.html.domimpl.HTMLOptionsCollectionImpl;
import org.lobobrowser.html.domimpl.InputContext;
import org.mozilla.javascript.Function;
import org.w3c.dom.DOMException;
import org.w3c.dom.html2.HTMLElement;
import org.w3c.dom.html2.HTMLOptionsCollection;
import org.w3c.dom.html2.HTMLSelectElement;

public class HTMLSelectElementImpl
extends HTMLBaseInputElement
implements HTMLSelectElement {
    private Boolean multipleState = null;
    private HTMLOptionsCollection options;
    private int deferredSelectedIndex = -1;
    private Function onchange;

    public HTMLSelectElementImpl(String string) {
        super(string);
    }

    public void add(HTMLElement hTMLElement, HTMLElement hTMLElement2) throws DOMException {
        this.insertBefore(hTMLElement, hTMLElement2);
    }

    public int getLength() {
        return this.getOptions().getLength();
    }

    public boolean getMultiple() {
        Boolean bl = this.multipleState;
        if (bl != null) {
            return bl;
        }
        return this.getAttributeAsBoolean("multiple");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTMLOptionsCollection getOptions() {
        HTMLSelectElementImpl hTMLSelectElementImpl = this;
        synchronized (hTMLSelectElementImpl) {
            if (this.options == null) {
                this.options = new HTMLOptionsCollectionImpl(this);
            }
            return this.options;
        }
    }

    public int getSelectedIndex() {
        InputContext inputContext = this.inputContext;
        if (inputContext != null) {
            return inputContext.getSelectedIndex();
        }
        return this.deferredSelectedIndex;
    }

    public int getSize() {
        InputContext inputContext = this.inputContext;
        if (inputContext != null) {
            return inputContext.getVisibleSize();
        }
        return 0;
    }

    public String getType() {
        return this.getMultiple() ? "select-multiple" : "select-one";
    }

    public void remove(int n) {
        try {
            this.removeChild(this.getOptions().item(n));
        }
        catch (DOMException dOMException) {
            this.warn("remove(): Unable to remove option at index " + n + ".", dOMException);
        }
    }

    public void setLength(int n) throws DOMException {
        this.getOptions().setLength(n);
    }

    public void setMultiple(boolean bl) {
        boolean bl2 = this.getMultiple();
        this.multipleState = bl;
        if (bl2 != bl) {
            this.informLayoutInvalid();
        }
    }

    public void setSelectedIndex(int n) {
        this.setSelectedIndexImpl(n);
        HTMLOptionsCollection hTMLOptionsCollection = this.getOptions();
        int n2 = hTMLOptionsCollection.getLength();
        for (int i = 0; i < n2; ++i) {
            HTMLOptionElementImpl hTMLOptionElementImpl = (HTMLOptionElementImpl)hTMLOptionsCollection.item(i);
            hTMLOptionElementImpl.setSelectedImpl(i == n);
        }
    }

    void setSelectedIndexImpl(int n) {
        InputContext inputContext = this.inputContext;
        if (inputContext != null) {
            inputContext.setSelectedIndex(n);
        } else {
            this.deferredSelectedIndex = n;
        }
    }

    public void setSize(int n) {
        InputContext inputContext = this.inputContext;
        if (inputContext != null) {
            inputContext.setVisibleSize(n);
        }
    }

    protected FormInput[] getFormInputs() {
        String string;
        String[] stringArray;
        InputContext inputContext = this.inputContext;
        String[] stringArray2 = stringArray = inputContext == null ? null : inputContext.getValues();
        if (stringArray == null) {
            String[] stringArray3;
            string = this.getValue();
            if (string == null) {
                stringArray3 = null;
            } else {
                String[] stringArray4 = new String[1];
                stringArray3 = stringArray4;
                stringArray4[0] = string;
            }
            stringArray = stringArray3;
            if (stringArray == null) {
                return null;
            }
        }
        if ((string = this.getName()) == null) {
            return null;
        }
        ArrayList<FormInput> arrayList = new ArrayList<FormInput>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(new FormInput(string, stringArray[i]));
        }
        return arrayList.toArray(FormInput.EMPTY_ARRAY);
    }

    public void resetInput() {
        InputContext inputContext = this.inputContext;
        if (inputContext != null) {
            inputContext.resetInput();
        }
    }

    public void setInputContext(InputContext inputContext) {
        super.setInputContext(inputContext);
        if (inputContext != null) {
            inputContext.setSelectedIndex(this.deferredSelectedIndex);
        }
    }

    public Function getOnchange() {
        return this.getEventFunction(this.onchange, "onchange");
    }

    public void setOnchange(Function function) {
        this.onchange = function;
    }
}

