/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.js.Executor;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.Document;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.html2.HTMLScriptElement;

public class HTMLScriptElementImpl
extends HTMLElementImpl
implements HTMLScriptElement {
    private static final Logger logger = Logger.getLogger(HTMLScriptElementImpl.class.getName());
    private static final boolean loggableInfo = logger.isLoggable(Level.INFO);
    private String text;
    private boolean defer;

    public HTMLScriptElementImpl() {
        super("SCRIPT", true);
    }

    public HTMLScriptElementImpl(String string) {
        super(string, true);
    }

    public String getText() {
        String string = this.text;
        if (string == null) {
            return this.getRawInnerText(true);
        }
        return string;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getHtmlFor() {
        return this.getAttribute("htmlFor");
    }

    public void setHtmlFor(String string) {
        this.setAttribute("htmlFor", string);
    }

    public String getEvent() {
        return this.getAttribute("event");
    }

    public void setEvent(String string) {
        this.setAttribute("event", string);
    }

    public boolean getDefer() {
        return this.defer;
    }

    public void setDefer(boolean bl) {
        this.defer = bl;
    }

    public String getSrc() {
        return this.getAttribute("src");
    }

    public void setSrc(String string) {
        this.setAttribute("src", string);
    }

    public String getType() {
        return this.getAttribute("type");
    }

    public void setType(String string) {
        this.setAttribute("type", string);
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        if ("cobra.suspend".equals(string) && object != Boolean.TRUE) {
            this.processScript();
        }
        return super.setUserData(string, object, userDataHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void processScript() {
        UserAgentContext userAgentContext = this.getUserAgentContext();
        if (userAgentContext == null) {
            throw new IllegalStateException("No user agent context.");
        }
        if (userAgentContext.isScriptingEnabled()) {
            URL uRL;
            int n;
            String string;
            String string2;
            String string3 = this.getSrc();
            Document document = this.document;
            if (!(document instanceof HTMLDocumentImpl)) {
                throw new IllegalStateException("no valid document");
            }
            boolean bl = loggableInfo;
            if (string3 == null) {
                string2 = this.getText();
                string = document.getBaseURI();
                n = 1;
            } else {
                this.informExternalScriptLoading();
                uRL = ((HTMLDocumentImpl)document).getFullURL(string3);
                string = uRL == null ? string3 : uRL.toExternalForm();
                long l = bl ? System.currentTimeMillis() : 0L;
                try {
                    final HttpRequest httpRequest = userAgentContext.createHttpRequest();
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager == null) {
                        try {
                            httpRequest.open("GET", string, false);
                            httpRequest.send(null);
                        }
                        catch (IOException iOException) {
                            logger.log(Level.WARNING, "processScript()", iOException);
                        }
                    } else {
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                try {
                                    httpRequest.open("GET", string, false);
                                    httpRequest.send(null);
                                }
                                catch (IOException iOException) {
                                    logger.log(Level.WARNING, "processScript()", iOException);
                                }
                                return null;
                            }
                        });
                    }
                    int n2 = httpRequest.getStatus();
                    if (n2 != 200 && n2 != 0) {
                        this.warn("Script at [" + string + "] failed to load; HTTP status: " + n2 + ".");
                        return;
                    }
                    string2 = httpRequest.getResponseText();
                }
                finally {
                    if (bl) {
                        long l2 = System.currentTimeMillis();
                        logger.info("processScript(): Loaded external Javascript from URI=[" + string + "] in " + (l2 - l) + " ms.");
                    }
                }
                n = 1;
            }
            uRL = Executor.createContext(this.getDocumentURL(), userAgentContext);
            try {
                Scriptable scriptable = (Scriptable)document.getUserData("cobra.js.scope");
                if (scriptable == null) {
                    throw new IllegalStateException("Scriptable (scope) instance was expected to be keyed as UserData to document using cobra.js.scope");
                }
                try {
                    long l;
                    long l3 = l = bl ? System.currentTimeMillis() : 0L;
                    if (string2 == null) {
                        throw new IllegalStateException("Script source is null: " + this + ".");
                    }
                    uRL.evaluateString(scriptable, string2, string, n, null);
                    if (bl) {
                        long l4 = System.currentTimeMillis();
                        logger.info("addNotify(): Evaluated (or attempted to evaluate) Javascript in " + (l4 - l) + " ms.");
                    }
                }
                catch (EcmaError ecmaError) {
                    logger.log(Level.WARNING, "Javascript error at " + ecmaError.getSourceName() + ":" + ecmaError.getLineNumber() + ": " + ecmaError.getMessage(), ecmaError);
                }
                catch (Throwable throwable) {
                    logger.log(Level.WARNING, "Unable to evaluate Javascript code", throwable);
                }
            }
            finally {
                Context.exit();
            }
        }
    }

    protected void appendInnerTextImpl(StringBuffer stringBuffer) {
    }
}

