/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLFormElementImpl;
import org.lobobrowser.html.domimpl.ImageEvent;
import org.lobobrowser.html.domimpl.ImageListener;
import org.lobobrowser.html.domimpl.InputContext;
import org.lobobrowser.html.js.Executor;
import org.mozilla.javascript.Function;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLFormElement;

public abstract class HTMLBaseInputElement
extends HTMLAbstractUIElement {
    protected InputContext inputContext;
    protected String deferredValue;
    private Function onload;
    private Image image = null;
    private String imageSrc;
    private final ArrayList imageListeners = new ArrayList(1);

    public HTMLBaseInputElement(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputContext(InputContext inputContext) {
        String string = null;
        HTMLBaseInputElement hTMLBaseInputElement = this;
        synchronized (hTMLBaseInputElement) {
            this.inputContext = inputContext;
            if (inputContext != null) {
                string = this.deferredValue;
            }
        }
        if (string != null) {
            inputContext.setValue(string);
        }
    }

    public String getDefaultValue() {
        return this.getAttribute("defaultValue");
    }

    public void setDefaultValue(String string) {
        this.setAttribute("defaultValue", string);
    }

    public HTMLFormElement getForm() {
        Node node;
        for (node = this.getParentNode(); node != null && !(node instanceof HTMLFormElement); node = node.getParentNode()) {
        }
        return (HTMLFormElement)node;
    }

    public void submitForm(FormInput[] formInputArray) {
        HTMLFormElementImpl hTMLFormElementImpl = (HTMLFormElementImpl)this.getForm();
        if (hTMLFormElementImpl != null) {
            hTMLFormElementImpl.submit(formInputArray);
        }
    }

    public void resetForm() {
        HTMLFormElement hTMLFormElement = this.getForm();
        if (hTMLFormElement != null) {
            hTMLFormElement.reset();
        }
    }

    public String getAccept() {
        return this.getAttribute("accept");
    }

    public void setAccept(String string) {
        this.setAttribute("accept", string);
    }

    public String getAccessKey() {
        return this.getAttribute("accessKey");
    }

    public void setAccessKey(String string) {
        this.setAttribute("accessKey", string);
    }

    public String getAlign() {
        return this.getAttribute("align");
    }

    public void setAlign(String string) {
        this.setAttribute("align", string);
    }

    public String getAlt() {
        return this.getAttribute("alit");
    }

    public void setAlt(String string) {
        this.setAttribute("alt", string);
    }

    public boolean getDisabled() {
        InputContext inputContext = this.inputContext;
        return inputContext == null ? false : inputContext.getDisabled();
    }

    public void setDisabled(boolean bl) {
        InputContext inputContext = this.inputContext;
        if (inputContext != null) {
            inputContext.setDisabled(bl);
        }
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public void setName(String string) {
        this.setAttribute("name", string);
    }

    public boolean getReadOnly() {
        InputContext inputContext = this.inputContext;
        return inputContext == null ? false : inputContext.getReadOnly();
    }

    public void setReadOnly(boolean bl) {
        InputContext inputContext = this.inputContext;
        if (inputContext != null) {
            inputContext.setReadOnly(bl);
        }
    }

    public int getTabIndex() {
        InputContext inputContext = this.inputContext;
        return inputContext == null ? 0 : inputContext.getTabIndex();
    }

    public void setTabIndex(int n) {
        InputContext inputContext = this.inputContext;
        if (inputContext != null) {
            inputContext.setTabIndex(n);
        }
    }

    public String getValue() {
        InputContext inputContext = this.inputContext;
        if (inputContext != null) {
            return inputContext.getValue();
        }
        String string = this.deferredValue;
        if (string != null) {
            return string;
        }
        String string2 = this.getAttribute("value");
        return string2 == null ? "" : string2;
    }

    protected File getFileValue() {
        InputContext inputContext = this.inputContext;
        if (inputContext != null) {
            return inputContext.getFileValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String string) {
        InputContext inputContext = null;
        HTMLBaseInputElement hTMLBaseInputElement = this;
        synchronized (hTMLBaseInputElement) {
            inputContext = this.inputContext;
            if (inputContext == null) {
                this.deferredValue = string;
            }
        }
        if (inputContext != null) {
            inputContext.setValue(string);
        }
    }

    public void blur() {
        InputContext inputContext = this.inputContext;
        if (inputContext != null) {
            inputContext.blur();
        }
    }

    public void focus() {
        InputContext inputContext = this.inputContext;
        if (inputContext != null) {
            inputContext.focus();
        }
    }

    public void select() {
        InputContext inputContext = this.inputContext;
        if (inputContext != null) {
            inputContext.select();
        }
    }

    protected void assignAttributeField(String string, String string2) {
        if ("value".equals(string)) {
            InputContext inputContext = this.inputContext;
            if (inputContext != null) {
                inputContext.setValue(string2);
            }
        } else if ("src".equals(string)) {
            this.loadImage(string2);
        } else {
            super.assignAttributeField(string, string2);
        }
    }

    public Function getOnload() {
        return this.getEventFunction(this.onload, "onload");
    }

    public void setOnload(Function function) {
        this.onload = function;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImage(String string) {
        HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)this.document;
        if (hTMLDocumentImpl != null) {
            ArrayList arrayList = this.imageListeners;
            synchronized (arrayList) {
                this.imageSrc = string;
                this.image = null;
            }
            if (string != null) {
                hTMLDocumentImpl.loadImage(string, new LocalImageListener(string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Image getImage() {
        ArrayList arrayList = this.imageListeners;
        synchronized (arrayList) {
            return this.image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageListener(ImageListener imageListener) {
        Image image;
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.imageListeners;
        synchronized (arrayList2) {
            image = this.image;
            arrayList.add(imageListener);
        }
        if (image != null) {
            imageListener.imageLoaded(new ImageEvent(this, image));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImageListener(ImageListener imageListener) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.imageListeners;
        synchronized (arrayList2) {
            arrayList.remove(arrayList);
        }
    }

    void resetInput() {
        InputContext inputContext = this.inputContext;
        if (inputContext != null) {
            inputContext.resetInput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent(String string, ImageEvent imageEvent) {
        ImageListener[] imageListenerArray;
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.imageListeners;
        synchronized (arrayList2) {
            if (!string.equals(this.imageSrc)) {
                return;
            }
            this.image = imageEvent.image;
            imageListenerArray = arrayList.toArray(ImageListener.EMPTY_ARRAY);
        }
        int n = imageListenerArray.length;
        for (int i = 0; i < n; ++i) {
            imageListenerArray[i].imageLoaded(imageEvent);
        }
        Function function = this.getOnload();
        if (function != null) {
            Executor.executeFunction(this, function, null);
        }
    }

    private class LocalImageListener
    implements ImageListener {
        private final String expectedImgSrc;

        public LocalImageListener(String string) {
            this.expectedImgSrc = string;
        }

        public void imageLoaded(ImageEvent imageEvent) {
            HTMLBaseInputElement.this.dispatchEvent(this.expectedImgSrc, imageEvent);
        }
    }
}

