/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FormInput {
    public static final FormInput[] EMPTY_ARRAY = new FormInput[0];
    private final String name;
    private final String textValue;
    private final File fileValue;

    public FormInput(String string, String string2) {
        this.name = string;
        this.textValue = string2;
        this.fileValue = null;
    }

    public FormInput(String string, File file) {
        this.name = string;
        this.textValue = null;
        this.fileValue = file;
    }

    public String getName() {
        return this.name;
    }

    public boolean isText() {
        return this.textValue != null;
    }

    public boolean isFile() {
        return this.fileValue != null;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public File getFileValue() {
        return this.fileValue;
    }

    public String getCharset() {
        return "UTF-8";
    }

    public InputStream getInputStream() throws IOException {
        if (this.isText()) {
            return new ByteArrayInputStream(this.getTextValue().getBytes("UTF-8"));
        }
        if (this.isFile()) {
            return new FileInputStream(this.getFileValue());
        }
        return null;
    }

    public String toString() {
        return "FormInput[name=" + this.name + ",textValue=" + this.textValue + "]";
    }
}

