/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.dom.Property;
import com.steadystate.css.parser.CSSOMParser;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSStyleDeclarationImpl
implements CSSStyleDeclaration,
Serializable {
    private final CSSRule _parentRule;
    private final ArrayList _properties = new ArrayList(4);
    private final Map _propertiesMap = new HashMap(6);

    public CSSStyleDeclarationImpl(CSSRule cSSRule) {
        this._parentRule = cSSRule;
    }

    public String getCssText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        ArrayList arrayList = this._properties;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Property property = (Property)arrayList.get(i);
            if (property != null) {
                stringBuffer.append(property.toString());
            }
            if (i >= n - 1) continue;
            stringBuffer.append("; ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void setCssText(String string) throws DOMException {
        try {
            InputSource inputSource = new InputSource(new StringReader(string));
            CSSOMParser cSSOMParser = new CSSOMParser();
            this._properties.clear();
            this._propertiesMap.clear();
            cSSOMParser.parseStyleDeclaration(this, inputSource);
        }
        catch (Exception exception) {
            throw new DOMExceptionImpl(12, 0, exception.getMessage());
        }
    }

    public String getPropertyValue(String string) {
        Property property = this.getPropertyDeclaration(string);
        return property != null ? property.getValue().getCssText() : "";
    }

    public CSSValue getPropertyCSSValue(String string) {
        Property property = this.getPropertyDeclaration(string);
        return property != null ? property.getValue() : null;
    }

    public String removeProperty(String string) throws DOMException {
        Map map = this._propertiesMap;
        Property property = (Property)map.remove(string.toLowerCase());
        if (property != null) {
            this._properties.remove(property);
            CSSValue cSSValue = property.getValue();
            return cSSValue == null ? "" : cSSValue.getCssText();
        }
        return "";
    }

    public String getPropertyPriority(String string) {
        Property property = this.getPropertyDeclaration(string);
        if (property != null) {
            return property.isImportant() ? "important" : "";
        }
        return "";
    }

    public void setProperty(String string, String string2, String string3) throws DOMException {
        try {
            boolean bl;
            InputSource inputSource = new InputSource(new StringReader(string2));
            CSSOMParser cSSOMParser = new CSSOMParser();
            CSSValue cSSValue = cSSOMParser.parsePropertyValue(inputSource);
            Property property = this.getPropertyDeclaration(string);
            boolean bl2 = bl = string3 != null ? string3.equalsIgnoreCase("important") : false;
            if (property == null) {
                property = new Property(string, cSSValue, bl);
                this.addProperty(property);
            } else {
                property.setValue(cSSValue);
                property.setImportant(bl);
            }
        }
        catch (Exception exception) {
            throw new DOMExceptionImpl(12, 0, exception.getMessage());
        }
    }

    public int getLength() {
        return this._properties.size();
    }

    public String item(int n) {
        Property property = (Property)this._properties.get(n);
        return property != null ? property.getName() : "";
    }

    public CSSRule getParentRule() {
        return this._parentRule;
    }

    public void addProperty(Property property) {
        this._propertiesMap.put(property.getName().toLowerCase(), property);
        this._properties.add(property);
    }

    private Property getPropertyDeclaration(String string) {
        return (Property)this._propertiesMap.get(string.toLowerCase());
    }

    public String toString() {
        return this.getCssText();
    }
}

