/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.CSSRuleListImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.parser.CSSOMParser;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSMediaRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class CSSMediaRuleImpl
implements CSSMediaRule,
Serializable {
    private CSSStyleSheetImpl _parentStyleSheet = null;
    private CSSRule _parentRule = null;
    private MediaList _media = null;
    private CSSRuleList _rules = null;

    public CSSMediaRuleImpl(CSSStyleSheetImpl cSSStyleSheetImpl, CSSRule cSSRule, MediaList mediaList) {
        this._parentStyleSheet = cSSStyleSheetImpl;
        this._parentRule = cSSRule;
        this._media = mediaList;
    }

    public short getType() {
        return 4;
    }

    public String getCssText() {
        StringBuffer stringBuffer = new StringBuffer("@media ");
        stringBuffer.append(this.getMedia().toString()).append(" {");
        for (int i = 0; i < this.getCssRules().getLength(); ++i) {
            CSSRule cSSRule = this.getCssRules().item(i);
            stringBuffer.append(cSSRule.getCssText()).append(" ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void setCssText(String string) throws DOMException {
        if (this._parentStyleSheet != null && this._parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource inputSource = new InputSource(new StringReader(string));
            CSSOMParser cSSOMParser = new CSSOMParser();
            CSSRule cSSRule = cSSOMParser.parseRule(inputSource);
            if (cSSRule.getType() != 4) {
                throw new DOMExceptionImpl(13, 7);
            }
            this._media = ((CSSMediaRuleImpl)cSSRule)._media;
            this._rules = ((CSSMediaRuleImpl)cSSRule)._rules;
        }
        catch (CSSException cSSException) {
            throw new DOMExceptionImpl(12, 0, cSSException.getMessage());
        }
        catch (IOException iOException) {
            throw new DOMExceptionImpl(12, 0, iOException.getMessage());
        }
    }

    public CSSStyleSheet getParentStyleSheet() {
        return this._parentStyleSheet;
    }

    public CSSRule getParentRule() {
        return this._parentRule;
    }

    public MediaList getMedia() {
        return this._media;
    }

    public CSSRuleList getCssRules() {
        return this._rules;
    }

    public int insertRule(String string, int n) throws DOMException {
        if (this._parentStyleSheet != null && this._parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource inputSource = new InputSource(new StringReader(string));
            CSSOMParser cSSOMParser = new CSSOMParser();
            cSSOMParser.setParentStyleSheet(this._parentStyleSheet);
            CSSRule cSSRule = cSSOMParser.parseRule(inputSource);
            ((CSSRuleListImpl)this.getCssRules()).insert(cSSRule, n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new DOMExceptionImpl(1, 1, arrayIndexOutOfBoundsException.getMessage());
        }
        catch (CSSException cSSException) {
            throw new DOMExceptionImpl(12, 0, cSSException.getMessage());
        }
        catch (IOException iOException) {
            throw new DOMExceptionImpl(12, 0, iOException.getMessage());
        }
        return n;
    }

    public void deleteRule(int n) throws DOMException {
        if (this._parentStyleSheet != null && this._parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            ((CSSRuleListImpl)this.getCssRules()).delete(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new DOMExceptionImpl(1, 1, arrayIndexOutOfBoundsException.getMessage());
        }
    }

    public void setRuleList(CSSRuleListImpl cSSRuleListImpl) {
        this._rules = cSSRuleListImpl;
    }

    public String toString() {
        return this.getCssText();
    }
}

