/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.parser.CSSOMParser;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSCharsetRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleSheet;

public class CSSCharsetRuleImpl
implements CSSCharsetRule,
Serializable {
    CSSStyleSheetImpl _parentStyleSheet = null;
    CSSRule _parentRule = null;
    String _encoding = null;

    public CSSCharsetRuleImpl(CSSStyleSheetImpl cSSStyleSheetImpl, CSSRule cSSRule, String string) {
        this._parentStyleSheet = cSSStyleSheetImpl;
        this._parentRule = cSSRule;
        this._encoding = string;
    }

    public short getType() {
        return 2;
    }

    public String getCssText() {
        return "@charset \"" + this.getEncoding() + "\";";
    }

    public void setCssText(String string) throws DOMException {
        if (this._parentStyleSheet != null && this._parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource inputSource = new InputSource(new StringReader(string));
            CSSOMParser cSSOMParser = new CSSOMParser();
            CSSRule cSSRule = cSSOMParser.parseRule(inputSource);
            if (cSSRule.getType() != 2) {
                throw new DOMExceptionImpl(13, 5);
            }
            this._encoding = ((CSSCharsetRuleImpl)cSSRule)._encoding;
        }
        catch (CSSException cSSException) {
            throw new DOMExceptionImpl(12, 0, cSSException.getMessage());
        }
        catch (IOException iOException) {
            throw new DOMExceptionImpl(12, 0, iOException.getMessage());
        }
    }

    public CSSStyleSheet getParentStyleSheet() {
        return this._parentStyleSheet;
    }

    public CSSRule getParentRule() {
        return this._parentRule;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String string) throws DOMException {
        this._encoding = string;
    }
}

