/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.model.wsdl;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.EndpointAddress;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.binding.WebServiceFeatureList;
import com.sun.xml.internal.ws.model.wsdl.AbstractFeaturedObjectImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLBoundPortTypeImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLModelImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLServiceImpl;
import com.sun.xml.internal.ws.resources.ClientMessages;
import com.sun.xml.internal.ws.util.exception.LocatableWebServiceException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;

public final class WSDLPortImpl
extends AbstractFeaturedObjectImpl
implements WSDLPort {
    private final QName name;
    private EndpointAddress address;
    private final QName bindingName;
    private final WSDLServiceImpl owner;
    private WSEndpointReference epr;
    private WSDLBoundPortTypeImpl boundPortType;

    public WSDLPortImpl(XMLStreamReader xMLStreamReader, WSDLServiceImpl wSDLServiceImpl, QName qName, QName qName2) {
        super(xMLStreamReader);
        this.owner = wSDLServiceImpl;
        this.name = qName;
        this.bindingName = qName2;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    public QName getBindingName() {
        return this.bindingName;
    }

    @Override
    public EndpointAddress getAddress() {
        return this.address;
    }

    @Override
    public WSDLServiceImpl getOwner() {
        return this.owner;
    }

    public void setAddress(EndpointAddress endpointAddress) {
        assert (endpointAddress != null);
        this.address = endpointAddress;
    }

    public void setEPR(@NotNull WSEndpointReference wSEndpointReference) {
        assert (wSEndpointReference != null);
        this.addExtension(wSEndpointReference);
        this.epr = wSEndpointReference;
    }

    @Nullable
    public WSEndpointReference getEPR() {
        return this.epr;
    }

    @Override
    public WSDLBoundPortTypeImpl getBinding() {
        return this.boundPortType;
    }

    public SOAPVersion getSOAPVersion() {
        return this.boundPortType.getSOAPVersion();
    }

    void freeze(WSDLModelImpl wSDLModelImpl) {
        this.boundPortType = wSDLModelImpl.getBinding(this.bindingName);
        if (this.boundPortType == null) {
            throw new LocatableWebServiceException(ClientMessages.UNDEFINED_BINDING(this.bindingName), this.getLocation());
        }
        if (this.features == null) {
            this.features = new WebServiceFeatureList();
        }
        this.features.setParentFeaturedObject(this.boundPortType);
        this.notUnderstoodExtensions.addAll(this.boundPortType.notUnderstoodExtensions);
    }
}

