/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public final class WindowsTabbedPaneUI
extends com.sun.java.swing.plaf.windows.WindowsTabbedPaneUI {
    private static final boolean IS_XP_LAF_5_OR_LATER = LookUtils.IS_JAVA_5_OR_LATER && LookUtils.IS_LAF_WINDOWS_XP_ENABLED;
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static final int INSET = IS_XP_LAF_5_OR_LATER ? -1 : 1;
    private static final Insets NO_CONTENT_BORDER_NORTH_INSETS = new Insets(INSET, 0, 0, 0);
    private static final Insets NO_CONTENT_BORDER_WEST_INSETS = new Insets(0, INSET, 0, 0);
    private static final Insets NO_CONTENT_BORDER_SOUTH_INSETS = new Insets(0, 0, INSET, 0);
    private static final Insets NO_CONTENT_BORDER_EAST_INSETS = new Insets(0, 0, 0, INSET);
    private static final Insets CONTENT_BORDER_NORTH_INSETS = new Insets(0, 2, 4, 4);
    private static final Insets CONTENT_BORDER_WEST_INSETS = new Insets(2, 0, 4, 4);
    private static final Insets CONTENT_BORDER_SOUTH_INSETS = new Insets(4, 2, 0, 4);
    private static final Insets CONTENT_BORDER_EAST_INSETS = new Insets(2, 4, 4, 0);
    private static boolean isTabIconsEnabled = Options.isTabIconsEnabled();
    private Boolean noContentBorder;
    private Boolean embeddedTabs;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsTabbedPaneUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.embeddedTabs = (Boolean)jComponent.getClientProperty("jgoodies.embeddedTabs");
        this.noContentBorder = (Boolean)jComponent.getClientProperty("jgoodies.noContentBorder");
    }

    private boolean hasNoContentBorder() {
        return this.hasEmbeddedTabs() || Boolean.TRUE.equals(this.noContentBorder);
    }

    private boolean hasEmbeddedTabs() {
        return this.embeddedTabs == null ? false : this.embeddedTabs;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new MyPropertyChangeHandler();
    }

    private void doLayout() {
        this.tabPane.revalidate();
        this.tabPane.repaint();
    }

    private void embeddedTabsPropertyChanged(Boolean bl) {
        this.embeddedTabs = bl;
        this.doLayout();
    }

    private void noContentBorderPropertyChanged(Boolean bl) {
        this.noContentBorder = bl;
        this.doLayout();
    }

    protected Icon getIconForTab(int n) {
        String string = this.tabPane.getTitleAt(n);
        boolean bl = string != null && string.length() > 0;
        return !isTabIconsEnabled && bl ? null : super.getIconForTab(n);
    }

    protected Insets getContentBorderInsets(int n) {
        if (!this.hasNoContentBorder()) {
            if (IS_XP_LAF_5_OR_LATER) {
                switch (n) {
                    case 4: {
                        return CONTENT_BORDER_EAST_INSETS;
                    }
                    case 2: {
                        return CONTENT_BORDER_WEST_INSETS;
                    }
                    case 1: {
                        return CONTENT_BORDER_NORTH_INSETS;
                    }
                }
                return CONTENT_BORDER_SOUTH_INSETS;
            }
            return this.contentBorderInsets;
        }
        if (this.hasEmbeddedTabs()) {
            return EMPTY_INSETS;
        }
        switch (n) {
            case 4: {
                return NO_CONTENT_BORDER_EAST_INSETS;
            }
            case 2: {
                return NO_CONTENT_BORDER_WEST_INSETS;
            }
            case 1: {
                return NO_CONTENT_BORDER_NORTH_INSETS;
            }
        }
        return NO_CONTENT_BORDER_SOUTH_INSETS;
    }

    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        switch (n) {
            case 4: {
                return bl ? 2 : 0;
            }
            case 2: {
                return bl ? -2 : 0;
            }
        }
        return 0;
    }

    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        return 0;
    }

    protected Insets getSelectedTabPadInsets(int n) {
        int n2;
        if (this.hasEmbeddedTabs()) {
            return EMPTY_INSETS;
        }
        if (this.hasNoContentBorder()) {
            int n3 = IS_XP_LAF_5_OR_LATER ? 1 : 0;
            switch (n) {
                case 2: {
                    return new Insets(1, 2, 1, n3);
                }
                case 4: {
                    return new Insets(1, n3, 1, 2);
                }
                case 1: {
                    return new Insets(2, 2, n3, 2);
                }
                case 3: {
                    return new Insets(n3, 2, 2, 2);
                }
            }
            return EMPTY_INSETS;
        }
        Insets insets = super.getSelectedTabPadInsets(n);
        insets.left = insets.right = (n2 = insets.left + insets.right / 2);
        return insets;
    }

    protected Insets getTabAreaInsets(int n) {
        return this.hasEmbeddedTabs() ? EMPTY_INSETS : super.getTabAreaInsets(n);
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle rectangle;
        if (this.hasNoContentBorder() && n != 1) {
            return;
        }
        Rectangle rectangle2 = rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        if (n != 1 || n2 < 0 || rectangle.y + rectangle.height + 1 < n4 || rectangle.x < n3 || rectangle.x > n3 + n5) {
            super.paintContentBorderTopEdge(graphics, n, n2, n3, n4, n5, n6);
        } else {
            graphics.setColor(this.lightHighlight);
            graphics.fillRect(n3, n4, rectangle.x + 1 - n3, 1);
            graphics.fillRect(rectangle.x + rectangle.width, n4, n3 + n5 - 2 - rectangle.x - rectangle.width, 1);
        }
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (!this.hasNoContentBorder()) {
            Rectangle rectangle;
            Rectangle rectangle2 = rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
            if (n != 3 || n2 < 0 || rectangle.y - 1 > n6 + n4 || rectangle.x < n3 || rectangle.x > n3 + n5) {
                super.paintContentBorderBottomEdge(graphics, n, n2, n3, n4, n5, n6);
            } else {
                graphics.setColor(this.lightHighlight);
                graphics.fillRect(n3, n4 + n6 - 1, 1, 1);
                graphics.setColor(this.shadow);
                graphics.fillRect(n3 + 1, n4 + n6 - 2, rectangle.x - 1 - n3, 1);
                graphics.fillRect(rectangle.x + rectangle.width, n4 + n6 - 2, n3 + n5 - 2 - rectangle.x - rectangle.width, 1);
                graphics.setColor(this.darkShadow);
                graphics.fillRect(n3, n4 + n6 - 1, rectangle.x - n3, 1);
                graphics.fillRect(rectangle.x + rectangle.width - 1, n4 + n6 - 1, n3 + n5 - rectangle.x - rectangle.width, 1);
            }
        } else if (n == 3) {
            graphics.setColor(this.shadow);
            graphics.fillRect(n3, n4 + n6, n5, 1);
        }
    }

    protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (!this.hasNoContentBorder()) {
            Rectangle rectangle;
            Rectangle rectangle2 = rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
            if (n != 2 || n2 < 0 || rectangle.x + rectangle.width + 1 < n3 || rectangle.y < n4 || rectangle.y > n4 + n6) {
                super.paintContentBorderLeftEdge(graphics, n, n2, n3, n4, n5, n6);
            } else {
                graphics.setColor(this.lightHighlight);
                graphics.fillRect(n3, n4, 1, rectangle.y + 1 - n4);
                graphics.fillRect(n3, rectangle.y + rectangle.height, 1, n4 + n6 - 1 - rectangle.y - rectangle.height);
            }
        } else if (n == 2) {
            graphics.setColor(this.shadow);
            graphics.fillRect(n3, n4, 1, n6);
        }
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (!this.hasNoContentBorder()) {
            Rectangle rectangle;
            Rectangle rectangle2 = rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
            if (n != 4 || n2 < 0 || rectangle.x - 1 > n3 + n5 || rectangle.y < n4 || rectangle.y > n4 + n6) {
                super.paintContentBorderRightEdge(graphics, n, n2, n3, n4, n5, n6);
            } else {
                graphics.setColor(this.lightHighlight);
                graphics.fillRect(n3 + n5 - 1, n4, 1, 1);
                graphics.setColor(this.shadow);
                graphics.fillRect(n3 + n5 - 2, n4 + 1, 1, rectangle.y - 1 - n4);
                graphics.fillRect(n3 + n5 - 2, rectangle.y + rectangle.height, 1, n4 + n6 - 1 - rectangle.y - rectangle.height);
                graphics.setColor(this.darkShadow);
                graphics.fillRect(n3 + n5 - 1, n4, 1, rectangle.y - n4);
                graphics.fillRect(n3 + n5 - 1, rectangle.y + rectangle.height - 1, 1, n4 + n6 - rectangle.y - rectangle.height);
            }
        } else if (n == 4) {
            graphics.setColor(this.shadow);
            graphics.fillRect(n3 + n5, n4, 1, n6);
        }
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        if (!this.hasEmbeddedTabs()) {
            super.paintTabBorder(graphics, n, n2, n3, n4, n5, n6, bl);
            return;
        }
        graphics.translate(n3 - 1, n4 - 1);
        switch (n) {
            case 1: {
                n12 = 1;
                n11 = n5 - 2;
                n10 = 1;
                n9 = 1;
                n8 = n6 - 1;
                n7 = 0;
                break;
            }
            case 3: {
                n12 = 1;
                n11 = n5 - 2;
                n10 = 1;
                n9 = 0;
                n8 = n6 - 1;
                n7 = 1;
                break;
            }
            case 2: {
                n12 = 1;
                n11 = n5 - 1;
                n10 = 0;
                n9 = 1;
                n8 = n6 - 3;
                n7 = 1;
                break;
            }
            default: {
                n12 = 0;
                n11 = n5 - 1;
                n10 = 1;
                n9 = 1;
                n8 = n6 - 3;
                n7 = 1;
            }
        }
        if (bl) {
            graphics.setColor(this.lightHighlight);
            graphics.drawRect(n12, n9, n12 + n11 + n10, n9 + n8 + n7);
            graphics.setColor(this.shadow);
            graphics.fillRect(1 + n12, 0, n11, n9);
            graphics.fillRect(0, 1 + n9, n12, n8);
            graphics.fillRect(2 * n12 + n11 + 2 * n10, 1 + n9, n10, n8);
            graphics.fillRect(1 + n12, 2 * n9 + n8 + 2 * n7, n11, n7);
            graphics.fillRect(1, 1, n12, n9);
            graphics.fillRect(2 * n12 + n11 + n10, 1, n10, n9);
            graphics.fillRect(1, 2 * n9 + n8 + n7, n12, n7);
            graphics.fillRect(2 * n12 + n11 + n10, 2 * n9 + n8 + n7, n10, n7);
        } else {
            graphics.setColor(this.shadow);
            graphics.fillRect(n12 + n11 + 2 * n10, n7 * n8 / 2, n10, n8 * 2 / 3);
            graphics.fillRect(n10 * n11 / 2, n9 + n8 + 2 * n7, n11 / 2 + 2, n7);
        }
        graphics.translate(-n3 + 1, -n4 + 1);
    }

    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        if (!this.hasEmbeddedTabs()) {
            super.paintFocusIndicator(graphics, n, rectangleArray, n2, rectangle, rectangle2, bl);
            return;
        }
        if (this.tabPane.hasFocus() && bl) {
            graphics.setColor(this.focus);
            BasicGraphicsUtils.drawDashedRect(graphics, rectangle2.x - 2, rectangle2.y, rectangle2.width + 3, rectangle2.height);
        }
    }

    protected boolean shouldRotateTabRuns(int n) {
        return !this.hasEmbeddedTabs();
    }

    protected void layoutLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            this.tabPane.putClientProperty("html", view);
        }
        int n3 = this.getTabLabelShiftX(n, n2, bl);
        int n4 = this.getTabLabelShiftY(n, n2, bl);
        if (!(n != 4 && n != 2 || icon == null || string == null || string.equals(""))) {
            SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 2, 0, 11, rectangle, rectangle2, rectangle3, this.textIconGap);
            n3 += 4;
        } else {
            SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 0, 0, 11, rectangle, rectangle2, rectangle3, this.textIconGap);
        }
        this.tabPane.putClientProperty("html", null);
        rectangle2.x += n3;
        rectangle2.y += n4;
        rectangle3.x += n3;
        rectangle3.y += n4;
    }

    private final class MyPropertyChangeHandler
    extends BasicTabbedPaneUI.PropertyChangeHandler {
        private MyPropertyChangeHandler() {
            super((BasicTabbedPaneUI)((Object)WindowsTabbedPaneUI.this));
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            String string = propertyChangeEvent.getPropertyName();
            if (null == string) {
                return;
            }
            if (string.equals("jgoodies.embeddedTabs")) {
                WindowsTabbedPaneUI.this.embeddedTabsPropertyChanged((Boolean)propertyChangeEvent.getNewValue());
                return;
            }
            if (string.equals("jgoodies.noContentBorder")) {
                WindowsTabbedPaneUI.this.noContentBorderPropertyChanged((Boolean)propertyChangeEvent.getNewValue());
                return;
            }
        }
    }
}

