<?php defined('InBizpower') or exit('Access Invalid!');?>
<div class="graytbwrap">
<?php if (!empty($output['chancelist'])){?>
	<table id="gray-table">
		<thead>
			<tr>
				<th><?php echo $lang['bp_chance_subject'];?></th>
				<th><?php echo $lang['bp_chance_user'];?></th>
				<th><?php echo $lang['bp_chance_member'];?></th>
				<th><?php echo $lang['bp_chance_typetext'];?></th>
				<th><?php echo $lang['bp_chance_predictdate'];?></th>
				<th><?php echo $lang['bp_chance_predictmoney'];?></th>
				<th><?php echo $lang['bp_chance_stage'];?></th>
				<th><?php echo $lang['bp_chance_probability'];?></th>
				<th><?php echo $lang['bp_chance_state'];?></th>
				<th><?php echo $lang['bp_chance_stopdays'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php foreach ((array)$output['chancelist'] as $k=>$v){?>
			<tr>
				<td title="<?php echo $v['cha_title'];?>"><?php echo mb_substr($v['cha_title'],0,24,'utf-8'); ?></td>
				<td class="w100"><?php echo $v['cha_username']; ?></td>
				<td class="w100"><a href="index.php?act=customer&op=customer_view&cc_id=<?php echo $v['cha_customerid'];?>" target="_blank"><?php echo $v['cha_customername']; ?></a><span class="f_remind"><?php echo $v['cc_statetext'];?></span></td>
				<td class="w80"><?php echo $v['typetext']; ?></td>
				<td class="w80"><?php echo $v['predictdate_text']; ?></td>
				<td class="w80"><?php echo ncPriceFormat($v['cha_predictmoney']); ?></td>
				<td class="w80"><?php echo $v['stagetext']; ?></td>
				<td class="w50"><?php echo $v['probabilitytext']; ?></td>
				<td class="w50"><?php echo $v['statetext'];?></td>
				<td class="w70"><?php echo $v['stopdays']; ?></td>
			</tr>
			<?php }?>
			<tr>
				<td colspan='5'><?php echo $lang['bp_chance_pagetotal']; ?></td>
				<td colspan='2'><?php echo $output['predmoney_pagecount']; ?></td>
				<td colspan='4'>&nbsp;</td>
			</tr>
			<tr>
				<td colspan='5'><?php echo $lang['bp_chance_alltotal']; ?></td>
				<td colspan='2'><?php echo ncPriceFormat($output['predmoney_count']); ?></td>
				<td colspan='4'>&nbsp;</td>
			</tr>
		</tbody>
	</table>
	<?php }else{?>
	<div class="no_data"><?php echo $lang['no_record'];?></div>
	<?php }?>
</div>
<?php if (!empty($output['chancelist'])){?>
	<div class="paginationmodule fl mgtop9"><?php echo $output['show_page'];?></div>
<?php }?>

<script>
$(document).ready(function(){
	//分页绑定异步加载事件
	$('#chancelist').find('.demo').ajaxContent({
		event:'click',
		loaderType:"img",
		target:'#chancelist'
	});
	//给table加间隔色
	var tableTbody = $("#gray-table tbody");
	$(tableTbody).find("tr:odd").addClass("even");
	$(tableTbody).delegate("tr","mouseover",function(){
		$(this).addClass("hover");
	}).delegate("tr","mouseout",function(){
		$(this).removeClass("hover");
	});
});
</script>