<?php
/**
 * This file is part of the exporting module for Highcharts JS.
 * www.highcharts.com/license
 *
 * !!!  TODO: make this list complete !!!!!!
 * $filename  string   The desired filename without extension
 * $type      string   The MIME type for export.
 * $width     int      The pixel width of the exported raster image. The height is calculated.
 * $svg       string   The SVG source code to convert.
 */
define('InBizpower',true);
set_time_limit(0);
include_once '../../../config.ini.php';
//define ('PHANTOMJS_PATH', 'phantomjs.exe');
if($config['graphexportfile'] == 'phantomjs.exe'){
	define ('PHANTOMJS_PATH', $config['graphexportfile']);
}else{
	define ('PHANTOMJS_PATH', './'.$config['graphexportfile']);
}
define ("PHANTOMJS_SCRIPT", 'highcharts-convert.js');
define ("TMP_DIR", "exporttmp");

function strip_magic_slashes($str)
{
	return get_magic_quotes_gpc() ? stripslashes($str) : $str;
}
function execute($cmd) {
	$descriptors = array(
			0 => array('pipe', 'r'),  // stdin
			1 => array('pipe', 'w'),  // stdout
			2 => array('pipe', 'w')   // stderr
			/*1 => array( 'file' , 'tmp/output' , 'w' ) , #输出，可以为管道或文件  
            2 => array( 'file' , 'tmp/errors' , 'w' )   #错误日志，可以为管道或文件*/
	);
	$stdout = '';
	//Must be enabled functions proc_open ()
	$proc = proc_open(escapeshellcmd($cmd), $descriptors,$pipes);

	if (!is_resource($proc)) {
		throw new Exception('Could not execute process');
	}

	// Set the stdout stream to none-blocking.
	stream_set_blocking($pipes[1], 0);

	$timeout = 3000; // miliseconds.
	$forceKill = true;

	while ($timeout > 0) {
		$start = round(microtime(true) * 1000);

		// Wait until we have output or the timer expired.
		$status = proc_get_status($proc);
		$read = array($pipes[1]);
		stream_select($read, $other, $other, 0, $timeout);

		$stdout .= stream_get_contents($pipes[1]);

		if (!$status['running']) {
			// Break from this loop if the process exited before the timeout.
			$forceKill = false;
			break;
		}

		// Subtract the number of microseconds that we waited.
		$timeout -= round(microtime(true) * 1000) - $start;
	}

	if($forceKill == true) {
		proc_terminate($proc, 9);
	}

	return $stdout;
}
if(empty($_POST['export_svg'])){
	echo "Data export failure";
	die;
}
$svg = array();

if($_POST['isbatch']==1){
	foreach($_POST['export_svg'] as $k=>$v){
		$svg[] = strip_magic_slashes($v);		
	}
}else{
	$svg[] = strip_magic_slashes($_POST['export_svg']);		
}
$type = strip_magic_slashes($_POST['export_type']);
$options = '';
if(!empty($_POST['export_options'])){
	$options = strip_magic_slashes((string) $_POST['export_options']);	
}
$filename = '';
if(!empty($_POST['export_filename'])){
	$filename = strip_magic_slashes((string) $_POST['export_filename']);
	$filename = $filename.date('Y-m-d H-i-s',time());
}
$callback = '';
if(!empty($_POST['export_callback'])){
	$callback = strip_magic_slashes((string) $_POST['export_callback']);	
}
$cmd = "";
// prepare variables
if (empty($filename)) {
	$filename = 'chart';
}
// allow no other than predefined types, default = 'png'
if ($type == 'image/jpeg') {
	$ext = 'jpg';
} elseif ($type == 'application/pdf') {
	$ext = 'pdf';
} elseif ($type == 'image/svg+xml') {
	$ext = 'svg';
} else {
	$type == 'image/png';
	$ext = 'png';
}
// define infile name
$outfile_arr = array();
foreach($svg as $k=>$v){
	if (empty($v)){
		continue;
	}
	$tmpName = md5(rand());
	$infile = TMP_DIR . "/$tmpName.svg";
	//check for malicious attack in SVG
	if(strpos($v,"<!ENTITY") !== false) {
		// TODO: THis was an exploit in Apache/Batik. Possibly better to remove this in Phantom.js?
		exit("Execution is stopped, the posted SVG could contain code for a mailcious attack");
	}
	$filecontent = $v;
	$cmd = "$cmd -infile $infile";
	if(! empty($callback)){
		$callbackFile = TMP_DIR . "/$tmpName.cb.js";
		$cmd = "$cmd -callback $callbackFile";
	}
	$outfile = TMP_DIR . "/$tmpName.$ext";
	$cmd = "$cmd -outfile $outfile";

	$width = '';
	if ($_POST['export_width'] && $_POST['export_width'] != 'undefined') {
		// added != undefined otherwise param -width=0
		$width = "-width " . (int) strip_magic_slashes($_POST['export_width']);
	}
	
	$scale = '';
	if (!empty($_POST['export_scale'])) {
		$scale = "-scale " . (double) strip_magic_slashes($_POST['export_scale']);
	}
	
	//constructor
	$constr = '';
	if (!empty($_POST['export_constr'])) {
		$constr = "-constr " . (string) strip_magic_slashes($_POST['export_constr']);
	}
	
	if (!file_put_contents($infile, $filecontent)) {
		die("Couldn't create temporary file. Check that the directory permissions for
				the /tmp directory are set to 777.");
	}

	if (!empty($callback) && !file_put_contents(TMP_DIR . "/$tmpName.cb.js", $callback)) {
		die("Couldn't create temporary file. Check that the directory permissions for
				the /tmp directory are set to 777.");
	}
	
	// do the conversion
	/*Usage: 'Usage: highcharts-convert.js -infile URL -outfile filename
	-scale 2.5 -width 300 -constr Chart -callback callback.js'*/
	$command = PHANTOMJS_PATH . " " . PHANTOMJS_SCRIPT . " $cmd $width $scale $constr";
	$output = execute($command);
	if (!is_file($outfile) || filesize($outfile) < 10) {
		continue;
	}
	$outfile_arr[] = $outfile;
}
if(empty($outfile_arr)){
	echo "Data export failure";
	die;
}
if($_POST['isbatch']==true){
	require_once('../../../framework/libraries/fpdf.php');//包含fpdf 类库文件
	$pdf=new FPDF('P','mm','A4'); //创建新的FPDF 对象，竖向放纸，单位为毫米，纸张大小A4
	$x = 5;
	$init_y = 10;
	$y = 10;
	$i = 0;
	$y_height = 0;//一页的高度
	foreach ($outfile_arr as $k=>$v){
		/*if ($i%2 == 0){
			$pdf->AddPage(); //增加一页
			$y = 10;
		}*/
		$img_info = getimagesize($v);
		if ($img_info[0] > 200){
			$width = 200;
			$height = $img_info[1]*($width/$img_info[0]);
		}else {
			$width = $img_info[0];
			$height = $img_info[1];
		}
		$y_height = $y+$height+20;
		if ($y_height > 297 && $y > $init_y){//页面高度超出A4纸高度，且不为新页即该页没有插入任何内容
			$y = $init_y;
			$y_height = 0;
		}
		if ($y == $init_y){
			$pdf->AddPage(); //增加一页
		}
		$pdf->Image($v,$x,$y,$width,$height);//增加一张图片
		$y = $y+$height+20;
	}
	$pdf->Output($filename.'.pdf', 'D');
}else{
	header("Content-Disposition: attachment; filename=\"$filename.$ext\"");
	header("Content-Type: $type");
	echo file_get_contents($outfile_arr[0]);
}
//删除文件
deldir(TMP_DIR);
function deldir($dir){
	if (!file_exists($dir)){
		return true;
	}else{
		@chmod($dir, 0777);
	}
	$dh=opendir($dir);
	while ($file=readdir($dh)){
		if($file!="." && $file!=".."){
			$fullpath=$dir."/".$file;
			if(!is_dir($fullpath)) {
				unlink($fullpath);
			} else {
				deldir($fullpath);
			}
		}
	}
}
?>
