<?php
/**
 * 日周月报管理
 * 
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class reportModel  extends Model {
	public function __construct(){
		parent::__construct('report');
	}
	/*
	 * 获得周报列表
	 */
	public function getReportWeekList($where = '',$page = '',$field='*',$order='rpt_recordtime desc'){
		$model = Model();
		if($page == ''){
			$reportlist = $model->table('report')->field($field)->where($where)->order($order)->select();
		}else{
			$reportlist = $model->table('report')->field($field)->where($where)->order($order)->page($page)->select();
		}
		if(!empty($reportlist)){
			foreach((array)$reportlist as $k => $v){
				$v['starttime'] = $v['rpt_recordtime'] -84600*6;
				$v['starttime'] = date('Y-m-d',$v['starttime']);
				$v['endtime'] = date('Y-m-d',$v['rpt_recordtime']);
				$v['weeknum'] = ($v['rpt_recordtime'] - strtotime("+0 week Sunday"))/86400/7;
				$reportlist[$k] = $v;
			}
		}
		return $reportlist;
	}
	/*
	 * 获得月报列表
	 */
	public function getReportMonthList($where = '',$page = '',$field='*',$order='rpt_recordtime desc'){
		$model = Model();
		if($page == ''){
			$reportlist = $model->table('report')->field($field)->where($where)->order($order)->select();
		}else{
			$reportlist = $model->table('report')->field($field)->where($where)->order($order)->page($page)->select();
		}
		if(!empty($reportlist)){
			foreach((array)$reportlist as $k => $v){
				$v['rpt_recordyear'] = date('Y',$v['rpt_recordtime']);
				$v['rpt_recordmonth'] = date('m',$v['rpt_recordtime']);
				$reportlist[$k] = $v;
			}
		}
		return $reportlist;
	}
}