<?php
/**
 * 部门管理
 * 
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class departmentModel  extends Model {
	public function __construct(){
		parent::__construct('department');
	}
	/*
	 * 获得部门树
	 */
	public function getDepartmentTree($where = '',$startid = 0,$type = "getTreeStructure"){
		$dlist = $this->table('department')->where($where)->order('d_depth asc,d_id asc')->select();
		$tree_arr = array();
		if(!empty($dlist)){
			$this->$type($dlist,$tree_arr,$startid);
		}
		return $tree_arr;
	}
	/*
	 * 构造树结构
	 */
	public function getTreeStructure($department, &$tree_arr, $startid = 0, $level = 0){
		if (!empty($department)){			
			foreach ((array)$department as $key => $value)
			{
				if ($value['d_parentid'] == $startid)
				{
					$value['treedepth'] = $level;
					$tree_arr[] = $value;
					unset($department[$key]);
					$level++;
					$this->getTreeStructure($department, $tree_arr, $value['d_id'], $level--);
				}
			}
		}
	}
	/*
	 * 构造树结构并获得子部门
	 */
	public function getTreeStructureAndSon($department, &$tree_arr, $startid = 0, $level = 0){
		if (!empty($department)){
			$departmenttmp = $department;
			foreach ((array)$department as $key => $value)
			{
				if ($value['d_parentid'] == $startid)
				{
					$value['treedepth'] = $level;					
					$value['son'] = array();
					foreach ((array)$departmenttmp as $k_tmp=>$v_tmp){
						if (strpos($v_tmp['d_allparentid'],$value['d_allparentid'].$value['d_id']) !== false){
							$value['son'][] = $v_tmp['d_id'];
						}
					}
					if (!empty($value['son'])){
						$value['son'] = implode(',',$value['son']);
					}else {
						$value['son'] = '';
					}
					$tree_arr[$value['d_id']] = $value;
					unset($department[$key]);
					$level++;
					$this->getTreeStructureAndSon($department, $tree_arr, $value['d_id'], $level--);
				}
			}
		}
	}
	/**
	 * 根据部门缓存获得selecthtml
	 */
	public function getDepartmentCacheSelect($closeshow=false,$currentid=0,$style='',$startid = 0){
		$html = "<option value=''>".Language::get('bp_pleasechoose')."</option>";
		$dlist = ($t = F('department')) ? $t : H('department',true,'file');
		if(!empty($dlist)){
			$dlist_new = array();
			if ($startid > 0){//取部分部门数据
				//取得$startid子部门ID
				if (!empty($dlist[$startid])){
					$son_str = $dlist[$startid]['son'];
					$son_arr[] = $startid;
					if (!empty($son_str)){
						$t = explode(',',$son_str);
						$son_arr = array_merge($son_arr,$t);
					}
					foreach ((array)$son_arr as $k=>$v){
						if ($closeshow == true || $dlist[$v]['d_state'] == 1){
							$dlist_new[] = $dlist[$v];
						}
					}
				}
			}else {
				$dlist_new = $dlist;
			}
			foreach((array)$dlist_new as $k=>$v){
				$stylehtml = $currentid==$v['d_id']?'selected':'';
				$depthhtml = '';
				for($i=0;$i<$v['treedepth'];$i++){
					$depthhtml.="&nbsp;&nbsp;&nbsp;&nbsp;";
				}
				$html.="<option value=\"{$v['d_id']}\" $stylehtml sonid=\"{$v['son']}\">$depthhtml{$v['d_name']}</option>";
			}
		}
		return $html;
	}
	/*
	 * 根据部门缓存获得部门树
	 */
	public function getDepartmentCacheTree($closeshow=false,$currentid='',$startid = 0){
		$dlist = ($t = F('department')) ? $t : H('department',true,'file');
		$dlist_new = array();
		$currentid_arr = array();
		if (!empty($currentid)){
			$currentid_arr = explode(',',$currentid);
		}
		if(!empty($dlist)){
			if ($startid > 0){//取部分部门数据
				//取得$startid子部门ID
				if (!empty($dlist[$startid])){
					$son_str = $dlist[$startid]['son'];
					$son_arr[] = $startid;
					if (!empty($son_str)){
						$t = explode(',',$son_str);
						$son_arr = array_merge($son_arr,$t);
					}
					foreach ((array)$son_arr as $k=>$v){
						if ($closeshow == true || $dlist[$v]['d_state'] == 1){
							if (!empty($currentid_arr) && in_array($v,$currentid_arr)){
								$dlist[$v]['ischeck'] = 1;
							}
							$dlist_new[] = $dlist[$v];
						}
					}
				}
			}else {
				foreach ((array)$dlist as $k=>$v){
					if ($closeshow == true || $v['d_state'] == 1){
						if (!empty($currentid_arr) && in_array($v['d_id'],$currentid_arr)){
							$v['ischeck'] = 1;
						}
						$dlist_new[] = $v;
					}			
				}
			}
		}
		return $dlist_new;
	}
	/*
	 * 获得部门层级数组
	 */
	public function getDepartmentArr($where = ''){
		$dlist = $this->table('department')->where($where)->order('d_depth asc,d_id asc')->select();
		$dlist_new = array();
		if(!empty($dlist)){
			foreach((array)$dlist as $k=>$v){
				if(!empty($v['d_allparentid'])){
					$allparentid_arr = explode(',',$v['d_allparentid']);
					$allparentid_str = '';
					foreach ((array)$allparentid_arr as $k_pid=>$v_pid){
						$allparentid_str .="[$v_pid]";
					}
					$v_str = '';
					foreach ((array)$v as $k_info=>$v_info){
						$v_str .= "'$k_info'=>'$v_info',";
					}
					if (!empty($v_str)){
						$v_str = substr($v_str,0,strlen($v_str)-1);
					}
					$v_str = "array($v_str)";
					$allparentid_str .="[{$v['d_id']}][info]";
					eval("\$dlist_new$allparentid_str=$v_str;");
				}else {
					$dlist_new[$v['d_id']]['info'] = $v;
				}
			}
		}
		return $dlist_new;
	}
}