<?php
/**
 * 会员信息管理
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class customerModel extends Model{
	/**
	 * 会员列表
	 *
	 * @param array $condition 检索条件
	 * @param obj 分页对象
	 * @return array 数组形式的返回结果
	 */
	public function getCustomerList($condition,$page = ''){
		$condition_str = $this->getCondition($condition);
		$param = array();
		$param['where'] = $condition_str;
		$param['table'] = 'customer,user';
		$param['join_type']= 'LEFT JOIN';
		$param['join_on']= array('customer.cc_staff_id = user.user_id');
		$param['field'] = $condition['field'];
		$param['order'] = $condition['order'] ? $condition['order'] : 'customer.cc_id desc';
		$param['group'] = $condition['group'];
		$param['limit'] = $condition['limit'];
		$result = Db::select($param,$page);
		return $result;
	}
	/**
	 * 获取会员详细信息
	 */
	public function getCustomerInfo($condition){
		$condition_str = $this->getCondition($condition);
		$param = array();
		$param['where'] = $condition_str;
		$param['table'] = 'customer';
		$param['field'] = $condition['field'];
		$result = Db::select($param,$page);
		return $result[0];
	}
	/**
	 * 会员转移日志列表
	 *
	 * @param array $condition 检索条件
	 * @param obj 分页对象
	 * @return array 数组形式的返回结果
	 */
	public function getCTList($condition,$page = ''){
		$condition_str = $this->getCondition($condition);
		$param = array();
		$param['where'] = $condition_str;
		$param['table'] = 'ctlog,customer,user';
		$param['join_type']= 'LEFT JOIN';
		$param['join_on']= array('ctlog.cc_id=customer.cc_id','user.user_id in (ctlog.ct_from,ctlog.ct_to,ctlog.ct_opstaffid)');
		$param['field'] = $condition['field'];
		$param['order'] = $condition['order'] ? $condition['order'] : 'ctlog.ct_id desc';
		$param['group'] = $condition['group'];
		$param['limit'] = $condition['limit'];
		$result = Db::select($param,$page);
		return $result;
	}
	/**
	 * 将条件数组组合为SQL语句的条件部分
	 *
	 * @param	array $conditon_array
	 * @return	string
	 */
	private function getCondition($conditon_array){
		$condition_sql = '';
		if($conditon_array['cc_type'] != '') {
			$condition_sql	.= " and `customer`.cc_type = '".$conditon_array['cc_type']."'";
		}
		if($conditon_array['cc_insea'] != '') {
			$condition_sql	.= " and `customer`.cc_insea = '".$conditon_array['cc_insea']."'";
		}
		if($conditon_array['cc_id'] != '') {
			$condition_sql	.= " and `customer`.cc_id = '".$conditon_array['cc_id']."'";
		}
		if($conditon_array['cc_name'] != '') {
			$condition_sql	.= " and `customer`.cc_name like '%".$conditon_array['cc_name']."%'";
		}
		if($conditon_array['cc_shortname'] != '') {
			$condition_sql	.= " and `customer`.cc_shortname like '%".$conditon_array['cc_shortname']."%'";
		}
		if($conditon_array['cc_isdel'] != '') {
			$condition_sql	.= " and `customer`.cc_isdel = '".$conditon_array['cc_isdel']."'";
		}
		if($conditon_array['shop_id'] != '') {
			$condition_sql	.= " and `customer`.shop_id = '".$conditon_array['shop_id']."'";
		}
		if($conditon_array['cc_staff_id'] != '') {
			$condition_sql	.= " and `customer`.cc_staff_id = '".$conditon_array['cc_staff_id']."'";
		}
		if($conditon_array['dp_id'] != '') {
			$dp_array = ($t = F('department')) ? $t : H('department',true,'file');
			$dp_son   = $dp_array[$_SESSION['dp_id']]['son'];
			$condition_sql	.= " and customer.cc_dept_id in (".$_SESSION['dp_id'].($dp_son!=''?",".$dp_son:'').")";
		}
		if($conditon_array['cc_tostaffid'] != '') {
			$condition_sql	.= " and `customer`.cc_tostaffid = '".$conditon_array['cc_tostaffid']."'";
		}
		return $condition_sql;
	}
}