<?php
/**
 * 缓存操作
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class cacheModel extends Model {
	public function __construct(){
		parent::__construct();
	}
	public function call($method){
		$method = '_'.strtolower($method);
		if (method_exists($this,$method)){
			return $this->$method();
		}else{
			return false;
		}
	}
	/**
	 * 基本设置
	 *
	 * @return array
	 */
	private function _setting(){
		$list =$this->table('setting')->where(true)->select();
		$array = array();
		foreach ((array)$list as $v) {
			$array[$v['name']] = $v['value'];
		}
		unset($list);
		return $array;
	}
	/**
	 * 部门缓存
	 */
	private function _department(){
		$model = Model('department');
		//存储未进入回收站的部门信息
		$tree_arr = $model->getDepartmentTree('',0,'getTreeStructureAndSon');		
		return $tree_arr;
	}
	/**
	 * 员工缓存
	 */
	private function _user(){
		$model = Model('user');
		//存储未离职的员工信息
		$user_arr = $model->getUserAndJobpostList(array('user_state'=>array('in','0,1')));
		$user_arr_new = array();
		if (!empty($user_arr)){
			foreach ($user_arr as $k=>$v){
				$user_arr_new[$v['user_id']] = $v;
			}
		}
		return $user_arr_new;
	}
	/**
	 * 商品缓存（键值为“店铺ID|商城商品ID”）
	 */
	private function _product(){
		$tmp_product_list = $this->table('product')->select(array('limit'=>'all'));
		//处理数组信息
		$product_list = array();
		if(!empty($tmp_product_list)){
			foreach ($tmp_product_list as $k=>$v){
				$product_list[$v['shop_id'].'|'.$v['cp_mallpid']] = $v;
			}
		}
		return $product_list;
	}
	/**
	 * 会员缓存（键值为“店铺ID|会员昵称”）
	 */
	private function _customer(){
		$tmp_customer_list = $this->table('customer')->select(array('limit'=>'all'));
		//处理数组信息
		$customer_list = array();
		if(!empty($tmp_customer_list)){
			foreach ($tmp_customer_list as $k=>$v){
				$customer_list[$v['shop_id'].'|'.$v['shop_nickname']] = $v['cc_id'];
			}
		}
		return $customer_list;
	}
	/**
	 * 地址缓存（键值为“会员ID|收货人|收货地址”）
	 */
	private function _address(){
		$tmp_address_list = $this->table('address')->select(array('limit'=>'all'));
		//处理数组信息
		$address_list = array();
		if(!empty($tmp_address_list)){
			foreach ($tmp_address_list as $k=>$v){
				$address_list[$v['cc_id'].'|'.$v['receiver_name'].'|'.$v['address_detail']] = $v['address_id'];
			}
		}
		return $address_list;
	}
	/**
	 * 数据字典缓存
	 */
	private function _dictionary(){
		$model = Model();
		//调取数据库中的数据字典信息并写入缓存文件
		$tmp_array = $model->table('dictionary')->select(array('limit'=>'all'));
		
		$dic_array = array();
		if(is_array($tmp_array) && !empty($tmp_array)){
			foreach ((array)$tmp_array as $k=>$v){
				if($v['cd_parent_id'] == 0){
					$tmp_child_array = array();
					foreach ((array)$tmp_array as $ck=>$cv){
						if($cv['cd_parent_id'] == $v['cd_id']){
							$tmp_child_array[$cv['cd_id']] = array('cd_id'=>$cv['cd_id'],'cd_name'=>$cv['cd_name'],'cd_status'=>$cv['cd_status']);
						}
					}
					$dic_array[$v['cd_key']] = array('class'=>array('cd_id'=>$v['cd_id'],'cd_name'=>$v['cd_name'],'cd_status'=>$v['cd_status'],'cd_model_id'=>$v['cd_model_id']),'child_option'=>$tmp_child_array);
					unset($tmp_child_array);
				}
			}
		}
		return $dic_array;
	}
	/**
	 * 帐套缓存
	 */
	private function _salaryclass(){
		$model = Model();
		$sc_list = $model->table('salaryclass')->order('sc_number asc')->select();
		$tmp_list = array();
		if (!empty($sc_list)){
			foreach ($sc_list as $k=>$v){
				$tmp_list[$v['sc_id']]['info'] = $v;
			}
			$sitem_list = $model->table('salaryitem')->order('sitem_order asc')->select();
			foreach ((array)$sitem_list as $k=>$v){
				$tmp_list[$v['sitem_classid']]['item'][$v['sitem_id']] = $v;
			}
		}
		return $tmp_list;
	}
	/**
	 * 店铺缓存
	 */
	private function _shop(){
		$model = Model();
		$shop_list = $model->table('shop')->where(true)->select();
		$tmp_list = array();
		if (!empty($shop_list)){
			foreach ($shop_list as $k=>$v){
				$tmp_list[$v['shop_id']] = $v;
			}
		}
		return $tmp_list;
	}
}