CREATE TABLE `#__active` (
  `act_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `act_shopid` int(11) NOT NULL COMMENT '店铺ID',
  `act_name` varchar(500) NOT NULL COMMENT '活动名称',
  `act_type` varchar(100) NOT NULL COMMENT '活动类型 sms为短信，email为邮件',
  `act_stime` int(11) NOT NULL DEFAULT '0' COMMENT '开始时间',
  `act_etime` int(11) NOT NULL DEFAULT '0' COMMENT '结束时间',
  `act_sendtime` int(11) NOT NULL DEFAULT '0' COMMENT '执行时间',
  `act_describe` varchar(2000) DEFAULT NULL COMMENT '活动描述',
  `act_cost` decimal(10,4) NOT NULL DEFAULT '0.0000' COMMENT '预期成本',
  `act_cusgroupid` int(11) NOT NULL DEFAULT '0' COMMENT '会员自定义分组ID',
  `act_orderrule` text COMMENT '购买行为规则',
  `act_cusrule` text COMMENT '会员规则',
  `act_arearule` text COMMENT '地区规则',
  `act_cusnum` int(11) NOT NULL DEFAULT '0' COMMENT '会员数',
  `act_cusid` text COMMENT '会员ID字符串用“，”分割',
  `act_tplid` int(11) DEFAULT '0' COMMENT '模板ID',
  `act_content` text COMMENT '内容',
  `act_addtime` int(11) NOT NULL COMMENT '添加时间',
  `act_adduserid` int(11) NOT NULL COMMENT '添加人ID',
  `act_state` tinyint(1) NOT NULL DEFAULT '0' COMMENT '活动状态 0未完成 1已完成',
  `act_savestate` tinyint(4) NOT NULL DEFAULT '0' COMMENT '数据是否已处理保存 0未保存 1已保存',
  PRIMARY KEY (`act_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='营销活动短信活动' AUTO_INCREMENT=1;

CREATE TABLE `#__activedata` (
  `ad_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `ad_shopid` int(11) NOT NULL COMMENT '店铺ID',
  `ad_actid` int(11) NOT NULL COMMENT '活动ID',
  `ad_type` varchar(100) NOT NULL COMMENT '活动类型 sms为短信，email为邮件',
  `ad_stime` int(11) NOT NULL COMMENT '开始时间',
  `ad_etime` int(11) NOT NULL COMMENT '结束时间',
  `ad_sendtime` int(11) NOT NULL DEFAULT '0' COMMENT '发送时间',
  `ad_ccid` int(11) NOT NULL COMMENT '会员ID',
  `ad_title` varchar(2000) DEFAULT NULL COMMENT '标题',
  `ad_content` text NOT NULL COMMENT '内容',
  `ad_state` tinyint(4) NOT NULL DEFAULT '0' COMMENT '发送状态 0未发送 1已发送 ',
  PRIMARY KEY (`ad_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='营销活动发送记录表' AUTO_INCREMENT=1;

CREATE TABLE `#__address` (
  `address_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '地址ID',
  `cc_id` int(11) unsigned NOT NULL COMMENT '客户ID',
  `receiver_name` varchar(50) NOT NULL COMMENT '收货人姓名',
  `address_detail` varchar(1000) NOT NULL COMMENT '收货人详细地址',
  `postcode` int(6) unsigned NOT NULL COMMENT '邮编',
  `phone` varchar(20) NOT NULL COMMENT '收货人座机电话',
  `mobilephone` varchar(20) NOT NULL COMMENT '收货人手机电话',
  `dl_info` text NOT NULL,
  PRIMARY KEY (`address_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='收货地址表' AUTO_INCREMENT=1;

CREATE TABLE `#__attachment` (
  `ca_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '附件ID',
  `ca_name` varchar(100) NOT NULL COMMENT '附件名称',
  `ca_size` int(11) NOT NULL COMMENT '附件大小（单位KB）',
  `ca_type` varchar(10) NOT NULL COMMENT '附件类型',
  `ca_model` varchar(20) NOT NULL COMMENT '所属模块',
  `ca_addstaff` int(11) NOT NULL COMMENT '添加人ID',
  `ca_addtime` int(10) NOT NULL COMMENT '添加时间',
  `ca_note` text NOT NULL COMMENT '附件描述',
  PRIMARY KEY (`ca_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='附件表' AUTO_INCREMENT=1;

CREATE TABLE `#__chance` (
  `cha_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `cha_title` varchar(200) NOT NULL COMMENT '机会主题',
  `cha_customerid` int(11) NOT NULL COMMENT '客户ID',
  `cha_customername` varchar(255) NOT NULL COMMENT '客户名称',
  `cha_contactid` int(11) DEFAULT NULL COMMENT '联系人ID',
  `cha_contactname` varchar(100) DEFAULT NULL COMMENT '联系人姓名',
  `cha_type` int(11) DEFAULT '0' COMMENT '机会类型',
  `cha_discoverydate` int(11) DEFAULT NULL COMMENT '发现时间',
  `cha_addtime` int(11) NOT NULL COMMENT '添加时间',
  `cha_source` int(11) NOT NULL DEFAULT '0' COMMENT '机会来源',
  `cha_adduserid` int(11) NOT NULL COMMENT '创建人ID',
  `cha_addusername` varchar(100) NOT NULL COMMENT '创建人姓名',
  `cha_adddepartmentid` int(11) NOT NULL COMMENT '添加人部门ID',
  `cha_userid` int(11) NOT NULL COMMENT '负责人',
  `cha_username` varchar(100) NOT NULL COMMENT '负责人名称',
  `cha_departmentid` int(11) NOT NULL COMMENT '所属部门ID',
  `cha_needtext` varchar(5000) DEFAULT NULL COMMENT '客户需求',
  `cha_predictdate` int(11) DEFAULT NULL COMMENT '预计完成时间',
  `cha_predictmoney` decimal(14,4) DEFAULT NULL COMMENT '预计金额',
  `cha_stage` int(11) NOT NULL DEFAULT '0' COMMENT '机会阶段',
  `cha_probability` int(11) NOT NULL DEFAULT '0' COMMENT '机会可能性',
  `cha_state` tinyint(4) NOT NULL DEFAULT '0' COMMENT '机会状态 0跟踪,1成功,2失败,3搁置,4失效',
  `cha_stageremark` varchar(2000) DEFAULT NULL COMMENT '阶段备注',
  `cha_stagechangedate` int(11) DEFAULT NULL COMMENT '阶段更改时间',
  `cha_istrash` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否进入回收站 0否 1是',
  PRIMARY KEY (`cha_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='销售机会表' AUTO_INCREMENT=1;

CREATE TABLE `#__chancelog` (
  `chal_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `chal_chanceid` int(11) unsigned NOT NULL COMMENT '被转移机会ID',
  `chal_chancetitle` varchar(1000) NOT NULL COMMENT '机会标题',
  `chal_userid` int(11) unsigned NOT NULL COMMENT '所有人ID',
  `chal_username` varchar(100) NOT NULL COMMENT '所有人名称',
  `chal_departmentid` int(11) NOT NULL COMMENT '部门ID',
  `chal_operatorid` int(11) unsigned NOT NULL COMMENT '操作人ID',
  `chal_operatorname` varchar(100) NOT NULL COMMENT '操作人姓名',
  `chal_type` tinyint(1) NOT NULL COMMENT '日志类型 1为转出日志 2为转入日志',
  `chal_addtime` int(10) unsigned NOT NULL COMMENT '操作时间',
  `chal_note` text NOT NULL COMMENT '备注',
  PRIMARY KEY (`chal_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='销售机会转移日志表' AUTO_INCREMENT=1;

CREATE TABLE `#__chanceprogress` (
  `cp_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `cp_chanceid` int(11) NOT NULL COMMENT '机会ID',
  `cp_adddate` int(11) NOT NULL COMMENT '添加时间',
  `cp_state` tinyint(1) NOT NULL COMMENT '当时状态 0跟踪,1成功,2失败,3搁置,4失效',
  `cp_stage` int(11) NOT NULL DEFAULT '0' COMMENT '当时阶段',
  `cp_operatoruid` int(11) NOT NULL COMMENT '负责人ID',
  `cp_operatoruname` varchar(100) NOT NULL COMMENT '负责人名称',
  `cp_remark` varchar(2000) DEFAULT NULL COMMENT '进程备注',
  PRIMARY KEY (`cp_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='机会进程表' AUTO_INCREMENT=1;

CREATE TABLE `#__clearlog` (
  `clog_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '清除日志ID',
  `clog_type` varchar(15) NOT NULL COMMENT '清除类型',
  `clog_time` int(10) unsigned NOT NULL COMMENT '操作时间',
  `clog_excstaff` int(11) unsigned NOT NULL COMMENT '操作人ID',
  `clog_truename` varchar(100) NOT NULL COMMENT '操作人姓名',
  `clog_content` text NOT NULL COMMENT '清除内容',
  PRIMARY KEY (`clog_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='清除日志' AUTO_INCREMENT=1;

CREATE TABLE `#__commonlog` (
  `clog_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `clog_type` varchar(50) NOT NULL COMMENT '日志类型比如员工',
  `clog_originalid` int(11) DEFAULT NULL COMMENT '原来表中的数据ID',
  `clog_addtime` int(11) NOT NULL COMMENT '添加时间',
  `clog_operatorid` int(11) NOT NULL COMMENT '操作人id',
  `clog_operatorname` varchar(100) NOT NULL COMMENT '操作人名称',
  `clog_content` varchar(2000) NOT NULL COMMENT '日志内容',
  PRIMARY KEY (`clog_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='公用日志表' AUTO_INCREMENT=1;

CREATE TABLE `#__company_contact` (
  `ccc_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '企业联系人ID',
  `cc_id` int(11) unsigned NOT NULL COMMENT '客户ID',
  `cci_id` int(11) unsigned NOT NULL COMMENT '所属企业ID',
  `ccc_important` tinyint(1) unsigned NOT NULL COMMENT '重要程度（1低2中3高）',
  `ccc_isfirst` tinyint(1) unsigned NOT NULL COMMENT '是否是首要联系人（0不是1是）',
  `ccc_name` varchar(50) NOT NULL COMMENT '联系人姓名',
  `ccc_sex` tinyint(1) unsigned NOT NULL COMMENT '性别（1男2女）',
  `ccc_mobilephone` varchar(50) NOT NULL COMMENT '手机',
  `ccc_workphone` varchar(50) NOT NULL COMMENT '工作电话',
  `ccc_homephone` varchar(50) NOT NULL COMMENT '家庭电话',
  `ccc_email` varchar(100) NOT NULL COMMENT '邮箱',
  `ccc_msn` varchar(100) NOT NULL COMMENT 'MSN',
  `ccc_qq` varchar(20) NOT NULL COMMENT 'QQ',
  `ccc_skype` varchar(100) NOT NULL COMMENT 'Skype',
  `ccc_ww` varchar(100) NOT NULL COMMENT '阿里旺旺',
  `ccc_homeaddress` varchar(100) NOT NULL COMMENT '家庭地址',
  `ccc_postcode` varchar(10) NOT NULL COMMENT '邮编',
  `ccc_company_dept` varchar(50) NOT NULL COMMENT '公司部门',
  `ccc_company_job` varchar(50) NOT NULL COMMENT '公司职位',
  `ccc_birthday` int(10) unsigned NOT NULL COMMENT '生日',
  `ccc_hobby` varchar(100) NOT NULL COMMENT '爱好',
  `ccc_addtime` int(11) unsigned NOT NULL COMMENT '添加日期',
  `ccc_addstaffid` int(11) unsigned NOT NULL COMMENT '添加人员ID',
  `ccc_self_field` text NOT NULL COMMENT '自定义属性',
  `ccc_note` text NOT NULL COMMENT '备注',
  `ccc_isdel` tinyint(1) unsigned NOT NULL COMMENT '是否删除',
  PRIMARY KEY (`ccc_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='企业客户联系人表' AUTO_INCREMENT=1;

CREATE TABLE `#__company_info` (
  `cci_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '企业信息ID',
  `cc_id` int(11) unsigned NOT NULL COMMENT '客户ID',
  `cci_staff_size` int(5) unsigned NOT NULL COMMENT '人员规模',
  `cci_intro` varchar(300) NOT NULL COMMENT '公司简介',
  `cci_phone` varchar(20) NOT NULL COMMENT '电话',
  `cci_fax` varchar(20) NOT NULL COMMENT '传真',
  `cci_email` varchar(100) NOT NULL COMMENT '邮箱',
  `cci_postcode` varchar(10) NOT NULL COMMENT '邮编',
  `cci_website` varchar(100) NOT NULL COMMENT '网址',
  `cci_note` text NOT NULL COMMENT '备注',
  PRIMARY KEY (`cci_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='企业客户信息分表' AUTO_INCREMENT=1;

CREATE TABLE `#__competitor` (
  `cpr_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `cpr_companyname` varchar(500) NOT NULL COMMENT '竞争公司名称',
  `cpr_customerid` int(11) NOT NULL COMMENT '客户ID',
  `cpr_customername` varchar(300) NOT NULL COMMENT '客户名称',
  `cpr_chanceid` int(11) NOT NULL COMMENT '机会ID',
  `cpr_chancetitle` varchar(1000) NOT NULL COMMENT '机会标题',
  `cpr_price` decimal(10,2) DEFAULT NULL COMMENT '价格',
  `cpr_competitiveness` int(11) NOT NULL COMMENT '竞争能力',
  `cpr_productsdesc` varchar(2000) NOT NULL COMMENT '竞争相关商品或者方案描述',
  `cpr_superiority` varchar(2000) DEFAULT NULL COMMENT '优势',
  `cpr_inferiority` varchar(2000) DEFAULT NULL COMMENT '劣势',
  `cpr_strategy` varchar(2000) DEFAULT NULL COMMENT '应对策略',
  `cpr_remark` varchar(2000) DEFAULT NULL COMMENT '备注',
  `cpr_addtime` int(11) NOT NULL COMMENT '添加时间',
  `cpr_adduserid` int(11) NOT NULL COMMENT '添加人ID',
  `cpr_addusername` varchar(100) NOT NULL COMMENT '添加人姓名',
  `cpr_adddepartmentid` int(11) NOT NULL COMMENT '添加部门ID',
  `cpr_userid` int(11) NOT NULL COMMENT '负责人ID',
  `cpr_username` varchar(100) NOT NULL COMMENT '负责人名称',
  `cpr_departmentid` int(11) NOT NULL COMMENT '部门ID',
  PRIMARY KEY (`cpr_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='竞争对手表' AUTO_INCREMENT=1;

CREATE TABLE `#__ctlog` (
  `ct_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `cc_id` int(11) unsigned NOT NULL COMMENT '被转移客户ID',
  `ct_from` int(11) unsigned NOT NULL COMMENT '原始所有人ID',
  `ct_to` int(11) unsigned NOT NULL COMMENT '目标所有人ID',
  `ct_opstaffid` int(11) unsigned NOT NULL COMMENT '操作人ID',
  `ct_time` int(10) unsigned NOT NULL COMMENT '操作时间',
  `ct_note` text NOT NULL COMMENT '备注',
  `ct_confirm` tinyint(1) unsigned NOT NULL COMMENT '接收人是否确认0未确认1已确认2已拒绝',
  PRIMARY KEY (`ct_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='客户转移日志表' AUTO_INCREMENT=1;

CREATE TABLE `#__customer` (
  `cc_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '客户ID',
  `cc_name` varchar(255) NOT NULL COMMENT '客户名称',
  `cc_important` tinyint(1) unsigned NOT NULL COMMENT '重要性（1低2中3高）',
  `cc_shortname` varchar(20) NOT NULL COMMENT '助记简称',
  `cc_staff_id` int(11) unsigned NOT NULL COMMENT '所属业务员ID',
  `cc_insea` tinyint(1) unsigned NOT NULL COMMENT '是否是公海客户（0不是1是）',
  `cc_getseatime` int(10) unsigned NOT NULL COMMENT '认领公海客户时间',
  `cc_isdel` tinyint(1) unsigned NOT NULL COMMENT '回收站（1删除进回收站0没有进回收站）',
  `cc_addtime` int(10) unsigned NOT NULL COMMENT '添加时间',
  `cc_addstaffid` int(11) unsigned NOT NULL COMMENT '添加人ID',
  `cc_ispotential` tinyint(1) unsigned NOT NULL COMMENT '是否是潜在客户（0不是1是）',
  `cc_potential_value` tinyint(1) unsigned NOT NULL COMMENT '潜在价值（1低2中3高）',
  `cc_fromactionid` int(11) unsigned NOT NULL COMMENT '来源活动ID',
  `cc_credit_degree` tinyint(1) unsigned NOT NULL COMMENT '客户信用等级（1低2中3高）',
  `cc_class` int(5) unsigned NOT NULL COMMENT '客户种类',
  `cc_industry` int(5) unsigned NOT NULL COMMENT '所属行业',
  `cc_relationship` int(5) unsigned NOT NULL COMMENT '关系等级',
  `cc_from` int(5) unsigned NOT NULL COMMENT '客户来源',
  `cc_worktag` int(5) unsigned NOT NULL COMMENT '工作标签',
  `cc_type` tinyint(1) unsigned NOT NULL COMMENT '客户类型（1企业2个人）',
  `cc_self_field` text NOT NULL COMMENT '自定义字段',
  `cc_dept_id` int(11) unsigned NOT NULL COMMENT '所属部门ID',
  `cc_country` varchar(50) NOT NULL COMMENT '国家地区',
  `cc_province` varchar(50) NOT NULL COMMENT '省份',
  `cc_city` varchar(50) NOT NULL COMMENT '城市',
  `cc_district` varchar(50) NOT NULL COMMENT '区县',
  `cc_address` varchar(100) NOT NULL COMMENT '详细地址',
  `shop_id` int(11) unsigned NOT NULL COMMENT '店铺ID',
  `shop_nickname` varchar(100) NOT NULL COMMENT '店铺买家昵称',
  `cc_tostaffid` tinyint(1) unsigned NOT NULL COMMENT '客户转移目标人ID',
  `cc_transtime` int(10) unsigned NOT NULL COMMENT '转移时间',
  `cc_lat` float NOT NULL COMMENT '客户纬度',
  `cc_lng` float NOT NULL COMMENT '客户经度',
  `cc_grade` int(11) NOT NULL DEFAULT '0' COMMENT '会员等级',
  PRIMARY KEY (`cc_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='客户主表' AUTO_INCREMENT=1;

CREATE TABLE `#__customergrade` (
  `cg_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `cg_name` varchar(100) NOT NULL COMMENT '等级名称',
  `cg_amountlimits` varchar(500) NOT NULL COMMENT '金额范围限制',
  `cg_timeslimits` varchar(500) NOT NULL COMMENT '订单次数限制',
  `cg_shopid` int(11) NOT NULL COMMENT '店铺ID',
  `cg_isdefault` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否默认 0否 1是',
  `cg_ordernum` int(11) NOT NULL COMMENT '排序',
  `cg_updatetime` int(11) NOT NULL COMMENT '更新时间',
  `cg_state` tinyint(4) NOT NULL DEFAULT '1' COMMENT '使用状态 0 关闭 1使用',
  PRIMARY KEY (`cg_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='会员等级表' AUTO_INCREMENT=1;

CREATE TABLE `#__customergroup` (
  `cgroup_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `cgroup_name` varchar(100) NOT NULL COMMENT '分组名称',
  `cgroup_shopid` int(11) NOT NULL COMMENT '店铺ID',
  `cgroup_desc` varchar(2000) DEFAULT NULL COMMENT '描述',
  `cgroup_orderrule` text COMMENT '购买行为规则',
  `cgroup_cusrule` text COMMENT '会员规则',
  `cgroup_arearule` text COMMENT '地区规则',
  `cgroup_cusnum` int(11) NOT NULL DEFAULT '0' COMMENT '会员数',
  `cgroup_cusid` text COMMENT '会员ID字符串用“，”分割',
  `cgroup_updatetime` int(11) NOT NULL COMMENT '统计更新时间',
  PRIMARY KEY (`cgroup_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='会员自定义分组表' AUTO_INCREMENT=1;

CREATE TABLE `#__customer_action` (
  `cca_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '行动ID',
  `cc_id` int(11) unsigned NOT NULL COMMENT '客户ID',
  `cca_chanceid` int(11) DEFAULT NULL COMMENT '销售机会ID',
  `cca_addstaff` int(11) unsigned NOT NULL COMMENT '添加人ID',
  `cca_addtime` int(10) unsigned NOT NULL COMMENT '添加时间',
  `cca_content` text NOT NULL COMMENT '行动内容',
  `cca_start_time` int(10) unsigned NOT NULL COMMENT '起始时间',
  `cca_end_time` int(10) unsigned NOT NULL COMMENT '结束时间',
  `cca_excstaff` text NOT NULL COMMENT '行动执行人',
  `cca_ismission` tinyint(1) unsigned NOT NULL COMMENT '是否任务（0日程1任务2客户关怀）',
  `cca_dp_id` int(11) unsigned NOT NULL COMMENT '所属部门ID',
  PRIMARY KEY (`cca_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='客户行动历史记录表' AUTO_INCREMENT=1;

CREATE TABLE `#__customer_care` (
  `care_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '关怀ID',
  `care_subject` varchar(100) NOT NULL COMMENT '关怀主题',
  `care_date` int(10) unsigned NOT NULL COMMENT '日期',
  `cc_id` int(11) NOT NULL COMMENT '客户ID',
  `ccc_id` int(11) NOT NULL COMMENT '联系人ID（个人客户为0）',
  `care_content` text NOT NULL COMMENT '关怀内容',
  `care_type` int(11) NOT NULL COMMENT '关怀类型',
  `care_feedback` text NOT NULL COMMENT '客户反馈',
  `care_note` text NOT NULL COMMENT '备注',
  `care_addstaff` int(11) unsigned NOT NULL COMMENT '添加人',
  `care_addtime` int(10) unsigned NOT NULL COMMENT '添加时间',
  PRIMARY KEY (`care_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='客户关怀表' AUTO_INCREMENT=1;

CREATE TABLE `#__department` (
  `d_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '部门ID',
  `d_name` varchar(100) NOT NULL COMMENT '部门名称',
  `d_intro` varchar(1000) DEFAULT NULL COMMENT '部门简介',
  `d_parentid` int(11) NOT NULL DEFAULT '0' COMMENT '上级部门ID',
  `d_allparentid` varchar(100) NOT NULL COMMENT '所有上级部门id字符串用","分割',
  `d_depth` int(11) NOT NULL DEFAULT '1' COMMENT '部门层级深度',
  `d_state` tinyint(4) NOT NULL DEFAULT '1' COMMENT '0为关闭 1为开启',
  PRIMARY KEY (`d_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='部门表' AUTO_INCREMENT=1;

INSERT INTO `#__department` (`d_id`, `d_name`, `d_intro`, `d_parentid`, `d_allparentid`, `d_depth`, `d_state`) VALUES
(1, '公司', '公司', 0, '', 0, 1);

CREATE TABLE `#__dictionary` (
  `cd_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '数据字典ID',
  `cd_name` varchar(100) NOT NULL COMMENT '数据内容',
  `cd_parent_id` int(11) unsigned NOT NULL COMMENT '父级ID',
  `cd_status` tinyint(1) unsigned NOT NULL COMMENT '状态（1正常0停止使用）',
  `cd_model_id` int(2) unsigned NOT NULL COMMENT '所属模块id（自定义字段使用，系统默认字段均为0）',
  `cd_key` varchar(50) NOT NULL COMMENT '数据字典key值',
  `cd_listshow_status` tinyint(1) unsigned NOT NULL COMMENT '在模块列表显示（0不是1是）',
  `cd_listsearch_status` tinyint(1) unsigned NOT NULL COMMENT '在模块列表搜索（0不是1是）',
  PRIMARY KEY (`cd_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='数据字典表' AUTO_INCREMENT=1;

CREATE TABLE `#__jobpost` (
  `jp_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '岗位ID',
  `jp_name` varchar(100) NOT NULL COMMENT '岗位名称',
  `jp_intro` varchar(1000) DEFAULT NULL COMMENT '岗位简介',
  `jp_departmentid` int(11) NOT NULL COMMENT '所属部门ID',
  `jp_departmentname` varchar(100) NOT NULL COMMENT '所属部门名称',
  `jp_permissionid` int(11) NOT NULL COMMENT '权限组ID',
  `jp_reportto` int(11) DEFAULT NULL COMMENT '报告给的岗位ID',
  `jp_only` tinyint(4) NOT NULL DEFAULT '0' COMMENT '岗位是否唯一 0不唯一 1唯一',
  `jp_state` tinyint(4) NOT NULL DEFAULT '1' COMMENT '状态 0失效 1有效',
  `jp_isleader` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否为主管 0否 1是',
  PRIMARY KEY (`jp_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='岗位表' AUTO_INCREMENT=1;

INSERT INTO `#__jobpost` (`jp_id`, `jp_name`, `jp_intro`, `jp_departmentid`, `jp_departmentname`, `jp_permissionid`, `jp_reportto`, `jp_only`, `jp_state`,`jp_isleader`) VALUES
(1, '超级管理员', '负责系统全部功能操作及维护', 1, '公司', 1, 1, 1, 1, 0);

CREATE TABLE `#__mission` (
  `cm_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '任务ID',
  `cm_subject` varchar(100) NOT NULL COMMENT '主题',
  `cc_id` int(11) unsigned NOT NULL COMMENT '客户ID',
  `cm_chanceid` int(11) DEFAULT NULL COMMENT '销售机会ID',
  `cm_contact` varchar(100) NOT NULL COMMENT '联系人ID（个人客户为0）',
  `cm_priority` tinyint(1) unsigned NOT NULL COMMENT '优先级（1低2中3高）',
  `cm_donedate` varchar(10) NOT NULL COMMENT '完成期限',
  `cm_excstaff` text NOT NULL COMMENT '执行人ID',
  `cm_status` tinyint(1) NOT NULL COMMENT '状态（1未结束0已结束-1取消）',
  `cm_addstaff` int(11) unsigned NOT NULL COMMENT '创建人ID',
  `cm_addtime` int(10) unsigned NOT NULL COMMENT '创建时间',
  `cm_type` int(11) unsigned NOT NULL COMMENT '任务类型ID',
  `cm_note` text NOT NULL COMMENT '任务描述',
  `cm_attachment` varchar(100) NOT NULL COMMENT '附件ID',
  `cm_dp_id` int(11) unsigned NOT NULL COMMENT '所属部门ID',
  PRIMARY KEY (`cm_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='待办任务表' AUTO_INCREMENT=1;

CREATE TABLE `#__mobilelogin` (
  `uid` int(11) unsigned NOT NULL COMMENT '员工ID',
  `username` varchar(30) NOT NULL COMMENT '员工用户名',
  `ip` varchar(15) NOT NULL COMMENT '登陆IP地址',
  `lastlogin_time` int(10) unsigned NOT NULL COMMENT '最近登陆时间',
  `lastlogin_device` varchar(10) NOT NULL COMMENT '最近登陆移动设备'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='移动设备登陆表';

CREATE TABLE `#__notepad` (
  `np_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `np_title` varchar(200) NOT NULL COMMENT '标题',
  `np_customerid` int(11) DEFAULT NULL COMMENT '客户编号',
  `np_customername` varchar(100) DEFAULT NULL COMMENT '客户名称',
  `np_executetime` int(11) DEFAULT NULL COMMENT '执行时间',
  `np_remindtime` int(11) NOT NULL DEFAULT '0' COMMENT '提醒时间 0为不提醒',
  `np_content` varchar(1000) NOT NULL COMMENT '内容',
  `np_userid` int(11) NOT NULL COMMENT '员工ID',
  `np_username` varchar(100) NOT NULL COMMENT '员工名称',
  `np_attachment` varchar(100) DEFAULT NULL COMMENT '文件附件',
  `np_addtime` int(11) NOT NULL COMMENT '添加时间',
  `np_state` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否结束 0未结束 1结束',
  PRIMARY KEY (`np_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='记事本表' AUTO_INCREMENT=1;

CREATE TABLE `#__notice` (
  `nt_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `nt_recid` int(11) NOT NULL COMMENT '接收者ID 0表示全部员工',
  `nt_recname` varchar(100) DEFAULT NULL COMMENT '接收者姓名',
  `nt_rectype` tinyint(4) NOT NULL DEFAULT '0' COMMENT '接收类型 0表示个人 1表示部门 2 表示全体人员',
  `nt_nttid` int(11) NOT NULL COMMENT '公告内容ID',
  PRIMARY KEY (`nt_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='公告表' AUTO_INCREMENT=1;

CREATE TABLE `#__noticeread` (
  `ntread_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `ntread_uid` int(11) NOT NULL COMMENT '用户ID',
  `ntread_nttid` int(11) NOT NULL COMMENT '公告ID',
  `ntread_state` tinyint(4) NOT NULL COMMENT '状态 1已读 2已删除',
  PRIMARY KEY (`ntread_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='公告读取表' AUTO_INCREMENT=1;

CREATE TABLE `#__noticetext` (
  `ntt_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `ntt_title` varchar(500) NOT NULL COMMENT '标题',
  `ntt_content` text NOT NULL COMMENT '内容',
  `ntt_senduid` int(11) NOT NULL COMMENT '发送者编号',
  `ntt_senduname` varchar(100) NOT NULL COMMENT '发送者名称',
  `ntt_istop` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否置顶 0否 1是',
  `ntt_sendtime` int(11) NOT NULL COMMENT '发送时间',
  `ntt_sendstate` tinyint(4) NOT NULL DEFAULT '0' COMMENT '发送者是否删除 0否 1是',
  `ntt_rectype` tinyint(1) NOT NULL DEFAULT '0' COMMENT '接收类型 0表示个人 1表示部门 2 表示全体人员',
  PRIMARY KEY (`ntt_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='内部公告内容表' AUTO_INCREMENT=1;

CREATE TABLE `#__orders` (
  `co_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '订单ID',
  `shop_id` int(11) unsigned NOT NULL COMMENT '店铺ID',
  `co_malloid` int(11) unsigned NOT NULL,
  `cc_id` int(11) unsigned NOT NULL COMMENT '客户ID',
  `co_staff_id` int(11) unsigned NOT NULL COMMENT '员工ID',
  `dp_id` int(11) unsigned NOT NULL COMMENT '部门ID',
  `co_code` varchar(100) NOT NULL COMMENT '订单编号',
  `co_type` int(11) unsigned NOT NULL COMMENT '订单类型',
  `co_paymethod` int(11) unsigned NOT NULL COMMENT '付款方式',
  `co_return_money` decimal(10,4) unsigned NOT NULL COMMENT '订单回款金额',
  `co_addstaff` int(11) unsigned NOT NULL COMMENT '添加人员ID',
  `co_addtime` int(10) unsigned NOT NULL COMMENT '订单创建时间',
  `late_delivery_time` int(10) unsigned NOT NULL COMMENT '最晚发货时间',
  `address_id` int(11) unsigned NOT NULL COMMENT '收货地址ID',
  `co_total_price` decimal(10,4) NOT NULL COMMENT '商品总价',
  `co_final_price` decimal(10,4) unsigned NOT NULL COMMENT '订单总价',
  `co_cost_price` decimal(10,4) unsigned NOT NULL COMMENT '成本总价',
  `co_note` text NOT NULL COMMENT '备注',
  `co_status` tinyint(1) unsigned NOT NULL COMMENT '订单状态（0进行中1交易完成2已发货3已关闭）',
  `co_statuschangetime` int(11) NOT NULL COMMENT '状态修改时间',
  `co_self_field` text NOT NULL COMMENT '自定义字段',
  `express_delivery` int(10) unsigned NOT NULL COMMENT '物流公司',
  `express_payment` decimal(14,4) unsigned NOT NULL COMMENT '订单运费',
  `express_code` varchar(100) NOT NULL COMMENT '物流单号',
  `co_check` tinyint(1) unsigned NOT NULL COMMENT '订单审核（0未审核1审核通过2异常）',
  `co_checkrp` varchar(2000) NOT NULL COMMENT '审核报告',
  `co_buyermsg` varchar(2000) NOT NULL COMMENT '买家留言',
  `co_sellermemo` varchar(2000) NOT NULL COMMENT '卖家备注',
  `co_subject` varchar(1000) NOT NULL COMMENT '订单主题',
  `co_paytime` int(10) unsigned NOT NULL COMMENT '付款时间',
  `co_hdfk` tinyint(1) unsigned NOT NULL COMMENT '是否货到付款订单（0不是1是）',
  PRIMARY KEY (`co_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='订单表' AUTO_INCREMENT=1;

CREATE TABLE `#__order_log` (
  `col_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '订单日志ID',
  `co_id` int(11) unsigned NOT NULL COMMENT '订单ID',
  `col_staff` int(11) unsigned NOT NULL COMMENT '操作人ID',
  `col_time` int(10) unsigned NOT NULL COMMENT '操作时间',
  `col_content` varchar(2000) NOT NULL COMMENT '日志内容',
  PRIMARY KEY (`col_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='订单日志表' AUTO_INCREMENT=1;

CREATE TABLE `#__order_product` (
  `cop_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `cp_id` int(11) unsigned NOT NULL COMMENT '商品ID',
  `co_id` int(11) unsigned NOT NULL COMMENT '订单ID',
  `cop_unitprice` decimal(10,4) NOT NULL COMMENT '单价',
  `cop_pnum` int(11) unsigned NOT NULL COMMENT '数量',
  `cop_given` int(10) unsigned NOT NULL COMMENT '已交付数量',
  `cop_total_price` decimal(10,4) NOT NULL COMMENT '商品总价',
  `cop_note` text NOT NULL COMMENT '说明',
  `cp_ori_price` decimal(10,4) NOT NULL COMMENT '商品单价（原始价格）',
  `cp_cost` decimal(10,4) NOT NULL COMMENT '商品成本价格',
  `cop_lock` tinyint(1) unsigned NOT NULL COMMENT '是否锁定',
  PRIMARY KEY (`cop_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='订单商品明细表' AUTO_INCREMENT=1;

CREATE TABLE `#__permission` (
  `pmn_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `pmn_name` varchar(100) NOT NULL COMMENT '权限组名称',
  `pmn_accessright` text NOT NULL COMMENT '岗位权限 all表示所有',
  `pmn_sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`pmn_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='权限组' AUTO_INCREMENT=1;

INSERT INTO `#__permission` (`pmn_id`, `pmn_name`, `pmn_accessright`, `pmn_sort`) VALUES
(1, '超级管理员', 'all', 0);

CREATE TABLE `#__personal_info` (
  `cpi_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '个人客户ID',
  `cc_id` int(11) unsigned NOT NULL COMMENT '客户ID',
  `cpi_sex` tinyint(1) unsigned NOT NULL COMMENT '性别（1男2女）',
  `cpi_mobilephone` varchar(50) NOT NULL COMMENT '手机',
  `cpi_workphone` varchar(50) NOT NULL COMMENT '工作电话',
  `cpi_homephone` varchar(50) NOT NULL COMMENT '家庭电话',
  `cpi_fax` varchar(50) NOT NULL COMMENT '传真',
  `cpi_email` varchar(100) NOT NULL COMMENT '邮箱',
  `cpi_msn` varchar(100) NOT NULL COMMENT 'MSN',
  `cpi_qq` varchar(20) NOT NULL COMMENT 'QQ',
  `cpi_skype` varchar(100) NOT NULL COMMENT 'Skype',
  `cpi_ww` varchar(100) NOT NULL COMMENT '阿里旺旺',
  `cpi_postcode` varchar(10) NOT NULL COMMENT '邮编',
  `cpi_birthday` int(10) unsigned NOT NULL COMMENT '生日',
  `cpi_hobby` varchar(100) NOT NULL COMMENT '爱好',
  `cpi_website` varchar(100) NOT NULL COMMENT '网址',
  `cpi_note` text NOT NULL COMMENT '备注',
  PRIMARY KEY (`cpi_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='个人客户信息分表' AUTO_INCREMENT=1;

CREATE TABLE `#__product` (
  `cp_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品ID',
  `cp_ori_price` decimal(14,4) NOT NULL COMMENT '商品单价（原始价格）',
  `cp_lowest_price` decimal(14,4) NOT NULL COMMENT '商品最低销售价格',
  `cp_name` varchar(2000) NOT NULL COMMENT '商品名称',
  `cp_ptime` int(10) unsigned NOT NULL COMMENT '生产日期',
  `cp_otime` int(10) unsigned NOT NULL COMMENT '失效日期',
  `cp_barcode` varchar(100) NOT NULL COMMENT '商品条码',
  `cp_code` varchar(100) NOT NULL COMMENT '商品编码',
  `cp_updatetime` int(10) unsigned NOT NULL COMMENT '更新时间',
  `cp_updatestaff` int(11) unsigned NOT NULL COMMENT '更新人员ID',
  `cp_status` tinyint(1) NOT NULL COMMENT '商品状态（1上架2下架）',
  `cp_self_field` text NOT NULL COMMENT '自定义字段',
  `cp_saleprice` text NOT NULL COMMENT '价格策略',
  `cp_cost` decimal(14,4) unsigned NOT NULL COMMENT '商品成本价格',
  `cp_pic` varchar(1000) NOT NULL COMMENT '商品图片',
  `cp_note` text NOT NULL COMMENT '备注',
  `cp_price_range` int(11) unsigned NOT NULL COMMENT '价格区间',
  `shop_id` int(11) unsigned NOT NULL COMMENT '店铺ID',
  `cp_mallurl` varchar(1000) NOT NULL COMMENT '商品外链地址',
  `cp_mallpid` int(11) unsigned NOT NULL COMMENT '商城商品ID',
  `cp_postfee` decimal(14,4) unsigned NOT NULL COMMENT '平邮费用',
  `cp_expressfee` decimal(14,4) unsigned NOT NULL COMMENT '快递费用',
  `cp_emsfee` decimal(14,4) unsigned NOT NULL COMMENT 'EMS费用',
  `cp_sku` text NOT NULL COMMENT '商品SKU',
  `cp_num` int(11) unsigned NOT NULL COMMENT '库存数量',
  PRIMARY KEY (`cp_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='商品库表' AUTO_INCREMENT=1;

CREATE TABLE `#__quotedprice` (
  `qp_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `qp_title` varchar(500) NOT NULL COMMENT '报价主题',
  `qp_customerid` int(11) NOT NULL COMMENT '客户ID',
  `qp_customername` varchar(200) NOT NULL COMMENT '客户名称',
  `qp_chanceid` int(11) NOT NULL COMMENT '机会ID',
  `qp_chancetitle` varchar(1000) NOT NULL COMMENT '机会标题',
  `qp_quotationdate` int(11) NOT NULL COMMENT '报价日期',
  `qp_amount` decimal(10,4) DEFAULT NULL COMMENT '报价总额',
  `qp_contactid` int(11) DEFAULT NULL COMMENT '联系人ID',
  `qp_contactname` varchar(100) DEFAULT NULL COMMENT '联系人姓名',
  `qp_adduserid` int(11) NOT NULL COMMENT '报价人ID',
  `qp_addusername` varchar(300) NOT NULL COMMENT '报价人名称',
  `qp_adddepartmentid` int(11) NOT NULL COMMENT '添加部门ID',
  `qp_userid` int(11) NOT NULL COMMENT '负责人ID',
  `qp_username` varchar(100) NOT NULL COMMENT '负责人名称',
  `qp_departmentid` int(11) NOT NULL COMMENT '部门ID',
  `qp_deliverexplain` varchar(2000) DEFAULT NULL COMMENT '交付说明',
  `qp_payexplain` varchar(2000) DEFAULT NULL COMMENT '付款说明',
  `qp_transportexplain` varchar(2000) DEFAULT NULL COMMENT '包装运输说明',
  `qp_remark` varchar(2000) DEFAULT NULL COMMENT '备注',
  `qp_addtime` int(11) NOT NULL COMMENT '添加时间',
  PRIMARY KEY (`qp_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='报价表' AUTO_INCREMENT=1;

CREATE TABLE `#__quotedprice_product` (
  `qpp_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `qpp_productid` int(11) unsigned NOT NULL COMMENT '商品ID',
  `qpp_productname` varchar(100) NOT NULL COMMENT '商品名称',
  `qpp_qpid` int(11) unsigned NOT NULL COMMENT '报价单ID',
  `qpp_unitprice` decimal(10,4) NOT NULL COMMENT '商品单价',
  `qpp_pnum` int(11) unsigned NOT NULL COMMENT '数量',
  `qpp_note` text NOT NULL COMMENT '说明',
  PRIMARY KEY (`qpp_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='报价单商品表' AUTO_INCREMENT=1;

CREATE TABLE `#__report` (
  `rpt_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `rpt_userid` int(11) NOT NULL COMMENT '员工ID',
  `rpt_username` varchar(100) NOT NULL COMMENT '员工真实姓名',
  `rpt_jpid` int(11) NOT NULL COMMENT '岗位ID',
  `rpt_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '记录类型 0日报 1周报 2月报',
  `rpt_summary` text COMMENT '总结',
  `rpt_plan` text COMMENT '计划',
  `rpt_issubmit` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否已提交 0暂存 1已提交',
  `rpt_recordtime` int(11) NOT NULL COMMENT '报告时间',
  `rpt_submittime` int(11) NOT NULL COMMENT '提交时间',
  `rpt_delaydays` int(11) NOT NULL DEFAULT '0' COMMENT '延误天数',
  `rpt_pass` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否通过 0未通过 1通过（通过后不可修改）2 退回',
  `rpt_replytext` varchar(5000) DEFAULT NULL COMMENT '批复内容',
  PRIMARY KEY (`rpt_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='日周月报' AUTO_INCREMENT=1;

CREATE TABLE `#__requirement` (
  `req_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `req_title` varchar(300) NOT NULL COMMENT '需求主题',
  `req_customerid` int(11) NOT NULL COMMENT '客户ID',
  `req_customername` varchar(255) NOT NULL COMMENT '客户名称',
  `req_chanceid` int(11) DEFAULT NULL COMMENT '机会ID',
  `req_chancetitle` varchar(1000) DEFAULT NULL COMMENT '销售机会主题',
  `req_adduserid` int(11) NOT NULL COMMENT '添加人ID',
  `req_addusername` varchar(300) NOT NULL COMMENT '添加人名称',
  `req_adddepartmentid` int(11) NOT NULL COMMENT '添加部门ID',
  `req_userid` int(11) NOT NULL COMMENT '负责人ID',
  `req_username` varchar(100) NOT NULL COMMENT '负责人名称',
  `req_departmentid` int(11) NOT NULL COMMENT '部门ID',
  `req_recordtime` int(11) NOT NULL DEFAULT '0' COMMENT '记录时间',
  `req_addtime` int(11) NOT NULL COMMENT '添加时间',
  `req_importantdegree` tinyint(4) NOT NULL DEFAULT '0' COMMENT '重要程度 0未知 1不重要 2一般 3重要 4非常重要',
  `req_content` varchar(2000) NOT NULL COMMENT '详细需要内容',
  `req_completedegree` tinyint(1) NOT NULL DEFAULT '0' COMMENT '完成程度 0未完成 1已完成',
  PRIMARY KEY (`req_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='详细需求表' AUTO_INCREMENT=1;

CREATE TABLE `#__salaryclass` (
  `sc_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增编号',
  `sc_number` varchar(50) NOT NULL COMMENT '帐套编号',
  `sc_name` varchar(100) NOT NULL COMMENT '帐套名称',
  `sc_updatetime` int(11) NOT NULL COMMENT '最后更新时间',
  `sc_state` tinyint(1) NOT NULL DEFAULT '1' COMMENT '帐套状态 0关闭 1开启',
  `sc_operatorid` int(11) DEFAULT NULL COMMENT '操作人ID',
  `sc_operatorname` varchar(100) DEFAULT NULL COMMENT '操作人名',
  PRIMARY KEY (`sc_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='帐套表' AUTO_INCREMENT=1;

CREATE TABLE `#__salaryitem` (
  `sitem_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增编号',
  `sitem_order` int(11) NOT NULL COMMENT '序号',
  `sitem_name` varchar(100) NOT NULL COMMENT '项目名称',
  `sitem_classid` int(11) NOT NULL COMMENT '工资帐套ID',
  `sitem_type` int(11) NOT NULL DEFAULT '1' COMMENT '项目类型  1表示输入项 2表示计算项 3表示所得税项 4表示年终奖个税项 5继承上月项 6 销售提成项 7 考勤项',
  `sitem_roundtype` tinyint(1) NOT NULL COMMENT '舍位方式 0四舍五入 1全舍 2全入',
  `sitem_initial` decimal(10,4) NOT NULL DEFAULT '0.0000' COMMENT '初始值',
  `sitem_isshow` tinyint(1) NOT NULL COMMENT '是否显示 0不显示 1显示',
  `sitem_expression` text COMMENT '计算公式',
  PRIMARY KEY (`sitem_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='帐套工资项表' AUTO_INCREMENT=1;

CREATE TABLE `#__salarypacket` (
  `sp_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增编号',
  `sp_classid` int(11) NOT NULL COMMENT '帐套编号',
  `sp_classname` varchar(100) NOT NULL COMMENT '帐套名称',
  `sp_time` int(11) NOT NULL COMMENT '工资时间',
  `sp_items` text NOT NULL COMMENT '工资项目序列化',
  `sp_finishstate` tinyint(4) NOT NULL DEFAULT '0' COMMENT '结账状态 0未结账 1已结账',
  `sp_operatorid` int(11) NOT NULL COMMENT '操作人ID',
  `sp_operatorname` varchar(100) NOT NULL COMMENT '操作人名',
  `sp_departmentid` int(11) NOT NULL COMMENT '部门ID',
  PRIMARY KEY (`sp_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='工资数据包表' AUTO_INCREMENT=1;

CREATE TABLE `#__salarypacketinfo` (
  `spi_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增编号',
  `spi_userid` int(11) NOT NULL COMMENT '员工ID',
  `spi_spid` int(11) NOT NULL COMMENT '数据包ID',
  `spi_usernumbers` varchar(50) NOT NULL COMMENT '员工编号',
  `spi_truename` varchar(100) NOT NULL COMMENT '真实姓名',
  `spi_departmentid` int(11) NOT NULL COMMENT '部门ID',
  `spi_jobpostid` int(11) NOT NULL COMMENT '岗位ID',
  `spi_time` int(11) NOT NULL COMMENT '工资时间',
  `spi_state` tinyint(4) NOT NULL DEFAULT '0' COMMENT '结账状态 0未结账 1已结账',
  PRIMARY KEY (`spi_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='工资详细表' AUTO_INCREMENT=1;

CREATE TABLE `#__salarypacketitem` (
  `spitem_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增编号',
  `spitem_spid` int(11) NOT NULL COMMENT '数据包ID',
  `spitem_userid` int(11) NOT NULL COMMENT '用户ID',
  `spitem_itemid` int(11) NOT NULL COMMENT '工资项目ID',
  `spitem_money` decimal(10,4) NOT NULL COMMENT '金额',
  PRIMARY KEY (`spitem_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='工资项目金额表' AUTO_INCREMENT=1;

CREATE TABLE `#__schedule` (
  `cs_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '日程ID',
  `cs_subject` varchar(100) NOT NULL COMMENT '主题',
  `cc_id` int(11) unsigned NOT NULL COMMENT '客户ID',
  `cs_chanceid` int(11) DEFAULT NULL COMMENT '销售机会ID',
  `cs_staff_id` int(11) unsigned NOT NULL COMMENT '员工ID',
  `cs_addtime` int(10) unsigned NOT NULL COMMENT '添加时间',
  `cs_start_time` int(10) unsigned NOT NULL COMMENT '起始时间',
  `cs_end_time` int(10) NOT NULL COMMENT '结束时间',
  `cs_note` text NOT NULL COMMENT '日程内容',
  `cs_type` int(11) unsigned NOT NULL COMMENT '日程类型',
  `cs_dp_id` int(11) unsigned NOT NULL COMMENT '所属部门ID',
  PRIMARY KEY (`cs_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='日程表' AUTO_INCREMENT=1;

CREATE TABLE `#__setting` (
  `name` varchar(50) NOT NULL,
  `value` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8  COMMENT='系统设置表';

INSERT INTO `#__setting` (`name`, `value`) VALUES
('system_logo', 'bizpower_crm.png'),
('system_name', 'BizPower CRM'),
('closed_reason', ''),
('site_status', '1'),
('timezone', '-12'),
('use_sea', '1'),
('return_days', '7'),
('max_scnum', '10'),
('auto_gotosea', '1'),
('annualinventorydate_month', '12'),
('annualinventorydate_day', '31'),
('index_mission_maxnum', '10'),
('index_order_maxnum', '10'),
('index_np_maxnum', '10'),
('md5_key', '025b609afef0cdd5545cd8b68806176e'),
('personaltax_rateinfo', 'a:7:{i:0;a:5:{s:5:"order";s:1:"1";s:5:"start";s:1:"0";s:3:"end";s:4:"1500";s:4:"rate";s:1:"3";s:6:"deduct";s:1:"0";}i:1;a:5:{s:5:"order";s:1:"2";s:5:"start";s:4:"1500";s:3:"end";s:4:"4500";s:4:"rate";s:2:"10";s:6:"deduct";s:3:"105";}i:3;a:5:{s:5:"order";s:1:"3";s:5:"start";s:4:"4500";s:3:"end";s:4:"9000";s:4:"rate";s:2:"20";s:6:"deduct";s:3:"555";}i:4;a:5:{s:5:"order";s:1:"4";s:5:"start";s:4:"9000";s:3:"end";s:5:"35000";s:4:"rate";s:2:"25";s:6:"deduct";s:4:"1005";}i:5;a:5:{s:5:"order";s:1:"5";s:5:"start";s:5:"35000";s:3:"end";s:5:"55000";s:4:"rate";s:2:"30";s:6:"deduct";s:4:"2755";}i:6;a:5:{s:5:"order";s:1:"6";s:5:"start";s:5:"55000";s:3:"end";s:5:"80000";s:4:"rate";s:2:"35";s:6:"deduct";s:4:"5505";}i:7;a:5:{s:5:"order";s:1:"7";s:5:"start";s:5:"80000";s:3:"end";s:1:"0";s:4:"rate";s:2:"45";s:6:"deduct";s:5:"13505";}}'),
('personaltax_start', '3500'),
('salepercentage_type', '0'),
('salepercentage_value', '10'),
('cusrfparam', 'a:8:{s:5:"r_min";s:2:"30";s:10:"r_between1";s:2:"31";s:10:"r_between2";s:2:"90";s:5:"r_max";s:2:"91";s:5:"f_min";s:1:"3";s:10:"f_between1";s:1:"4";s:10:"f_between2";s:2:"10";s:5:"f_max";s:2:"11";}');

CREATE TABLE `#__shop` (
  `shop_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '店铺ID',
  `shop_name` varchar(100) NOT NULL COMMENT '店铺名称',
  `shop_class` int(11) NOT NULL COMMENT '店铺分类',
  `shop_province` varchar(50) NOT NULL COMMENT '店铺省份',
  `shop_city` varchar(50) NOT NULL COMMENT '店铺城市',
  `shop_district` varchar(50) NOT NULL COMMENT '店铺区',
  `shop_address` varchar(100) NOT NULL COMMENT '店铺地址',
  `shop_postcode` varchar(10) NOT NULL COMMENT '邮编',
  `shop_contact` varchar(50) NOT NULL COMMENT '联系人',
  `shop_phone` varchar(50) NOT NULL COMMENT '固定电话',
  `shop_mobilephone` varchar(50) NOT NULL COMMENT '手机',
  `shop_url` varchar(100) NOT NULL COMMENT '网店地址',
  `shop_default` tinyint(1) unsigned NOT NULL COMMENT '是否是默认店铺（0不是1是）',
  `shop_platform` tinyint(2) unsigned NOT NULL COMMENT '所属平台（1ShopNC2淘宝3ShopEx单店）',
  `shop_addstaff` int(11) unsigned NOT NULL COMMENT '添加人ID',
  `shop_addtime` int(10) unsigned NOT NULL COMMENT '添加时间',
  `shop_connect` tinyint(1) unsigned NOT NULL COMMENT '是否绑定（0未绑定1已绑定）',
  `shop_platinfo` text NOT NULL COMMENT '店铺平台授权用信息',
  `shop_isuse` tinyint(1) unsigned NOT NULL COMMENT '是否启用（0未启用1已启用）',
  `shop_lastorder` int(11) unsigned NOT NULL COMMENT '店铺最后一次下载的订单创建时间',
  PRIMARY KEY (`shop_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='店铺表' AUTO_INCREMENT=1;

CREATE TABLE `#__solution` (
  `sol_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `sol_title` varchar(300) NOT NULL COMMENT '标题',
  `sol_customerid` int(11) NOT NULL COMMENT '客户ID',
  `sol_customername` varchar(300) NOT NULL COMMENT '客户名称',
  `sol_chanceid` int(11) NOT NULL COMMENT '机会ID',
  `sol_chancetitle` varchar(1000) NOT NULL COMMENT '机会标题',
  `sol_adduserid` int(11) NOT NULL COMMENT '添加人ID',
  `sol_addusername` varchar(300) NOT NULL COMMENT '添加人名称',
  `sol_adddepartmentid` int(11) NOT NULL COMMENT '添加部门ID',
  `sol_userid` int(11) NOT NULL COMMENT '负责人ID',
  `sol_username` varchar(100) NOT NULL COMMENT '负责人名称',
  `sol_departmentid` int(11) NOT NULL COMMENT '部门ID',
  `sol_addtime` int(11) NOT NULL COMMENT '添加时间',
  `sol_content` varchar(6000) NOT NULL COMMENT '内容',
  `sol_feedback` varchar(6000) DEFAULT NULL COMMENT '客户反馈',
  PRIMARY KEY (`sol_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='解决方案表' AUTO_INCREMENT=1;

CREATE TABLE `#__statusersales` (
  `status_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增编号',
  `status_userid` int(11) NOT NULL COMMENT '员工ID',
  `status_usernumbers` varchar(50) NOT NULL COMMENT '员工编号',
  `status_usertruename` varchar(100) NOT NULL COMMENT '员工真实姓名',
  `status_departmentid` int(11) NOT NULL COMMENT '部门ID',
  `status_jobpostid` int(11) NOT NULL COMMENT '岗位ID',
  `status_stattime` int(11) NOT NULL COMMENT '统计时间',
  `status_amount` decimal(10,4) NOT NULL COMMENT '销售额',
  `status_profity` decimal(10,4) NOT NULL COMMENT '毛利',
  `status_addtime` int(11) NOT NULL COMMENT '添加时间',
  PRIMARY KEY (`status_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='员工销售额统计表' AUTO_INCREMENT=1;

CREATE TABLE `#__sysmodule` (
  `sm_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `sm_actkey` varchar(100) NOT NULL COMMENT 'act标识',
  `sm_actname` varchar(100) NOT NULL COMMENT 'act名称',
  `sm_opkey` varchar(100) NOT NULL COMMENT 'op标识',
  `sm_opname` varchar(100) NOT NULL COMMENT 'op名称',
  `sm_sort` int(11) NOT NULL COMMENT '排序',
  PRIMARY KEY (`sm_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='系统功能模块表' AUTO_INCREMENT=1;

INSERT INTO `#__sysmodule` (`sm_actkey`, `sm_actname`, `sm_opkey`, `sm_opname`, `sm_sort`) VALUES
('notice', '公告管理', 'noticepublish', '发布管理', 1),
('work_calendar', '工作台历', 'calendar_show', '查看工作台历', 2),
('mission', '任务管理', 'mission_list', '任务列表', 3),
('mission', '任务管理', 'mission_add', '添加任务', 3),
('mission', '任务管理', 'mission_edit', '编辑任务', 3),
('schedule', '日程管理', 'schedule_list', '日程列表', 4),
('schedule', '日程管理', 'schedule_add', '添加日程', 4),
('schedule', '日程管理', 'schedule_edit', '编辑日程', 4),
('schedule', '日程管理', 'schedule_del', '删除日程', 4),
('report', '日周月报', 'reportreply', '批复管理', 5),
('report', '日周月报', 'reportsubmitstat', '提交情况', 5),
('customer', '会员管理', 'customer_list', '会员列表', 6),
('customer', '会员管理', 'customer_add', '添加会员', 6),
('customer', '会员管理', 'customer_edit', '编辑会员', 6),
('customer', '会员管理', 'contact_add', '添加企业会员联系人', 6),
('customer', '会员管理', 'contact_edit', '编辑企业会员联系人', 6),
('customer', '会员管理', 'contact_del', '删除企业会员联系人', 6),
('customer', '会员管理', 'contact_view', '查看企业会员联系人', 6),
('customer', '会员管理', 'customer_history_list', '会员跟踪日志', 6),
('customercare', '会员关怀', 'care_list', '会员关怀列表', 8),
('customercare', '会员关怀', 'care_add', '新增会员关怀', 8),
('customercare', '会员关怀', 'care_edit', '编辑会员关怀', 8),
('customercare', '会员关怀', 'care_del', '删除会员关怀', 8),
('customergroup', '会员分组', 'cgroupmanage', '自定义分组', 8),
('active', '营销', 'activesms', '短信活动', 9),
('active', '营销', 'activeemail', '邮件活动', 9),
('order', '订购', 'order_list', '订单列表', 10),
('order', '订购', 'order_add', '添加订单', 10),
('order', '订购', 'order_edit', '编辑订单', 10),
('order', '订购', 'close_trade', '关闭交易', 10),
('order', '订购', 'order_log', '订单日志', 10),
('order', '订购', 'order_verify_single', '订单审核', 10),
('order', '订购', 'order_split', '拆单操作', 10),
('order', '订购', 'shipment_confirm', '完成发货', 10),
('chance', '销售机会', 'chancelist', '机会列表', 11),
('chance', '销售机会', 'chanceadd', '新增机会', 11),
('chance', '销售机会', 'chanceedit', '编辑机会', 11),
('chance', '销售机会', 'chancedel', '删除机会', 11),
('chance', '销售机会', 'chanceview', '机会查看', 11),
('chance', '销售机会', 'chancetrashreturn', '恢复机会', 11),
('chance', '销售机会', 'chancetransfer', '机会转移', 11),
('chance', '销售机会', 'chancefiller', '机会漏斗', 11),
('requirement', '会员需求', 'requirementlist', '需求列表', 12),
('requirement', '会员需求', 'requirementadd', '新增需求', 12),
('requirement', '会员需求', 'requirementedit', '编辑需求', 12),
('requirement', '会员需求', 'requirementdel', '删除需求', 12),
('requirement', '会员需求', 'requirementview', '需求查看', 12),
('solution', '解决方案', 'solutionlist', '方案列表', 13),
('solution', '解决方案', 'solutionadd', '新增方案', 13),
('solution', '解决方案', 'solutionedit', '编辑方案', 13),
('solution', '解决方案', 'solutiondel', '删除方案', 13),
('solution', '解决方案', 'solutionview', '方案查看', 13),
('quotedprice', '报价管理', 'quotedpricelist', '报价单列表', 14),
('quotedprice', '报价管理', 'quotedpriceadd', '新增报价单', 14),
('quotedprice', '报价管理', 'quotedpriceedit', '编辑报价单', 14),
('quotedprice', '报价管理', 'quotedpricedel', '删除报价单', 14),
('quotedprice', '报价管理', 'quotedpriceview', '报价单查看', 14),
('competitor', '竞争对手', 'competitorlist', '竞争对手列表', 15),
('competitor', '竞争对手', 'competitoradd', '新增竞争对手', 15),
('competitor', '竞争对手', 'competitoredit', '编辑竞争对手', 15),
('competitor', '竞争对手', 'competitordel', '删除竞争对手', 15),
('competitor', '竞争对手', 'competitorview', '竞争对手查看', 15),
('salaryclass', '薪资帐套', 'salaryclassmanage', '帐套管理', 16),
('salaryclass', '薪资帐套', 'salaryclassview', '帐套查看', 16),
('salary', '薪资管理', 'salaryuser', '员工帐套设定', 16),
('salary', '薪资管理', 'salarypacket', '工资表查看', 16),
('salary', '薪资管理', 'salarypacketmanage', '工资表管理', 16),
('user', '员工管理', 'userlist', '员工列表', 17),
('user', '员工管理', 'useradd', '新增员工', 17),
('user', '员工管理', 'useredit', '员工编辑', 17),
('user', '员工管理', 'userlog', '员工日志', 17),
('product', '商品管理', 'product_list', '商品列表', 18),
('product', '商品管理', 'sku_info', '规格信息', 18),
('product', '商品管理', 'addon_info', '附加信息', 18),
('product', '商品管理', 'quick_edit', '快速编辑', 18),
('statinventory', '年度盘点', 'stati_customer', '会员统计', 19),
('statinventory', '年度盘点', 'stati_product', '商品统计', 19),
('statinventory', '年度盘点', 'stati_sales', '销售统计', 19),
('statinventory', '年度盘点', 'stati_summary', '全年汇总', 19),
('statdetail', '统计图表', 'statdetail_customer', '会员统计', 20),
('statdetail', '统计图表', 'statdetail_chance', '销售机会统计', 20),
('statdetail', '统计图表', 'statdetail_sales', '销售统计', 20),
('statdetail', '统计图表', 'statdetail_tracking', '会员跟踪', 20),
('statdetail', '统计图表', 'statdetail_user', '员工统计', 20),
('statdetail', '统计图表', 'statdetail_product', '商品统计', 20),
('stathistory', '统计历史', 'statusersales', '员工月销售统计', 21),
('logmanage', '日志管理', 'show_firstlog', '使用日志管理中心', 22),
('download', '下载数据', 'download', '下载数据', 23),
('exportdata', '数据导出', 'export_excel', '导出Excel', '24'),
('exportdata', '数据导出', 'export_pdf', '导出PDF', '25');

CREATE TABLE `#__template` (
  `tpl_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '模板ID',
  `tpl_name` varchar(1000) NOT NULL COMMENT '模板名称',
  `tpl_type` varchar(100) NOT NULL COMMENT '分类类型 ‘sms’为短信 ‘email’为邮件',
  `tpl_cid` int(11) NOT NULL COMMENT '所属类别',
  `tpl_content` text NOT NULL COMMENT '内容',
  `tpl_addtime` int(11) NOT NULL COMMENT '添加时间',
  `tpl_state` tinyint(4) NOT NULL DEFAULT '1' COMMENT '状态 0禁用 1启用',
  `tpl_userid` int(11) NOT NULL COMMENT '添加人ID',
  PRIMARY KEY (`tpl_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='活动模板表' AUTO_INCREMENT=1;

CREATE TABLE `#__templateclass` (
  `tc_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `tc_name` varchar(1000) NOT NULL COMMENT '分类名称',
  `tc_type` varchar(100) NOT NULL COMMENT '分类类型 ‘sms’为短信 ‘email’为邮件',
  `tc_remark` varchar(2000) NOT NULL COMMENT '备注',
  `tc_addtime` int(11) NOT NULL COMMENT '添加时间',
  PRIMARY KEY (`tc_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='活动模板分类' AUTO_INCREMENT=1;

CREATE TABLE `#__user` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '员工ID',
  `user_name` varchar(100) NOT NULL COMMENT '员工用户名',
  `user_password` varchar(50) NOT NULL COMMENT '员工密码',
  `user_truename` varchar(100) NOT NULL COMMENT '真实姓名',
  `user_numbers` varchar(50) NOT NULL COMMENT '员工编号',
  `user_avatar` varchar(100) NOT NULL COMMENT '头像',
  `user_addtime` int(11) NOT NULL COMMENT '添加时间',
  `user_department` int(11) NOT NULL COMMENT '部门ID',
  `user_departmentname` varchar(100) NOT NULL COMMENT '部门名称',
  `user_jobpost` int(11) NOT NULL COMMENT '岗位ID',
  `user_jobpostname` varchar(100) NOT NULL COMMENT '岗位名称',
  `user_shopid` int(11) NOT NULL DEFAULT '0' COMMENT '店铺ID',
  `user_salaryclassid` int(11) NOT NULL DEFAULT '0' COMMENT '工资帐套ID',
  `user_state` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态 0在职 1停职 2离职',
  `user_operatorid` int(11) DEFAULT NULL COMMENT '操作人ID',
  `user_operatorname` varchar(100) DEFAULT NULL COMMENT '操作人名称',
  PRIMARY KEY (`user_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='员工信息' AUTO_INCREMENT=1;

CREATE TABLE `#__userextend` (
  `uex_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `uex_userid` int(11) NOT NULL COMMENT '用户ID',
  `uex_sex` tinyint(4) NOT NULL COMMENT '性别 0未知 1女 2男',
  `uex_entrytime` int(11) DEFAULT NULL COMMENT '入职时间',
  `uex_leavingtime` int(11) DEFAULT '0' COMMENT '离职时间',
  `uex_birthday` int(11) DEFAULT NULL COMMENT '生日',
  `uex_education` int(11) NOT NULL DEFAULT '0' COMMENT '0未知 1小学 2初中 4中专 3高中 5大专 6本科 7硕士 8博士 9其他',
  `uex_mobile` varchar(50) DEFAULT NULL COMMENT '手机',
  `uex_telephone` varchar(50) DEFAULT NULL COMMENT '电话',
  `uex_email` varchar(100) DEFAULT NULL COMMENT '邮箱',
  `uex_qq` varchar(20) DEFAULT NULL COMMENT 'QQ',
  `uex_msn` varchar(100) DEFAULT NULL COMMENT 'msn',
  `uex_skype` varchar(100) DEFAULT NULL COMMENT 'skype',
  `uex_province` varchar(100) DEFAULT NULL COMMENT '地址省份',
  `uex_city` varchar(100) DEFAULT NULL COMMENT '地址市',
  `uex_county` varchar(100) DEFAULT NULL COMMENT '地址县',
  `uex_address` varchar(500) DEFAULT NULL COMMENT '详细地址',
  PRIMARY KEY (`uex_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='员工信息扩展表' AUTO_INCREMENT=1;