<?php
/**
 * 压缩解压缩类
 *
 * 文件的压缩解压缩操作
 *
 *
 * @package    library
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class ZipFile{
	/**
	 * 存储压缩数据的数组
	 */
	public $datasec = array();
	/**
	 * 目录
	 */ 
	public $ctrl_dir = array();
	/**
	 * 目录后的编码
	 */
	public $eof_ctrl_dir = "\x50\x4b\x05\x06\x00\x00\x00\x00";

	/**
	 * 旧数据覆盖标识
	 */ 
	public $old_offset = 0;

	/**
	 * 一个Unix时间戳转换为4字节的DOS的日期和时间格式（高两个字节，允许在两个数量级比较低字节时间日期）。
	 *
	 * @param int $unixtime 时间戳
	 * @return int 在一个4字节的DOS格式的当前日期
	 */
	private function   unix2DosTime($unixtime   =   0)   {
		$timearray   =   ($unixtime   ==   0)   ?   getdate()   :   getdate($unixtime);

		if   ($timearray['year']   <   1980)   {
			$timearray['year']         =   1980;
			$timearray['mon']           =   1;
			$timearray['mday']         =   1;
			$timearray['hours']       =   0;
			$timearray['minutes']   =   0;
			$timearray['seconds']   =   0;
		}   //   end   if

		return   (($timearray['year']   -   1980)   <<   25)   |   ($timearray['mon']   <<   21)   |   ($timearray['mday']   <<   16)   |
		($timearray['hours']   <<   11)   |   ($timearray['minutes']   <<   5)   |   ($timearray['seconds']   >>   1);
	}

	/**
	 * 生成一个文件流保存在变量中
	 *
	 * @param string $data 文件内容
	 * @param string $name 文件名
	 * @param int $time 时间戳
	 * @return array $rs_row 返回数组形式的查询结果
	 */
	public function addFile($data,   $name,   $time   =   0)
	{
		$name           =   str_replace('\\',   '/',   $name);

		$dtime         =   dechex($this->unix2DosTime($time));
		$hexdtime   =   '\x'   .   $dtime[6]   .   $dtime[7]
		.   '\x'   .   $dtime[4]   .   $dtime[5]
		.   '\x'   .   $dtime[2]   .   $dtime[3]
		.   '\x'   .   $dtime[0]   .   $dtime[1];
		eval('$hexdtime   =   "'   .   $hexdtime   .   '";');

		$fr       =   "\x50\x4b\x03\x04";
		$fr       .=   "\x14\x00";                         //   ver   needed   to   extract
		$fr       .=   "\x00\x00";                         //   gen   purpose   bit   flag
		$fr       .=   "\x08\x00";                         //   compression   method
		$fr       .=   $hexdtime;                           //   last   mod   time   and   date

		//   "local   file   header"   segment
		$unc_len   =   strlen($data);
		$crc           =   crc32($data);
		$zdata       =   gzcompress($data);
		$zdata       =   substr(substr($zdata,   0,   strlen($zdata)   -   4),   2);   //   fix   crc   bug
		$c_len       =   strlen($zdata);
		$fr             .=   pack('V',   $crc);                           //   crc32
		$fr             .=   pack('V',   $c_len);                       //   compressed   filesize
		$fr             .=   pack('V',   $unc_len);                   //   uncompressed   filesize
		$fr             .=   pack('v',   strlen($name));         //   length   of   filename
		$fr             .=   pack('v',   0);                                 //   extra   field   length
		$fr             .=   $name;

		//   "file   data"   segment
		$fr   .=   $zdata;

		//   "data   descriptor"   segment   (optional   but   necessary   if   archive   is   not
		//   served   as   file)
		$fr   .=   pack('V',   $crc);                                   //   crc32
		$fr   .=   pack('V',   $c_len);                               //   compressed   filesize
		$fr   .=   pack('V',   $unc_len);                           //   uncompressed   filesize

		//   add   this   entry   to   array
		$this   ->   datasec[]   =   $fr;

		//   now   add   to   central   directory   record
		$cdrec   =   "\x50\x4b\x01\x02";
		$cdrec   .=   "\x00\x00";                                 //   version   made   by
		$cdrec   .=   "\x14\x00";                                 //   version   needed   to   extract
		$cdrec   .=   "\x00\x00";                                 //   gen   purpose   bit   flag
		$cdrec   .=   "\x08\x00";                                 //   compression   method
		$cdrec   .=   $hexdtime;                                   //   last   mod   time   &   date
		$cdrec   .=   pack('V',   $crc);                       //   crc32
		$cdrec   .=   pack('V',   $c_len);                   //   compressed   filesize
		$cdrec   .=   pack('V',   $unc_len);               //   uncompressed   filesize
		$cdrec   .=   pack('v',   strlen($name)   );   //   length   of   filename
		$cdrec   .=   pack('v',   0   );                           //   extra   field   length
		$cdrec   .=   pack('v',   0   );                           //   file   comment   length
		$cdrec   .=   pack('v',   0   );                           //   disk   number   start
		$cdrec   .=   pack('v',   0   );                           //   internal   file   attributes
		$cdrec   .=   pack('V',   32   );                         //   external   file   attributes   -   'archive'   bit   set

		$cdrec   .=   pack('V',   $this   ->   old_offset   );   //   relative   offset   of   local   header
		$this   ->   old_offset   +=   strlen($fr);

		$cdrec   .=   $name;

		//   optional   extra   field,   file   comment   goes   here
		//   save   to   central   directory
		$this   ->   ctrl_dir[]   =   $cdrec;
	}   //   end   of   the   'addFile()'   method


	/**
	 * Dumps   out   file   
	 *
	 * @param 
	 * @return string 字符串形式的返回结果，文件流
	 */
	public function file(){
		$data         =   implode('',   $this   ->   datasec);
		$ctrldir   =   implode('',   $this   ->   ctrl_dir);

		return
		$data   .
		$ctrldir   .
		$this   ->   eof_ctrl_dir   .
		pack('v',   sizeof($this   ->   ctrl_dir))   .     //   total   #   of   entries   "on   this   disk"
		pack('v',   sizeof($this   ->   ctrl_dir))   .     //   total   #   of   entries   overall
		pack('V',   strlen($ctrldir))   .                       //   size   of   central   dir
		pack('V',   strlen($data))   .                             //   offset   to   start   of   central   dir
		"\x00\x00";                                                           //   .zip   file   comment   length
	}
}
?>