<?php
/**
 * 淘宝数据获取
 *
 *
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class TopClient{
	public $appKey='test';
	public $appSecret='test';
	/**
	 * 请求数据
	 * 
	 * @param $param 请求参数数组（系统、应用级参数）
	 * @param $tbsb 是否进行沙箱测试（默认是关闭的）
	 * @return 接口返回数据（数组形式）
	 */
	public function reqdata($paramArr=array(),$tbsb=false){
		$paramArr['timestamp']     = date('Y-m-d H:i:s',time());
		$paramArr['format']        = 'json';
		$paramArr['app_key']       = $this->appKey;
		$paramArr['v']             = '2.0';
		$paramArr['sign_method']   = 'md5';
		//生成签名
		$sign = $this->createSign($paramArr);	
		//组织参数	
		$strParam  = $this->createStrParam($paramArr);	
		$strParam .= 'sign='.$sign;
		//访问服务
		if($tbsb){
			$url = 'http://gw.api.tbsandbox.com/router/rest?'.$strParam; //沙箱环境调用地址
		}else{
			$url = 'http://gw.api.taobao.com/router/rest?'.$strParam;//正式运营环境
		}
		$result = file_get_contents($url);
		$result_arr = json_decode($result,true);
		return $result_arr;
	}
	/**
	 * 获取SessionKey
	 * 
	 * @return 成功获得sessionkey会直接返回，否则会返回false
	 */
	public function getsk(){
		$requrl = 'http://container.open.taobao.com/container?authcode='.C('taobao_authcode');
		$result = file_get_contents($requrl);
		if($result != ''){
			if(strstr($result, 'error') !== false){
				return false;
			}
			$tmp_arr    = explode('&', $result);
			$sk_arr     = explode('=', $tmp_arr[2]);
			$sessionkey = $sk_arr[1];
			//将sessionkey存入数据库并更新缓存
			$m  = M();
			$rs = $m->table('setting')->where(array('name'=>'taobao_sessionkey'))->update(array('value'=>$sessionkey));
			H('setting',true);
			return $sessionkey;
		}else{
			return false;
		}
	}
	/**
	 * 签名参数
	 * 
	 */
	private function createSign($paramArr) {
	     ksort($paramArr);
	     $sign = $this->appSecret;
	     foreach ($paramArr as $key => $val) {
	         if ($key != '' && $val != '') {
	             $sign .= $key.$val;
	         }
	     }
	     $sign.=$this->appSecret;
	     $sign = strtoupper(md5($sign));
	     return $sign;
	}
	/**
	 * 拼接参数
	 * 
	 */
	private function createStrParam($paramArr) {
	     $strParam = '';
	     foreach ($paramArr as $key => $val) {
	     if ($key != '' && $val != '') {
	             $strParam .= $key.'='.urlencode($val).'&';
	         }
	     }
	     return $strParam;
	}
}