<?php
/**
 * 公共方法
 *
 * 公共方法
 *
 * @package    function
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
/**
 * 设置cookie
 *
 * @param string $name cookie 的名称
 * @param string $value cookie 的值
 * @param int $expire cookie 有效周期
 * @param string $path cookie 的服务器路径 默认为 /
 * @param string $domain cookie 的域名
 * @param string $secure 是否通过安全的 HTTPS 连接来传输 cookie,默认为false
 */
function setNcCookie($name, $value, $expire='3600', $path='', $domain='', $secure=false){
	if (empty($path)) $path = '/';
	if (empty($domain)) $domain = C("subdomain_suffix") ? C("subdomain_suffix") : '';
	$name = defined('COOKIE_PRE') ? COOKIE_PRE.$name : strtoupper(substr(md5(MD5_KEY),0,4)).'_'.$name;
	$expire = intval($expire)?intval($expire):(intval(SESSION_EXPIRE)?intval(SESSION_EXPIRE):3600);
	$result = setcookie($name, $value, time()+intval($expire), $path, $domain, $secure);
	/**
	 * 同时对$_COOKIE变量进行赋值，这是保证当前进程cookie就有相应的值
	 */
	$_COOKIE[$name] = $value;
}

/**
 * 取得COOKIE的值
 *
 * @param string $name
 * @return unknown
 */
function cookie($name= ''){
	$name = defined('COOKIE_PRE') ? COOKIE_PRE.$name : strtoupper(substr(md5(MD5_KEY),0,4)).'_'.$name;
	return $_COOKIE[$name];
}

/**
 * 输出信息
 *
 * @param string $msg 输出信息
 * @param string/array $url 跳转地址 当$url为数组时，结构为 array('msg'=>'跳转连接文字','url'=>'跳转连接');
 * @param string $show_type 输出格式 默认为html
 * @param string $msg_type 信息类型 succ 为成功，error为失败/错误
 * @param string $is_show  是否显示跳转链接，默认是为1，显示
 * @param int $time 跳转时间，默认为2秒
 * @return string 字符串类型的返回结果
 */
function showMessage($msg,$url='',$show_type='html',$msg_type='succ',$is_show=1,$time=2000){
	if (!class_exists('Language')) import('libraries.language');
	Language::read('core_lang_index');
	$lang	= Language::getLangContent();
	/**
	 * 如果默认为空，则跳转至上一步链接
	 */
	$url = ($url!='' ? $url : getReferer());

	$msg_type = in_array($msg_type,array('succ','error')) ? $msg_type : 'error'; 

	/**
	 * 输出类型
	 */
	switch ($show_type){
		case 'json':
			$return = '{';
			$return .= '"msg":"'.$msg.'",';
			$return .= '"url":"'.$url.'"';
			$return .= '}';
			echo $return;
			break;
		case 'exception':
			echo '<!DOCTYPE html>';
			echo '<html>';
			echo '<head>';
			echo '<meta http-equiv="Content-Type" content="text/html; charset='.CHARSET.'" />';			
			echo '<title>'.SiteUrl.'</title>';
			echo '<style type="text/css">';
			echo 'body { font-family: "Verdana";padding: 0; margin: 0;}';
			echo 'h2 { font-size: 12px; line-height: 30px; border-bottom: 1px dashed #CCC; padding-bottom: 8px;width:800px; margin: 20px 0 0 150px;}';
			echo 'dl { float: left; display: inline; clear: both; padding: 0; margin: 10px 20px 20px 150px;}';
			echo 'dt { font-size: 14px; font-weight: bold; line-height: 40px; color: #333; padding: 0; margin: 0; border-width: 0px;}';
			echo 'dd { font-size: 12px; line-height: 40px; color: #333; padding: 0px; margin:0;}';
			echo '</style>';
			echo '</head>';
			echo '<body>';
			echo '<h2>'.$lang['error_info'].'</h2>';
			echo '<dl>';
			echo '<dd>'.$msg.'</dd>';
			echo '<dt><p /></dt>';
			echo '<dd>'.$lang['error_notice_operate'].'</dd>';
			echo '<dd><p /><p /><p /><p /></dd>';
			echo '<dd><p /><p /><p /><p />Copyright 2007-2013 Bizpower Inc.,All rights reserved. </dd>';
			echo '</dl>';
			echo '</body>';
			echo '</html>';
			exit;
			break;
		case 'javascript':
			echo "<script>";
			echo "alert('". $msg ."');";
			echo "location.href='". $url ."'";
			echo "</script>";
			exit;
			break;
		case 'tenpay':
			echo "<html><head>";
			echo "<meta name=\"TENCENT_ONLINE_PAYMENT\" content=\"China TENCENT\">";
			echo "<script language=\"javascript\">";
			echo "window.location.href='" . $url . "';";
			echo "</script>";
			echo "</head><body></body></html>";
			exit;
			break;
		default:
			if (is_array($url)){
				foreach ($url as $k => $v){
					$url[$k]['url'] = $v['url']?$v['url']:getReferer();
				}
			}
			/**
			 * 读取信息布局的语言包
			 */
			Language::read("msg");
			/**
			 * html输出形式
			 * 指定为指定项目目录下的error模板文件
			 */
			Tpl::setDir('');
			Tpl::output('html_title',Language::get('nc_html_title'));
			Tpl::output('msg',$msg);
			Tpl::output('url',$url);
			Tpl::output('msg_type',$msg_type);
			Tpl::output('is_show',$is_show);
			Tpl::showpage('msg','home_layout',$time);
	}
	exit;
}

/**
 * 消息提示，主要适用于普通页面AJAX提交的情况
 *
 * @param string $message 消息内容
 * @param string $url 提示完后的URL去向
 * @param stting $alert_type 提示类型 error/succ/notice 分别为错误/成功/警示
 * @param string $extrajs 扩展JS
 * @param int $time 停留时间
 */
function showDialog($message = '', $url = '', $alert_type = 'error', $extrajs = '', $time = 2){

	if (empty($_GET['inajax'])){
		if ($url == 'reload') $url = '';
		showMessage($message.$extrajs,$url,'html',$alert_type,1,$time*1000);
	}

	$message = str_replace("'", "\\'", strip_tags($message));

	$paramjs = '';
	if ($url == 'reload'){
		$paramjs = 'window.location.reload()';
	}elseif ($url != ''){
		$paramjs = 'window.location.href =\''.$url.'\'';
	}
	if ($paramjs){
		$paramjs = 'function (){'.$paramjs.'}';
	}else{
		$paramjs = 'null';
	}
	$modes = array('error' => 'alert', 'succ' => 'succ', 'notice' => 'notice','js'=>'js');
	$cover = $alert_type == 'error' ? 1 : 0;
	$extra .= 'showDialog(\''.$message.'\', \''.$modes[$alert_type].'\', null, '.($paramjs ? $paramjs : 'null').', '.$cover.', null, null, null, null, '.(is_numeric($time) ? $time : 'null').', null);';
	$extra = $extra ? '<script type="text/javascript" reload="1">'.$extra.'</script>' : '';
	if ($extrajs != '' && substr(trim($extrajs),0,8) != '<script>'){
		$extrajs = '<script type="text/javascript" reload="1">'.$extrajs.'</script>';
	}
	$extra .= $extrajs;

	ob_end_clean();
	@header("Expires: -1");
	@header("Cache-Control: no-store, private, post-check=0, pre-check=0, max-age=0", FALSE);
	@header("Pragma: no-cache");
	@header("Content-type: text/xml; charset=".CHARSET);

	$string =  '<?xml version="1.0" encoding="'.CHARSET.'"?>'."\r\n";
	$string .= '<root><![CDATA['.$message.$extra.']]></root>';
	echo $string;exit;
}

/**
 * 不显示信息直接跳转
 *
 * @param string $url
 */
function redirect($url = ''){
	if (empty($url)){
		if(!empty($_REQUEST['ref_url'])){
			$url = $_REQUEST['ref_url'];
		}else{
			$url = getReferer();
		}
	}
	header('Location: '.$url);exit();
}

/**
 * 取上一步来源地址
 *
 * @param
 * @return string 字符串类型的返回结果
 */
function getReferer(){
	return empty($_SERVER['HTTP_REFERER'])?'':$_SERVER['HTTP_REFERER'];
}

/**
 * 取验证码hash值
 *
 * @param
 * @return string 字符串类型的返回结果
 */
function getNchash(){
    if (C('captcha_status_login')){ 
        return substr(md5(SiteUrl.$_GET['act'].$_GET['op']),0,8);
    } else {
        return '';
    }
}

/**
 * 加密函数
 *
 * @param string $txt 需要加密的字符串
 * @param string $key 密钥
 * @return string 返回加密结果
 */
function encrypt($txt, $key = ''){
	if (empty($txt)) return $txt;
	if (empty($key)) $key = md5(MD5_KEY);
	$chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_.";
	$ikey ="-x6g6ZWm2G9g_vr0Bo.pOq3kRIxsZ6rm";
	$nh1 = rand(0,64);
	$nh2 = rand(0,64);
	$nh3 = rand(0,64);
	$ch1 = $chars{$nh1};
	$ch2 = $chars{$nh2};
	$ch3 = $chars{$nh3};
	$nhnum = $nh1 + $nh2 + $nh3;
	$knum = 0;$i = 0;
	while(isset($key{$i})) $knum +=ord($key{$i++});
	$mdKey = substr(md5(md5(md5($key.$ch1).$ch2.$ikey).$ch3),$nhnum%8,$knum%8 + 16);
	$txt = base64_encode(time().'_'.$txt);
	$txt = str_replace(array('+','/','='),array('-','_','.'),$txt);
	$tmp = '';
	$j=0;$k = 0;
	$tlen = strlen($txt);
	$klen = strlen($mdKey);
	for ($i=0; $i<$tlen; $i++) {
		$k = $k == $klen ? 0 : $k;
		$j = ($nhnum+strpos($chars,$txt{$i})+ord($mdKey{$k++}))%64;
		$tmp .= $chars{$j};
	}
	$tmplen = strlen($tmp);
	$tmp = substr_replace($tmp,$ch3,$nh2 % ++$tmplen,0);
	$tmp = substr_replace($tmp,$ch2,$nh1 % ++$tmplen,0);
	$tmp = substr_replace($tmp,$ch1,$knum % ++$tmplen,0);
	return $tmp;
}

/**
 * 解密函数
 *
 * @param string $txt 需要解密的字符串
 * @param string $key 密匙
 * @return string 字符串类型的返回结果
 */
function decrypt($txt, $key = '', $ttl = 0){
	if (empty($txt)) return $txt;
	if (empty($key)) $key = md5(MD5_KEY);

	$chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_.";
	$ikey ="-x6g6ZWm2G9g_vr0Bo.pOq3kRIxsZ6rm";
	$knum = 0;$i = 0;
	$tlen = strlen($txt);
	while(isset($key{$i})) $knum +=ord($key{$i++});
	$ch1 = $txt{$knum % $tlen};
	$nh1 = strpos($chars,$ch1);
	$txt = substr_replace($txt,'',$knum % $tlen--,1);
	$ch2 = @$txt{$nh1 % $tlen};
	$nh2 = @strpos($chars,$ch2);
	$txt = @substr_replace($txt,'',$nh1 % $tlen--,1);
	$ch3 = $txt{$nh2 % $tlen};
	$nh3 = @strpos($chars,$ch3);
	$txt = substr_replace($txt,'',$nh2 % $tlen--,1);
	$nhnum = $nh1 + $nh2 + $nh3;
	$mdKey = substr(md5(md5(md5($key.$ch1).$ch2.$ikey).$ch3),$nhnum % 8,$knum % 8 + 16);
	$tmp = '';
	$j=0; $k = 0;
	$tlen = strlen($txt);
	$klen = strlen($mdKey);
	for ($i=0; $i<$tlen; $i++) {
		$k = $k == $klen ? 0 : $k;
		$j = strpos($chars,$txt{$i})-$nhnum - ord($mdKey{$k++});
		while ($j<0) $j+=64;
		$tmp .= $chars{$j};
	}
	$tmp = str_replace(array('-','_','.'),array('+','/','='),$tmp);
	$tmp = trim(base64_decode($tmp));
	
	if (preg_match("/\d{10}_/s",substr($tmp,0,11))){
		if ($ttl > 0 && (time() - substr($tmp,0,11) > $ttl)){
			$tmp = null;
		}else{
			$tmp = substr($tmp,11);
		}
	}
	return $tmp;
}

/**
 * 取得IP
 *
 *
 * @return string 字符串类型的返回结果
 */
function getIp(){
	if (@$_SERVER['HTTP_CLIENT_IP'] && $_SERVER['HTTP_CLIENT_IP']!='unknown') {
		$ip = $_SERVER['HTTP_CLIENT_IP'];
	} elseif (@$_SERVER['HTTP_X_FORWARDED_FOR'] && $_SERVER['HTTP_X_FORWARDED_FOR']!='unknown') {
		$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
	} else {
		$ip = $_SERVER['REMOTE_ADDR'];
	}
	return preg_match('/^\d[\d.]+\d$/', $ip) ? $ip : '';
}

/**
 * 模型实例化入口
 *
 * @param string $model_name 模型名称
 * @return obj 对象形式的返回结果
 */
function Model($model = null){	
	static $_cache = array();
	if (!is_null($model) && isset($_cache[$model])) return $_cache[$model];
	$file_name = BasePath.DS.'model'.DS.$model.'.model.php';
	$class_name = $model.'Model';
	if (!file_exists($file_name)){
		return $_cache[$model] =  new Model($model);
	}else{
		require_once($file_name);
		if (!class_exists($class_name)){
			$error = 'Model Error:  Class '.$class_name.' is not exists!';
			throw_exception($error);
		}else{
			return $_cache[$model] = new $class_name();
		}
	}
}

/**
 * 读取目录列表
 * 不包括 . .. 文件 三部分
 *
 * @param string $path 路径
 * @return array 数组格式的返回结果
 */
function readDirList($path){
	if (is_dir($path)) {
		$handle = @opendir($path);
		$dir_list = array();
		if ($handle){
			while (false !== ($dir = readdir($handle))){
				if ($dir != '.' && $dir != '..' && is_dir($path.DS.$dir)){
					$dir_list[] = $dir;
				}
			}
			return $dir_list;
		}else {
			return false;
		}
	}else {
		return false;
	}
}

/**
 * 转换特殊字符
 *
 * @param string $string 要转换的字符串
 * @return string 字符串类型的返回结果
 */
function replaceSpecialChar($string){
	$str = str_replace("\r\n", "", $string);
	$str = str_replace("\t", "    ", $string);
	$str = str_replace("\n", "", $string);
	return $string;
}

/**
 * 编辑器内容
 * 
 * @param int $id 编辑器id名称，与name同名
 * @param string $value 编辑器内容
 * @param string $width 宽 带px
 * @param string $height 高 带px
 * @param string $style 样式内容
 * @param string $upload_state 上传状态，默认是开启
 */
function showEditor($id, $value='', $width='700px', $height='300px', $style='visibility:hidden;',$upload_state="true", $media_open=false, $type='all'){
	//是否开启多媒体
	$media = '';
	if ($media_open){
		$media = ", 'flash', 'media'";
	}
    switch($type) {
    case 'basic':
        $items = "['source', '|', 'fullscreen', 'undo', 'redo', 'cut', 'copy', 'paste', '|', 'about']";
        break;
    case 'simple':
        $items = "['source', '|', 'fullscreen', 'undo', 'redo', 'cut', 'copy', 'paste', '|',
            'fontname', 'fontsize', 'forecolor', 'hilitecolor', 'bold', 'italic', 'underline',
            'removeformat', 'justifyleft', 'justifycenter', 'justifyright', 'insertorderedlist',
            'insertunorderedlist', '|', 'emoticons', 'image', 'link', '|', 'about']"; 
        break;
    default:
        $items = "['source', '|', 'fullscreen', 'undo', 'redo', 'print', 'cut', 'copy', 'paste',
            'plainpaste', 'wordpaste', '|', 'justifyleft', 'justifycenter', 'justifyright',
            'justifyfull', 'insertorderedlist', 'insertunorderedlist', 'indent', 'outdent', 'subscript',
            'superscript', '|', 'selectall', 'clearhtml','quickformat','|',
            'formatblock', 'fontname', 'fontsize', '|', 'forecolor', 'hilitecolor', 'bold',
            'italic', 'underline', 'strikethrough', 'lineheight', 'removeformat', '|', 'image'".$media.", 'table', 'hr', 'emoticons', 'link', 'unlink', '|', 'about']";
        break;
    }
	//图片、Flash、视频、文件的本地上传都可开启。默认只有图片，要启用其它的需要修改resource\kindeditor\php下的upload_json.php的相关参数
	echo '<textarea id="'. $id .'" name="'. $id .'" style="width:'. $width .';height:'. $height .';'. $style .'">'.$value.'</textarea>';
	echo '
<script src="'. RESOURCE_PATH .'/kindeditor/kindeditor-min.js" charset="utf-8"></script>
<script src="'. RESOURCE_PATH .'/kindeditor/lang/'.C('lang_type').'.js" charset="utf-8"></script>
<script>
	var KE;
  KindEditor.ready(function(K) {
        KE = K.create("textarea[name=\''.$id.'\']", {
        				langType:"'.C('lang_type').'",
						items : '.$items.',
						cssPath : "' . RESOURCE_PATH . '/kindeditor/themes/default/default.css",
						allowImageUpload : '.$upload_state.',
						allowFlashUpload : false,
						allowMediaUpload : false,
						allowFileManager : false,
						syncType:"form",
						afterCreate : function() {
							var self = this;
							self.sync();
						},
						afterChange : function() {
							var self = this;
							self.sync();
						},
						afterBlur : function() {
							var self = this;
							self.sync();
						}
        });
			KE.appendHtml = function(id,val) {
				this.html(this.html() + val);
				if (this.isCreated) {
					var cmd = this.cmd;
					cmd.range.selectNodeContents(cmd.doc.body).collapse(false);
					cmd.select();
				}
				return this;
			}
	});
</script>
	';
	return true;
}

/**
 * 获取目录大小
 *
 * @param string $path 目录
 * @param int $size 目录大小
 * @return int 整型类型的返回结果
 */
function getDirSize($path, $size=0){
	$dir = @dir($path);
	if (!empty($dir->path) && !empty($dir->handle)){
		while($filename = $dir->read()){
			if($filename != '.' && $filename != '..'){
				if (is_dir($path.DS.$filename)){
					$size += getDirSize($path.DS.$filename);
				}else {
					$size += filesize($path.DS.$filename);
				}
			}
		}
	}
	return $size ? $size : 0 ;
}

/**
 * 删除缓存目录下的文件或子目录文件
 *
 * @param string $dir 目录名或文件名
 * @return boolean
 */
function delCacheFile($dir){
	//防止删除cache以外的文件
	if (strpos($dir,'..') !== false) return false;
	$path = BasePath.DS.'cache'.DS.$dir;
	if (is_dir($path)){
		$file_list = array();
		readFileList($path,$file_list);
		if (!empty($file_list)){
			foreach ($file_list as $v){
				if (basename($v) != 'index.html')@unlink($v);
			}
		}
	}else{
		if (basename($path) != 'index.html') @unlink($path);
	}
	return true;
}

/**
 * 获取文件列表(所有子目录文件)
 *
 * @param string $path 目录
 * @param array $file_list 存放所有子文件的数组
 * @param array $ignore_dir 需要忽略的目录或文件
 * @return array 数据格式的返回结果
 */
function readFileList($path,&$file_list,$ignore_dir=array()){
	$path = rtrim($path,'/');
	if (is_dir($path)) {
		$handle = @opendir($path);
		if ($handle){
			while (false !== ($dir = readdir($handle))){
				if ($dir != '.' && $dir != '..'){
					if (!in_array($dir,$ignore_dir)){
						if (is_file($path.DS.$dir)){
							$file_list[] = $path.DS.$dir;
						}elseif(is_dir($path.DS.$dir)){
							readFileList($path.DS.$dir,$file_list,$ignore_dir);
						}
					}
				}
			}
			@closedir($handle);
//			return $file_list;
		}else {
			return false;
		}
	}else {
		return false;
	}
}

/**
* 价格格式化
*
* @param int	$price
* @return string	$price_format
*/
function ncPriceFormat($price) {
	$price_format	= number_format(floatval($price),2,'.','');
	return $price_format;
}
/**
* 汇率格式化
*
* @param int	$price
* @return string	$price_format
*/
function ncExchangeRateFormat($rate) {
	$price_format	= number_format(floatval($rate),3,'.','');
	return $price_format;
}
/**
 * 获取url地址
 *
 * @param string $type url类型
 * @param array $param 参数
 * @param string $domain 二级域名
 * @return string 返回url地址
 */
function ncUrl($param = array(), $type = '', $domain = ''){
	if(!is_array($param) || empty($param)) return SiteUrl;
	
	// 开启伪静态相关数组
	$array = array('coupon_info', 'goods', 'groupbuy', 'article', 'store', 'activity', 'store_nav', 'document');
	/**
	 * 伪静态拼写规则
	 * 'coupon_info'		=> 'coupon_info-'.$coupon_id.'-'.$store_id.'.html',
	 * 'goods'				=> 'goods-'.$goods_id.'-'.$store_id.'.html',
	 * 'groupbuy'			=> 'groupbuy-'.$group_id.'-'.$store_id.'.html',
	 * 'article'			=> 'article-'.$article_id.'.html',
	 * 'store'				=> 'store-'.$store_id.'.html',
	 * 'activity'			=> 'activity-'.$activity_id.'-'.$nav_id.'.html',
	 * 'store_nav'			=> 'store_nav-'.$store_id.'-'.$sn_id.'.html',
	 * 'document'			=> 'document-'.$code.'.html',
	 */

	if($GLOBALS['setting_config']['rewrite_enabled'] == '1' && in_array($type, $array)){	// 开启伪静态
		$url = $type.'-';
		foreach ($param as $key=>$val){
			if($key != 'act' && $key != 'op'){
				$url .= $val.'-';
			}
		}
		$url = rtrim($url,'-').'.html';
	}else{// 未开启伪静态
		$url = 'index.php?';
		foreach ($param as $key=>$val){
			$url .=  $key.'='.$val.'&';
		}
		$url = rtrim($url,'&');
	}
	if (!empty($domain)) $url = ncDomainUrl($type, $url, $domain);// 店铺二级域名
	return $url;
}

/**
 * 获取二级域名url地址
 *
 * @param string $type url类型
 * @param string $domain_url 原始地址
 * @param string $domain 二级域名
 * @return string 返回url地址
 */
function ncDomainUrl($type,$domain_url,$domain){
	//是否开启二级域名
	if ($GLOBALS['setting_config']['enabled_subdomain']=='1' && !empty($domain)){
		switch ($type){
			case 'store':
					$domain_url = 'http://'.$domain.'.'.$GLOBALS['setting_config']['subdomain_suffix'].'/';
				break;
			case 'goods':
					$domain_url = 'http://'.$domain.'.'.$GLOBALS['setting_config']['subdomain_suffix'].'/'.$domain_url;
				break;
		}
	}
	return $domain_url;
}

/**
 * 二级域名解析
 * @return int 店铺id
 */
function subdomain(){
	$store_id = 0;
	/**
	 * 获得系统配置,二级域名功能是否开启
	 */
	if ($GLOBALS['setting_config']['enabled_subdomain']=='1'){//开启了二级域名
		$line = @explode($GLOBALS['setting_config']['subdomain_suffix'],$_SERVER['HTTP_HOST']);
		$line = trim($line[0],'.');
		if(empty($line) || strtolower($line) == 'www') return 0;
		
		$model_store = Model('store');
		$store_info = $model_store->shopStore(array('store_domain'=>$line),'store_id');
		//二级域名存在
		if ($store_info['store_id'] > 0){
			$store_id = $store_info['store_id'];
			$_GET['id'] = $store_info['store_id'];
		}
	}
	return $store_id;
}

/**
 * 通知邮件/通知消息 内容转换函数
 *
 * @param string $message 内容模板
 * @param array $param 内容参数数组
 * @return string 通知内容
 */
/*function ncReplaceText($message,$param){
	if(!is_array($param))return false;
	$param['mail_send_time']	= date('Y-m-d H:i');
	foreach ($param as $k=>$v){
		$message	= str_replace('{$'.$k.'}',$v,$message);
	}
	return $message;
}*/

/**
 * 字符串切割函数，一个字母算一个位置,一个字算2个位置
 *
 * @param string $string 待切割的字符串
 * @param int $length 切割长度
 * @param string $dot 尾缀
 */
function str_cut($string, $length, $dot = '')
{
	$string = str_replace(array('&nbsp;', '&amp;', '&quot;', '&#039;', '&ldquo;', '&rdquo;', '&mdash;', '&lt;', '&gt;', '&middot;', '&hellip;'), array(' ', '&', '"', "'", '“', '”', '—', '<', '>', '·', '…'), $string);
	$strlen = strlen($string);
	if($strlen <= $length) return $string;
	$maxi = $length - strlen($dot);
	$strcut = '';
	if(strtolower(CHARSET) == 'utf-8')
	{
		$n = $tn = $noc = 0;
		while($n < $strlen)
		{
			$t = ord($string[$n]);
			if($t == 9 || $t == 10 || (32 <= $t && $t <= 126)) {
				$tn = 1; $n++; $noc++;
			} elseif(194 <= $t && $t <= 223) {
				$tn = 2; $n += 2; $noc += 2;
			} elseif(224 <= $t && $t < 239) {
				$tn = 3; $n += 3; $noc += 2;
			} elseif(240 <= $t && $t <= 247) {
				$tn = 4; $n += 4; $noc += 2;
			} elseif(248 <= $t && $t <= 251) {
				$tn = 5; $n += 5; $noc += 2;
			} elseif($t == 252 || $t == 253) {
				$tn = 6; $n += 6; $noc += 2;
			} else {
				$n++;
			}
			if($noc >= $maxi) break;
		}
		if($noc > $maxi) $n -= $tn;
		$strcut = substr($string, 0, $n);
	}
	else
	{
		$dotlen = strlen($dot);
		$maxi = $length - $dotlen;
		for($i = 0; $i < $maxi; $i++)
		{
			$strcut .= ord($string[$i]) > 127 ? $string[$i].$string[++$i] : $string[$i];
		}
	}
	$strcut = str_replace(array('&', '"', "'", '<', '>'), array('&amp;', '&quot;', '&#039;', '&lt;', '&gt;'), $strcut);
	return $strcut.$dot;
}

/**
 * unicode转为utf8
 * @param string $str 待转的字符串
 * @return string
 */
function unicodeToUtf8($str, $order = "little")
{
	$utf8string ="";
	$n=strlen($str);
	for ($i=0;$i<$n ;$i++ )
	{
		if ($order=="little")
		{
			$val = str_pad(dechex(ord($str[$i+1])), 2, 0, STR_PAD_LEFT) .
			str_pad(dechex(ord($str[$i])),      2, 0, STR_PAD_LEFT);
		}
		else
		{
			$val = str_pad(dechex(ord($str[$i])),      2, 0, STR_PAD_LEFT) .
			str_pad(dechex(ord($str[$i+1])), 2, 0, STR_PAD_LEFT);
		}
		$val = intval($val,16); // 由于上次的.连接，导致$val变为字符串，这里得转回来。
		$i++; // 两个字节表示一个unicode字符。
		$c = "";
		if($val < 0x7F)
		{ // 0000-007F
			$c .= chr($val);
		}
		elseif($val < 0x800)
		{ // 0080-07F0
			$c .= chr(0xC0 | ($val / 64));
			$c .= chr(0x80 | ($val % 64));
		}
		else
		{ // 0800-FFFF
			$c .= chr(0xE0 | (($val / 64) / 64));
			$c .= chr(0x80 | (($val / 64) % 64));
			$c .= chr(0x80 | ($val % 64));
		}
		$utf8string .= $c;
	}
	/* 去除bom标记 才能使内置的iconv函数正确转换 */
	if (ord(substr($utf8string,0,1)) == 0xEF && ord(substr($utf8string,1,2)) == 0xBB && ord(substr($utf8string,2,1)) == 0xBF)
	{
		$utf8string = substr($utf8string,3);
	}
	return $utf8string;
}

/*
 * 重写$_SERVER['REQUREST_URI']
 */
function request_uri()
{
    if (isset($_SERVER['REQUEST_URI']))
    {
        $uri = $_SERVER['REQUEST_URI'];
    }
    else
    {
        if (isset($_SERVER['argv']))
        {
            $uri = $_SERVER['PHP_SELF'] .'?'. $_SERVER['argv'][0];
        }
        else
        {
            $uri = $_SERVER['PHP_SELF'] .'?'. $_SERVER['QUERY_STRING'];
        }
    }
    return $uri;
}

/**
 * 获取图片类型
 * @param string $str
 * @return string
 */
function get_image_type($str)
{
	$a = explode('.', $str);
	return end($a);
}

/*
 * 自定义memory_get_usage()
 * 
 * @return 内存使用额度，如果该方法无效，返回0
 */
if(!function_exists('memory_get_usage')){
	function memory_get_usage(){//目前程序不兼容5以下的版本
		return 0;
	}
}

// 记录和统计时间（微秒）
function addUpTime($start,$end='',$dec=3) {
    static $_info = array();
    if(!empty($end)) { // 统计时间
        if(!isset($_info[$end])) {
            $_info[$end]   =  microtime(TRUE);
        }
        return number_format(($_info[$end]-$_info[$start]),$dec);
    }else{ // 记录时间
        $_info[$start]  =  microtime(TRUE);
    }
}

/**
 * 取得系统配置信息
 *
 * @param string $key 取得下标值
 * @return mixed
 */
function C($key){
	if (strpos($key,'.')){
		$key = explode('.',$key);
		if (isset($key[2])){
			return $GLOBALS['setting_config'][$key[0]][$key[1]][$key[2]];
		}else{
			return $GLOBALS['setting_config'][$key[0]][$key[1]];
		}
	}else{
		return $GLOBALS['setting_config'][$key];
	}
}
/**
 * 加载文件
 * 
 * 使用require_once函数，只适用于加载框架内类库文件
 * 如果文件名中包含"_"使用"#"代替
 * 
 * @example import('cache'); //require_once(BasePath.'/framework/libraries/cache.php');
 * @example import('libraries.cache');	//require_once(BasePath.'/framework/libraries/cache.php');
 * @example import('function.core');	//require_once(BasePath.'/framework/function/core.php');
 * @example import('.control.adv')	//require_once(BasePath.'/control/adv.php');
 * 
 * @param 要加载的文件 $libname
 * @param 文件扩展名 $file_ext
 */
function import($libname,$file_ext='.php'){
	//替换为目录符号/
	if (strstr($libname,'.')){
		$path = str_replace('.','/',$libname);
	}else{
		$path = 'libraries/'.$libname;
	}
	// 基准目录，如果是顶级目录
	if(substr($libname,0,1) == '.'){
		$base_dir = BasePath.'/';
		$path = ltrim(str_replace('libraries/','',$path),'/');
	}else{
		$base_dir = BasePath.'/framework/';
	}
	//如果文件名中含有.使用#代替
	if (strstr($path,'#')){
		$path = str_replace('#','.',$path);
	}
	//返回安全路径
	if(preg_match('/^[\w\d\/_.]+$/i', $path)){
		$file = realpath($base_dir.$path.$file_ext);
	}else{
		$file = false;
	}
	if (!$file){
		exit($path.$file_ext.' isn\'t exists!');
	}else{
		require_once($file);
	}

}

/**
 * 取得随机数
 *
 * @param int $length 生成随机数的长度
 * @param int $numeric 是否只产生数字随机数 1是0否
 * @return string
 */
function random($length, $numeric = 0) {
	$seed = base_convert(md5(microtime().$_SERVER['DOCUMENT_ROOT']), 16, $numeric ? 10 : 35);
	$seed = $numeric ? (str_replace('0', '', $seed).'012340567890') : ($seed.'zZ'.strtoupper($seed));
	$hash = '';
	$max = strlen($seed) - 1;
	for($i = 0; $i < $length; $i++) {
		$hash .= $seed{mt_rand(0, $max)};
	}
	return $hash;
}

/**
 * 返回模板文件所在完整目录
 *
 * @param string $tplpath 模板文件名（不含扩展名）
 * @param string $project 项目名称
 * @return string
 */
function template($tplpath,$project=''){
	if ($project == ''){
		return BasePath.'/templates/'.TPL_NAME.'/'.$tplpath.'.php';
	}else{
		return BasePath.'/'.$project.'/templates/'.$tplpath.'.php';
	}
}

/**
 * 检测FORM是否提交
 * @param  $check_token 是否验证token
 * @param  $check_captcha 是否验证验证码
 * @param  $return_type 'alert','num'
 * @return boolean
 */
function chksubmit($check_token = false, $check_captcha = false, $return_type = 'alert'){
	$submit = isset($_POST['form_submit']) ? $_POST['form_submit'] : $_GET['form_submit'];
	if ($submit != 'ok') return false;
	if ($check_token && !Security::checkToken()){
		if ($return_type == 'alert'){
			showDialog('Token error!');
		}else{
			return -11;
		}
	}
	if ($check_captcha && !checkSeccode($_POST['nchash'],$_POST['captcha'])){
		if ($return_type == 'alert'){
			showDialog('Verification code error!');
		}else{
			return -12;
		}
	}
	return true;
}
/**
 * 输出validate的验证信息
 *
 * @param array/string $error
 */
function showValidateError($error){
	if (!empty($_GET['inajax'])){
		foreach (explode('<br/>',$error) as $v) {
			if (trim($v != '')){
				showDialog($v,'','error','',3);
			}
		}
	}else{
		showDialog($error,'','error','',3);
	}
}

/**
 * 文件数据读取和保存 字符串、数组
 *
 * @param string $name 文件名称（不含扩展名）
 * @param mixed $value 待写入文件的内容
 * @param string $path 写入cache的目录
 * @param string $ext 文件扩展名
 * @return mixed
 */
function F($name, $value = null, $path = 'cache', $ext = '.php') {
	static $_cache = array();
	if (isset($_cache[$name.$path])) return $_cache[$name.$path];
    $filename = BasePath.'/'.$path.'/'.$name.$ext;
    if (!is_null($value)) {
        $dir = dirname($filename);
        if (!is_dir($dir)) mkdir($dir);
        return write_file($filename,$value);
    }

    if (is_file($filename)) {
        $_cache[$name.$path] = $value = include $filename;
    } else {
        $value = false;
    }
    return $value;
}

/**
 * 内容写入文件
 *
 * @param string $filepath 待写入内容的文件路径
 * @param string/array $data 待写入的内容
 * @param  string $mode 写入模式，如果是追加，可传入“append”
 * @return bool
 */
function write_file($filepath, $data, $mode = null){
	if (is_array($data)){
		$data = var_export($data,true);
	}elseif (!is_scalar($data)){
		return false;
	}
	if ($data === '') $data = '\'\'';
	$data = "<?php defined('InBizpower') or exit('Access Invalid!'); return ".$data."\n?>";
	$mode = $mode == 'append' ? FILE_APPEND : null;
    if (false === file_put_contents($filepath,compress_code($data),$mode)){
    	return false;
    }else{
    	return true;
    }
}

/**
 * 循环创建目录
 *
 * @param string $dir 待创建的目录
 * @param  $mode 权限
 * @return boolean
 */
function mk_dir($dir, $mode = '0777') {
    if (is_dir($dir) || @mkdir($dir, $mode))
        return true;
    if (!mk_dir(dirname($dir), $mode))
        return false;
    return @mkdir($dir, $mode);
}

/**
 * 封装分页操作到函数，方便调用
 *
 * @param string $cmd 命令类型
 * @param mixed $arg 参数
 * @return mixed
 */
function pagecmd($cmd ='', $arg = ''){
	if (!class_exists('page'))	import('page');
	static $page;
	if ($page == null){
		$page = new Page();
	}
	switch (strtolower($cmd)) {
		case 'seteachnum':		$page->setEachNum($arg);break;
		case 'settotalnum': 	$page->setTotalNum($arg);break;
		case 'setstyle': 		$page->setStyle($arg);break;
		case 'show': 			return $page->show($arg);break;
		case 'obj':				return $page;break;
		case 'gettotalnum':		return $page->getTotalNum();break;
		case 'gettotalpage':	return $page->getTotalPage();break;
		default:				break;
	}
}

/**
 * 抛出异常
 *
 * @param string $error 异常信息
 */
function throw_exception($error){
	showMessage($error,'','exception');
}

/**
 * 输出错误信息
 *
 * @param string $error 错误信息
 */
function halt($error){
	showMessage($error,'','exception');
}

/**
 * 去除代码中的空白和注释
 *
 * @param string $content 待压缩的内容
 * @return string
 */
	function compress_code($content) {
    $stripStr = '';
    //分析php源码
    $tokens = token_get_all($content);
    $last_space = false;
    for ($i = 0, $j = count($tokens); $i < $j; $i++) {
        if (is_string($tokens[$i])) {
            $last_space = false;
            $stripStr .= $tokens[$i];
        } else {
            switch ($tokens[$i][0]) {
                case T_COMMENT:	//过滤各种PHP注释
                case T_DOC_COMMENT:
                    break;
                case T_WHITESPACE:	//过滤空格
                    if (!$last_space) {
                        $stripStr .= ' ';
                        $last_space = true;
                    }
                    break;
                default:
                    $last_space = false;
                    $stripStr .= $tokens[$i][1];
            }
        }
    }
    return $stripStr;
}

/**
 * 取得对象实例
 *
 * @param object $class
 * @param string $method
 * @param array $args
 * @return object
 */
function get_obj_instance($class, $method='', $args = array()){
	static $_cache = array();
	$key = $class.$method.(empty($args) ? null : md5(serialize($args)));
	if (isset($_cache[$key])){
		return $_cache[$key];
	}else{
		if (class_exists($class)){
			$obj = new $class;
			if (method_exists($obj,$method)){
				if (empty($args)){
					$_cache[$key] = $obj->$method();
				}else{
					$_cache[$key] = call_user_func_array(array(&$obj, $method), $args);
				}
			}else{
				$_cache[$key] = $obj;
			}
			return $_cache[$key];
		}else{
			throw_exception('Class '.$class.' isn\'t exists!');
		}
	}
}

/**
 * 读/写 缓存方法
 *
 * H('key') 取得缓存
 * H('setting',true) 生成缓存并返回缓存结果
 * H('key',null) 清空缓存
 * H('setting',true,'file') 生成商城配置信息的文件缓存
 * H('setting',true,'memcache') 生成商城配置信息到memcache
 * @param string $key 缓存名称
 * @param string $value 缓存内容
 * @param string $type	缓存类型，允许值为 file,memcache,xcache,apc,eaccelerator，可以为空，默认为file缓存
 * @param int/null $expire 缓存周期
 * @param mixed $args 扩展参数
 * @return mixed
 */
function H($key, $value='', $cache_type='', $expire=null, $args=null){
	static $cache = array();
	$cache_type = $cache_type ? $cache_type : 'file';
	$webnum = C('webnum');
	$cache_type = (empty($webnum) || $webnum == 1) ? $cache_type : C('cache.type');
	
	$obj_cache = Cache::getInstance($cache_type,$args);
    if ($value !== '') {
        if (is_null($value)) { // 删除缓存
            $result = $obj_cache->rm($key);
            if ($result)
                unset($cache[$cache_type . '_' . $key]);
            return $result;
        }else { // 缓存数据
        	if ($value === true) $obj_cache->rm($key);
            $list = Model('cache')->call($key);
            $obj_cache->set($key, $list, null, $expire);
            $cache[$cache_type . '_' . $key] = $list;
        }
        return $value === true ? $list : true;
    }
    if (isset($cache[$cache_type . '_' . $key]))
        return $cache[$cache_type . '_' . $key];

    $value = $obj_cache->get($key);	// 取得缓存
    $cache[$cache_type . '_' . $key] = $value;
    return $value;
}

/**
 * 返回以原数组某个值为下标的新数据
 *
 * @param array $array
 * @param string $key
 * @param int $type 1一维数组2二维数组
 * @return array
 */
function array_under_reset($array, $key, $type=1){
	if (is_array($array)){
		$tmp = array();
		foreach ($array as $v) {
			if ($type === 1){
				$tmp[$v[$key]] = $v;
			}elseif($type === 2){
				$tmp[$v[$key]][] = $v;
			}
		}
		return $tmp;
	}else{
		return $array;
	}
}

/**
 * 读取缓存信息（只适用于内存缓存）
 *
 * @param string $key 要取得缓存 键
 * @param string $prefix 键值前缀
 * @param bool $unserialize 是否需要反序列化
 * @return array/bool
 */
function rcache($key = null, $prefix = '', $unserialize = true){
	if (empty($key) || C('cache.type') == 'file' ) return false;
	$obj_cache = Cache::getInstance(C('cache.type'));
    $data = $obj_cache->get($key, $prefix);
    return $unserialize ? unserialize($data) : $data;
}

/**
 * 写入缓存（只适用于内存缓存）
 *
 * @param string $key 缓存键值
 * @param array $data 缓存数据
 * @param string $prefix 键值前缀
 * @param int $ttl 缓存周期
 * @param string $perfix 存入的键值前缀
 * @param bool $serialize 是否序列化后保存
 * @return bool 返回值
 */
function wcache($key = null, $data = array(), $prefix = '',  $ttl = 0,  $serialize = true){
	if (empty($key) || C('cache.type') == 'file') return false;
	$obj_cache = Cache::getInstance(C('cache.type'));
	if ($ttl !== 0){
		$ttl = C('session_expire');
	}
    $obj_cache->set($key, $serialize ? serialize($data) : $data, $prefix, $ttl);
    return true;
}
/**
 * 验证当前员工权限是否可以进行操作
 *
 * @param
 * @return
 */
function cPermission($act='',$op=''){
	if ($_SESSION['permission'] == 'all'){
		return true;
	}
	if ($act == '' || $op == ''){
		$act = $_GET['act'];
		$op = $_GET['op'];
	}
	//不需要验证的act
	$nocheck_act = array('seccode','commondata','index','profiles','notepad');
	if (in_array($act,$nocheck_act)){
		return true;
	}
	//不需要验证的op
	$nocheck_op = array('noticelist','noticeinfo','noticehide','reportlist','reportweeklist','reportmonthlist','reportdayadd','reportweekadd','reportmonthadd','customer_view','care_view','mission_view','schedule_view','order_view','shipment_view','income_view','return_view','bill_view','product_view','get_contact','ajax_upload_file','class_edit','class_add','ajax_productpic_upload','get_seacustomer','status_batch_switch','transfer_confirm','userview','salarypacketpersonal');
	if (in_array($op,$nocheck_op)){
		return true;
	}
	$permission_arr = array();
	if(!empty($_SESSION['permission'])){
		$permission_arr = explode(',',$_SESSION['permission']);
	}
	//验证op
	if (in_array($op,$permission_arr)){
		return true;
	}
	return false;
}
function replaceHtmlAndJs($document){
	$document = trim($document);
	if (strlen($document) <= 0)
	{ return $document; }
	$search = array ("'<script[^>]*?>.*?</script>'si",  // 去掉 javascript
					"'<[\/\!]*?[^<>]*?>'si",          // 去掉 HTML 标记
					"'&(amp|#38);'i",
					"'&(lt|#60);'i",
					"'&(gt|#62);'i",
					"'&(nbsp|#160);'i"
	);// 作为 PHP 代码运行
	$replace = array ("","","&","<",">"," ");
	return @preg_replace ($search, $replace, $document);
}
/**
 * 认领状态公海会员过期判断
 * 
 */
function seacustomer_overtime(){
	$sc_overtime = F('sc_overtime');
	if(($sc_overtime['exc_date'] != date('Y-m-d',time()) || $sc_overtime === false)&& C('use_sea') == 1){
		$return_days = C('return_days')*3600*24;
		$model = Model();
		$getsea_customer = $model->field('cc_id,cc_getseatime')->table('customer')->where('cc_getseatime > 0')->select();
		foreach ($getsea_customer as $k=>$v){
			$cc_id_string = '';
			//判断如果认领会员超过系统规定的期限还没有产生订单则回归公海
			if((time()-$v['cc_getseatime']) >= $return_days && !customer_haveorder($v['cc_id'],$v['cc_getseatime'])){
				$cc_id_string .= $v['cc_id'].',';
			}
		}
		$cc_id_string = trim($cc_id_string,',');
		$model->table('customer')->where(array('cc_id'=>array('in',$cc_id_string)))->update(array('cc_staff_id'=>0,'cc_insea'=>1,'cc_dept_id'=>0,'cc_getseatime'=>0));
		//操作完成并将日期写入缓存
		$file_path = BasePath.'/cache/sc_overtime.php';
		if(is_file($file_path)){
			@unlink($file_path);
		}
		@write_file($file_path, array('exc_date'=>date('Y-m-d',time())));
	}
	return true;
}
/**
 * 判断会员是否已经产生订单
 * 
 * @param $cc_id 会员ID
 * @param $get_time 会员认领时间戳
 */
function customer_haveorder($cc_id,$get_time=0){
	$cc_id = intval($cc_id);
	if($cc_id <= 0){
		return false;
	}
	$model = Model();
	$where_condition = array();
	$where_condition['cc_id']      = $cc_id;
	if($get_time > 0){
		$where_condition['co_addtime'] = array('egt',$get_time);
	}
	$order_info = $model->table('orders')->where($where_condition)->find();
	if(!empty($order_info)){
		return true;
	}else{
		return false;
	}
}
/**
 * 批量将会员转成公海会员
 * 
 * @param $param 员工ID or 会员资料数组
 */
function gotosea_batch($param){
	if(C('use_sea') == 0){
		return false;
	}
	$model = Model();
	if(is_array($param)){
		if(!empty($param)){
			foreach ($param as $k=>$v){
				$model->table('customer')->where('cc_id='.$v['cc_id'])->update(array('cc_staff_id'=>0,'cc_insea'=>1,'cc_dept_id'=>0,'cc_getseatime'=>0));
			}
			return true;
		}else{
			return false;
		}
	}else{
		$staff_id = intval($param);
		if($staff_id <= 0){
			return false;
		}else{
			$rs = $model->table('customer')->where('cc_staff_id='.$staff_id)->update(array('cc_staff_id'=>0,'cc_insea'=>1,'cc_dept_id'=>0,'cc_getseatime'=>0));
			if($rs){
				return true;
			}else{
				return false;
			}
		}
	}
}
/**
 * 获得Column2D统计图数据
 */
function getStatData_Column2D($caption,$yaxisname,$stat_data=array(),$numtype = 'money'){
	$stat_chart = array(
		"baseFont"=>C('graphfont'),
		"baseFontSize"=>'12',
		"showborder"=>"0",
		"bgcolor"=>"FFFFFF,FFFFFF",		
		"useroundedges"=>"1",
		"numberprefix"=>"",
		"caption"=>$caption,
		"yaxisname"=>$yaxisname,
		"formatNumberScale"=>'0');
	if ($numtype =='money'){
		$stat_chart['decimals']=2;
		$stat_chart['forceDecimals']=1;
	}
	return json_encode(array('chart'=>$stat_chart,'data'=>$stat_data));
}
/**
 * 获得MSColumn2D统计图数据
 */
function getStatData_MSColumn2D($caption,$category_arr,$stat_data=array(),$numtype = 'money'){
	$stat_chart = array(
		"baseFont"=>C('graphfont'),
		"baseFontSize"=>'12',
		"showborder"=>"0",
		"legendborderalpha"=>"0",
		"useroundedges"=>"1",
		"caption"=>$caption,
		"numdivlines"=>"4",
		"animation"=>"1",
		"rotatenames"=>"0",
		"palette"=>"2",
		"formatNumberScale"=>'0');
	if ($numtype =='money'){
		$stat_chart['decimals']=2;
		$stat_chart['forceDecimals']=1;
	}
	$categories = array(
		"fontsize"=>"12",
		"font"=>C('graphfont'),
		"category"=>$category_arr);
	$stat_dataset[0] = array(
		"showvalues"=>"0",
		"alpha"=>"90",
		"color"=>"9ACCF6",
		"seriesname"=>Language::get('bp_yesteryear'),
		'data'=>$stat_data[0]);
    $stat_dataset[1] = array(
		"showvalues"=>"0",
		"alpha"=>"90",
		"color"=>"82CF27",
		"seriesname"=>Language::get('bp_thisyear'),
		'data'=>$stat_data[1]);
	return json_encode(array('chart'=>$stat_chart,'categories'=>$categories,'dataset'=>$stat_dataset));
}
/**
 * 获得Pie2D统计图数据
 */
function getStatData_Pie2D($caption,$stat_data=array()){
	$stat_chart = array(
		"baseFont"=>C('graphfont'),
		"baseFontSize"=>'12',
		"showborder"=>"0",
		"showpercentvalues"=>"1",
		"showlegend"=>"1",
		"showlabels"=>"0",
		"showvalues"=>"1",
		"showpercentageinlabel"=>"1",
		"caption"=>$caption
	);
	return json_encode(array('chart'=>$stat_chart,'data'=>$stat_data));
}
/**
 * 计算环比
 */
function getMtom($updata,$currentdata){
	$mtomrate = 0;
	if($updata != 0){
		$mtomrate = round(($currentdata - $updata)/$updata*100,2);
	}
	return $mtomrate; 
}
/**
 * 计算同比
 */
function getYtoy($updata,$currentdata){
	$ytoyrate = 0;
	if($updata != 0){
		$ytoyrate = round(($currentdata - $updata)/$updata*100,2);
	}
	return $ytoyrate; 
}
/**
 * 获得系统年份数组
 */
function getSystemYearArr(){
	$year_arr = array('2010'=>'2010','2011'=>'2011','2012'=>'2012','2013'=>'2013','2014'=>'2014','2015'=>'2015','2016'=>'2016','2017'=>'2017','2018'=>'2018','2019'=>'2019','2020'=>'2020');
	return $year_arr;
}
/**
 * 获得系统月份数组
 */
function getSystemMonthArr(){
	$month_arr = array('1'=>'01','2'=>'02','3'=>'03','4'=>'04','5'=>'05','6'=>'06','7'=>'07','8'=>'08','9'=>'09','10'=>'10','11'=>'11','12'=>'12');
	return $month_arr;
}
/**
 * 获得颜色自动生成数组
 */
function getColorArr($num=50){
	$color_arr = array();
	$string = "0123456789ABCDEF";
	for($j=0;$j<$num;$j++){
		$rand='';
		for($i=0;$i<6;$i++){
		    $rand .= substr($string,mt_rand(0,strlen($string)-1),1);
		}
		$color_arr[] = "#".$rand;
	}
	return $color_arr;
}
/**
 * 设置日志管理左菜单
 */
function setlogleftmenu($menu_key=''){
	$arr = array();
	$arr[0] = array('menu_name'=>Language::get('bp_home_log_manage'),	'menu_url'=>'#');
	$arr[0]['submenu'][0] = array('menu_key'=>'customer_history_list','menu_name'=>Language::get('bp_home_log_manage_customerhistorylog'),'linktype'=>'1','menu_url'=>'index.php?act=customer&op=customer_history_list&from=lm','menu_act'=>'customer','menu_op'=>'customer_history_list');
	$arr[0]['submenu'][2] = array('menu_key'=>'order_log','menu_name'=>Language::get('bp_home_log_manage_orderslog'),'linktype'=>'1','menu_url'=>'index.php?act=order&op=order_log&from=lm','menu_act'=>'order','menu_op'=>'order_log');
	$arr[0]['submenu'][6] = array('menu_key'=>'chancetransferlog','menu_name'=>Language::get('bp_home_log_manage_chancelog'),'linktype'=>'1','menu_url'=>'index.php?act=chance&op=chancetransfer&type=log&from=lm','menu_act'=>'chance','menu_op'=>'chancetransfer');
	$arr[0]['submenu'][7] = array('menu_key'=>'userloglist','menu_name'=>Language::get('bp_home_log_manage_userlog'),'linktype'=>'1','menu_url'=>'index.php?act=user&op=userlog&from=lm','menu_act'=>'user','menu_op'=>'userlog');
	Tpl::output('leftmenu',$arr);
	Tpl::output('menu_key',$menu_key);
}
/**
 * 下载远程图片到本地
 * 
 * @param $url 完整远程URL地址
 * @param $filename 定义保存到本地图片的文件名，默认为空自动生成
 * @param $upload_folder 定义下载到upload里的目录，默认为product
 * @return 成功返回文件名，失败会返回false
 */
function grabImage($url, $filename = '' ,$upload_folder = 'product') {
    if($url == ''){
        return false; //如果 $url 为空则返回 false;
    }
    $ext_name = strrchr($url, '.'); //获取图片的扩展名
    if($ext_name != '.gif' && $ext_name != '.jpg' && $ext_name != '.jpeg' && $ext_name != '.bmp' && $ext_name != '.png'){
        return false; //格式不在允许的范围
    }
    if($filename == ''){
        $filename = md5(uniqid(rand(),true)).$ext_name; //以时间戳另起名
    }
    //开始捕获
    ob_start();
    readfile($url);
    $img_data = ob_get_contents();
    ob_end_clean();
	if(false === file_put_contents(BasePath.'/upload/'.$upload_folder.'/'.$filename,$img_data)){
    	return false;
    }else{
    	return $filename;
    }
}
/**
 * 加密函数
 */
function authcode($string,$sign_key,$operation = 'DECODE', $key = '', $expiry = 0) {
	$ckey_length = 4;
	$key  = md5($key ? $key : $sign_key);
	$keya = md5(substr($key, 0, 16));
	$keyb = md5(substr($key, 16, 16));
	$keyc = $ckey_length ? ($operation == 'DECODE' ? substr($string, 0, $ckey_length): substr(md5(microtime()), -$ckey_length)) : '';

	$cryptkey = $keya.md5($keya.$keyc);
	$key_length = strlen($cryptkey);

	$string = $operation == 'DECODE' ? base64_decode(substr($string, $ckey_length)) : sprintf('%010d', $expiry ? $expiry + time() : 0).substr(md5($string.$keyb), 0, 16).$string;
	$string_length = strlen($string);

	$result = '';
	$box = range(0, 255);

	$rndkey = array();
	for($i = 0; $i <= 255; $i++) {
		$rndkey[$i] = ord($cryptkey[$i % $key_length]);
	}

	for($j = $i = 0; $i < 256; $i++) {
		$j = ($j + $box[$i] + $rndkey[$i]) % 256;
		$tmp = $box[$i];
		$box[$i] = $box[$j];
		$box[$j] = $tmp;
	}

	for($a = $j = $i = 0; $i < $string_length; $i++) {
		$a = ($a + 1) % 256;
		$j = ($j + $box[$a]) % 256;
		$tmp = $box[$a];
		$box[$a] = $box[$j];
		$box[$j] = $tmp;
		$result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
	}

	if($operation == 'DECODE') {
		if((substr($result, 0, 10) == 0 || substr($result, 0, 10) - time() > 0) && substr($result, 10, 16) == substr(md5(substr($result, 26).$keyb), 0, 16)) {
			return substr($result, 26);
		} else {
			return '';
		}
	} else {
		return $keyc.str_replace('=', '', base64_encode($result));
	}
}
/**
 * 远程POST数据
 */
function remote_post($url, $post = null) {    
    $context = array();
    if (is_array($post))    
    {    
        ksort($post); 
        $context['http'] = array    
        (    
            'method' => 'POST',    
            'content' => http_build_query($post, '', '&'),    
        );    
    } 
    return file_get_contents($url, false, stream_context_create($context));    
}

/*
 * 获取统计数据时间段
 */
function gettimequantum($year){
	$month = ($t = intval(C('annualinventorydate_month')))>0?$t:12;
	$day = ($t = intval(C('annualinventorydate_day')))>0?$t:31;
	$stime = mktime(23,59,59,$month,$day,$year-1)+1;
	$etime = mktime(23,59,59,$month,$day,$year);
	return array('stime'=>$stime,'etime'=>$etime);
}
/*
 * 获取特定月份时间段
 */
function getmonthtimequantum($time){
	$time = $time ? $time : time();
    $y = date('Y', $time);
    $m = date('m', $time);
    $d = date('t', $time);
    return array("stime"=>mktime(0,0,0,$m,1,$y),"etime"=>mktime(23,59,59,$m,$d,$y));
}

/**
 * 快速调用语言包
 *
 * @param string $key
 * @return string
 */
function L($key = ''){
	if (class_exists('Language')){
		if (strpos($key,',') !== false){
			$tmp = explode(',',$key);
			$str = Language::get($tmp[0]).Language::get($tmp[1]);
			return isset($tmp[2])? $str.Language::get($tmp[2]) : $str;
		}else{
			return Language::get($key);
		}
	}else{
		return null;
	}
}

/**
 * 加载完成业务方法的文件
 *
 * @param string $filename
 * @param string $file_ext
 */
function loadfunc($filename, $file_ext = '.php'){
	if(preg_match('/^[\w\d\/_.]+$/i', $filename.$file_ext)){
		$file = realpath(BasePath.'/control/function/func_'.$filename.$file_ext);
	}else{
		$file = false;
	}
	if (!$file){
		exit('func_'.$filename.$file_ext.' isn\'t exists!');
	}else{
		require_once($file);
	}
}

/**
 * 实例化类
 *
 * @param string $model_name 模型名称
 * @return obj 对象形式的返回结果
 */
function nc_class($classname = null){
	static $_cache = array();
	if (!is_null($classname) && isset($_cache[$classname])) return $_cache[$classname];
	$file_name = BasePath.'/classes/'.$classname.'.class.php';
	$newname = $classname.'Class';
	if (file_exists($file_name)){
		require_once($file_name);
		if (class_exists($newname)){
			return $_cache[$classname] = new $newname();
		}
	}
	throw_exception('Class Error:  Class '.$classname.' is not exists!');	
}

?>
