<?php
/**
 * 压缩框架
 *
 * @package
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
/**
 * 压缩框架文件
 *
 */
function build(){
	$args = func_get_args();
	extract($args[0]);
	$compile = '';
	$list = array(
		BasePath.'/framework/core/runtime.php',
		BasePath.'/framework/core/base.php',
		BasePath.'/framework/core/model.php',
		BasePath.'/framework/cache/cache.php',
		BasePath.'/framework/cache/cache.file.php',
		BasePath.'/framework/db/'.strtolower($dbdriver).'.php',
		BasePath.'/framework/function/seccode.php',
		BasePath.'/framework/libraries/email.php',
		BasePath.'/framework/libraries/language.php',
		BasePath.'/framework/libraries/log.php',
		BasePath.'/framework/libraries/page.php',
		BasePath.'/framework/libraries/security.php',
		BasePath.'/framework/libraries/validate.php',
		BasePath.'/framework/libraries/upload.php',
		BasePath.'/framework/function/core.php',
		BasePath.'/framework/tpl/nc.php',
		BasePath.'/control/control.php',
		BasePath.'/language/'.$lang_type.'/core_lang_index.php'
	);

	if (!empty($cache_type) && strtolower($cache_type) != 'file'){
		$list[] = BasePath.'/framework/cache/cache.'.strtolower($cache_type).'.php';
	}

	foreach ($list as $file) {
		if (file_exists($file))	{
			$compile .= compile($file);
		}else{
			exit(str_replace(BasePath,'',$file)." isn't exists!");
		}
	}

	//加载核心语言包
//	$lang_file = BasePath.'/language/'.$lang_type.'/core_lang_index.php';
//	if (!file_exists($lang_file)){
//		exit(str_replace(BasePath,'',$lang_file)." isn't exists!");
//	}
	$compile .= compile($lang_file);
	$compile .= "\nLanguage::appendLanguage(\$lang);";

	$compile .= "\nBase::run();";
	file_put_contents(RUNCOREPATH,compress_code("<?php defined('InBizpower') or exit('Access Invalid!');".$compile));
}

/**
 * 过滤掉不需要压缩的内容
 *
 * @param string $filename 待压缩文件
 * @return string
 */
function compile($filename) {
    $content = file_get_contents($filename);
    //过滤不需要编译的内容
    $content = preg_replace('/\/\/\[NC_SKIPBUILD\](.*?)\/\/\[\/NC_SKIPBUILD\]/s', '', $content);
    $content = str_ireplace("defined('InBizpower') or exit('Access Invalid!')", '', $content);
    $content = substr(trim($content), 5);
    if ('?>' == substr($content, -2))
        $content = substr($content, 0, -2);
    return $content;
}

/**
 * 压缩PHP代码
 *
 * @param string $content 压缩内容
 * @return string
 */
function compress_code($content) {
    $strip_str = '';
    //分析php源码
    $tokens = token_get_all($content);
    $last_space = false;
    for ($i = 0, $j = count($tokens); $i < $j; $i++) {
        if (is_string($tokens[$i])) {
            $last_space = false;
            $strip_str .= $tokens[$i];
        } else {
            switch ($tokens[$i][0]) {
                //过滤各种PHP注释
                case T_COMMENT:
                case T_DOC_COMMENT:
                    break;
                //过滤空格
                case T_WHITESPACE:
                    if (!$last_space) {
                        $strip_str .= ' ';
                        $last_space = true;
                    }
                    break;
                default:
                    $last_space = false;
                    $strip_str .= $tokens[$i][1];
            }
        }
    }
    return $strip_str;
}
?>