<?php
/**
 * pdo_mysql驱动
 *
 *
 * @package    db
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class Db{
	/**
	 * 单件对象
	 *
	 * @var object
	 */
	private static $instance_master = null;

	/**
	 * 单件对象
	 *
	 * @var object
	 */
	private static $instance_slave = null;

	/**
	 * 数据库连接对象
	 *
	 * @var object
	 */
	private static $link;
	
	/**
	 * 请求次数计数
	 */
	private static $query_num = 0;
    
	/**
     * 构造方法
     *
     */
	private function __construct(){
		//检测安装
		if (!class_exists('PDO')){
            throw_exception('Db Error: pdo_mysql is not install');
        }
	}

	/**
	 * 取得实列
	 *
	 * @return object
	 */
	public static function getInstance($dotype = 'read'){
		if (!in_array($dotype,array('read','write'))) $dotype = 'read';
		$conf = C('db.'.$dotype);

		if ($dotype == 'write'){
			$instance = & self::$instance_master;
		}else{
			$instance = & self::$instance_slave;
		}
		if($instance === null || !($instance instanceof Db)){
			$instance = new Db();
			$instance->connect($conf);
		}
	}

	/**
	 * 连接数据库
	 *
	 */
	public function connect($conf){
		$dsn = sprintf('mysql:host=%s;port=%s;dbname=%s',$conf['dbhost'],$conf['dbport'],$conf['dbname']);
		try{
			self::$link = new PDO($dsn,$conf['dbuser'],$conf['dbpwd']);
        }catch (PDOException $e) {
            throw_exception($e->getMessage());
        }
		//统一编码
		switch (strtoupper($conf['dbcharset'])){
			case 'UTF-8':
				$query_string = "
		                 SET CHARACTER_SET_CLIENT = utf8,
		                 CHARACTER_SET_CONNECTION = utf8,
		                 CHARACTER_SET_DATABASE = utf8,
		                 CHARACTER_SET_RESULTS = utf8,
		                 CHARACTER_SET_SERVER = utf8,
		                 COLLATION_CONNECTION = utf8_general_ci,
		                 COLLATION_DATABASE = utf8_general_ci,
		                 COLLATION_SERVER = utf8_general_ci,
		                 sql_mode=''";
				break;
			case 'GBK':
				$query_string = "
		   			    SET CHARACTER_SET_CLIENT = gbk,
		                 CHARACTER_SET_CONNECTION = gbk,
		                 CHARACTER_SET_DATABASE = gbk,
		                 CHARACTER_SET_RESULTS = gbk,
		                 CHARACTER_SET_SERVER = gbk,
		                 COLLATION_CONNECTION = gbk_chinese_ci,
		                 COLLATION_DATABASE = gbk_chinese_ci,
		                 COLLATION_SERVER = gbk_chinese_ci,
		                 sql_mode=''";
				break;
			default:
				$error = "Db Error: charset is Invalid";
				throw_exception($error);
		}

		//进行编码声明
		$result = self::$link->exec($query_string);
		if ($result === false){
			$error = "Db Error: PDO query error code is ".self::$link->errorCode();
			throw_exception($error);
		}
	}
	/**
	 * 调试模式记录
	 *
	 * @param string $sql
	 */
	public static function debug($sql){
        // 记录操作结束时间
        addUpTime('queryEndTime');
        Log::record($sql." [ RunTime:".addUpTime('queryStartTime','queryEndTime',6)."s ]",Log::SQL);
    }

	/**
	 * 执行查询操作
	 *
	 * @param string $sql
	 * @return mixed
	 */
	public static function query($sql,$type='exec'){
		self::getInstance('read');
		if (C('debug')){
			addUpTime('queryStartTime');
		}
		switch ($type){
			case 'query':
				$result = self::$link->query($sql);
				break;
			case 'exec':
				$result = self::$link->exec($sql);
				break;
		}
		if (C('debug')){
			self::debug($sql);
		}
		self::$query_num++;

		if ($result === false){
			$error = "Db Error: PDO query error code is ".self::$link->errorCode();
			throw_exception($error);
		}else {
			return $result;
		}
	}
	/**
	 * 取得查询操作
	 *
	 * @param string $sql
	 * @return mixed
	 */
	public static function getAll($sql){
		self::getInstance('read');
		$result = self::$instance_slave->query($sql,'query');
		if ($result === false) return false;
		$array = $result->fetchAll();
		return !empty($array) ? $array : null;
	}
	/**
     * 检索数据
     * 
     * @param array $param 参数
     * @param object $obj_page 分类对象
     * @return array
     */
	public static function select($param,$obj_page=''){
		static $_cache = array();
		self::getInstance('read');

		if (empty($param)){
			$error = 'Db Error: select param is empty!';
			throw_exception($error);
		}
		if (empty($param['field'])){
			$param['field'] = '*';
		}
		if (empty($param['count'])){
			$param['count'] = 'count(*)';
		}

		if (trim($param['where']) != ''){
			if (strtoupper(substr(trim($param['where']),0,5)) != 'WHERE'){
				if (strtoupper(substr(trim($param['where']),0,3)) == 'AND'){
					$param['where'] = substr(trim($param['where']),3);
				}
				$param['where'] = 'WHERE '.$param['where'];
			}
		}else {
			$param['where'] = '';
		}
		$param['where_group'] = '';
		if (!empty($param['group'])){
			$param['where_group'] .= ' group by '.$param['group'];
		}
		$param['where_order'] = '';
		if (!empty($param['order'])){
			$param['where_order'] .= ' order by '.$param['order'];
		}
		/**
		 * 判断是否是联表查询
		 */
		$tmp_table = explode(',',$param['table']);
		if (!empty($tmp_table) && count($tmp_table) > 1){
			/**
			 * 判断join表数量和join条件是否一致
			 */
			if ((count($tmp_table)-1) != count($param['join_on'])){
				$error = 'Db Error: join number is wrong!';
				throw_exception($error);
			}
			/*
			 * trim 掉空白字符
			 */
			foreach($tmp_table as $key=>$val){
				$tmp_table[$key] = trim($val) ;
			}
			/**
			 * 拼join on 语句
			 */
			for ($i=1;$i<count($tmp_table);$i++){
				$tmp_sql .= $param['join_type'].' `'.DBPRE.$tmp_table[$i].'` as `'.$tmp_table[$i].'` ON '.$param['join_on'][$i-1].' ';
			}
			$sql = 'SELECT '.$param['field'].' FROM `'.DBPRE.$tmp_table[0].'` as `'.$tmp_table[0].'` '.$tmp_sql.' '.$param['where'].$param['where_group'].$param['where_order'];
			/**
			 * 如果有分页，那么计算信息总数
			 */
			$count_sql = 'SELECT '.$param['count'].' as count FROM `'.DBPRE.$tmp_table[0].'` as `'.$tmp_table[0].'` '.$tmp_sql.' '.$param['where'].$param['where_group'];
		}else {
			$sql = 'SELECT '.$param['field'].' FROM `'.DBPRE.$param['table'].'` as `'.$param['table'].'` '.$param['where'].$param['where_group'].$param['where_order'];
			$count_sql = 'SELECT '.$param['count'].' as count FROM `'.DBPRE.$param['table'].'` as `'.$param['table'].'` '.$param['where'].$param['where_group'];
		}
		/**
		 * limit ，如果有分页对象的话，那么优先分页对象
		 */
		if ($obj_page instanceof Page ){
			if ($param['sqlcount'] === false){
				//大数据量时，只显示100页的内容，不需要求记录总数
				$obj_page->setTotalNum($obj_page->getEachNum()*100);
			}else{
				$count_query = self::query($count_sql,'query');
				$count_fetch = $count_query->fetch();
				$obj_page->setTotalNum($count_fetch['count']);
			}

			$param['limit'] = $obj_page->getLimitStart().",".$obj_page->getEachNum();
		}
		if ($param['limit'] != ''){
			$sql .= ' limit '.$param['limit'];
		}
		if ($param['cache'] !== false){
			$key =  is_string($param['cache_key'])?$param['cache_key']:md5($sql);
			if (isset($_cache[$key])) return $_cache[$key];
		}
		$result = self::$instance_slave->query($sql,'query');
		if ($result === false) return false;
		$array = $result->fetchAll();
		return !empty($array) ? $array : null;
	}
	/**
	 * 取得一行信息
	 * 
	 * @param array $param
	 * @param string $fields
	 * @return array
	 */
	public static function getRow($param, $fields = '*'){
		self::getInstance('write');

		$table = $param['table'];
		$wfield = $param['field'];
		$value = $param['value'];
		/**
		 * 判断字段是否是数组
		 */
		if (is_array($wfield)){
			$where = array();
			foreach ($wfield as $k => $v){
				$where[] = $v."='".$value[$k]."'";
			}
			$where = implode(' and ',$where);
		}else {
			$where = $wfield."='".$value."'";
		}

		$sql = "SELECT ".$fields." FROM `".DBPRE.$table."` WHERE ".$where;
		$result = self::$instance_master->query($sql,'query');
		if ($result === false) return false;
		$array = $result->fetch();
		return !empty($array) ? $array : null;
	}
	
	/**
	 * 插入操作
	 * 
	 * @param string $table_name 表名
	 * @param array $insert_array 待插入数据
	 * @return mixed
	 */
	public static function insert($table_name,$insert_array=array()){
		self::getInstance('write');
		if (!is_array($insert_array)) return false;
		$fields = array();
		$value = array();
		foreach ($insert_array as $key => $val){
			$fields[] = self::parseKey($key);
			$value[] = self::parseValue($val);
		}
		$sql = 'INSERT INTO `'.DBPRE.$table_name.'` ('.implode(',',$fields).') VALUES('.implode(',',$value).')';
		//当数据库没有自增ID的情况下，返回 是否成功
		$result    = self::$instance_master->query($sql,'exec');
		$insert_id = self::$link->lastInsertId();
		return $insert_id ? $insert_id : $result;
	}

	/**
	 * 批量插入
	 * 
	 * @param string $table_name 表名
	 * @param array $insert_array 待插入数据
	 * @return mixed
	 */
	public static function insertAll($table_name,$insert_array=array()){
		self::getInstance('write');
		if (!is_array($insert_array[0])) return false;
		$fields = array_keys($insert_array[0]);
		array_walk($fields,array(self,'parseKey'));
		$values = array();
		foreach ($insert_array as $data) {
			$value = array();
			foreach ($data as $key=>$val) {
				$val = self::parseValue($val);
				if (is_scalar($val)){
					$value[] = $val;
				}
			}
			$values[] = '('.implode(',',$value).')';
		}
		$sql = 'INSERT INTO `'.DBPRE.$table_name.'` ('.implode(',',$fields).') VALUES '.implode(',',$values);
		$result    = self::$instance_master->query($sql,'exec');
		$insert_id = self::$link->lastInsertId();
		return $insert_id ? $insert_id : $result;	
	}
	/**
	 * 更新操作
	 * 
	 * @param string $table_name 表名
	 * @param array $update_array 待更新数据
	 * @param string $where 执行条件
	 * @return bool
	 */
	public static function update($table_name,$update_array=array(),$where=''){
		self::getInstance('write');
		if (!is_array($update_array)) return false;
		$string_value = '';
		foreach ($update_array as $k => $v){
			if (is_array($v)){
				switch ($v['sign']){
					/**
					 * increase 自增/自减，值部分不带引号
					 */
					case 'increase':
						$string_value .= " $k = $k + ". $v['value'] .",";
						break;
					case 'decrease':
						$string_value .= " $k = $k - ". $v['value'] .",";
						break;
					case 'calc':
						$string_value .= " $k = ". $v['value'] .",";
						break;
					default:
						$string_value .= " $k = '". $v['value'] ."',";
				}
			}else {
				$string_value .= " $k = '". $v ."',";
			}
		}
		$string_value = trim(trim($string_value),',');
		if (trim($where) != ''){
			if (strtoupper(substr(trim($where),0,5)) != 'WHERE'){
				if (strtoupper(substr(trim($where),0,3)) == 'AND'){
					$where = substr(trim($where),3);
				}
				$where = ' WHERE '.$where;
			}
		}
		$sql = 'UPDATE `'.DBPRE.$table_name.'` AS `'.$table_name.'` SET '.$string_value.' '.$where;
		$result = self::$instance_master->query($sql,'exec');
		return $result;
	}
	
	/**
	 * 删除操作
	 * 
	 * @param string $table_name 表名
	 * @param string $where 执行条件
	 * @return bool
	 */
	public static function delete($table_name,$where=''){
		self::getInstance('write');
		if (trim($where) != ''){
			if (strtoupper(substr(trim($where),0,5)) != 'WHERE'){
				if (strtoupper(substr(trim($where),0,3)) == 'AND'){
					$where = substr(trim($where),3);
				}
				$where = ' WHERE '.$where;
			}
			$sql = 'DELETE FROM `'.DBPRE.$table_name.'` '.$where;
			$result = self::$instance_master->query($sql,'exec');
			return $result;
		}else {
			$error = "Db Error: the condition of delete is empty!";
			throw_exception($error);
		}
	}
	/**
	 * 返回执行次数
	 *
	 * @return int
	 */
	public static function getQueryNum(){
		return self::$query_num;
	}
	/**
	 * 执行REPLACE操作
	 *
	 * @param string $table_name 表名
	 * @param array $replace_array 待更新的数据
	 * @return bool
	 */
	public static function replace($table_name,$replace_array=array()){
		self::getInstance('write');
		if (!empty($replace_array)){
			foreach ($replace_array as $k => $v){
				$string_field .= " $k ,";
				$string_value .= " '". $v ."',";
			}
			$string_field = trim(trim($string_field),',');
			$string_value = trim(trim($string_value),',');
			$sql = 'REPLACE INTO `'.DBPRE.$table_name.'` ('.$string_field.') VALUES('.$string_value.')';
			$result = self::$instance_master->query($sql,'exec');
			return $result;
		}else {
			return false;
		}
	}
	/**
	 * 返回单表查询记录数量
	 *
     * </code>
	 * @param string $table 表名
	 * @param $condition mixed 查询条件，可以为空，也可以为数组或字符串
	 * @return int
	 */
	public static function getCount($table, $condition = null){
		self::getInstance('read');
		if (!empty($condition) && is_array($condition)){
			$where = '';
			foreach ($condition as $key=>$val) {
				self::parseKey($key);
				$val = self::parseValue($val);
				$where .= ' AND '.$key.'='.$val;
			}
			$where = ' WHERE '.substr($where,4);
		}elseif(is_string($condition)){
			if (strtoupper(substr(trim($condition),0,3)) == 'AND'){
				$where = ' WHERE '.substr(trim($condition),4);
			}else{
				$where = ' WHERE '.$condition;
			}
		}
		$sql = 'SELECT COUNT(*) as `count` FROM `'.DBPRE.$table.'` as `'.$table.'` '.(isset($where) ? $where : '');
		$result = self::$instance_slave->query($sql,'query');
		$result = $result->fetch();
		return $result['count'];
	}
	/**
	 * 列出所有表
	 *
	 * @return array
	 */
	public static function showTables(){
		self::getInstance();
		$sql = 'SHOW TABLES';
		$result = self::$instance_slave->query($sql,'query');
		/**
		 * 取数据集
		 */
		if ($result === false) return false;
		$array = $result->fetchAll();
		return !empty($array) ? $array : null;
	}

	/**
	 * 显示表结构语句
	 * 
	 * @param string $table
	 * @return string
	 */
	public static function showCreateTable($table){
		self::getInstance();
		$sql = 'SHOW CREATE TABLE '.DBPRE.$table;
		$result = self::$instance_slave->query($sql,'query');
		$result = $result->fetch();
		return $result['Create Table'];
	}
	
	/**
	 * 显示表结构信息
	 * 
	 * @param string $table
	 * @return array
	 */
	public static function showColumns($table){
		self::getInstance();		
		$sql = 'SHOW COLUMNS FROM `'.DBPRE.$table.'`';
		$result = self::$instance_slave->query($sql,'query');
		if ($result === false) return false;
		$array = $result->fetchAll();
		$result_array = array();
		if(!empty($array) && is_array($array)){
			foreach ($array as $k=>$v){
				$result_array[$v['Field']] = array(
                'name'    => $v['Field'],
                'type'    => $v['Type'],
                'null' 	  => $v['Null'],
                'default' => $v['Default'],
                'primary' => (strtolower($v['Key']) == 'pri'),
                'autoinc' => (strtolower($v['Extra']) == 'auto_increment'),
            	);
			}
		}
		return $result_array;
	}
	/**
	 * 格式化字段
	 *
	 * @param string $key 字段名
	 * @return string
	 */
    public static function parseKey(&$key){
        $key   =  trim($key);
        if(!preg_match('/[,\'\"\*\(\)`.\s]/',$key)) {
           $key = '`'.$key.'`';
        }
        return $key;
    }

    /**
     * 格式化值
     *
     * @param mixed $value
     * @return mixed
     */
    public static function parseValue($value){
    	$value = addslashes(stripslashes($value));//重新加斜线，防止从数据库直接读取出错
    	$value = "'".$value."'";
		return $value;
    }
    /**
	 * 执行SQL语句
	 *
	 * @param string $sql 待执行的SQL
	 * @return
	 */
	public static function execute($sql){
		self::getInstance('write');
		$result = self::$instance_master->query($sql,'exec');
		return $result;
	}

	/**
	 * 取得服务器信息
	 *
	 * @return string
	 */
	public static function getServerInfo(){
		return null;
	}

	/**
	 * 取得上一步插入产生的ID
	 *
	 * @return int
	 */
	public static function getLastId(){
		self::getInstance();
		return self::$link->lastInsertId();
	}
}