<?php
/**
 * oci8驱动
 *
 *
 * @package    db
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class Db{
	/**
	 * 单件对象
	 *
	 * @var object
	 */
	private static $instance = null;
	
	/**
	 * 数据库连接对象
	 *
	 * @var object
	 */
	private static $link;

	/**
	 * 请求次数计数
	 */	
	private static $query_num = 0;

	/**
	 * 暂存准备执行的SQL资源
	 *
	 * @var resource
	 */
	private static $query_id;
	
	/**
	 * 表序列前缀
	 *
	 * @var string
	 */
	private static $seq_prefix = 'SEQ_';

	/**
	 * 当前操作的表(不含DBPRE)，只适用于insert操作时，返回最新ID
	 *
	 * @var string
	 */
	private static $table;

	/**
     * 构造方法
     *
     */
	private function __construct(){
		//检测安装
        if ( !extension_loaded('oci8') ) {
			$error = "Db Error: oracle is not install";
			throw_exception($error);
        }
	}

	/**
	 * 取得实列
	 *
	 * @return object
	 */
	public static function getInstance(){		
		if(self::$instance === null || !(self::$instance instanceof Db)){
			self::$instance = new Db();
			self::$instance->connect();
		}
		return self::$instance;
	}

	/**
	 * 连接数据库
	 *
	 */
	public function connect(){
		$conf = C('db.write');
		$conn_str = sprintf('(DESCRIPTION = (ADDRESS = (PROTOCOL = TCP) (HOST = %s)(PORT = %s)) (CONNECT_DATA= (SID = %s)))',$conf['dbhost'],$conf['dbport'],$conf['dbname']);
        self::$link = oci_pconnect($con_user, $con_pwd, $conn_str, str_replace('-','',$con_charset));
        if (!self::$link){
            throw_exception(oci_error());
        }
	}

	/**
	 * 释放查询结果
	 *
	 */
     private static function free() {
        oci_free_statement(self::$query_id);
        self::$query_id = null;
    }

	/**
	 * 执行查询操作
	 *
	 * @param string $sql
	 * @return mixed
	 */
	public static function query($sql){
		self::getInstance();
		if (self::$debug){
			addUpTime('queryStartTime');
		}
		if ( self::$query_id ) self::free();
		self::$query_id = oci_parse(self::$link,$sql);
        if (false === oci_execute(self::$query_id, OCI_COMMIT_ON_SUCCESS)) {
            return false;
        }else{
        	return true;
        }
	}

	/**
	 * 取得查询操作
	 *
	 * @param string $sql
	 * @return bool/null/array
	 */	
	public static function getAll($sql){
		self::getInstance();
		if ( self::$query_id ) self::free();
		self::$query_id = oci_parse(self::$link,$sql);
        if (false === oci_execute(self::$query_id, OCI_COMMIT_ON_SUCCESS)) {
            return false;
        }
        $result = array();
        while ($tmp = oci_fetch_array(self::$query_id,OCI_BOTH)){
        	$result[] = array_change_key_case($tmp);
        }
//        oci_fetch_all(self::$query_id, $result, 0, -1, OCI_FETCHSTATEMENT_BY_ROW);
//        foreach($result as $k=>$v) {
//            $result[$k] = array_change_key_case($result[$k], CASE_LOWER);
//        }
        return $result;
	}	

	/**
	 * 调试模式记录
	 *
	 * @param string $sql
	 * @return void
	 */
	public static function debug($sql) {
        // 记录操作结束时间
        addUpTime('queryEndTime');
        Log::record($sql." [ RunTime:".addUpTime('queryStartTime','queryEndTime',6)."s ]",Log::SQL);
    }

    /**
     * 检索数据
     * 
     * @param array $param 参数
     * @param object $obj_page 分类对象
     * @return array
     */
	public static function select($param,$obj_page=''){
		self::getInstance();
		static $_cache = array();

		if (empty($param)){
			$error = 'Db Error: select param is empty!';
			throw_exception($error);
		}
		if (empty($param['field'])){
			$param['field'] = '*';
		}
		if (empty($param['count'])){
			$param['count'] = 'count(*)';
		}

		if (trim($param['where']) != ''){
			if (strtoupper(substr(trim($param['where']),0,5)) != 'WHERE'){
				if (strtoupper(substr(trim($param['where']),0,3)) == 'AND'){
					$param['where'] = substr(trim($param['where']),3);
				}
				$param['where'] = 'WHERE '.$param['where'];
			}
		}else {
			$param['where'] = '';
		}
		$param['where_group'] = '';
		if (!empty($param['group'])){
			$param['where_group'] .= ' group by '.$param['group'];
		}
		$param['where_order'] = '';
		if (!empty($param['order'])){
			$param['where_order'] .= ' order by '.$param['order'];
		}
		/**
		 * 判断是否是联表查询
		 */
		$tmp_table = explode(',',$param['table']);
		if (!empty($tmp_table) && count($tmp_table) > 1){
			/**
			 * 判断join表数量和join条件是否一致
			 */
			if ((count($tmp_table)-1) != count($param['join_on'])){
				$error = 'Db Error: join number is wrong!';
				throw_exception($error);
			}
			/*
			 * trim 掉空白字符
			 */
			foreach($tmp_table as $key=>$val){
				$tmp_table[$key] = trim($val) ;
			}
			/**
			 * 拼join on 语句
			 */
			for ($i=1;$i<count($tmp_table);$i++){
				$tmp_sql .= $param['join_type'].' '.DBPRE.$tmp_table[$i].' '.$tmp_table[$i].' ON '.$param['join_on'][$i-1].' ';
			}
			$sql = 'SELECT '.$param['field'].' FROM '.DBPRE.$tmp_table[0].' '.$tmp_table[0].' '.$tmp_sql.' '.$param['where'].$param['where_group'].$param['where_order'];
			/**
			 * 如果有分页，那么计算信息总数
			 */
			$count_sql = 'SELECT '.$param['count'].' as count FROM '.DBPRE.$tmp_table[0].' '.$tmp_table[0].' '.$tmp_sql.' '.$param['where'].$param['where_group'];
		}else {
			$sql = 'SELECT '.$param['field'].' FROM '.DBPRE.$param['table'].' '.$param['table'].' '.$param['where'].$param['where_group'].$param['where_order'];
			$count_sql = 'SELECT '.$param['count'].' count FROM '.DBPRE.$param['table'].' '.$param['table'].' '.$param['where'].$param['where_group'];
		}
		/**
		 * limit ，如果有分页对象的话，那么优先分页对象
		 */
		if ($obj_page instanceof Page ){
			$count_query = self::query($count_sql);
			$count_fetch = mysqli_fetch_array($count_query);
			$obj_page->setTotalNum($count_fetch['count']);
			$param['limit'] = $obj_page->getLimitStart().",".$obj_page->getEachNum();
		}
		if ($param['limit'] != ''){
			$sql .= ' limit '.$param['limit'];
		}

        if(!empty($limit)) {
            $limit	=	explode(',',$limit);
            if(count($limit)>1)
                $limitStr = "(numrow>" . $limit[0] . ") AND (numrow<=" . ($limit[0]+$limit[1]) . ")";
            else
                $limitStr = "(numrow>0 AND numrow<=".$limit[0].")";
        }
        return $limitStr?' WHERE '.$limitStr:'';		
		
		
		if ($param['cache'] !== false){
			$key =  is_string($param['cache_key'])?$param['cache_key']:md5($sql);
			if (isset($_cache[$key])) return $_cache[$key];
		}
		return self::getAll($sql);
	}
	
	/**
	 * 插入操作
	 * 
	 * @param string $table_name 表名
	 * @param array $insert_array 待插入数据
	 * @return mixed
	 */
	public static function insert($table_name,$insert_array=array()){
		self::getInstance();
		if (!is_array($insert_array)) return false;
		self::$table = $table_name;
		$fields = array();
		$value = array();
		foreach ($insert_array as $key => $val){
			$fields[] = self::parseKey($key);
			$value[] = self::parseValue($val);
		}
		$sql = 'INSERT INTO '.DBPRE.$table_name.' ('.implode(',',$fields).') VALUES('.implode(',',$value).')';
		//当数据库没有自增ID的情况下，返回 是否成功
		$result = self::$instance->query($sql);
		$insert_id = self::getLastId();
		return $insert_id ? $insert_id : $result;
	}

	/**
	 * 批量插入
	 * 
	 * @param string $table_name 表名
	 * @param array $insert_array 待插入数据
	 * @return mixed
	 */
	public static function insertAll($table_name,$insert_array=array()){
		self::getInstance();
		if (!is_array($insert_array[0])) return false;
		self::$table = $table_name;
		$fields = array_keys($insert_array[0]);
		array_walk($fields,array(self,'parseKey'));
		$values = array();
		foreach ($insert_array as $data) {
			$value = array();
			foreach ($data as $key=>$val) {
				$val = self::parseValue($val);
				if (is_scalar($val)){
					$value[] = $val;
				}
			}
			$values[] = '('.implode(',',$value).')';
		}
		$sql = 'INSERT INTO `'.DBPRE.$table_name.'` ('.implode(',',$fields).') VALUES '.implode(',',$values);
		$result = self::$instance->query($sql);
		$insert_id = self::getLastId();
		return $insert_id ? $insert_id : $result;	
	}

	/**
	 * 更新操作
	 * 
	 * @param string $table_name 表名
	 * @param array $update_array 待更新数据
	 * @param string $where 执行条件
	 * @return bool
	 */
	public static function update($table_name,$update_array=array(),$where=''){
		self::getInstance();
		if (!is_array($update_array)) return false;
		$string_value = '';
		foreach ($update_array as $k => $v){
			if (is_array($v)){
				switch ($v['sign']){
					/**
					 * increase 自增/自减，值部分不带引号
					 */
					case 'increase':
						$string_value .= " $k = $k + ". $v['value'] .",";
						break;
					case 'decrease':
						$string_value .= " $k = $k - ". $v['value'] .",";
						break;
					case 'calc':
						$string_value .= " $k = ". $v['value'] .",";
						break;
					default:
						$string_value .= " $k = '". $v['value'] ."',";
				}
			}else {
				$string_value .= " $k = '". $v ."',";
			}
		}
		$string_value = trim(trim($string_value),',');
		if (trim($where) != ''){
			if (strtoupper(substr(trim($where),0,5)) != 'WHERE'){
				if (strtoupper(substr(trim($where),0,3)) == 'AND'){
					$where = substr(trim($where),3);
				}
				$where = ' WHERE '.$where;
			}
		}
		$sql = 'UPDATE '.DBPRE.$table_name.' SET '.$string_value.' '.$where;
		$result = self::$instance->query($sql);
		return $result;
	}

	/**
	 * 删除操作
	 *
	 * @param string $table_name 表名
	 * @param string $where 执行条件
	 * @return bool
	 */
	public static function delete($table_name,$where=''){
		self::getInstance();
		if (trim($where) != ''){
			if (strtoupper(substr(trim($where),0,5)) != 'WHERE'){
				if (strtoupper(substr(trim($where),0,3)) == 'AND'){
					$where = substr(trim($where),3);
				}
				$where = ' WHERE '.$where;
			}
			$sql = 'DELETE FROM '.DBPRE.$table_name.' '.$where;
			$result = self::$instance->query($sql);
			return $result;
		}else {
			$error = "Db Error: the condition of delete is empty!";
			throw_exception($error);
		}
	}

	/**
	 * 取得上一步插入产生的ID
	 *    /**
     +----------------------------------------------------------
     * 获取最后插入id ,仅适用于采用序列+触发器结合生成ID的方式
     * 在config.php中指定
     * example :表 shopnc_user的序列为：
     * -- Create sequence
     * create sequence SEQ_USER
     * minvalue 1
     * maxvalue 999999999999999999999999999
     * start with 1
     * increment by 1
     * nocache;
     * 相对的触发器为：
     * create or replace trigger TR_USER
     * before insert on "TR_USER"
     * for each row
     * begin
     * select "SEQ_USER".nextval into :NEW.ID from dual;
     * end;
	 * @return int
	 */
	public static function getLastId(){
		self::getInstance();
        $sequence = self::$seq_prefix.self::$table;
        $sql = 'SELECT '.$sequence.'.currval val FROM dual';
        $currval = self::getAll($sql);
        return $currval[0]['val'] ? $currval[0]['val'] : 0;
	}

	/**
	 * 取得一行信息
	 * 
	 * @param array $param
	 * @param string $fields
	 * @return array
	 */
	public static function getRow($param, $fields = '*'){
		self::getInstance();
		$table = $param['table'];
		$wfield = $param['field'];
		$value = $param['value'];

		//判断字段是否是数组
		if (is_array($wfield)){
			$where = array();
			foreach ($wfield as $k => $v){
				$where[] = $v."='".$value[$k]."'";
			}
			$where = implode(' and ',$where);
		}else {
			$where = $wfield."='".$value."'";
		}

		$sql = "SELECT ".$fields." FROM ".DBPRE.$table." WHERE ".$where;
		if ( self::$query_id ) self::free();
		self::$query_id = oci_parse(self::$link,$sql);
        if (false === oci_execute(self::$query_id, OCI_COMMIT_ON_SUCCESS)) {
            return false;
        }
        $result = array();
        oci_fetch_all(self::$query_id, $result, 0, -1, OCI_FETCHSTATEMENT_BY_ROW);
        return array_change_key_case($result[0], CASE_LOWER);
	}
	
	/**
	 * 执行REPLACE操作
	 *
	 * @param string $table_name 表名
	 * @param array $replace_array 待更新的数据
	 * @return bool
	 */
	public static function replace($table_name,$replace_array=array()){
		/**
		 * ............
		 */
	}

	/**
	 * 返回单表查询记录数量
	 *
     * </code>
	 * @param string $table 表名
	 * @param $condition mixed 查询条件，可以为空，也可以为数组或字符串
	 * @return int
	 */
	public static function getCount($table, $condition = null){
		self::getInstance();
		if (!empty($condition) && is_array($condition)){
			$where = '';
			foreach ($condition as $key=>$val) {
				self::parseKey($key);
				$val = self::parseValue($val);
				$where .= ' AND '.$key.'='.$val;
			}
			$where = ' WHERE '.substr($where,4);
		}elseif(is_string($condition)){
			if (strtoupper(substr(trim($condition),0,3)) == 'AND'){
				$where = ' WHERE '.substr(trim($condition),4);
			}else{
				$where = ' WHERE '.$condition;
			}
		}

		$sql = 'SELECT COUNT(*) as count FROM '.DBPRE.$table.' '.$table.(isset($where) ? $where : '');
		$result = self::getAll($sql);
		return $result[0]['count'];
	}

	/**
	 * 执行SQL语句
	 *
	 * @param string $sql 待执行的SQL
	 * @return
	 */
	public static function execute($sql){
		self::getInstance();
		$result = self::$instance->query($sql);
		return $result;
	}
	
	/**
	 * 返回执行次数
	 *
	 * @return int
	 */
	public static function getQueryNum(){
		return self::$query_num;
	}

	/**
	 * 列出所有表息（取得用户表信息）
	 *
	 * @return array
	 */
	public static function showTables(){
		self::getInstance();
        $result = self::getAll("select table_name from user_tables");
        $info   =   array();
        foreach ($result as $key => $val) {
            $info[$key] = current($val);
        }
        return $info;
	}

	/**
	 * 显示表结构语句
	 * 
	 * @param string $table
	 * @return string
	 */
	public static function showCreateTable($table){
		return array();
	}

	/**
	 * 显示表结构信息
	 * 
	 * @param string $table
	 * @return array
	 */
	public static function showColumns($table){
		self::getInstance();
		$result = self::getAll('DESC '.strtoupper(DBPRE.$table));
		print_r($result);exit;
        $result = self::getAll("select a.column_name,data_type,decode(nullable,'Y',0,1) notnull,data_default,decode(a.column_name,b.column_name,1,0) pk "
                  ."from user_tab_columns a,(select column_name from user_constraints c,user_cons_columns col "
          ."where c.constraint_name=col.constraint_name and c.constraint_type='P'and c.table_name='".strtoupper(DBPRE.$tableName)
          ."') b where table_name='".strtoupper(DBPRE.$tableName)."' and a.column_name=b.column_name(+)");
        $info   =   array();
        if($result) {
        	print_r($result);exit;
            foreach ($result as $key => $val) {
                $info[strtolower($val['column_name'])] = array(
                    'name'    => strtolower($val['column_name']),
                    'type'    => strtolower($val['data_type']),
                    'notnull' => $val['notnull'],
                    'default' => $val['data_default'],
                    'primary' => $val['pk'],
                    'autoinc' => $val['pk'],
                );
            }
        }
        return $info;		

			
		$sql = 'SHOW COLUMNS FROM `'.DBPRE.$table.'`';
		$result = self::$instance->query($sql);
		$array = array();
		while ($tmp=mysqli_fetch_array($result)){
            $array[$tmp['Field']] = array(
                'name'    => $tmp['Field'],
                'type'    => $tmp['Type'],
                'null' 	  => $tmp['Null'],
                'default' => $tmp['Default'],
                'primary' => (strtolower($tmp['Key']) == 'pri'),
                'autoinc' => (strtolower($tmp['Extra']) == 'auto_increment'),
            );
		}
		return $array;
	}
	
	/**
	 * 取得服务器信息
	 *
	 * @return string
	 */
	public static function getServerInfo(){
		self::getInstance();
		$result = mysqli_get_server_info(self::$mysqli);
		return $result;
	}

	/**
	 * 格式化字段
	 *
	 * @param string $key 字段名
	 * @return string
	 */
    public static function parseKey(&$key){
        $key   =  trim($key);
        return $key;
    }

    /**
     * 格式化值
     *
     * @param mixed $value
     * @return mixed
     */
    public static function parseValue($value){
    	$value = addslashes(stripslashes($value));//重新加斜线，防止从数据库直接读取出错
    	$value = "'".$value."'";
		return $value;
    }
}