<?php
/**
 * 系统准备运行
 *
 *
 *
 * @package    core
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');

if (!is_array($config)) exit('config params error');

global $config;
define('SiteUrl',$config['site_url']);
define('SYSImgUrl',$config['site_url'].'/templates/default/images');
define('CHARSET',$config['db'][1]['dbcharset']);
define('DBDRIVER',$config['dbdriver']);
define('SESSION_EXPIRE',$config['session_expire']);
define('LANG_TYPE',$config['lang_type']);
define('COOKIE_PRE',$config['cookie_pre']);
define('CORE_PATH',BasePath.'/framework');
define('TPL_NAME',$config['tpl_name']);
define('BASE_TPL_PATH',BasePath.'/templates/'.TPL_NAME);
define('RESOURCE_PATH',SiteUrl.'/resource');

if (defined('NC_ADMIN') && NC_ADMIN === true){
	define('DBPRE',$db_pre ? $db_pre : $config['tablepre']);
}else {	//前台整合uc时,$dbtype使用mysql方式时防止出现没选择数据库的错误
	if (DBDRIVER == 'oci8'){
		define('DBPRE',$config['tablepre']);
	}else{
		define('DBPRE',($config['db'][1]['dbname']).'`.`'.($config['tablepre']));
	}
}

/**
 * 定义全局常量（附件文件目录）
 */
define('ATTACH_PATH','upload');
define('ATTACH_COMMON','upload/common');
define('ATTACH_AVATAR','upload/avatar');
define('ATTACH_PRODUCT','upload/product');
define('ATTACH_FILE','upload/file');

//模板相关内容路径
if (defined('ProjectName') and ProjectName != ''){
	define('TEMPLATES_PATH',SiteUrl.'/'.ProjectName.'/templates');
}else {
	define('TEMPLATES_PATH',SiteUrl.'/templates/'.TPL_NAME);
}

//统一ACTION
$_GET['act'] = $_GET['act']?strtolower($_GET['act']):($_POST['act']?strtolower($_POST['act']):'index');
$_GET['op'] = $_GET['op']?strtolower($_GET['op']):($_POST['op']?strtolower($_POST['op']):'index');

//对GET POST接收内容进行过滤,$ignore内的下标不被过滤
$ignore = array();
if (!class_exists('Security')) require(BasePath.'/framework/libraries/security.php');
$_GET = !empty($_GET) ? Security::getAddslashesForInput($_GET,$ignore) : array();
$_POST = !empty($_POST) ? Security::getAddslashesForInput($_POST,$ignore) : array();
$_REQUEST = !empty($_REQUEST) ? Security::getAddslashesForInput($_REQUEST,$ignore) : array();
$_SERVER = !empty($_SERVER) ? Security::getAddslashes($_SERVER) : array();

//启用ZIP压缩
if ($config['gzip'] == 1 && function_exists('ob_gzhandler') && $_GET['inajax'] != 1){
	ob_start('ob_gzhandler');
}else {
	ob_start();
}

//[NC_SKIPBUILD]
//被NC_SKIPBUILD包含的代码，框架压缩时，不会被执行
require(BasePath.'/framework/function/core.php');
require(BasePath.'/framework/db/'.strtolower($config['dbdriver']).'.php');
require(BasePath.'/framework/core/model.php');
require(BasePath.'/framework/cache/cache.php');
require(BasePath.'/framework/cache/cache.file.php');
require(BasePath.'/framework/libraries/language.php');
require(BasePath.'/framework/libraries/validate.php');
require(BasePath.'/framework/libraries/page.php');
require(BasePath.'/framework/libraries/upload.php');
require(BasePath.'/framework/libraries/log.php');
require(BasePath.'/framework/function/seccode.php');
require(BasePath.'/framework/tpl/nc.php');
require(BasePath.'/control/control.php');
require(BasePath.'/framework/core/base.php');
require(BasePath.'/framework/libraries/session.class.php');

Language::read('core_lang_index');
Base::run();
//[/NC_SKIPBUILD]
?>
