<?php
/**
 * 工作台历管理
 *
 *
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class work_calendarControl extends BaseHomeControl{
	/**
	 * 工作台历展示
	 */
	public function calendar_showOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu();
		/**
		 * 调取日程安排信息
		 */
		$tmp_schedule_info = $model->table('schedule')->where(array('cs_staff_id'=>$_SESSION['member_id']))->select();
		//处理日程信息数组
		$schedule_list = array();
		$now_time = time();
		if(!empty($tmp_schedule_info) && is_array($tmp_schedule_info)){
			foreach ((array)$tmp_schedule_info as $k=>$v){
				$start_d_plus = round(($v['cs_start_time']-$now_time)/(3600*24));
				$end_d_plus   = round(($v['cs_end_time']-$now_time)/(3600*24));
				$schedule_list[] = array(
					'title'=>$v['cs_subject'],
					'start'=>'y,m,d'.($start_d_plus>=0?'+'.$start_d_plus:$start_d_plus).','.date('h,i',$v['cs_start_time']),
					'end'=>'y,m,d'.($end_d_plus>=0?'+'.$end_d_plus:$end_d_plus).','.date('h,i',$v['cs_end_time']),
					'url'=>'index.php?act=schedule&op=schedule_view&cs_id='.$v['cs_id']
				);
			}
		}
		Tpl::output('schedule_list',$schedule_list);
		$this->setleftmenu('calendar_show');
		/**
		 * 模板输出
		 */
		Tpl::showpage('calendar_show');
	}
	/**
	 * 设置左菜单
	 */
	private function setleftmenu($menu_key=''){
		$arr = array();
		$arr[0] = array('menu_name'=>Language::get('bp_home_mission'),	'menu_url'=>'#');
		$arr[0]['submenu'][0] = array('menu_key'=>'calendar_show','menu_name'=>Language::get('bp_home_calendar'),'menu_act'=>'work_calendar','menu_op'=>'calendar_show');
		$arr[0]['submenu'][1] = array('menu_key'=>'mission_list','menu_name'=>Language::get('bp_home_mission_manage'),'menu_act'=>'mission','menu_op'=>'mission_list');
		$arr[0]['submenu'][2] = array('menu_key'=>'schedule_list','menu_name'=>Language::get('bp_home_schedule_manage'),'menu_act'=>'schedule','menu_op'=>'schedule_list');
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}