<?php
/**
 * 员工页面
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class userControl extends BaseHomeControl{
	private $commonwhere=array();
	public function __construct(){
		parent::__construct();		
		$model = Model();
		//查询岗位信息
		$jobpost_info = $model->table('jobpost')->where(array('jp_id'=>$_SESSION['jp_id']))->find();
		//获得所有查询共有条件
		if($jobpost_info['jp_isleader'] == 1 || $_SESSION['member_id'] == 1){
			$tree_arr = ($t = F('department')) ? $t : H('department',true,'file');
			$d_idarr = array();
			//从缓存查询子部门
			$d_info = $tree_arr[$_SESSION['dp_id']];
			if (!empty($tree_arr[$_SESSION['dp_id']]['son'])){
				$d_idarr = explode(',',$tree_arr[$_SESSION['dp_id']]['son']);
			}
			$d_idarr[] = $_SESSION['dp_id'];
			$this->commonwhere['user_department'] = array('in',$d_idarr);
		}else{
			$this->commonwhere['user_id'] = $_SESSION['member_id'];
		}
		Language::read('user');
	}
	/**
	 * 员工列表
	 */
	public function userlistOp(){
		$model = Model();
		$where = $this->commonwhere;
		//添加自定义搜索条件
		if ($_GET['search_did']){
			$did = intval($_GET['search_did']);
			$tree_arr = ($t = F('department')) ? $t : H('department',true,'file');
			$d_idarr = array();
			//从缓存查询子部门
			$d_info = $tree_arr[$_SESSION['dp_id']];
			if (!empty($tree_arr[$_SESSION['dp_id']]['son'])){
				$d_idarr = explode(',',$tree_arr[$_SESSION['dp_id']]['son']);
			}
			$d_idarr[] = $did;
			//将权限的数组与搜索的部门数组取与
			if (!empty($this->commonwhere['user_department'][1])){
				$d_idarr = array_intersect($d_idarr,$this->commonwhere['user_department'][1]);
			}
			$where['user_department'] = array('in',$d_idarr);
		}
		if (!empty($_GET['search_jpid'])){
			$where['user_jobpost'] = intval($_GET['search_jpid']);
		}
		if (!empty($_GET['search_state'])){
			$where['user_state'] = intval($_GET['search_state'])-1;
		}
		if (!empty($_GET['search_content'])){
			switch ($_GET['search_type']){
				case 'uname':
					$where['user_name'] = array('like',"%{$_GET['search_content']}%");
					break;
				case 'truename':
					$where['user_truename'] = array('like',"%{$_GET['search_content']}%");
					break;
			}
		}
		//店铺
		if (!empty($_GET['search_shop'])){
			$where['user_shopid'] = intval($_GET['search_shop']);
		}
		$user_list = $model->table('user')->where($where)->order('user_id desc')->page(10)->select();
		Tpl::output('show_page',$model->showpage(2));
		Tpl::output('user_list',$user_list);
		if (!empty($this->commonwhere['user_department'])){
			//获得部门select
			$selecthtml = $this->getDepartmentList(intval($_GET['search_did']));
			Tpl::output('selecthtml',$selecthtml);
		}
		//从缓存中调取店铺信息
		$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
		if(!empty($shop_list)){
			foreach($shop_list as $k=>$v){
				if($v['shop_isuse'] == 0){
					unset($shop_list[$k]);
				}
			}
		}
		Tpl::output('shop_list',$shop_list);
		//左侧菜单
		$this->setleftmenu('userlist');
		Tpl::showpage('userlist');
	}
	/**
	 * 查询有权限访问的部门数据
	 */
	private function getDepartmentList($did = 0){
		$start_id = 0;
		if(!empty($this->commonwhere['user_department'])){
			$start_id = $_SESSION['dp_id'];
		}
		$model = Model('department');
		$selecthtml = $model->getDepartmentCacheSelect(false,$did,'',$start_id);
		return $selecthtml;
	}
	/**
	 * 新增员工
	 */
	public function useraddOp(){
		$model = Model('department');
		if (chksubmit()){
			$did = intval($_POST["u_did"]);
			if($did<=0){
				$did = '';
			}
			$jpid = intval($_POST["u_jpid"]);
			if($jpid<=0){
				$jpid = '';
			}
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["u_name"],"require"=>"true","message"=>Language::get('bp_user_pls_add_username'));
			$validate_arr[] = array("input"=>$_POST["u_pw"],"require"=>"true","message"=>Language::get('bp_user_pls_add_pwd'));
			$validate_arr[] = array("input"=>$_POST["u_truename"],"require"=>"true","message"=>Language::get('bp_user_pls_add_truename'));
			$validate_arr[] = array("input"=>$did, "require"=>'true',"message"=>Language::get('bp_user_pls_choose_department'));
			$validate_arr[] = array("input"=>$jpid, "require"=>'true',"message"=>Language::get('bp_user_pls_choose_jobpost'));
			$validate_arr[] = array("input"=>$_POST['uex_entrytime'], "require"=>'true',"message"=>Language::get('bp_user_pls_add_onjob_time'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//用户名是否存在
			$ucount = $model->table('user')->where(array('user_name'=>$_POST['u_name']))->count();
			if($ucount > 0){
				showDialog(Language::get('bp_user_exist'),'','error');
			}
			//查询部门信息
			$d_info = $model->table('department')->where(array('d_id'=>$did,'d_state'=>1))->find();
			if(empty($d_info)){
				showDialog(Language::get('bp_user_dpt_error'),'','error');
			}
			//查询岗位信息
			$jp_info = $model->table('jobpost')->where(array('jp_id'=>$jpid,'jp_state'=>1))->find();
			if(empty($jp_info)){
				showDialog(Language::get('bp_user_jobpost_error'),'','error');
			}
			//岗位唯一则判断是否已经存在yuangong
			if ($jp_info['jp_only'] == 1){
				$ucount = $model->table('user')->where(array('user_jobpost'=>$jpid))->count();
				if ($ucount > 0){
					showDialog(Language::get('bp_user_staff_existonjob_choose_otherjob'),'','error');
				}
			}
			$d_namearr = array();//所有上级部门名称数组
			//全部上级部门
			if (!empty($d_info['d_allparentid'])){
				$d_list = $model->table('department')->where(array('d_id'=>array('in',$d_info['d_allparentid']),'d_state'=>1))->select();
				$d_listnew = array();
				foreach ((array)$d_list as $k=>$v){
					$d_listnew[$v['d_id']] = $v;
				}
				$d_idarr = explode(',',$d_info['d_allparentid']);
				foreach ((array)$d_idarr as $k=>$v){
					if (!empty($d_listnew[$v]['d_name'])){
						$d_namearr[] = $d_listnew[$v]['d_name'];
					}
				}
			}
			$d_namearr[] = $d_info['d_name'];
			//上传头像
			if (!empty($_FILES['u_avatar']['name'])){
				$upload = new UploadFile();
				$upload->set('default_dir',	ATTACH_AVATAR);
				$upload->set('thumb_ext',	'');
				$upload->set('file_name','');
				$upload->set('ifremove',false);
				$result = $upload->upfile('u_avatar');
				if ($result){
					$_POST['u_avatar'] = $upload->file_name;
				}else {
					showDialog($upload->error);
				}
			}
			$insert_arr = array();
			$insert_arr['user_name'] = $_POST['u_name'];
			$insert_arr['user_password'] = md5(trim($_POST['u_pw']));
			$insert_arr['user_truename'] = $_POST['u_truename'];
			$insert_arr['user_numbers'] = $_POST['u_numbers'];
			$insert_arr['user_avatar'] = empty($_POST['u_avatar'])?'':$_POST['u_avatar'];
			$insert_arr['user_addtime'] = time();
			$insert_arr['user_department'] = $did;
			$insert_arr['user_departmentname'] = implode('->',$d_namearr);
			$insert_arr['user_jobpost'] = $jpid;
			$insert_arr['user_jobpostname'] = $jp_info['jp_name'];
			$insert_arr['user_shopid'] = intval($_POST['u_shopid']);
			$insert_arr['user_state'] = intval($_POST['state']);
			$insert_arr['user_operatorid'] = $_SESSION['member_id'];
			$insert_arr['user_operatorname'] = $_SESSION['truename'];
			$rs = $model->table('user')->insert($insert_arr);
			if ($rs){
				//新增扩展信息
				$exinsert_arr = array();
				$exinsert_arr['uex_userid'] = $rs;
				$exinsert_arr['uex_sex'] = $_POST['uex_sex'];
				$exinsert_arr['uex_entrytime'] = strtotime($_POST['uex_entrytime'])?strtotime($_POST['uex_entrytime']):0;
				$exinsert_arr['uex_leavingtime'] = strtotime($_POST['uex_leavingtime'])?strtotime($_POST['uex_leavingtime']):0;
				$exinsert_arr['uex_birthday'] = strtotime($_POST['uex_birthday'])?strtotime($_POST['uex_birthday']):0;
				$exinsert_arr['uex_education'] = $_POST['uex_education'];
				$exinsert_arr['uex_mobile'] = $_POST['uex_mobile'];
				$exinsert_arr['uex_telephone'] = $_POST['uex_telephone'];
				$exinsert_arr['uex_email'] = $_POST['uex_email'];
				$exinsert_arr['uex_qq'] = $_POST['uex_qq'];
				$exinsert_arr['uex_msn'] = $_POST['uex_msn'];
				$exinsert_arr['uex_skype'] = $_POST['uex_skype'];
				if(intval($_POST['p_select']) > 0){
					$exinsert_arr['uex_province'] = $_POST['p_text'];
				}
				if(intval($_POST['c_select']) > 0){
					$exinsert_arr['uex_city'] = $_POST['c_text'];
				}
				if(intval($_POST['d_select']) > 0){
					$exinsert_arr['uex_county'] = $_POST['d_text'];
				}
				if(empty($exinsert_arr['uex_province']) || empty($exinsert_arr['uex_city']) || empty($exinsert_arr['uex_county'])){
					unset($exinsert_arr['uex_province'],$exinsert_arr['uex_city'] ,$exinsert_arr['uex_county']);
				}
				$exinsert_arr['uex_address'] = $_POST['addressinfo'];
				$model->table('userextend')->insert($exinsert_arr);
				//记录员工日志
				$loginsert_arr = array();
				$loginsert_arr['clog_type'] = 'user';
				$loginsert_arr['clog_originalid'] = $rs;
				$loginsert_arr['clog_addtime'] = time();
				$loginsert_arr['clog_operatorid'] = $_SESSION['member_id'];
				$loginsert_arr['clog_operatorname'] = $_SESSION['truename'];
				$loginsert_arr['clog_content'] = Language::get('bp_user_new_onjob').Language::get('bp_comma').Language::get('bp_user_department').Language::get('bp_colon')."{$insert_arr['user_departmentname']}".Language::get('bp_semicolon').Language::get('bp_user_jobpost').Language::get('bp_colon')."{$insert_arr['user_jobpostname']}";
				$model->table('commonlog')->insert($loginsert_arr);
				H('user',true,'file');//更新缓存
				showDialog(Language::get('bp_user_addsucc'),'index.php?act=user&op=userlist','succ');
			}else {
				showDialog(Language::get('bp_user_addfailed'),'','error');
			}
		}else{
			//获得部门select
			$selecthtml = $this->getDepartmentList();
			Tpl::output('selecthtml',$selecthtml);
			//从缓存中调取店铺信息
			$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
			if(!empty($shop_list)){
				foreach($shop_list as $k=>$v){
					if($v['shop_isuse'] == 0){
						unset($shop_list[$k]);
					}
				}
			}
			Tpl::output('shop_list',$shop_list);
			//左侧菜单
			$this->setleftmenu('userlist');
			Tpl::showpage('useradd');
		}
	}
	/**
	 * 编辑员工
	 */
	public function usereditOp(){
		$id = intval($_GET['id']);
		if ($id<=0){
			$id = intval($_POST['id']);
		}
		if ($id<=0){//1为系统默认管理员不能编辑
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		$where['user_id'] = $id;
		$where = array_merge($where,$this->commonwhere);
		$u_info = $model->table('user')->where($where)->find();
		if (empty($u_info)){
			showDialog(Language::get('bp_user_infoerror'),'','error');
		}
		if (chksubmit()){
			$did = intval($_POST["u_did"]);
			if($did<=0){
				$did = '';
			}
			$jpid = intval($_POST["u_jpid"]);
			if($jpid<=0){
				$jpid = '';
			}
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["u_name"],"require"=>"true","message"=>Language::get('bp_user_pls_add_username'));
			$validate_arr[] = array("input"=>$_POST["u_truename"],"require"=>"true","message"=>Language::get('bp_user_pls_add_truename'));
			$validate_arr[] = array("input"=>$did, "require"=>'true',"message"=>Language::get('bp_user_pls_choose_department'));
			$validate_arr[] = array("input"=>$jpid, "require"=>'true',"message"=>Language::get('bp_user_pls_choose_jobpost'));
			$validate_arr[] = array("input"=>$_POST['uex_entrytime'], "require"=>'true',"message"=>Language::get('bp_user_pls_add_onjob_time'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			if ($u_info['user_name'] != $_POST['u_name']){
				//用户名是否存在
				$ucount = $model->table('user')->where(array('user_name'=>$_POST['u_name']))->count();
				if($ucount > 0){
					showDialog(Language::get('bp_user_exist'),'','error');
				}
			}
			//查询部门信息
			$d_info = $model->table('department')->where(array('d_id'=>$did,'d_state'=>1))->find();
			if(empty($d_info)){
				showDialog(Language::get('bp_user_dpt_error'),'','error');
			}
			//查询岗位信息
			$jp_info = $model->table('jobpost')->where(array('jp_id'=>$jpid,'jp_state'=>1))->find();
			if(empty($jp_info)){
				showDialog(Language::get('bp_user_jobpost_error'),'','error');
			}
			//岗位唯一则判断是否已经存在yuangong
			if ($jp_info['jp_only'] == 1 && $jpid != $u_info['user_jobpost']){
				$ucount = $model->table('user')->where(array('user_jobpost'=>$jpid))->count();
				if ($ucount > 0){
					showDialog(Language::get('bp_user_staff_existonjob_choose_otherjob'),'','error');
				}
			}
			$d_namearr = array();//所有上级部门名称数组
			//全部上级部门
			if (!empty($d_info['d_allparentid'])){
				$d_list = $model->table('department')->where(array('d_id'=>array('in',$d_info['d_allparentid']),'d_state'=>1))->select();
				$d_listnew = array();
				foreach ((array)$d_list as $k=>$v){
					$d_listnew[$v['d_id']] = $v;
				}
				$d_idarr = explode(',',$d_info['d_allparentid']);
				foreach ((array)$d_idarr as $k=>$v){
					if (!empty($d_listnew[$v]['d_name'])){
						$d_namearr[] = $d_listnew[$v]['d_name'];
					}
				}
			}
			$d_namearr[] = $d_info['d_name'];
			//上传头像
			if (!empty($_FILES['u_avatar']['name'])){
				$upload = new UploadFile();
				$upload->set('default_dir',	ATTACH_AVATAR);
				$upload->set('thumb_ext',	'');
				$upload->set('file_name','');
				$upload->set('ifremove',false);
				$result = $upload->upfile('u_avatar');
				if ($result){
					$_POST['u_avatar'] = $upload->file_name;
				}else {
					showDialog($upload->error);
				}
			}
			//删除旧头像
			if (!empty($_POST['u_avatar']) && !empty($_POST['old_u_avatar'])){
				@unlink(BasePath.DS.ATTACH_AVATAR.DS.$_POST['old_u_avatar']);
			}
			$update_arr = array();
			if ($id != 1){//超管不能编辑其用户名
				$update_arr['user_name'] = $_POST['u_name'];
			}
			if (!empty($_POST['u_pw'])){
				$update_arr['user_password'] = md5(trim($_POST['u_pw']));
			}
			//根据系统设置来处理离职状态是否会员自动归入公海中
			if(C('auto_gotosea') == 1 && intval($_POST['state']) == 2){
				gotosea_batch($id);
			}
			$update_arr['user_truename'] = $_POST['u_truename'];
			$update_arr['user_numbers'] = $_POST['u_numbers'];
			$update_arr['user_avatar'] = empty($_POST['u_avatar'])?$_POST['old_u_avatar']:$_POST['u_avatar'];
			if ($id != 1){//超管不能编辑其部门和岗位及状态
				$update_arr['user_department'] = $did;
				$update_arr['user_departmentname'] = implode('->',$d_namearr);
				$update_arr['user_jobpost'] = $jpid;
				$update_arr['user_jobpostname'] = $jp_info['jp_name'];
				$update_arr['user_shopid'] = intval($_POST['u_shopid']);
				$update_arr['user_state'] = intval($_POST['state']);
			}
			$update_arr['user_operatorid'] = $_SESSION['member_id'];
			$update_arr['user_operatorname'] = $_SESSION['truename'];
			$rs = $model->table('user')->where(array('user_id'=>$id))->update($update_arr);
			if ($rs){
				//新增扩展信息
				$exupdate_arr = array();
				$exupdate_arr['uex_sex'] = $_POST['uex_sex'];
				$exupdate_arr['uex_entrytime'] = strtotime($_POST['uex_entrytime'])?strtotime($_POST['uex_entrytime']):0;
				$exupdate_arr['uex_leavingtime'] = strtotime($_POST['uex_leavingtime'])?strtotime($_POST['uex_leavingtime']):0;
				$exupdate_arr['uex_birthday'] = strtotime($_POST['uex_birthday'])?strtotime($_POST['uex_birthday']):0;
				$exupdate_arr['uex_education'] = $_POST['uex_education'];
				$exupdate_arr['uex_mobile'] = $_POST['uex_mobile'];
				$exupdate_arr['uex_telephone'] = $_POST['uex_telephone'];
				$exupdate_arr['uex_email'] = $_POST['uex_email'];
				$exupdate_arr['uex_qq'] = $_POST['uex_qq'];
				$exupdate_arr['uex_msn'] = $_POST['uex_msn'];
				$exupdate_arr['uex_skype'] = $_POST['uex_skype'];
				if(intval($_POST['p_select']) > 0){
					$exupdate_arr['uex_province'] = $_POST['p_text'];
				}
				if(intval($_POST['c_select']) > 0){
					$exupdate_arr['uex_city'] = $_POST['c_text'];
				}
				if(intval($_POST['d_select']) > 0){
					$exupdate_arr['uex_county'] = $_POST['d_text'];
				}
				if(empty($exupdate_arr['uex_province']) || empty($exupdate_arr['uex_city']) || empty($exupdate_arr['uex_county'])){
					unset($exupdate_arr['uex_province'],$exupdate_arr['uex_city'] ,$exupdate_arr['uex_county']);
				}
				$exupdate_arr['uex_address'] = $_POST['addressinfo'];
				//查询员工扩展信息
				$userextend_info = $model->table('userextend')->where(array('uex_userid'=>$id))->find();
				if (empty($userextend_info)){
					$exupdate_arr['uex_userid'] = $id;
					$model->table('userextend')->insert($exupdate_arr);
				}else {
					$model->table('userextend')->where(array('uex_userid'=>$id))->update($exupdate_arr);
				}
				//记录员工日志
				if ($jpid != $u_info['user_jobpost']){//岗位改变
					$loginsert_arr = array();
					$loginsert_arr['clog_type'] = 'user';
					$loginsert_arr['clog_originalid'] = $id;
					$loginsert_arr['clog_addtime'] = time();
					$loginsert_arr['clog_operatorid'] = $_SESSION['member_id'];
					$loginsert_arr['clog_operatorname'] = $_SESSION['truename'];
					$loginsert_arr['clog_content'] = Language::get('bp_user_change_jobpost_to_dpt').Language::get('bp_colon')."{$update_arr['user_departmentname']}".Language::get('bp_semicolon').Language::get('bp_user_jobpost').Language::get('bp_colon')."{$update_arr['user_jobpostname']}";
					$model->table('commonlog')->insert($loginsert_arr);	
				}
				if ($update_arr['user_state'] != $u_info['user_state']){//状态
					$loginsert_arr = array();
					$loginsert_arr['clog_type'] = 'user';
					$loginsert_arr['clog_originalid'] = $id;
					$loginsert_arr['clog_addtime'] = time();
					$loginsert_arr['clog_operatorid'] = $_SESSION['member_id'];
					$loginsert_arr['clog_operatorname'] = $_SESSION['truename'];
					switch ($update_arr['user_state']){
						case 1:
							$loginsert_arr['clog_content'] = Language::get('bp_user_transact_stopjob');
							break;
						case 2:
							$loginsert_arr['clog_content'] = Language::get('bp_user_transact_offjob');
							break;
						default:
							$loginsert_arr['clog_content'] = Language::get('bp_user_return_onjob');
							break;
					}
					$model->table('commonlog')->insert($loginsert_arr);	
				}
				H('user',true,'file');//更新缓存
				showDialog(Language::get('bp_user_editsucc'),'index.php?act=user&op=userlist','succ');
			}else {
				showDialog(Language::get('bp_user_editfailed'),'','error');
			}
		}else{
			//获得部门select
			$selecthtml = $this->getDepartmentList();
			Tpl::output('selecthtml',$selecthtml);
			//从缓存中调取店铺信息
			$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
			if(!empty($shop_list)){
				foreach($shop_list as $k=>$v){
					if($v['shop_isuse'] == 0){
						unset($shop_list[$k]);
					}
				}
			}
			Tpl::output('shop_list',$shop_list);
			//查询用户扩展信息
			$uex_info = $model->table('userextend')->where(array('uex_userid'=>$u_info['user_id']))->find();
			$uex_info['uex_birthday'] = empty($uex_info['uex_birthday'])?'':@date('Y-m-d',$uex_info['uex_birthday']);
			$uex_info['uex_entrytime'] = empty($uex_info['uex_entrytime'])?'':@date('Y-m-d',$uex_info['uex_entrytime']);
			$uex_info['uex_leavingtime'] = empty($uex_info['uex_leavingtime'])?'':@date('Y-m-d',$uex_info['uex_leavingtime']);
			Tpl::output('u_info',$u_info);
			Tpl::output('uex_info',$uex_info);
			//左侧菜单
			$this->setleftmenu('userlist');
			Tpl::showpage('useradd');
		}
	}
	/**
	 * 员工查看
	 */
	public function userviewOp(){
		$id = intval($_GET['id']);
		if ($id<=0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		$where = array();
		$where['user_id'] = $id;
		$u_info = $model->table('user')->where($where)->find();
		if (empty($u_info)){
			showDialog(Language::get('bp_user_infoerror'),'','error');
		}
		//查询用户扩展信息
		$uex_info = $model->table('userextend')->where(array('uex_userid'=>$u_info['user_id']))->find();
		$uex_info['uex_birthday'] = empty($uex_info['uex_birthday'])?'':@date('Y-m-d',$uex_info['uex_birthday']);
		$uex_info['uex_entrytime'] = empty($uex_info['uex_entrytime'])?'':@date('Y-m-d',$uex_info['uex_entrytime']);
		Tpl::output('u_info',$u_info);
		Tpl::output('uex_info',$uex_info);
		//左侧菜单
		$this->setleftmenu('userlist');
		Tpl::showpage('userview','windowopen_layout');
	}
	/**
	 * 员工日志列表
	 */
	public function userlogOp(){
		$model = Model();
		$where = $this->commonwhere;
		$where['clog_type'] = 'user';
		if (!empty($_GET['search_content'])){
			switch ($_GET['search_type']){
				case 'uname':
					$where['user_name'] = array('like',"%{$_GET['search_content']}%");
					break;
				case 'truename':
					$where['user_truename'] = array('like',"%{$_GET['search_content']}%");
					break;
				case 'content':
					$where['clog_content'] = array('like',"%{$_GET['search_content']}%");
					break;
			}
		}
		$log_list = $model->table('commonlog,user')->join('left')->on('commonlog.clog_originalid=user.user_id')->where($where)->order('clog_id desc')->page(10)->select();
		Tpl::output('show_page',$model->showpage(2));
		Tpl::output('log_list',$log_list);
		//左侧菜单
		if(trim($_GET['from']) == 'lm'){
			setlogleftmenu('userloglist');
		}else{
			$this->setleftmenu('userloglist');
		}
		Tpl::showpage('userloglist');
	}
	/*
	 * 左侧菜单
	 */
	private function setleftmenu($menu_key){
		$arr[0] = array('menu_name'=>Language::get('bp_user_staff'),	'linktype'=>'2');
		$arr[0]['submenu'][0] = array('menu_key'=>'departmentlist','menu_name'=>Language::get('bp_user_department_manage'),	'menu_act'=>'department','menu_op'=>'departmentlist','linktype'=>'0');
		$arr[0]['submenu'][1] = array('menu_key'=>'permissionlist','menu_name'=>Language::get('bp_user_permission_group'),	'menu_act'=>'permission','menu_op'=>'permissionlist','linktype'=>'0');
		$arr[0]['submenu'][2] = array('menu_key'=>'jobpostlist','menu_name'=>Language::get('bp_user_jobpost_manage'),	'menu_act'=>'jobpost','menu_op'=>'jobpostlist','linktype'=>'0');
		$arr[0]['submenu'][3] = array('menu_key'=>'userlist','menu_name'=>Language::get('bp_user_staff_manage'),	'menu_act'=>'user','menu_op'=>'userlist','linktype'=>'0');
		$arr[0]['submenu'][4] = array('menu_key'=>'userloglist','menu_name'=>Language::get('bp_user_staff_log'),	'menu_act'=>'user','menu_op'=>'userlog','linktype'=>'0');
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}