<?php
/**
 * 年度盘点功能
 * 
 * 
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class statinventoryControl extends BaseHomeControl{
	private $year;
	private $shopid;
	private $shopname;
	public function __construct(){
		parent::__construct();
		//年份
		$this->year = intval($_GET['year']);
		if($this->year <= 0){
			$this->year = date('Y',time());
		}
		Tpl::output('year',$this->year);
		//店铺ID
		if ($_SESSION['shop_id']){//如果员工负责某店铺
			$this->shopid = $_SESSION['shop_id'];
		}elseif (intval($_GET['shopid']) > 0){
			$this->shopid = intval($_GET['shopid']);
		}
		Tpl::output('shopid',$this->shopid);
		//从缓存中调取店铺信息
		$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
		if(!empty($shop_list)){
			foreach($shop_list as $k=>$v){
				if($v['shop_isuse'] == 0){
					unset($shop_list[$k]);
				}
			}
		}
		Tpl::output('shop_list',$shop_list);
		//店铺名称
		$cshopid = $this->shopid;
		$this->shopname = $shop_list[$cshopid]['shop_name'];
		Tpl::output('shopname',$this->shopname);
		Language::read('statdetail');
	}
	/*
	 * 全年汇总
	 */
	public function stati_summaryOp(){
		$model = Model();
		$timequantum = gettimequantum($this->year,$this->shopid);
		if (cPermission('statinventory','stati_customer')){//允许查看会员统计
			//年新增会员数
			$where = array();
			$where['cc_isdel'] = 0;
			if($this->shopid > 0){
				$where['shop_id'] = $this->shopid;
			}
			$where['cc_addtime'] = array('lt',$timequantum['etime']);
			$customerstat = $model->table('customer')->field("count(*) as customernum,sum(IF(cc_addtime > {$timequantum['stime']},1,0)) as newcustomernum")->where($where)->find();
			unset($where);
		}
		if (cPermission('statinventory','stati_team')){//允许查看团队评估
			//现有员工数
			$where = array();
			$where['user_state'] = array('neq',2);
			$model = Model();
			//查询岗位信息
			$jobpost_info = $model->table('jobpost')->where(array('jp_id'=>$_SESSION['jp_id']))->find();
			//获得所有查询共有条件
			if($jobpost_info['jp_isleader'] == 1 || $_SESSION['member_id'] == 1){
				$tree_arr = ($t = F('department')) ? $t : H('department',true,'file');
				$d_idarr = array();
				//从缓存查询子部门
				$d_info = $tree_arr[$_SESSION['dp_id']];
				if (!empty($tree_arr[$_SESSION['dp_id']]['son'])){
					$d_idarr = explode(',',$tree_arr[$_SESSION['dp_id']]['son']);
				}
				$d_idarr[] = $_SESSION['dp_id'];
				$where['user_department'] = array('in',$d_idarr);
			}else{
				$where['user_id'] = $_SESSION['member_id'];
			}
			
			$where['user_addtime'] = array('lt',$timequantum['etime']);
			$userstat = $model->table('user')->field("count(*) as usercount,sum(IF(user_addtime > {$timequantum['stime']} and user_addtime < {$timequantum['etime']},1,0)) as newusercount")->where($where)->find();
			unset($where);
		}
		if (cPermission('statinventory','stati_sales')){//允许查看销售统计
			//年订单总金额、毛利、订单个数
			$where = array();
			$where['co_status'] = array('in',array(0,1,2));
			if ($this->shopid > 0){
				$where['shop_id'] = $this->shopid;
			}
			$where['co_code'] = array('exp','co_id in (select co_id from '.C('tablepre').'orders group by co_code)');
			$where['co_addtime'] = array(array('egt',"{$timequantum['stime']}"),array('elt',"{$timequantum['etime']}"),'and');
			$orderlist = $model->table('orders')->where($where)->select();
			unset($where);
			$orderstat = array('orderamount'=>0,'ordernum'=>0,'costamount'=>0);
			if(!empty($orderlist)){
				$orderidarr = array();
				foreach((array)$orderlist as $k=>$v){
					$orderstat['orderamount'] += $v['co_final_price'];
					$orderstat['costamount'] += $v['co_cost_price'];
					$orderstat['ordernum'] += 1;
					$orderidarr[] = $v['co_id'];
				}
				$orderstat['orderamount'] = ncPriceFormat($orderstat['orderamount']);
				$orderstat['profitamount'] = ncPriceFormat($orderstat['orderamount'] - $orderstat['costamount']);
				unset($where);
			}
		}
		Tpl::output('customerstat',$customerstat);
		Tpl::output('userstat',$userstat);
		Tpl::output('orderstat',$orderstat);
		//年
		$year_arr = getSystemYearArr();
		Tpl::output('year_arr',$year_arr);
		Tpl::output('currentyear',$this->year);
		Tpl::output('currentshopid',$this->shopid);
		Tpl::showpage('stati_summary');
	}
	/*
	 * 销售统计
	 */
	public function stati_salesOp(){
		if (!empty($_GET['type'])){
			$funname = "sales_".$_GET['type'];
			if (method_exists($this,$funname)){
				$this->$funname();
			}
		}else{
			$this->sales_saleroommtom();
		}
	}
	/*
	 * 月度销售额环比统计
	 */
	private function sales_saleroommtom(){
		$orderlist = $this->getmonthsaleroom($this->year);
		$statlist = array();
		$stat_json = '';
		if(!empty($orderlist)){
			$stat_data = array();
			for($i=1;$i<=12;$i++){
				$tmp = array();
				$upmonth_amount = $statlist[$i-1]['orderamount'];
				if(isset($orderlist[$i])){
					$tmp['orderamount'] = $orderlist[$i]['orderamount'];
				}else{
					$tmp['orderamount'] = 0;
				}
				//计算环比
				$tmp['mtomrate'] = getMtom($upmonth_amount,$tmp['orderamount']);
				$stat_data[] = array('value'=>$tmp['orderamount'],'label'=>$i.'月');
				$statlist[$i] = $tmp;
			}
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_month'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_amount'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_ahead_compare'));
				//data
				foreach ((array)$statlist as $k=>$v){
					$excel_data[$k][] = array('data'=>$k.Language::get('bp_month'));
					$excel_data[$k][] = array('format'=>'Number','data'=>$v['orderamount']);
					$excel_data[$k][] = array('data'=>(($t = $v['mtomrate']) == 0?'-':$t.'%'));
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet($this->shopname.$this->year.Language::get('bp_statdetail_yearmonth_saleamount_ahead_compare'));
				$excel_class->generateXML($this->shopname.$this->year.Language::get('bp_statdetail_yearmonth_saleamount_ahead_compare').date('Y-m-d H-i-s',time()));
				exit();
			}else {
				//得到统计图数据
				$stat_json = getStatData_Column2D($this->shopname.$this->year.Language::get('bp_statdetail_yearmonth_saleamount_ahead_compare'),Language::get('bp_statdetail_month_sale'),$stat_data);
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
		Tpl::output('stat_json',$stat_json);
		Tpl::output('statlist',$statlist);
		Tpl::output('caption',$this->shopname.$this->year.Language::get('bp_statdetail_yearmonth_saleamount_ahead_compare'));
		//左侧菜单
		$this->setleftmenu('saleroommtom');
		Tpl::showpage('stati_saleroom');
	}
	/*
	 * 月度销售额同比统计
	 */
	private function sales_saleroomytoy(){
		$orderlist = $this->getmonthsaleroom($this->year);
		$orderlist_yesteryear = $this->getmonthsaleroom($this->year-1);
		$statlist = array();
		$stat_json = '';
		if (!empty($orderlist)){
			$stat_data = array();
			for($i=1;$i<=12;$i++){
				$tmp = array();
				if(isset($orderlist[$i])){
					$tmp['orderamount'] = $orderlist[$i]['orderamount'];
				}else{
					$tmp['orderamount'] = 0;
				}
				if(isset($orderlist_yesteryear[$i]['orderamount'])){
					$tmp['orderamountyester'] = $orderlist_yesteryear[$i]['orderamount'];
				}else{
					$tmp['orderamountyester'] = 0;
				}
				$tmp['ytoyrate'] = getYtoy($tmp['orderamountyester'],$tmp['orderamount']);
				$stat_data[0][] = array('value'=>$tmp['orderamountyester']);
				$stat_data[1][] = array('value'=>$tmp['orderamount']);
				$stat_category[] = array('label'=>$i.Language::get('bp_month'));
				$statlist[$i] = $tmp;
			}
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_month'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_lastyear_amount'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_thisyear_amount'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_sametime_compare'));
				//data
				foreach ((array)$statlist as $k=>$v){
					$excel_data[$k][] = array('data'=>$k.Language::get('bp_month'));
					$excel_data[$k][] = array('format'=>'Number','data'=>$v['orderamountyester']);
					$excel_data[$k][] = array('format'=>'Number','data'=>$v['orderamount']);
					$excel_data[$k][] = array('data'=>(($t = $v['ytoyrate']) == 0?'-':$t.'%'));
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet($this->shopname.$this->year.Language::get('bp_statdetail_yearmonth_saleamount_sametime_compare'));
				$excel_class->generateXML($this->shopname.$this->year.Language::get('bp_statdetail_yearmonth_saleamount_sametime_compare').date('Y-m-d H-i-s',time()));
				exit();
			}else {
				$stat_json = getStatData_MSColumn2D($this->shopname.$this->year.Language::get('bp_statdetail_yearmonth_saleamount_sametime_compare'),$stat_category,$stat_data);
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
		Tpl::output('stat_json',$stat_json);
		Tpl::output('statlist',$statlist);
		Tpl::output('caption',$this->shopname.$this->year.Language::get('bp_statdetail_yearmonth_saleamount_sametime_compare'));
		//左侧菜单
		$this->setleftmenu('saleroomytoy');
		Tpl::showpage('stati_saleroomytoy');
	}
	/*
	 * 月度毛利润环比统计
	 */
	private function sales_profitmtom(){
		$orderlist = $this->getmonthsaleroom($this->year);
		$statlist = array();
		$stat_json = '';
		if(!empty($orderlist)){
			$stat_data = array();
			for($i=1;$i<=12;$i++){
				$tmp = array();
				$upmonth_profitamount = $statlist[$i-1]['orderprofitamount'];
				if(isset($orderlist[$i])){
					$tmp['orderprofitamount'] = $orderlist[$i]['orderprofitamount'];
				}else{
					$tmp['orderprofitamount'] = 0;
				}
				$tmp['mtomrate'] = getMtom($upmonth_profitamount,$tmp['orderprofitamount']);
				$stat_data[] = array('value'=>$tmp['orderprofitamount'],'label'=>$i.Language::get('bp_month'));
				$statlist[$i] = $tmp;
			}
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_month'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_all_profit'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_ahead_compare'));
				//data
				foreach ((array)$statlist as $k=>$v){
					$excel_data[$k][] = array('data'=>$k.Language::get('bp_month'));
					$excel_data[$k][] = array('format'=>'Number','data'=>$v['orderprofitamount']);
					$excel_data[$k][] = array('data'=>(($t = $v['mtomrate']) == 0?'-':$t.'%'));
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet($this->shopname.$this->year.Language::get('bp_statdetail_yearmonth_profit_ahead_compare'));
				$excel_class->generateXML($this->shopname.$this->year.Language::get('bp_statdetail_yearmonth_profit_ahead_compare').date('Y-m-d H-i-s',time()));
				exit();
			}else {
				$stat_json = getStatData_Column2D($this->shopname.$this->year.Language::get('bp_statdetail_yearmonth_profit_ahead_compare'),Language::get('bp_statdetail_month_profit'),$stat_data);
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
		Tpl::output('stat_json',$stat_json);
		Tpl::output('statlist',$statlist);
		Tpl::output('caption',$this->shopname.$this->year.Language::get('bp_statdetail_yearmonth_profit_ahead_compare'));
		//左侧菜单
		$this->setleftmenu('profitmtom');
		Tpl::showpage('stati_profitmtom');
	}
	/*
	 * 月度毛利润同比统计
	 */
	private function sales_profitytoy(){
		$orderlist = $this->getmonthsaleroom($this->year);
		$orderlist_yesteryear = $this->getmonthsaleroom($this->year-1);
		$statlist = array();
		$stat_json = '';
		if (!empty($orderlist)){
			$stat_data = array();
			for($i=1;$i<=12;$i++){
				$tmp = array();
				if(isset($orderlist[$i])){
					$tmp['orderprofitamount'] = $orderlist[$i]['orderprofitamount'];
				}else{
					$tmp['orderprofitamount'] = 0;
				}
				if(isset($orderlist_yesteryear[$i]['orderprofitamount'])){
					$tmp['orderprofitamountyester'] = $orderlist_yesteryear[$i]['orderprofitamount'];
				}else{
					$tmp['orderprofitamountyester'] = 0;
				}
				$tmp['ytoyrate'] = getYtoy($tmp['orderprofitamountyester'],$tmp['orderprofitamount']);
				$stat_data[0][] = array('value'=>$tmp['orderprofitamountyester']);
				$stat_data[1][] = array('value'=>$tmp['orderprofitamount']);
				$stat_category[] = array('label'=>$i.Language::get('bp_month'));
				$statlist[$i] = $tmp;
			}
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_month'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_lastyear_amount'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_thisyear_amount'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_sametime_compare'));
				//data
				foreach ((array)$statlist as $k=>$v){
					$excel_data[$k][] = array('data'=>$k.Language::get('bp_month'));
					$excel_data[$k][] = array('format'=>'Number','data'=>$v['orderprofitamountyester']);
					$excel_data[$k][] = array('format'=>'Number','data'=>$v['orderprofitamount']);
					$excel_data[$k][] = array('data'=>(($t = $v['ytoyrate']) == 0?'-':$t.'%'));
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet($this->shopname.$this->year.Language::get('bp_statdetail_yearmonth_profit_sametime_compare'));
				$excel_class->generateXML($this->shopname.$this->year.Language::get('bp_statdetail_yearmonth_profit_sametime_compare').date('Y-m-d H-i-s',time()));
				exit();
			}else {
				$stat_json = getStatData_MSColumn2D($this->shopname.$this->year.Language::get('bp_statdetail_yearmonth_profit_sametime_compare'),$stat_category,$stat_data);
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
		Tpl::output('stat_json',$stat_json);
		Tpl::output('statlist',$statlist);
		Tpl::output('caption',$this->shopname.$this->year.Language::get('bp_statdetail_yearmonth_profit_sametime_compare'));
		//左侧菜单
		$this->setleftmenu('profitytoy');
		Tpl::showpage('stati_profitytoy');
	}
	/*
	 * 获得某年月销售额统计
	 */
	private function getmonthsaleroom($year){
		$model = Model();
		$timequantum = gettimequantum($year);
		$where = array();
		$where['co_status'] = array('in',array(0,1,2));
		if ($this->shopid > 0){
			$where['shop_id'] = $this->shopid;
		}
		$where['co_addtime'] = array(array('egt',"{$timequantum['stime']}"),array('elt',"{$timequantum['etime']}"),'and');
		$where['co_code'] = array('exp','co_id in (select co_id from '.C('tablepre').'orders group by co_code)');
		$orderlist = $model->table('orders')->field('MONTH(FROM_UNIXTIME(co_addtime)) as monthval,sum(co_final_price) as orderamount,sum(co_final_price-co_cost_price) as orderprofitamount')->where($where)->group('monthval')->select();
		$orderlistnew = array();
		if(!empty($orderlist)){
			foreach((array)$orderlist as $k=>$v){
				$v['orderamount'] = ncPriceFormat($v['orderamount']);
				$v['orderprofitamount'] = ncPriceFormat($v['orderprofitamount']);
				$orderlistnew[$v['monthval']] = $v;
			}
		}
		return $orderlistnew;
	}
	/*
	 * 商品统计
	 */
	public function stati_productOp(){
		if (!empty($_GET['type'])){
			$funname = "product_".$_GET['type'];
			if (method_exists($this,$funname)){
				$this->$funname();
			}
		}else{
			$this->product_numtop();
		}
	}
	/**
	 * 商品销量前20名
	 */
	private function product_numtop(){
		$this->getproductstat('num','top');
	}
	/*
	 * 商品销量后20名
	 */
	private function product_numlower(){
		$this->getproductstat('num','lower');
	}
	/**
	 * 商品销售额前20名
	 */
	private function product_amounttop(){
		$this->getproductstat('amount','top');
	}
	/*
	 * 商品销售额后20名
	 */
	private function product_amountlower(){
		$this->getproductstat('amount','lower');
	}
	/**
	 * 商品毛利润前20名
	 */
	private function product_profittop(){
		$this->getproductstat('profit','top');
	}
	/*
	 * 商品毛利润后20名
	 */
	private function product_profitlower(){
		$this->getproductstat('profit','lower');
	}
	/*
	 * $type 为查询数据类型包括销量(num)，销售额(amount)，毛利润(profit)
	 * $order 为查询数据排序方式包含top，lower
	 */
	private function getproductstat($type,$order){
		$productlist = $this->getyearproduct($this->year,$type.$order);
		$stat_json = '';
		$caption = '';
		$type_desc = '';
		switch ($type){
			case 'num':
				$type_desc = Language::get('bp_statdetail_product_salenum');
				$dataformat = 'integer';
				break;
			case 'amount':
				$type_desc = Language::get('bp_statdetail_product_sale');
				$dataformat = 'money';
				break;
			case 'profit':
				$type_desc = Language::get('bp_statdetail_product_profit');
				$dataformat = 'money';
				break;
		}
		if ($order == 'top'){
			$caption = $this->shopname.$this->year.Language::get('bp_year').$type_desc.Language::get('bp_statdetail_top20');
		}else{
			$caption = $this->shopname.$this->year.Language::get('bp_year').$type_desc.Language::get('bp_statdetail_last20');
		}
		if(!empty($productlist)){
			$stat_data = array();
			$productlistnew = array();
			foreach ((array)$productlist as $k=>$v){
				$stat_data[] = array('value'=>$v[$type],'label'=>str_cut($v['cp_name'],24,'...'));
				$v['statvalue'] = $v[$type];
				$productlistnew[] = $v;
			}
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_sort'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_product_name'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>$type_desc);
				//data
				foreach ((array)$productlistnew as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$v['order']);
					$tmp[] = array('data'=>$v['cp_name']);
					$tmp[] = array('format'=>'Number','data'=>$v['statvalue']);
					$excel_data[] = $tmp;
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet($caption);
				$excel_class->generateXML($caption.date('Y-m-d H-i-s',time()));
				exit();
			}else {
				$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data,$dataformat);
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
		Tpl::output('stat_json',$stat_json);
		Tpl::output('productlist',$productlistnew);
		Tpl::output('type',$type);
		Tpl::output('type_desc',$type_desc);
		Tpl::output('caption',$caption);
		//左侧菜单
		$this->setleftmenu('product'.$type.$order);
		Tpl::showpage('stati_productstat');
	}
	/*
	 * 获得某年商品统计
	 */
	private function getyearproduct($year,$type){
		$model = Model();
		$where = array();
		$where['co_status'] = array('in',array(0,1,2));
		if ($this->shopid > 0){
			$where['shop_id'] = $this->shopid;
		}
		$timequantum = gettimequantum($year);
		$where['co_addtime'] = array(array('egt',"{$timequantum['stime']}"),array('elt',"{$timequantum['etime']}"),'and');
		$field = 'cp_id';
		switch ($type){
			case 'numtop':
				$field .=",sum(cop_pnum) as num";
				$orderby = 'num desc';
				break;
			case 'numlower':
				$field .=",sum(cop_pnum) as num";
				$orderby = 'num asc';
				break;
			case 'amounttop':
				$field .=",sum(order_product.cop_total_price) as amount";
				$orderby = 'amount desc';
				break;
			case 'amountlower':
				$field .=",sum(order_product.cop_total_price) as amount";
				$orderby = 'amount asc';
				break;
			case 'profittop':
				$field .=",sum(order_product.cop_total_price - cp_cost*cop_pnum) as profit";
				$orderby = 'profit desc';
				break;
			case 'profitlower':
				$field .=",sum(order_product.cop_total_price - cp_cost*cop_pnum) as profit";
				$orderby = 'profit asc';
				break;
			default:
				$field .=",sum(cop_pnum) as num,sum(order_product.cop_total_price) as amount,sum(order_product.cop_total_price - cp_cost*cop_pnum) as profit";
				$orderby = 'num desc';
				break;
		}
		$on = 'order_product.co_id=orders.co_id';
		$orderproductlist = $model->table('order_product,orders')->field($field)->join('left')->on($on)->where($where)->group('cp_id')->order($orderby)->limit(20)->select();
		$orderproductlistnew = array();
		if(!empty($orderproductlist)){
			$i=1;
			foreach((array)$orderproductlist as $k=>$v){
				$v['amount'] = ncPriceFormat($v['amount']);
				$v['profit'] = ncPriceFormat($v['profit']);
				$v['order'] = $i;
				$i++;
				$orderproductlistnew[$v['cp_id']] = $v;
			}
			//查询商品详细信息
			$productlist = $model->table('product')->where(array('cp_id'=>array('in',array_keys($orderproductlistnew))))->select();
			if (!empty($productlist)){
				foreach ((array)$productlist as $k=>$v){
					$orderproductlistnew[$v['cp_id']]['cp_name'] = $v['cp_name'];
					$orderproductlistnew[$v['cp_id']]['cp_mallurl'] = $v['cp_mallurl'];
				}
			}
		}
		return $orderproductlistnew;
	}
	/**
	 * 会员统计
	 */
	public function stati_customerOp(){
		if (!empty($_GET['type'])){
			$funname = "customer_".$_GET['type'];
			if (method_exists($this,$funname)){
				$this->$funname();
			}
		}else{
			$this->customer_newnum();
		}
	}
	/*
	 * 月度新增会员统计
	 */
	private function customer_newnum(){
		$model = Model('statistics');
		$customerlist = $model->getMonthNewCustomer($this->year,$this->shopid);
		$stat_data = array();
		$customerlist_new = array();
		$countnum = 0;
		$stat_json = '';
		if (!empty($customerlist)){
			$stat_data = array();
			foreach ((array)$customerlist as $k=>$v){
				$customerlist_new[$v['monthval']] = $v['num'];
				$countnum += intval($v['num']);
				$stat_data[$v['monthval']-1] = array('value'=>$v['num'],'label'=>$v['monthval'].'月');
			}
			for($i=1;$i<=12;$i++){
				if (!isset($customerlist_new[$i])){
					$customerlist_new[$i] = 0;
					$stat_data[$i-1] = array('value'=>0,'label'=>$i.'月');
				}
			}
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_month'));
				for ($i=1;$i<=12;$i++){
					$excel_data[0][] = array('styleid'=>'s_title','data'=>$i.Language::get('bp_month'));
				}
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_sum'));
				//data
				$excel_data[1][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_num'));
				for($i=1;$i<=12;$i++){
					$excel_data[1][] = array('format'=>'Number','data'=>$customerlist_new[$i]);
				}
				$excel_data[1][] = array('format'=>'Number','data'=>$countnum);
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet($this->shopname.$this->year.Language::get('bp_statdetail_yearmonth_newadd_customer_stat'));
				$excel_class->generateXML($this->shopname.$this->year.Language::get('bp_statdetail_yearmonth_newadd_customer_stat').date('Y-m-d H-i-s',time()));
				exit();
			}else {
				ksort($stat_data);  			
  				$stat_json = getStatData_Column2D($this->shopname.$this->year.Language::get('bp_statdetail_yearmonth_newadd_customer_stat'),Language::get('bp_statdetail_add_customer_num'),$stat_data,'integer');
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
		Tpl::output('stat_json',$stat_json);
		Tpl::output('countnum',$countnum);
		Tpl::output('customerlist',$customerlist_new);
		Tpl::output('caption',$this->shopname.$this->year.Language::get('bp_statdetail_yearmonth_newadd_customer_stat'));
		//左侧菜单
		$this->setleftmenu('customernewnum');
		Tpl::showpage('stati_customernew');
	}
	/*
	 * 会员前20名（销售额）
	 */
	private function customer_amounttop(){
		$this->getyearcustomersalesstatshowdata('amount','top');
	}
	/*
	 * 会员前20名（毛利润）
	 */
	private function customer_profittop(){
		$this->getyearcustomersalesstatshowdata('profit','top');
	}
	/**
	 * 获得某年会员销售统计展示数据
	 *
	 * @param unknown_type $year
	 * @param unknown_type $type
	 * @param unknown_type $order
	 */
	private function getyearcustomersalesstatshowdata($type,$order){
		$customerlist = $this->getyearcustomersalesstat($this->year,$type,$order);
		$stat_json = '';
		$caption = '';
		$type_desc = '';
		switch ($type){
			case 'amount':
				$type_desc = Language::get('bp_statdetail_sale_amount_s');
				break;
			case 'profit':
				$type_desc = Language::get('bp_statdetail_sale_profit_s');
				break;
		}
		if ($order == 'top'){
			$caption = $this->shopname.$this->year.Language::get('bp_statdetail_year_customer_top20').$type_desc;
		}else{
			$caption = $this->shopname.$this->year.Language::get('bp_statdetail_year_customer_last20').$type_desc;
		}
		$customerlistnew = array();
		if(!empty($customerlist)){
			$stat_data = array();
			foreach ((array)$customerlist as $k=>$v){
				$stat_data[] = array('value'=>$v[$type],'label'=>$v['cc_name']);
				$v['statvalue'] = $v[$type];
				$customerlistnew[] = $v;
			}
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_sort'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_customer_name'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>$type_desc);
				//data
				foreach ((array)$customerlistnew as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$v['order']);
					$tmp[] = array('data'=>$v['cc_name']);
					$tmp[] = array('format'=>'Number','data'=>$v['statvalue']);
					$excel_data[] = $tmp;
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet($caption);
				$excel_class->generateXML($caption.date('Y-m-d H-i-s',time()));
				exit();
			}else {
  				$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data);
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
		Tpl::output('stat_json',$stat_json);
		Tpl::output('customerlist',$customerlistnew);
		Tpl::output('type_desc',$type_desc);
		Tpl::output('caption',$caption);
		//左侧菜单
		$this->setleftmenu('customer'.$type.$order);
		Tpl::showpage('stati_customerstat');
	}
	/**
	 * 获得某年会员销售统计数据
	 * $year 为统计的年份
	 * $type 为查询数据类型包括销量(num)，销售额(amount)，毛利润(profit)
	 * $order 为查询数据排序方式包含top，lower
	 */
	private function getyearcustomersalesstat($year,$type,$order){
		$model = Model();
		$where = array();
		$where['co_status'] = array('in',array(0,1,2));
		if($this->shopid > 0){
			$where['orders.shop_id'] = $this->shopid;
		}
		$timequantum = gettimequantum($year);
		$where['co_addtime'] = array(array('egt',"{$timequantum['stime']}"),array('elt',"{$timequantum['etime']}"),'and');
		$where['co_code'] = array('exp','co_id in (select co_id from '.C('tablepre').'orders group by co_code)');		
		$field = 'orders.cc_id,customer.cc_name';
		switch ($type){
			case 'amount':
				$field .=",sum(co_final_price) as amount";
				$orderby = 'amount';
				break;
			case 'profit':
				$field .=",sum(co_final_price - co_cost_price) as profit";
				$orderby = 'profit';
				break;
			default:
				$field .=",sum(co_final_price) as amount,sum(co_final_price - co_cost_price) as profit";
				$orderby = 'amount';
				break;
		}
		if ($order == 'lower'){
			$orderby .= ' asc';
		}else {
			$orderby .= ' desc';
		}
		$on = 'orders.cc_id=customer.cc_id';
		$ordercustomerlist = $model->table('orders,customer')->field($field)->join('left')->on($on)->where($where)->group('orders.cc_id')->order($orderby)->limit(20)->select();
		$ordercustomerlistnew = array();
		if(!empty($ordercustomerlist)){
			$i=1;
			foreach((array)$ordercustomerlist as $k=>$v){
				$v['amount'] = ncPriceFormat($v['amount']);
				$v['profit'] = ncPriceFormat($v['profit']);
				$v['order'] = $i;
				$i++;
				$ordercustomerlistnew[$v['cc_id']] = $v;
			}
		}
		return $ordercustomerlistnew;
	}
	/**
	 * 会员区域分布
	 */
	private function customer_area(){
		$model = Model();
		$where = array();
		$where['cc_isdel'] = 0;
		if($this->shopid > 0){
			$where['shop_id'] = $this->shopid;
		}
		$timequantum = gettimequantum($this->year);
		$where['cc_addtime'] = array(array('lt',$timequantum['etime']));
		$customerlist = $model->table('customer')->field('cc_province,count(*) as num')->where($where)->group('cc_province')->select();
		$customerlist_new = array();
		$stat_json = '';
		$caption = $this->shopname.$this->year.Language::get('bp_statdetail_year_customer_area_distribution');
		if (!empty($customerlist)){
			foreach ((array)$customerlist as $k=>$v){
				if (empty($v['cc_province'])){
					$k_new = Language::get('bp_statdetail_other');
				}else {
					$k_new = $v['cc_province'];
				}
				$customerlist_new[$k_new]['countnum'] += intval($v['num']);				
			}
			if (!empty($customerlist_new)){
				//构造颜色数组
				$color_arr = getColorArr(50);
				$i = 0;
				foreach ((array)$customerlist_new as $k=>$v){
					$stat_data[] = array("color"=>$color_arr[$i],"label"=>$k,"value"=>$customerlist_new[$k]['countnum']);
					$i++;
				}
			}
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_area'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_num'));
				//data
				foreach ((array)$customerlist_new as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$k);
					$tmp[] = array('format'=>'Number','data'=>($v['countnum']>0?$v['countnum']:0));
					$excel_data[] = $tmp;
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet($caption);
				$excel_class->generateXML($caption.date('Y-m-d H-i-s',time()));
				exit();
			}else {
	  			$stat_json = getStatData_Pie2D($caption,$stat_data);
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
  		Tpl::output('stat_json',$stat_json);
		Tpl::output('customerlist',$customerlist_new);
		Tpl::output('caption',$caption);
		//左侧菜单
		$this->setleftmenu('customerarea');
		Tpl::showpage('stati_customerarea');
	}
	/*
	 * 左侧菜单
	 */
	private function setleftmenu($menu_key=''){
		$arr = array();
		//两级菜单
		$arr[0] = array('menu_name'=>Language::get('bp_statdetail_sale_stat'),	'linktype'=>'2');
		$arr[0]['submenu'][0] = array('menu_key'=>'saleroommtom','menu_name'=>Language::get('bp_statdetail_month_sale_ahead_compare'),'menu_act'=>'statinventory','menu_op'=>'stati_sales','menu_url'=>'index.php?act=statinventory&op=stati_sales&type=saleroommtom&year='.$this->year.'&shopid='.$this->shopid,'linktype'=>'0');
		$arr[0]['submenu'][1] = array('menu_key'=>'saleroomytoy','menu_name'=>Language::get('bp_statdetail_month_sale_sametime_compare'),'menu_act'=>'statinventory','menu_op'=>'stati_sales','menu_url'=>'index.php?act=statinventory&op=stati_sales&type=saleroomytoy&year='.$this->year.'&shopid='.$this->shopid,'linktype'=>'0');
		$arr[0]['submenu'][2] = array('menu_key'=>'profitmtom','menu_name'=>Language::get('bp_statdetail_month_profit_ahead_compare'),'menu_act'=>'statinventory','menu_op'=>'stati_sales','menu_url'=>'index.php?act=statinventory&op=stati_sales&type=profitmtom&year='.$this->year.'&shopid='.$this->shopid,'linktype'=>'0');
		$arr[0]['submenu'][3] = array('menu_key'=>'profitytoy','menu_name'=>Language::get('bp_statdetail_month_profit_sametime_compare'),'menu_act'=>'statinventory','menu_op'=>'stati_sales','menu_url'=>'index.php?act=statinventory&op=stati_sales&type=profitytoy&year='.$this->year.'&shopid='.$this->shopid,'linktype'=>'0');
		
		$arr[2] = array('menu_name'=>Language::get('bp_statdetail_product_stat'),	'linktype'=>'2');
		$arr[2]['submenu'][0] = array('menu_key'=>'productnumtop','menu_name'=>Language::get('bp_statdetail_product_salenum_top20'),'menu_act'=>'statinventory','menu_op'=>'stati_product','menu_url'=>'index.php?act=statinventory&op=stati_product&type=numtop&year='.$this->year.'&shopid='.$this->shopid,'linktype'=>'0');
		$arr[2]['submenu'][1] = array('menu_key'=>'productnumlower','menu_name'=>Language::get('bp_statdetail_product_salenum_last20'),'menu_act'=>'statinventory','menu_op'=>'stati_product','menu_url'=>'index.php?act=statinventory&op=stati_product&type=numlower&year='.$this->year.'&shopid='.$this->shopid,'linktype'=>'0');
		$arr[2]['submenu'][2] = array('menu_key'=>'productamounttop','menu_name'=>Language::get('bp_statdetail_product_sale_top20'),'menu_act'=>'statinventory','menu_op'=>'stati_product','menu_url'=>'index.php?act=statinventory&op=stati_product&type=amounttop&year='.$this->year.'&shopid='.$this->shopid,'linktype'=>'0');
		$arr[2]['submenu'][3] = array('menu_key'=>'productamountlower','menu_name'=>Language::get('bp_statdetail_product_sale_last20'),'menu_act'=>'statinventory','menu_op'=>'stati_product','menu_url'=>'index.php?act=statinventory&op=stati_product&type=amountlower&year='.$this->year.'&shopid='.$this->shopid,'linktype'=>'0');
		$arr[2]['submenu'][4] = array('menu_key'=>'productprofittop','menu_name'=>Language::get('bp_statdetail_product_profit_top20'),'menu_act'=>'statinventory','menu_op'=>'stati_product','menu_url'=>'index.php?act=statinventory&op=stati_product&type=profittop&year='.$this->year.'&shopid='.$this->shopid,'linktype'=>'0');
		$arr[2]['submenu'][5] = array('menu_key'=>'productprofitlower','menu_name'=>Language::get('bp_statdetail_product_profit_last20'),'menu_act'=>'statinventory','menu_op'=>'stati_product','menu_url'=>'index.php?act=statinventory&op=stati_product&type=profitlower&year='.$this->year.'&shopid='.$this->shopid,'linktype'=>'0');
		
		$arr[3] = array('menu_name'=>Language::get('bp_statdetail_customer_stat'),	'linktype'=>'2');
		$arr[3]['submenu'][0] = array('menu_key'=>'customernewnum','menu_name'=>Language::get('bp_statdetail_customer_month_add_stat'),'menu_act'=>'statinventory','menu_op'=>'stati_customer','menu_url'=>'index.php?act=statinventory&op=stati_customer&type=newnum&year='.$this->year.'&shopid='.$this->shopid,'linktype'=>'0');
		$arr[3]['submenu'][1] = array('menu_key'=>'customeramounttop','menu_name'=>Language::get('bp_statdetail_customer_sale_top20'),'menu_act'=>'statinventory','menu_op'=>'stati_customer','menu_url'=>'index.php?act=statinventory&op=stati_customer&type=amounttop&year='.$this->year.'&shopid='.$this->shopid,'linktype'=>'0');
		$arr[3]['submenu'][2] = array('menu_key'=>'customerprofittop','menu_name'=>Language::get('bp_statdetail_customer_profit_top20'),'menu_act'=>'statinventory','menu_op'=>'stati_customer','menu_url'=>'index.php?act=statinventory&op=stati_customer&type=profittop&year='.$this->year.'&shopid='.$this->shopid,'linktype'=>'0');
		$arr[3]['submenu'][3] = array('menu_key'=>'customerarea','menu_name'=>Language::get('bp_statdetail_customer_area_distribution'),'menu_act'=>'statinventory','menu_op'=>'stati_customer','menu_url'=>'index.php?act=statinventory&op=stati_customer&type=area&year='.$this->year.'&shopid='.$this->shopid,'linktype'=>'0');

		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}