<?php
/**
 * 员工销售统计功能
 * 
 * 
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class stathistoryControl extends BaseHomeControl{
	private $commonwhere=array();
	public function __construct(){
		parent::__construct();
		$model = Model();
		//查询岗位信息
		$jobpost_info = $model->table('jobpost')->where(array('jp_id'=>$_SESSION['jp_id']))->find();
		//获得所有查询共有条件
		if($jobpost_info['jp_isleader'] == 1 || $_SESSION['member_id'] == 1){
			$tree_arr = ($t = F('department')) ? $t : H('department',true,'file');
			$d_idarr = array();
			//从缓存查询子部门
			$d_info = $tree_arr[$_SESSION['dp_id']];
			if (!empty($tree_arr[$_SESSION['dp_id']]['son'])){
				$d_idarr = explode(',',$tree_arr[$_SESSION['dp_id']]['son']);
			}
			$d_idarr[] = $_SESSION['dp_id'];
			$this->commonwhere['status_departmentid'] = array('in',$d_idarr);
		}else{
			$this->commonwhere['status_userid'] = $_SESSION['member_id'];
		}
		Language::read('stathistory');
	}
	/**
	 * 员工月销售统计
	 */
	public function statusersalesop(){
		if (!empty($_GET['type'])){
			$funname = "statusersales_".$_GET['type'];
			if (method_exists($this,$funname)){
				$this->$funname();
			}
		}else {
			//员工月销售统计列表
			$this->statusersales_list();
		}
	}
	/*
	 * 员工月销售统计列表
	 */
	public function statusersales_list(){
		$model = Model('department');
		//获得所有查询共有条件
		$where = array();
		//添加自定义搜索条件
		if ($_GET['search_did'] && isset($this->commonwhere['status_departmentid'])){
			$did = intval($_GET['search_did']);
			$tree_arr = ($t = F('department')) ? $t : H('department',true,'file');
			$d_idarr = array();
			//从缓存查询子部门
			$d_info = $tree_arr[$did];
			if (!empty($tree_arr[$did]['son'])){
				$d_idarr = explode(',',$tree_arr[$did]['son']);
			}
			$d_idarr[] = $did;
			//将数据权限的数组与搜索的部门数组取与
			if (!empty($this->commonwhere['status_departmentid'][1])){
				$d_idarr = array_intersect($d_idarr,$this->commonwhere['status_departmentid'][1]);
			}
			$where['status_departmentid'] = array('in',$d_idarr);
		}
		if (!empty($_GET['search_content'])){
			switch ($_GET['search_type']){
				case 'unumbers':
					$where['status_usernumbers'] = array('like',"%{$_GET['search_content']}%");
					break;
				case 'truename':
					$where['status_usertruename'] = array('like',"%{$_GET['search_content']}%");
					break;
			}
		}
		if ($_GET['search_syear'] && $_GET['search_smonth']){
			$where['status_stattime'] = array('exp',"YEAR(FROM_UNIXTIME(status_stattime)) = {$_GET['search_syear']} and MONTH(FROM_UNIXTIME(status_stattime)) = {$_GET['search_smonth']}");
		}else {
			$cur_year = date('Y',time());
			$cur_month = date('m',time());
			$where['status_stattime'] = array('exp',"YEAR(FROM_UNIXTIME(status_stattime)) = {$cur_year} and MONTH(FROM_UNIXTIME(status_stattime)) = {$cur_month}");
		}
		$statlist = $model->table('statusersales')->where($where)->order('status_addtime desc')->page(10)->select();
		Tpl::output('statlist',$statlist);
		//员工缓存
		$usercache = ($t = F('user')) ? $t : H('user',true,'file');
		Tpl::output('usercache',$usercache);
		//左侧菜单
		$this->setleftmenu('statusersales');
		Tpl::output('show_page',$model->showpage(2));
		$year_arr = getSystemYearArr();
		Tpl::output('year_arr',$year_arr);
		$month_arr = getSystemMonthArr();
		Tpl::output('month_arr',$month_arr);
		//输出部门select
		//查询岗位信息
		$jobpost_info = $model->table('jobpost')->where(array('jp_id'=>$_SESSION['jp_id']))->find();
		//获得所有查询共有条件
		if($jobpost_info['jp_isleader'] == 1 || $_SESSION['member_id'] == 1){
			$start_id = 0;
			$selecthtml = $model->getDepartmentCacheSelect(false,intval($_GET['search_did']),'',$_SESSION['dp_id']);
		}
		Tpl::output('selecthtml',$selecthtml);
		Tpl::showpage('stat_usersaleslist');
	}
	/*
	 * 员工月销售统计
	 */
	public function statusersales_add(){
		$model = Model('department');		
		if (chksubmit()){
			set_time_limit(0);
			if(empty($_POST['search_syear']) || empty($_POST['search_smonth'])){
				showDialog(Language::get('bp_stat_pls_choose_stattime'),'','error');
			}
			$stime = strtotime($_POST['search_syear'].'-'.$_POST['search_smonth'].'-01');
			$time_arr = getmonthtimequantum($stime);
			$etime = $time_arr['etime'];
			if($stime < 0 || $etime < 0){
				showDialog(Language::get('bp_stat_pls_choose_stattime'),'','error');
			}
			//获得所有查询共有条件
			$where = array();
			//添加自定义搜索条件
			if ($_POST['search_did']){
				$did = intval($_POST['search_did']);
				$tree_arr = ($t = F('department')) ? $t : H('department',true,'file');
				$d_idarr = array();
				//从缓存查询子部门
				$d_info = $tree_arr[$did];
				if (!empty($tree_arr[$did]['son'])){
					$d_idarr = explode(',',$tree_arr[$did]['son']);
				}
				$d_idarr[] = $did;
				$where['user_department'] = array('in',$d_idarr);
			}
			$on = 'orders.co_staff_id = user.user_id';
			$field = " user_id,user_numbers,user_truename,user_department,user_jobpost,sum(co_final_price) as statamount,sum(co_final_price - co_cost_price) as statprofity ";
			//搜索条件
			$where['co_status'] = 1;//订单“交易完成”
			$where['co_statuschangetime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
			$where['co_code'] = array('exp','co_id in (select co_id from '.C('tablepre').'orders group by co_code)');
			$statlist = $model->table('orders,user')->field($field)->join('inner')->on($on)->where($where)->group('user_id')->select();
			//删除旧的统计记录
			$where_del = array();
			if(isset($where['user_department'])){
				$where_del['status_departmentid'] = $where['user_department'];
			}
			$where_del['status_stattime'] = $stime;
			$model->table('statusersales')->where($where_del)->delete();
			if(!empty($statlist)){
				$i = 0;
				foreach($statlist as $k=>$v){
					$infotmp = array();
					$infotmp['status_userid'] = $v['user_id'];
					$infotmp['status_usernumbers'] = $v['user_numbers'];
					$infotmp['status_usertruename'] = $v['user_truename'];
					$infotmp['status_departmentid'] = $v['user_department'];
					$infotmp['status_jobpostid'] = $v['user_jobpost'];
					$infotmp['status_stattime'] = $stime;
					$infotmp['status_amount'] = $v['statamount'];
					$infotmp['status_profity'] = $v['statprofity'];
					$infotmp['status_addtime'] = time();
					$tmp = intval($i/100);
					$infoinsert_arr[$tmp][] = $infotmp;
					$i++;
				}
				//每100条重新执行一次sql
				foreach ((array)$infoinsert_arr as $k=>$v){
					$model->table('statusersales')->insertAll($v);
				}
			}
			showDialog(Language::get('bp_stat_finish'),'index.php?act=stathistory&op=statusersales','succ');
		}else{
			$year_arr = getSystemYearArr();
			Tpl::output('year_arr',$year_arr);
			$month_arr = getSystemMonthArr();
			Tpl::output('month_arr',$month_arr);
			//输出部门select
			$model = Model('department');
			$selecthtml = $model->getDepartmentCacheSelect(false,intval($_GET['search_did']),'',0);
			Tpl::output('selecthtml',$selecthtml);
			//左侧菜单
			$this->setleftmenu('statusersales');
			Tpl::showpage('stat_usersalesadd');
		}
	}
	/*
	 * 左侧菜单
	 */
	private function setleftmenu($menu_key){
		$arr[0] = array('menu_name'=>Language::get('bp_stat_history'),'linktype'=>'2');
		$arr[0]['submenu'][0] = array('menu_key'=>'statusersales','menu_name'=>Language::get('bp_stat_staff_month_sale_analysis'),'menu_act'=>'stathistory','menu_op'=>'statusersales','linktype'=>'0');
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}