<?php
/**
 * 统计图表功能
 * 
 * 
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class statdetail_userControl extends statdetailControl{
	private $commonwhere=array();
	public function __construct(){
		parent::__construct();
		$model = Model();
		//查询岗位信息
		$jobpost_info = $model->table('jobpost')->where(array('jp_id'=>$_SESSION['jp_id']))->find();
		//获得所有查询共有条件
		if($jobpost_info['jp_isleader'] == 1 || $_SESSION['member_id'] == 1){
			$tree_arr = ($t = F('department')) ? $t : H('department',true,'file');
			$d_idarr = array();
			//从缓存查询子部门
			$d_info = $tree_arr[$_SESSION['dp_id']];
			if (!empty($tree_arr[$_SESSION['dp_id']]['son'])){
				$d_idarr = explode(',',$tree_arr[$_SESSION['dp_id']]['son']);
			}
			$d_idarr[] = $_SESSION['dp_id'];
			$this->commonwhere['user_department'] = array('in',$d_idarr);
		}else{
			$this->commonwhere['user_id'] = $_SESSION['member_id'];
		}
		Language::read('user');
	}
	/*
	 * 员工状态分布
	 */
	public function statuser_state(){
		$this->typestat('state');
	}
	/*
	 * 员工学历分布
	 */
	public function statuser_education(){
		$this->typestat('education');
	}
	/*
	 * 员工性别分布
	 */
	public function statuser_sex(){
		$this->typestat('sex');
	}
	/*
	 * 员工固定类型统计
	 */
	private function typestat($stattype){
		$model = Model();
		$where = $this->commonwhere;
		//添加时间搜索
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime > 0 && $etime>0){
			$where['uex_entrytime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($stime > 0){
			$where['uex_entrytime'] = array('egt',"$stime");
		}elseif($etime>0){
			$where['uex_entrytime'] = array('elt',"$etime");
		}
		$dataformat = 'integer';
		$type_desc = Language::get('bp_statdetail_num');
		$field ='count(*) as num';
		switch($stattype){
			case 'education':
				$field .=',uex_education as stattext';
				$caption = Language::get('bp_statdetail_staff_education_distribution');
				$tableheader = array('typetitle'=>Language::get('bp_user_education'),'valuetitle'=>Language::get('bp_statdetail_num'));
				$typetext_arr = array(0=>Language::get('bp_user_unknow'),1=>Language::get('bp_user_primary_school'),2=>Language::get('bp_user_middle_school'),3=>Language::get('bp_user_secondary_school'),4=>Language::get('bp_user_high_school'),5=>Language::get('bp_user_college'),6=>Language::get('bp_user_bachelor'),7=>Language::get('bp_user_master'),8=>Language::get('bp_user_doctor'),9=>Language::get('bp_user_others'));
				$where['user_state'] = array('neq',2);
				break;
			case 'state':
				$field .=',user_state as stattext';
				$caption = Language::get('bp_statdetail_staff_status_distribution');
				$tableheader = array('typetitle'=>Language::get('bp_statdetail_status'),'valuetitle'=>Language::get('bp_statdetail_num'));
				$typetext_arr = array(0=>Language::get('bp_user_onjob'),1=>Language::get('bp_user_stopjob'),2=>Language::get('bp_user_offjob'));
				break;
			case 'sex':
				$field .=',uex_sex as stattext';
				$caption = Language::get('bp_statdetail_staff_sex_distribution');
				$tableheader = array('typetitle'=>Language::get('bp_user_sex'),'valuetitle'=>Language::get('bp_statdetail_num'));
				$typetext_arr = array(0=>Language::get('bp_user_unknow'),1=>Language::get('bp_user_female'),2=>Language::get('bp_user_male'));
				$where['user_state'] = array('neq',2);
				break;
		}
		$statlist = $model->table('user,userextend')->field($field)->join('left')->on('user.user_id = userextend.uex_userid')->where($where)->group('stattext')->select();		
		$stat_json = '';
		if(!empty($statlist)){
			$statlist_new = array();
			foreach((array)$statlist as $k=>$v){
				if ($v['stattext']){
					$statlist_new[$v['stattext']] = $v;
				}else{
					$statlist_new[0] = $v;
				}
			}
			foreach ((array)$typetext_arr as $k=>$v){
				if (isset($statlist_new[$k])){
					$tmp['value'] = $statlist_new[$k]['num'];
				}else {
					$tmp['value'] = 0;
				}
				$tmp['text'] = $v;
				$statlist_new[$k] = $tmp;
				$stat_data[] = array('value'=>$tmp['value'],'label'=>$tmp['text']);
			}
			ksort($statlist_new);
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>$tableheader['typetitle']);
				$excel_data[0][] = array('styleid'=>'s_title','data'=>$tableheader['valuetitle']);
				//data
				foreach ((array)$statlist_new as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$v['text']);
					$tmp[] = array('format'=>'Number','data'=>$v['value']);
					$excel_data[] = $tmp;
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet($caption);
				$excel_class->generateXML($caption.date('Y-m-d H-i-s',time()));
				exit();
			}else {
				//得到统计图数据
				$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data,$dataformat);
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
		Tpl::output('stat_json',$stat_json);
		Tpl::output('statlist',$statlist_new);
		Tpl::output('caption',$caption);
		Tpl::output('type_desc',$type_desc);
		Tpl::output('tableheader',$tableheader);
		//左侧菜单
		parent::setleftmenu('user_'.$stattype);
		Tpl::showpage('statd_simple');
	}
	/*
	 * 员工地区分布
	 */
	public function statuser_area(){
		$model = Model();
		$where = $this->commonwhere;
		$where['user_state'] = array('neq',2);
		//搜索条件
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime > 0 && $etime>0){
			$where['uex_entrytime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($stime > 0){
			$where['uex_entrytime'] = array('egt',"$stime");
		}elseif($etime>0){
			$where['uex_entrytime'] = array('elt',"$etime");
		}		
		$field = ' uex_province as stattext,count(*) as statvalue ';
		$caption = Language::get('bp_statdetail_staff_area_distribution');
		$type_desc = Language::get('bp_statdetail_num');
		$on = 'user.user_id = userextend.uex_userid';
		$statlist = $model->table('user,userextend')->field($field)->join('left')->on($on)->where($where)->group('stattext')->select();
		$statlist_new = array();
		if(!empty($statlist)){
			//构造颜色数组
			$color_arr = getColorArr(50);
			$i = 0;
			foreach((array)$statlist as $k=>$v){
				if (empty($v['stattext'])){
					$k_new = Language::get('bp_user_others');
				}else {
					$k_new = $v['stattext'];
				}
				$statlist_new[$k_new]['value'] += ncPriceFormat($v['statvalue']);
			}
		}
		$stat_json = '';
		if (!empty($statlist_new)){
			//构造颜色数组
			$color_arr = getColorArr(50);
			$i = 0;
			foreach ((array)$statlist_new as $k=>$v){
				$stat_data[] = array("color"=>$color_arr[$i],"label"=>$k,"value"=>$v['value']);
				$i++;
			}
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_area'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>$type_desc);
				//data
				foreach ((array)$statlist_new as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$k);
					$tmp[] = array('format'=>'Number','data'=>($v['value']>0?$v['value']:0));
					$excel_data[] = $tmp;
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet($caption);
				$excel_class->generateXML($caption.date('Y-m-d H-i-s',time()));
				exit();
			}else {
				$stat_json = getStatData_Pie2D($caption,$stat_data);
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
  		Tpl::output('caption',$caption);
  		Tpl::output('type_desc',$type_desc);
  		Tpl::output('stat_json',$stat_json);
		Tpl::output('statlist',$statlist_new);
		//左侧菜单
		$this->setleftmenu('user_area');
		Tpl::showpage('statd_areastat');
	}
	/*
	 * 员工拥有机会数量前20名
	 */
	public function statuser_chancenumtop(){
		$this->statuserrelevantdata('chancenum','top');
	}
	/*
	 * 员工拥有机会数量后20名
	 */
	public function statuser_chancenumlower(){
		$this->statuserrelevantdata('chancenum','lower');
	}
	/*
	 * 员工行动历史数量前20名
	 */
	public function statuser_historynumtop(){
		$this->statuserrelevantdata('historynum','top');
	}
	/*
	 * 员工行动历史数量后20名
	 */
	public function statuser_historynumlower(){
		$this->statuserrelevantdata('historynum','lower');
	}
	/*
	 * 员工会员数统计
	 */
	private function statuserrelevantdata($stattype,$order){
		$model = Model();
		$where = $this->commonwhere;
		$where['user_state'] = array('neq',2);
		$field = ' user_truename as stattext,user_id';
		switch($stattype){
			case 'chancenum':
				$caption = Language::get('bp_statdetail_staff_own_chance_num');
				$type_desc = Language::get('bp_statdetail_num');
				$table = 'chance,user';
				$on = 'chance.cha_userid = user.user_id';
				$field .=",count(*) as statvalue ";
				$dataformat = 'integer';
				//搜索条件
				$stime = strtotime($_GET['search_stime']);
				$etime = strtotime($_GET['search_etime']);
				if ($stime > 0 && $etime>0){
					$where['cha_addtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
				}elseif($stime > 0){
					$where['cha_addtime'] = array('egt',"$stime");
				}elseif($etime>0){
					$where['cha_addtime'] = array('elt',"$etime");
				}
				$where['cha_istrash'] = 0;
				break;
			case 'historynum':
				$caption = Language::get('bp_statdetail_staff_action_history_num');
				$type_desc = Language::get('bp_statdetail_num');
				$table = 'customer_action,user';
				$on = 'customer_action.cca_excstaff = user.user_id';
				$field .=",count(*) as statvalue ";
				$dataformat = 'integer';
				//搜索条件
				$stime = strtotime($_GET['search_stime']);
				$etime = strtotime($_GET['search_etime']);
				if ($stime > 0 && $etime>0){
					$where['cca_addtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
				}elseif($stime > 0){
					$where['cca_addtime'] = array('egt',"$stime");
				}elseif($etime>0){
					$where['cca_addtime'] = array('elt',"$etime");
				}
				break;
		}
		if($order == 'top'){
			$ordertext = 'statvalue desc';
			$caption .= Language::get('bp_statdetail_top20');
		}else{
			$ordertext = 'statvalue asc';
			$caption .= Language::get('bp_statdetail_last20');
		}
		$statlist = $model->table($table)->field($field)->join('inner')->on($on)->where($where)->group('user_id')->order($ordertext)->select();
		$stat_json = '';
		if(!empty($statlist)){
			$i = 1;
			foreach((array)$statlist as $k=>$v){
				$tmp['text'] = $v['stattext'];
				if($dataformat == 'money'){
					$tmp['value'] = ncPriceFormat($v['statvalue']);
				}else{
					$tmp['value'] = $v['statvalue'];
				}
				$tmp['order'] = $i;
				$statlist_new[] = $tmp;
				$stat_data[] = array('value'=>$tmp['value'],'label'=>$tmp['text']);
				$i++;
			}
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_sort'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_user_staff'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>$type_desc);
				//data
				foreach ((array)$statlist_new as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$v['order']);
					$tmp[] = array('data'=>$v['text']);
					$tmp[] = array('format'=>'Number','data'=>$v['value']);
					$excel_data[] = $tmp;
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet($caption);
				$excel_class->generateXML($caption.date('Y-m-d H-i-s',time()));
				exit();
			}else {
				//得到统计图数据
				$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data,'integer');
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
		Tpl::output('stat_json',$stat_json);
		Tpl::output('statlist',$statlist_new);
		Tpl::output('caption',$caption);
		Tpl::output('type_desc',$type_desc);
		Tpl::output('tableheader',array('typetitle'=>Language::get('bp_user_staff'),'valuetitle'=>$type_desc));
		//左侧菜单
		parent::setleftmenu('user_'.$stattype.$order);
		Tpl::showpage('statd_datasort');
	}
	
}