<?php
/**
 * 统计图表功能
 * 
 * 
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class statdetail_trackingControl extends statdetailControl{
	private $commonwhere=array();
	public function __construct(){
		parent::__construct();
		if ($_SESSION['shop_id']){//如果员工负责某店铺
			$this->commonwhere['shop_id'] = $_SESSION['shop_id'];
		} elseif (intval($_GET['shopid']) > 0){
			$this->commonwhere['shop_id'] = intval($_GET['shopid']);
		}
		if (!$_SESSION['shop_id']){
			//从缓存中调取店铺信息
			$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
			if(!empty($shop_list)){
				foreach($shop_list as $k=>$v){
					if($v['shop_isuse'] == 0){
						unset($shop_list[$k]);
					}
				}
			}
			Tpl::output('shop_list',$shop_list);
		}
	}
	/*
	 * 行动历史类型统计
	 */
	public function stattracking_historytype(){
		$model = Model();
		$where = $this->commonwhere;
		//添加时间搜索
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime > 0 && $etime>0){
			$where['cca_addtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($stime > 0){
			$where['cca_addtime'] = array('egt',"$stime");
		}elseif($etime>0){
			$where['cca_addtime'] = array('elt',"$etime");
		}
		$tableheader = array();
		$dataformat = 'integer';		
		$field ='cca_ismission,count(*) as num,shop_id';
		$caption = Language::get('bp_statdetail_action_history_type_distribution');
		$type_desc = Language::get('bp_statdetail_num');
		$tableheader = array('typetitle'=>Language::get('bp_statdetail_type'),'valuetitle'=>Language::get('bp_statdetail_num'));
		$actionstat = $model->table('customer_action,customer')->join('left')->on('customer_action.cc_id = customer.cc_id')->field($field)->where($where)->group('cca_ismission')->select();		
		$stat_json = '';
		if(!empty($actionstat)){
			$actionstat_new = array();
			foreach((array)$actionstat as $k=>$v){
				$actionstat_new[$v['cca_ismission']] = $v;
			}
			for ($i=0;$i<3;$i++){
				if (isset($actionstat_new[$i])){
					$tmp['value'] = $actionstat_new[$i]['num'];
				}else {
					$tmp['value'] = 0;
				}
				switch($i){
					case 0:
						$tmp['text'] = Language::get('bp_statdetail_schedule');
						break;
					case 1:
						$tmp['text'] = Language::get('bp_statdetail_mission');
						break;
					case 2:
						$tmp['text'] = Language::get('bp_statdetail_customer_care');
						break;
				}
				$actionstat_new[$i] = $tmp;
				$stat_data[] = array('value'=>$tmp['value'],'label'=>$tmp['text']);
			}
			ksort($actionstat_new);
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>$tableheader['typetitle']);
				$excel_data[0][] = array('styleid'=>'s_title','data'=>$tableheader['valuetitle']);
				//data
				foreach ((array)$actionstat_new as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$v['text']);
					$tmp[] = array('format'=>'Number','data'=>$v['value']);
					$excel_data[] = $tmp;
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet($caption);
				$excel_class->generateXML($caption.date('Y-m-d H-i-s',time()));
				exit();
			}else {
				//得到统计图数据
				$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data,$dataformat);
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
		Tpl::output('stat_json',$stat_json);
		Tpl::output('statlist',$actionstat_new);
		Tpl::output('caption',$caption);
		Tpl::output('type_desc',$type_desc);
		Tpl::output('tableheader',$tableheader);
		//左侧菜单
		parent::setleftmenu('tracking_historytype');
		Tpl::showpage('statd_simple');
	}
	/**
	 * 日程类型统计
	 */
	public function stattracking_scheduletype(){
		$model = Model();
		$where = $this->commonwhere;
		//添加时间搜索
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime > 0 && $etime>0){
			$where['cs_addtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($stime > 0){
			$where['cs_addtime'] = array('egt',"$stime");
		}elseif($etime>0){
			$where['cs_addtime'] = array('elt',"$etime");
		}
		$field ='cs_type as stattext,count(*) as statvalue,shop_id';		
		$schedulestat = $model->table('schedule,customer')->join('left')->on('schedule.cc_id=customer.cc_id')->field($field)->where($where)->group('cs_type')->select();
		$this->dictionarystat('scheduletype',$schedulestat);
	}
	/**
	 * 订单数据字典相关数据统计
	 */
	private function dictionarystat($type,$statlist){
		$model = Model();
		//数据字典字段与数据库字段对应
		switch ($type){
			case 'scheduletype':
				$dic_key = 'mission_type';
				$caption = Language::get('bp_statdetail_schedule_type_distribution');
				$type_desc = Language::get('bp_statdetail_num');
				$tableheader = array('typetitle'=>Language::get('bp_statdetail_type'),'valuetitle'=>Language::get('bp_statdetail_num'));
				$dateformat = 'integer';
				break;
		}
		//从缓存中调取数据字典信息
		$dic_array = H('dictionary');
		if (empty($dic_array[$dic_key])){
			showDialog(Language::get('bp_statdetail_dicinfo_error_cannot_viewstat'),'','error');
		}
		$stat_json = '';
		if(!empty($statlist)){
			$statlist_new = array();
			foreach((array)$statlist as $k=>$v){
				if ($dateformat == 'money'){
					$v['statvalue'] = ncPriceFormat($v['statvalue']);
				}
				if (empty($v['stattext'])){
					$statlist_new[0] = array('text'=>Language::get('bp_statdetail_null'),'value'=>$v['statvalue']);
					$stat_data[] = array('value'=>$v['statvalue'],'label'=>Language::get('bp_statdetail_null'));
				}else {
					$statlist_new[$v['stattext']] = $v;
				}
			}
			foreach ((array)$dic_array[$dic_key]['child_option'] as $k=>$v){
				$tmp = array();
				$tmp['text'] = $v['cd_name'];
				if (isset($statlist_new[$k])){
					$tmp['value'] = $statlist_new[$k]['statvalue'];
				}else{
					$tmp['value'] = 0;
				}
				$statlist_new[$k] = $tmp;
				$stat_data[] = array('value'=>$tmp['value'],'label'=>$tmp['text']);
			}
			ksort($statlist_new);
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>$tableheader['typetitle']);
				$excel_data[0][] = array('styleid'=>'s_title','data'=>$tableheader['valuetitle']);
				//data
				foreach ((array)$statlist_new as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$v['text']);
					$tmp[] = array('format'=>'Number','data'=>$v['value']);
					$excel_data[] = $tmp;
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet($caption);
				$excel_class->generateXML($caption.date('Y-m-d H-i-s',time()));
				exit();
			}else {
				//得到统计图数据
				$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data,$dateformat);
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
		Tpl::output('stat_json',$stat_json);
		Tpl::output('statlist',$statlist_new);
		Tpl::output('caption',$caption);
		Tpl::output('tableheader',$tableheader);
		//左侧菜单
		parent::setleftmenu('tracking_'.$type);
		Tpl::showpage('statd_simple');
	}

	/**
	 * 月度行动历史统计
	 */
	public function stattracking_monthlyhistory(){
		$year = intval($_GET['year']);
		if($year <= 0){
			$year = date('Y',time());
		}
		$model = Model();
		$timequantum = gettimequantum($year);
		$where = $this->commonwhere;
		$where['cca_addtime'] = array(array('egt',"{$timequantum['stime']}"),array('elt',"{$timequantum['etime']}"),'and');
		$field = 'MONTH(FROM_UNIXTIME(cca_addtime)) as monthval,count(*) as statvalue,shop_id';
		$statlist = $model->table('customer_action,customer')->join('left')->on('customer_action.cc_id = customer.cc_id')->field($field)->where($where)->group('monthval')->select();
		$statlistnew = array();
		if(!empty($statlist)){
			foreach((array)$statlist as $k=>$v){
				$statlistnew[$v['monthval']] = $v;
			}
		}
		$this->statShowByMonth('monthlyhistory',$statlistnew,$year);
	}
	/**
	 * 按照月份显示统计信息
	 */
	private function statShowByMonth($type,$statlist,$year){
		$caption = '';
		$type_desc = '';
		switch ($type){
			case 'monthlyhistory':
				$caption = Language::get('bp_statdetail_month_action_history_stat');
				$type_desc = Language::get('bp_statdetail_num');
				$dateformat = 'integer';
				break;
		}
		$stat_json = '';
		if (!empty($statlist)){
			$stat_data = array();
			for($i=1;$i<=12;$i++){
				$tmp = array();
				if(isset($statlist[$i])){
					if ($dateformat == 'money'){
						$tmp['value'] = ncPriceFormat($statlist[$i]['statvalue']);
					}else {
						$tmp['value'] = $statlist[$i]['statvalue'];
					}
				}else{
					$tmp['value'] = 0;
				}
				$stat_data[] = array('value'=>$tmp['value'],'label'=>$i.'月');
				$statlist[$i] = $tmp;
			}
			ksort($statlist);
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_month'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>$type_desc);
				//data
				foreach ((array)$statlist as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$k);
					$tmp[] = array('format'=>'Number','data'=>$v['value']);
					$excel_data[] = $tmp;
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet($caption);
				$excel_class->generateXML($caption.date('Y-m-d H-i-s',time()));
				exit();
			}else {
				$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data,$dateformat);
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
		Tpl::output('caption',$caption);
		Tpl::output('stat_json',$stat_json);
		Tpl::output('statlist',$statlist);
		Tpl::output('currentyear',$year);
		Tpl::output('tableheader',array('valuetitle'=>$type_desc));
		//年
		$year_arr = getSystemYearArr();
		Tpl::output('year_arr',$year_arr);
		//左侧菜单
		parent::setleftmenu('tracking_'.$type);
		Tpl::showpage('statd_monthstat');
	}
}