<?php
/**
 * 统计图表功能
 * 
 * 
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class statdetail_salesControl extends statdetailControl{
	private $commonwhere=array();
	public function __construct(){
		parent::__construct();
		$model = Model();
		//按照订单统计数据
		$order_typearr = array('statenum','stateamount','ordertype','ordertypemoney','ordernum','ordersaleroom','orderprofity');
		if (in_array($_GET['type'],$order_typearr)){
			if ($_SESSION['shop_id']){//如果员工负责某店铺
				$this->commonwhere['shop_id'] = $_SESSION['shop_id'];
			} elseif (intval($_GET['shopid']) > 0){
				$this->commonwhere['shop_id'] = intval($_GET['shopid']);
			}
		}
		//按照订单统计数据并且使用多表联查
		$order_typejoinarr = array('paymethod','areanum','areasaleroom','areaatv');
		if (in_array($_GET['type'],$order_typejoinarr)){
			if ($_SESSION['shop_id']){//如果员工负责某店铺
				$this->commonwhere['orders.shop_id'] = $_SESSION['shop_id'];
			} elseif (intval($_GET['shopid']) > 0){
				$this->commonwhere['orders.shop_id'] = intval($_GET['shopid']);
			}
		}
		if (!$_SESSION['shop_id']){
			//从缓存中调取店铺信息
			$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
			if(!empty($shop_list)){
				foreach($shop_list as $k=>$v){
					if($v['shop_isuse'] == 0){
						unset($shop_list[$k]);
					}
				}
			}
			Tpl::output('shop_list',$shop_list);
		}
	}
	/**
	 * 订单状态分布
	 */
	public function statsales_statenum(){
		$this->orderstate_stat('num');
	}
	/**
	 * 订单状态金额分布
	 */
	public function statsales_stateamount(){
		$this->orderstate_stat('amount');
	}
	/**
	 * 订单状态统计
	 */
	private function orderstate_stat($type){
		$model = Model();
		$where = $this->commonwhere;
		//添加时间搜索
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime > 0 && $etime>0){
			$where['co_addtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($stime > 0){
			$where['co_addtime'] = array('egt',"$stime");
		}elseif($etime>0){
			$where['co_addtime'] = array('elt',"$etime");
		}
		$tableheader = array();
		$dataformat = 'integer';
		$field = 'co_status';
		switch ($type){
			case 'num':
				$field .=',count(*) as num';
				$caption = Language::get('bp_statdetail_order_stat_distribution');
				$type_desc = Language::get('bp_statdetail_order_num');
				$tableheader = array('typetitle'=>Language::get('bp_statdetail_status'),'valuetitle'=>Language::get('bp_statdetail_num'));
				break;
			case 'amount':
				$field .=',sum(co_final_price) as amount';
				$caption = Language::get('bp_statdetail_order_stat_money_distribution');
				$type_desc = Language::get('bp_statdetail_order_price');
				$tableheader = array('typetitle'=>Language::get('bp_statdetail_status'),'valuetitle'=>Language::get('bp_statdetail_money_s'));
				$dataformat = 'money';
				break;
		}
		$where['co_code'] = array('exp','co_id in (select co_id from '.C('tablepre').'orders group by co_code)');
		$orderstat = $model->table('orders')->field($field)->where($where)->group('co_status')->select();
		$stat_json = '';
		if(!empty($orderstat)){
			$orderstat_new = array();
			foreach((array)$orderstat as $k=>$v){
				$orderstat_new[$v['co_status']] = $v;
			}
			for ($i=0;$i<=3;$i++){
				if (isset($orderstat_new[$i])){
					if ($dataformat == 'money'){
						$tmp['value'] = ncPriceFormat($orderstat_new[$i][$type]);
					}else {
						$tmp['value'] = $orderstat_new[$i][$type];
					}
				}else {
					$tmp['value'] = 0;
				}
				switch($i){
					case 0:
						$tmp['text'] = Language::get('bp_statdetail_order_working');
						break;
					case 1:
						$tmp['text'] = Language::get('bp_statdetail_order_done');
						break;
					case 2:
						$tmp['text'] = Language::get('bp_statdetail_order_shipped');
						break;
					case 3:
						$tmp['text'] = Language::get('bp_statdetail_order_closed');
						break;
				}
				$orderstat_new[$i] = $tmp;
				$stat_data[] = array('value'=>$tmp['value'],'label'=>$tmp['text']);
			}
			ksort($orderstat_new);
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>$tableheader['typetitle']);
				$excel_data[0][] = array('styleid'=>'s_title','data'=>$tableheader['valuetitle']);
				//data
				foreach ((array)$orderstat_new as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$v['text']);
					$tmp[] = array('format'=>'Number','data'=>$v['value']);
					$excel_data[] = $tmp;
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet($caption);
				$excel_class->generateXML($caption.date('Y-m-d H-i-s',time()));
				exit();
			}else {
				//得到统计图数据
				$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data,$dataformat);
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
		Tpl::output('stat_json',$stat_json);
		Tpl::output('statlist',$orderstat_new);
		Tpl::output('caption',$caption);
		Tpl::output('type_desc',$type_desc);
		Tpl::output('tableheader',$tableheader);
		//左侧菜单
		parent::setleftmenu('sales_state'.$type);
		Tpl::showpage('statd_simple');
	}
	/**
	 * 订单类型统计
	 */
	public function statsales_ordertype(){
		$this->dictionarystat('ordertype','sales_ordertype');
	}
	/**
	 * 订单类型金额分布
	 */
	public function statsales_ordertypemoney(){
		$this->dictionarystat('ordertype','sales_ordertypemoney');
	}
	/**
	 * 订单数据字典相关数据统计
	 */
	private function dictionarystat($dic_key,$menukey){
		$model = Model();
		//从缓存中调取数据字典信息
		$dic_array = H('dictionary');
		if (empty($dic_array[$dic_key])){
			showDialog(Language::get('bp_statdetail_dicinfo_error_cannot_viewstat'),'','error');
		}
		$table = 'orders';
		$where = $this->commonwhere;
		//数据字典字段与数据库字段对应
		switch ($menukey){
			case 'sales_ordertype':
				$caption = Language::get('bp_statdetail_order_type_distribution');
				$type_desc = Language::get('bp_statdetail_order_num');
				$tableheader = array('typetitle'=>Language::get('bp_statdetail_type'),'valuetitle'=>Language::get('bp_statdetail_num'));
				$dateformat = 'integer';
				$field = 'co_type as stattext,count(*) as statvalue';
				//搜索条件
				$where['co_status'] = array('neq',3);
				$stime = strtotime($_GET['search_stime']);
				$etime = strtotime($_GET['search_etime']);
				if ($stime > 0 && $etime>0){
					$where['co_addtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
				}elseif($stime > 0){
					$where['co_addtime'] = array('egt',"$stime");
				}elseif($etime>0){
					$where['co_addtime'] = array('elt',"$etime");
				}
				break;
			case 'sales_ordertypemoney':
				$caption = Language::get('bp_statdetail_order_type_money_distribution');
				$type_desc = Language::get('bp_statdetail_money_s');
				$tableheader = array('typetitle'=>Language::get('bp_statdetail_type'),'valuetitle'=>Language::get('bp_statdetail_money_s'));
				$dateformat = 'money';
				$field = 'co_type as stattext,sum(co_final_price) as statvalue';
				//搜索条件
				$where['co_status'] = array('neq',3);
				$stime = strtotime($_GET['search_stime']);
				$etime = strtotime($_GET['search_etime']);
				if ($stime > 0 && $etime>0){
					$where['co_addtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
				}elseif($stime > 0){
					$where['co_addtime'] = array('egt',"$stime");
				}elseif($etime>0){
					$where['co_addtime'] = array('elt',"$etime");
				}
				break;
		}
		$where['co_code'] = array('exp','co_id in (select co_id from '.C('tablepre').'orders group by co_code)');
		if (empty($join)){
			$statlist = $model->table($table)->field($field)->where($where)->group('stattext')->select();
		}else {
			$statlist = $model->table($table)->field($field)->join($join)->on($on)->where($where)->group('stattext')->select();
		}
		$stat_json = '';
		if(!empty($statlist)){
			$statlist_new = array();
			foreach((array)$statlist as $k=>$v){
				if ($dateformat == 'money'){
					$v['statvalue'] = ncPriceFormat($v['statvalue']);
				}
				if (empty($v['stattext'])){
					$statlist_new[0] = array('text'=>Language::get('bp_statdetail_null'),'value'=>$v['statvalue']);
					$stat_data[] = array('value'=>$v['statvalue'],'label'=>Language::get('bp_statdetail_null'));
				}else {
					$statlist_new[$v['stattext']] = $v;
				}
			}
			foreach ((array)$dic_array[$dic_key]['child_option'] as $k=>$v){
				$tmp = array();
				$tmp['text'] = $v['cd_name'];
				if (isset($statlist_new[$k])){
					$tmp['value'] = $statlist_new[$k]['statvalue'];
				}else{
					$tmp['value'] = 0;
				}
				$statlist_new[$k] = $tmp;
				$stat_data[] = array('value'=>$tmp['value'],'label'=>$tmp['text']);
			}
			ksort($statlist_new);
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>$tableheader['typetitle']);
				$excel_data[0][] = array('styleid'=>'s_title','data'=>$tableheader['valuetitle']);
				//data
				foreach ((array)$statlist_new as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$v['text']);
					$tmp[] = array('format'=>'Number','data'=>$v['value']);
					$excel_data[] = $tmp;
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet($caption);
				$excel_class->generateXML($caption.date('Y-m-d H-i-s',time()));
				exit();
			}else {
				//得到统计图数据
				$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data,$dateformat);
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
		Tpl::output('stat_json',$stat_json);
		Tpl::output('statlist',$statlist_new);
		Tpl::output('caption',$caption);
		Tpl::output('tableheader',$tableheader);
		//左侧菜单
		parent::setleftmenu($menukey);
		Tpl::showpage('statd_simple');
	}
	/**
	 * 毛利润月份统计
	 */
	public function statsales_orderprofity(){
		$year = intval($_GET['year']);
		if($year <= 0){
			$year = date('Y',time());
		}
		$statlist = $this->getmonthsalestat('orderprofity',$year);
		$this->statShowByMonth('orderprofity',$statlist,$year);
	}
	/*
	 * 销售额月份统计
	 */
	public function statsales_ordersaleroom(){
		$year = intval($_GET['year']);
		if($year <= 0){
			$year = date('Y',time());
		}
		$statlist = $this->getmonthsalestat('ordersaleroom',$year);
		$this->statShowByMonth('ordersaleroom',$statlist,$year);
	}
	/**
	 * 销量月份统计
	 */
	public function statsales_ordernum(){
		$year = intval($_GET['year']);
		if($year <= 0){
			$year = date('Y',time());
		}
		$statlist = $this->getmonthsalestat('ordernum',$year);
		$this->statShowByMonth('ordernum',$statlist,$year);
	}
	/*
	 * 获得某年月销售额统计
	 */
	private function getmonthsalestat($type,$year){
		$model = Model();
		$timequantum = gettimequantum($year);
		$where = $this->commonwhere;
		$where['co_status'] = array('neq',3);
		$where['co_addtime'] = array(array('egt',"{$timequantum['stime']}"),array('elt',"{$timequantum['etime']}"),'and');
		$where['co_code'] = array('exp','co_id in (select co_id from '.C('tablepre').'orders group by co_code)');
		$field = 'MONTH(FROM_UNIXTIME(co_addtime)) as monthval';
		switch ($type){
			case 'orderprofity':
				$field .= ',sum(co_final_price-co_cost_price) as statvalue';
				break;
			case 'ordersaleroom':
				$field .= ',sum(co_final_price) as statvalue';
				break;
			case 'ordernum':
				$field .= ',count(*) as statvalue';
				break;				
		}
		$statlist = $model->table('orders')->field($field)->where($where)->group('monthval')->select();
		$statlistnew = array();
		if(!empty($statlist)){
			foreach((array)$statlist as $k=>$v){
				$statlistnew[$v['monthval']] = $v;
			}
		}
		return $statlistnew;
	}
	/**
	 * 按照月份显示统计信息
	 */
	private function statShowByMonth($type,$statlist,$year){
		//添加自定义搜索条件
		$caption = '';
		$type_desc = '';
		switch ($type){
			case 'ordernum':
				$caption = Language::get('bp_statdetail_month_salenum_stat');
				$type_desc = Language::get('bp_statdetail_num');
				$dateformat = 'integer';
				break;
			case 'ordersaleroom':
				$caption = Language::get('bp_statdetail_month_saleamount_stat');
				$type_desc = Language::get('bp_statdetail_money_s');
				$dateformat = 'money';
				break;
			case 'orderprofity':
				$caption = Language::get('bp_statdetail_month_saleprofit_stat');
				$type_desc = Language::get('bp_statdetail_money_s');
				$dateformat = 'money';
				break;
		}
		$stat_json = '';
		if (!empty($statlist)){
			$stat_data = array();
			for($i=1;$i<=12;$i++){
				$tmp = array();
				if(isset($statlist[$i])){
					if ($dateformat == 'money'){
						$tmp['value'] = ncPriceFormat($statlist[$i]['statvalue']);
					}else {
						$tmp['value'] = $statlist[$i]['statvalue'];
					}
				}else{
					$tmp['value'] = 0;
				}
				$stat_data[] = array('value'=>$tmp['value'],'label'=>$i.'月');
				$statlist[$i] = $tmp;
			}
			ksort($statlist);
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_month'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>$type_desc);
				//data
				foreach ((array)$statlist as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$k);
					$tmp[] = array('format'=>'Number','data'=>$v['value']);
					$excel_data[] = $tmp;
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet($caption);
				$excel_class->generateXML($caption.date('Y-m-d H-i-s',time()));
				exit();
			}else {
				$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data,$dateformat);
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
		Tpl::output('caption',$caption);
		Tpl::output('stat_json',$stat_json);
		Tpl::output('statlist',$statlist);
		Tpl::output('currentyear',$year);
		Tpl::output('tableheader',array('typetitle'=>Language::get('bp_statdetail_month'),'valuetitle'=>$type_desc));
		//年
		$year_arr = getSystemYearArr();
		Tpl::output('year_arr',$year_arr);
		//左侧菜单
		parent::setleftmenu('sales_'.$type);
		Tpl::showpage('statd_sales_monthstat');
	}
	/**
	 * 订单区域分布
	 */
	public function statsales_areanum(){
		$this->getAreaSalestat('areanum');
	}
	/**
	 * 订单区域统计
	 */
	private function getAreaSalestat($type){
		$model = Model();
		$where = $this->commonwhere;
		$where['co_status'] = array('neq',3);
		//搜索条件
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime > 0 && $etime>0){
			$where['co_addtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($stime > 0){
			$where['co_addtime'] = array('egt',"$stime");
		}elseif($etime>0){
			$where['co_addtime'] = array('elt',"$etime");
		}
		$where['co_code'] = array('exp','co_id in (select co_id from '.C('tablepre').'orders group by co_code)');
		$field = ' cc_province as stattext ';
		switch ($type){
			case 'areanum':
				$field .= ' ,count(*) as statvalue ';
				$caption = Language::get('bp_statdetail_order_area_distribution');
				$type_desc = Language::get('bp_statdetail_num');
				$dataformat = 'integer';
				break;
			case 'areasaleroom':
				$field .= ' ,sum(co_final_price) as statvalue ';
				$caption = Language::get('bp_statdetail_order_saleamount_area_distribution');
				$type_desc = Language::get('bp_statdetail_money_s');
				$dataformat = 'money';
				break;
			case 'areaatv'://客单价
				$field .= ' ,sum(co_final_price)/count(*) as statvalue';
				$caption = Language::get('bp_statdetail_customer_price_area_distribution');
				$type_desc = Language::get('bp_statdetail_money_s');
				$dataformat = 'money';
				break;
		}
		$on = 'orders.cc_id = customer.cc_id';
		$orderlist = $model->table('orders,customer')->field($field)->join('left')->on($on)->where($where)->group('stattext')->select();
		$statlist = array();
		if(!empty($orderlist)){
			//构造颜色数组
			$color_arr = getColorArr(50);
			$i = 0;
			foreach((array)$orderlist as $k=>$v){
				if (empty($v['stattext'])){
					$k_new = Language::get('bp_statdetail_other');
				}else {
					$k_new = $v['stattext'];
				}
				//$statlist[$k_new]['value'] += ncPriceFormat($v['statvalue']);
				$statlist[$k_new]['value'] += $v['statvalue'];
			}
		}
		$stat_json = '';
		if (!empty($statlist)){
			//构造颜色数组
			$color_arr = getColorArr(50);
			$i = 0;
			foreach ((array)$statlist as $k=>$v){
				$stat_data[] = array("color"=>$color_arr[$i],"label"=>$k,"value"=>$v['value']);
				if ($dataformat == 'integer'){
					$statlist[$k]['value'] = intval($v['value']);
				}else{
					$statlist[$k]['value'] = ncPriceFormat($v['value']);
				}
				$i++;
			}
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_area'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>$type_desc);
				//data
				foreach ((array)$statlist as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$k);
					$tmp[] = array('format'=>'Number','data'=>($v['value']>0?$v['value']:0));
					$excel_data[] = $tmp;
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet($caption);
				$excel_class->generateXML($caption.date('Y-m-d H-i-s',time()));
				exit();
			}else {
				$stat_json = getStatData_Pie2D($caption,$stat_data);
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
  		Tpl::output('caption',$caption);
  		Tpl::output('type_desc',$type_desc);
  		Tpl::output('stat_json',$stat_json);
		Tpl::output('statlist',$statlist);
		//左侧菜单
		$this->setleftmenu('sales_'.$type);
		Tpl::showpage('statd_sales_areastat');
	}
	/**
	 * 订单销售额区域分布
	 */
	public function statsales_areasaleroom(){
		$this->getAreaSalestat('areasaleroom');
	}
	/**
	 * 订单客单价区域分布
	 */
	public function statsales_areaatv(){
		$model = Model();
		$where = $this->commonwhere;
		$where['co_status'] = array('neq',3);
		//搜索条件
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime > 0 && $etime>0){
			$where['co_addtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($stime > 0){
			$where['co_addtime'] = array('egt',"$stime");
		}elseif($etime>0){
			$where['co_addtime'] = array('elt',"$etime");
		}
		$field = ' cc_province as stattext,sum(co_final_price)/count(*) as statvalue';
		$on = 'orders.cc_id = customer.cc_id';
		$orderlist = $model->table('orders,customer')->field($field)->join('left')->on($on)->where($where)->group('stattext')->select();
		$orderlist_new = array();
		$stat_json = '';
		$caption = Language::get('bp_statdetail_customer_price_area_distribution');
		$type_desc = Language::get('bp_statdetail_customer_price');
		if(!empty($orderlist)){
			foreach((array)$orderlist as $k=>$v){
				if (!empty($v['stattext'])){
					$tmp = array();
					$tmp['text'] = $v['stattext'];
					$tmp['value'] = ncPriceFormat($v['statvalue']);
					$statlist[] = $tmp;
					$stat_data[] = array('value'=>$tmp['value'],'label'=>$tmp['text']);				
				}
			}
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_province_city'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>$type_desc);
				//data
				foreach ((array)$statlist as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$v['text']);
					$tmp[] = array('format'=>'Number','data'=>$v['value']);
					$excel_data[] = $tmp;
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet($caption);
				$excel_class->generateXML($caption.date('Y-m-d H-i-s',time()));
				exit();
			}else {
				$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data);
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
  		Tpl::output('caption',$caption);
  		Tpl::output('type_desc',$type_desc);
  		Tpl::output('stat_json',$stat_json);
		Tpl::output('statlist',$statlist);
		Tpl::output('tableheader',array('typetitle'=>Language::get('bp_statdetail_province_city'),'valuetitle'=>$type_desc));
		//左侧菜单
		$this->setleftmenu('sales_areaatv');
		Tpl::showpage('statd_simple');
	}
	/*
	 * 订单金额分布范围
	 */
	public function statsales_amountinterval(){
		$model = Model();
		$where = array();
		if ($_SESSION['shop_id']){//如果员工负责某店铺
			$where['shop_id'] = $_SESSION['shop_id'];
		} elseif (intval($_GET['shopid']) > 0){
			$where['shop_id'] = intval($_GET['shopid']);
		}
		$where['co_status'] = array('neq',3);
		//搜索条件
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime > 0 && $etime>0){
			$where['co_addtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($stime > 0){
			$where['co_addtime'] = array('egt',"$stime");
		}elseif($etime>0){
			$where['co_addtime'] = array('elt',"$etime");
		}
		$where['co_code'] = array('exp','co_id in (select co_id from '.C('tablepre').'orders group by co_code)');
		//从缓存中调取数据字典信息
		$dic_array = H('dictionary');
		if (empty($dic_array['orderamountinterval'])){
			showDialog(Language::get('bp_statdetail_dicinfo_error_cannot_viewstat'),'','error');
		}
		$interval_new = array();
		foreach ((array)$dic_array['orderamountinterval']['child_option'] as $k=>$v){
			$interval_new[] = $v['cd_name'];
		}
		for($i=0;$i <= count($interval_new);$i++){
			$statvalue_name = 'statvalue'.$i;
			if($i==0){
				$field = "sum(IF(co_final_price <= {$interval_new[$i]},1,0)) as {$statvalue_name}";
			}elseif($i == count($interval_new)){
				$field .= ",sum(IF(co_final_price > {$interval_new[$i-1]},1,0)) as {$statvalue_name}";
			}else{
				$field .= ",sum(IF(co_final_price > {$interval_new[$i-1]} and co_final_price <= {$interval_new[$i]},1,0)) as {$statvalue_name}";
			}
		}
		$orderlist = $model->table('orders')->field($field)->where($where)->find();
		$statlist = array();
		$stat_json = '';
		if (count($interval_new)>0){
			for($i=0;$i <= count($interval_new);$i++){
				if($i==0){
					$keynew = '0-'.$interval_new[$i];
				}elseif($i == count($interval_new)){
					$keynew = $interval_new[$i-1].Language::get('bp_statdetail_above');
				}else{
					$keynew = $interval_new[$i-1].'-'.$interval_new[$i];
				}
				$statlist[] = array('text'=>$keynew,'value'=>intval($orderlist['statvalue'.$i]));
				$stat_data[] = array('value'=>$orderlist['statvalue'.$i],'label'=>$keynew);
			}
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_range'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_num'));
				//data
				foreach ((array)$statlist as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$v['text']);
					$tmp[] = array('format'=>'Number','data'=>$v['value']);
					$excel_data[] = $tmp;
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet(Language::get('bp_statdetail_order_price_range_distribution'));
				$excel_class->generateXML(Language::get('bp_statdetail_order_price_range_distribution').date('Y-m-d H-i-s',time()));
				exit();
			}else {
				//得到统计图数据
				$stat_json = getStatData_Column2D(Language::get('bp_statdetail_order_price_range_distribution'),Language::get('bp_statdetail_num'),$stat_data,'integer');
			}	
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
		Tpl::output('stat_json',$stat_json);
		Tpl::output('statlist',$statlist);
		Tpl::output('caption',Language::get('bp_statdetail_order_price_range_distribution'));
		Tpl::output('tableheader',array('typetitle'=>Language::get('bp_statdetail_range'),'valuetitle'=>Language::get('bp_statdetail_num')));		
		//左侧菜单
		$this->setleftmenu('sales_amountinterval');
		Tpl::showpage('statd_simple');
	}
}