<?php
/**
 * 统计图表功能
 * 
 * 
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class statdetail_productControl extends statdetailControl{
	private $commonwhere=array();
	public function __construct(){
		parent::__construct();
		if (!$_SESSION['shop_id']){
			//从缓存中调取店铺信息
			$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
			if(!empty($shop_list)){
				foreach($shop_list as $k=>$v){
					if($v['shop_isuse'] == 0){
						unset($shop_list[$k]);
					}
				}
			}
			Tpl::output('shop_list',$shop_list);
		}
	}
	/*
	 * 商品销量前20名
	 */
	public function statproduct_ordernumtop(){
		$this->statproductrelevantdata('ordernum','top');
	}
	/*
	 * 商品销量后20名
	 */
	public function statproduct_ordernumlower(){
		$this->statproductrelevantdata('ordernum','lower');
	}
	/*
	 * 商品销售额前20名
	 */
	public function statproduct_orderamounttop(){
		$this->statproductrelevantdata('orderamount','top');
	}
	/*
	 * 商品销售额后20名
	 */
	public function statproduct_orderamountlower(){
		$this->statproductrelevantdata('orderamount','lower');
	}
	/*
	 * 商品毛利润前20名
	 */
	public function statproduct_orderprofitytop(){
		$this->statproductrelevantdata('orderprofity','top');
	}
	/*
	 * 商品毛利润后20名
	 */
	public function statproduct_orderprofitylower(){
		$this->statproductrelevantdata('orderprofity','lower');
	}
	/*
	 * 员工会员数统计
	 */
	private function statproductrelevantdata($stattype,$order){
		$model = Model('department');
		$where = array();
		$where['co_status'] = array('in',array(0,1,2));
		if ($_SESSION['shop_id']){//如果员工负责某店铺
			$where['orders.shop_id'] = $_SESSION['shop_id'];
		} elseif (intval($_GET['shopid']) > 0){
			$where['orders.shop_id'] = intval($_GET['shopid']);
		}
		//添加时间搜索
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime > 0 && $etime>0){
			$where['co_addtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($stime > 0){
			$where['co_addtime'] = array('egt',"$stime");
		}elseif($etime>0){
			$where['co_addtime'] = array('elt',"$etime");
		}
		$field = 'product.cp_id,product.cp_name as stattext,product.cp_mallurl as staturl';
		switch($stattype){
			case 'ordernum':
				$caption = Language::get('bp_statdetail_product_salenum');
				$type_desc = Language::get('bp_statdetail_num');
				$field .=",sum(cop_pnum) as statvalue";
				$dataformat = 'integer';
				break;
			case 'orderamount':
				$caption = Language::get('bp_statdetail_product_sale');
				$type_desc = Language::get('bp_statdetail_money_s');
				$field .=",sum(order_product.cop_total_price) as statvalue ";
				$dataformat = 'money';
				break;
			case 'orderprofity':
				$caption = Language::get('bp_statdetail_product_profit');
				$type_desc = Language::get('bp_statdetail_money_s');
				$field .=",sum(order_product.cop_total_price - order_product.cp_cost*cop_pnum) as statvalue ";
				$dataformat = 'money';
				break;
		}
		if($order == 'top'){
			$ordertext = 'statvalue desc';
			$caption .= Language::get('bp_statdetail_top20');
		}else{
			$ordertext = 'statvalue asc';
			$caption .= Language::get('bp_statdetail_last20');
		}
		$table = 'order_product,orders,product';
		$on = 'order_product.co_id=orders.co_id,order_product.cp_id=product.cp_id';
		$statlist = $model->table($table)->field($field)->join('inner,inner')->on($on)->where($where)->group('product.cp_id')->order($ordertext)->select();
		$stat_json = '';
		if(!empty($statlist)){
			$i = 1;
			foreach((array)$statlist as $k=>$v){
				$tmp['text'] = $v['stattext'];
				$tmp['staturl'] = $v['staturl'];
				if($dataformat == 'money'){
					$tmp['value'] = ncPriceFormat($v['statvalue']);
				}else{
					$tmp['value'] = $v['statvalue'];
				}
				$tmp['order'] = $i;
				$tmp['cp_id'] = $v['cp_id'];
				
				$statlist_new[] = $tmp;
				$stat_data[] = array('value'=>$tmp['value'],'label'=>str_cut($tmp['text'],24,'...'));
				$i++;
			}
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_sort'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_product'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>$type_desc);
				//data
				foreach ((array)$statlist_new as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$v['order']);
					$tmp[] = array('data'=>$v['text']);
					$tmp[] = array('format'=>'Number','data'=>$v['value']);
					$excel_data[] = $tmp;
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet($caption);
				$excel_class->generateXML($caption.date('Y-m-d H-i-s',time()));
				exit();
			}else {
				//得到统计图数据
				$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data,$dataformat);
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
		Tpl::output('stat_json',$stat_json);
		Tpl::output('statlist',$statlist_new);
		Tpl::output('caption',$caption);
		Tpl::output('type_desc',$type_desc);
		Tpl::output('tableheader',array('typetitle'=>Language::get('bp_statdetail_product'),'valuetitle'=>$type_desc));
		Tpl::output('datatype','product');
		//左侧菜单
		parent::setleftmenu('product_'.$stattype.$order);
		Tpl::showpage('statd_datasort');
	}
}