<?php
/**
 * 统计图表功能
 * 
 * 
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class statdetail_customerControl extends statdetailControl{
	private $commonwhere= array();
	public function __construct(){
		parent::__construct();
		$cus_typearr = array('typescale','degree','cusclass','cusindustry','cusrelationship','cusfrom','cuspotentialvalue','cusprovince','cusrf');
		if (in_array($_GET['type'],$cus_typearr) || !$_GET['type']){
			if ($_SESSION['shop_id']){//如果员工负责某店铺
				$this->commonwhere['shop_id'] = $_SESSION['shop_id'];
			} elseif (intval($_GET['shopid']) > 0){
				$this->commonwhere['shop_id'] = intval($_GET['shopid']);
			}
			//添加自定义搜索条件
			$stime = strtotime($_GET['search_stime']);
			$etime = strtotime($_GET['search_etime']);
			if ($stime > 0 && $etime>0){
				$this->commonwhere['cc_addtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
			}elseif($stime > 0){
				$this->commonwhere['cc_addtime'] = array('egt',"$stime");
			}elseif($etime>0){
				$this->commonwhere['cc_addtime'] = array('elt',"$etime");
			}
			if (!$_SESSION['shop_id']){
				//从缓存中调取店铺信息
				$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
				if(!empty($shop_list)){
					foreach($shop_list as $k=>$v){
						if($v['shop_isuse'] == 0){
							unset($shop_list[$k]);
						}
					}
				}
				Tpl::output('shop_list',$shop_list);
			}
		}
	}
	/*
	 * 各个会员特殊类型占会员总数比例统计
	 */
	public function statcustomer_typescale(){
		$model = Model();
		$field = " count(*) as allnum,sum(IF(cc_insea = 1,1,0)) as seanum,sum(IF(cc_ispotential = 1,1,0)) as potentialnum,sum(IF(cc_type = 1,1,0)) as companynum,sum(IF(cc_type = 2,1,0)) as personalnum";
		$customerstat = $model->table('customer')->field($field)->where($this->commonwhere)->find();
		$stat_json = '';
		if(!empty($customerstat)){
			$customerstat_new = array();
			foreach((array)$customerstat as $k=>$v){
				$tmp['value'] = $v>0?$v:0;
				switch($k){
					case 'allnum':
						$tmp['text'] = Language::get('bp_statdetail_all_customer');
						break;
					case 'seanum':
						$tmp['text'] = Language::get('bp_statdetail_sea_customer');
						break;
					case 'potentialnum':
						$tmp['text'] = Language::get('bp_statdetail_potential_customer');
						break;
					case 'companynum':
						$tmp['text'] = Language::get('bp_statdetail_company_customer');
						break;
					case 'personalnum':
						$tmp['text'] = Language::get('bp_statdetail_personal_customer');
						break;
				}
				if($customerstat['allnum'] >0){
					$tmp['rate'] = round($v/$customerstat['allnum']*100,2).'%';
				}else{
					$tmp['rate'] = "0%";
				}
				$customerstat_new[] = $tmp;
				$stat_data[] = array('value'=>$v,'label'=>$tmp['text']);
			}
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_type'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_num'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_rate'));
				//data
				foreach ((array)$customerstat_new as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$v['text']);
					$tmp[] = array('format'=>'Number','data'=>$v['value']);
					$tmp[] = array('data'=>$v['rate']);
					$excel_data[] = $tmp;
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet(Language::get('bp_statdetail_customer_type_rate'));
				$excel_class->generateXML(Language::get('bp_statdetail_customer_type_rate').date('Y-m-d H-i-s',time()));
				exit();
			}else {
				//得到统计图数据
				$stat_json = getStatData_Column2D(Language::get('bp_statdetail_customer_type_rate'),Language::get('bp_statdetail_customer_num'),$stat_data,'integer');
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
		Tpl::output('stat_json',$stat_json);
		Tpl::output('customerstat',$customerstat_new);
		//左侧菜单
		parent::setleftmenu('cus_typescale');
		Tpl::showpage('statd_customer_typescale');
	}
	/**
	 * 会员信用等级分布
	 */
	public function statcustomer_degree(){
		$model = Model();
		$customerstat = $model->table('customer')->field("cc_credit_degree,count(*) as allnum")->where($this->commonwhere)->group('cc_credit_degree')->select();
		$stat_json = '';
		if(!empty($customerstat)){
			$customerstat_new = array();
			foreach((array)$customerstat as $k=>$v){
				$customerstat_new[$v['cc_credit_degree']] = $v;
			}
			for ($i=1;$i<=3;$i++){
				if (isset($customerstat_new[$i])){
					$tmp['value'] = $customerstat_new[$i]['allnum'];
				}else {
					$tmp['value'] = 0;
				}
				switch($i){
					case 1:
						$tmp['text'] = Language::get('bp_statdetail_low');
						break;
					case 2:
						$tmp['text'] = Language::get('bp_statdetail_middle');
						break;
					case 3:
						$tmp['text'] = Language::get('bp_statdetail_high');
						break;
				}
				$customerstat_new[$i] = $tmp;
				$stat_data[] = array('value'=>$tmp['value'],'label'=>$tmp['text']);
			}
			ksort($customerstat_new);
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_type'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_num'));
				//data
				foreach ((array)$customerstat_new as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$v['text']);
					$tmp[] = array('format'=>'Number','data'=>$v['value']);
					$excel_data[] = $tmp;
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet(Language::get('bp_statdetail_customer_credit_distribution'));
				$excel_class->generateXML(Language::get('bp_statdetail_customer_credit_distribution').date('Y-m-d H-i-s',time()));
				exit();
			}else {
				//得到统计图数据
				$stat_json = getStatData_Column2D(Language::get('bp_statdetail_customer_credit_distribution'),Language::get('bp_statdetail_customer_num'),$stat_data,'integer');
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
		Tpl::output('stat_json',$stat_json);
		Tpl::output('customerstat',$customerstat_new);
		Tpl::output('title',Language::get('bp_statdetail_customer_credit_distribution'));
		//左侧菜单
		parent::setleftmenu('cus_degree');
		Tpl::showpage('statd_customer_simple');
	}
	/**
	 * 会员种类分布
	 */
	public function statcustomer_cusclass(){
		$this->dictionarystat('customer_class','cus_class');
	}
	/**
	 * 会员行业分布
	 */
	public function statcustomer_cusindustry(){
		$this->dictionarystat('industry','cus_industry');
	}
	/**
	 * 会员关系等级分布
	 */
	public function statcustomer_cusrelationship(){
		$this->dictionarystat('relationship','cus_relationship');
	}
	/**
	 * 会员来源分布
	 */
	public function statcustomer_cusfrom(){
		$this->dictionarystat('customer_from','cus_from');
	}
	/**
	 * 员工规模分布
	 */
	public function statcustomer_cusstaffsize(){
		$this->dictionarystat('staff_size','cus_staffsize');
	}
	/**
	 * 会员数据字典相关数据统计
	 */
	private function dictionarystat($dic_key,$menukey){
		$model = Model();
		//从缓存中调取数据字典信息
		$dic_array = H('dictionary');
		if (empty($dic_array[$dic_key])){
			return array();
		}
		$table = 'customer';
		//数据字典字段与数据库字段对应
		switch ($dic_key){
			case 'customer_class':
				$data_key = 'cc_class';
				break;
			case 'industry':
				$data_key = 'cc_industry';
				break;
			case 'relationship':
				$data_key = 'cc_relationship';
				break;
			case 'customer_from':
				$data_key = 'cc_from';
				break;
			case 'staff_size':
				$data_key = 'cci_staff_size';
				$table = 'customer,company_info';
				$join = 'left';
				$on = 'company_info.cc_id = customer.cc_id';
				$this->commonwhere['cc_type'] = 1;
				break;
		}
		if (empty($join)){
			$customerstat = $model->table($table)->field("$data_key,count(*) as allnum")->where($this->commonwhere)->group($data_key)->select();
		}else {
			$customerstat = $model->table($table)->field("$data_key,count(*) as allnum")->join($join)->on($on)->where($this->commonwhere)->group($data_key)->select();
		}
		$stat_json = '';
		$title = $dic_array[$dic_key]['class']['cd_name'].Language::get('bp_statdetail_distribution');
		if(!empty($customerstat)){
			$customerstat_new = array();
			foreach((array)$customerstat as $k=>$v){
				if (empty($v[$data_key])){
					$customerstat_new[0] = array('text'=>Language::get('bp_statdetail_null'),'value'=>(intval($customerstat_new[0]['value'])+$v['allnum']));
					$stat_data[0] = array('value'=>$customerstat_new[0]['value'],'label'=>Language::get('bp_statdetail_null'));
				}else {
					$customerstat_new[$v[$data_key]] = $v;
				}
			}
			foreach ((array)$dic_array[$dic_key]['child_option'] as $k=>$v){
				$tmp = array();
				$tmp['text'] = $v['cd_name'];
				if (isset($customerstat_new[$k])){
					$tmp['value'] = $customerstat_new[$k]['allnum'];
				}else{
					$tmp['value'] = 0;
				}
				$customerstat_new[$k] = $tmp;
				$stat_data[] = array('value'=>$tmp['value'],'label'=>$tmp['text']);
			}
			ksort($customerstat_new);
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_type'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_num'));
				//data
				foreach ((array)$customerstat_new as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$v['text']);
					$tmp[] = array('format'=>'Number','data'=>$v['value']);
					$excel_data[] = $tmp;
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet($title);
				$excel_class->generateXML($title.date('Y-m-d H-i-s',time()));
				exit();
			}else {
				//得到统计图数据
				$stat_json = getStatData_Column2D($title,Language::get('bp_statdetail_customer_num'),$stat_data,'integer');
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
		Tpl::output('stat_json',$stat_json);
		Tpl::output('customerstat',$customerstat_new);
		Tpl::output('title',$title);
		//左侧菜单
		parent::setleftmenu($menukey);
		Tpl::showpage('statd_customer_simple');
	}
	/**
	 * 潜在会员潜在价值分布
	 */
	public function statcustomer_cuspotentialvalue(){
		$model = Model();
		$where = $this->commonwhere;
		$where['cc_ispotential'] = '1';
		$customerstat = $model->table('customer')->field("cc_potential_value,count(*) as allnum")->where($where)->group('cc_potential_value')->select();
		$customerstat_new = '';
		$stat_json = '';
		if(!empty($customerstat)){
			$customerstat_new = array();
			foreach((array)$customerstat as $k=>$v){
				$customerstat_new[$v['cc_potential_value']] = $v;
			}
			for ($i=1;$i<=3;$i++){
				if (isset($customerstat_new[$i])){
					$tmp['value'] = $customerstat_new[$i]['allnum'];
				}else {
					$tmp['value'] = 0;
				}
				switch($i){
					case 1:
						$tmp['text'] = Language::get('bp_statdetail_low');
						break;
					case 2:
						$tmp['text'] = Language::get('bp_statdetail_middle');
						break;
					case 3:
						$tmp['text'] = Language::get('bp_statdetail_high');
						break;
				}
				$customerstat_new[$i] = $tmp;
				$stat_data[] = array('value'=>$tmp['value'],'label'=>$tmp['text']);
			}
			ksort($customerstat_new);
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_type'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_num'));
				//data
				foreach ((array)$customerstat_new as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$v['text']);
					$tmp[] = array('format'=>'Number','data'=>$v['value']);
					$excel_data[] = $tmp;
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet(Language::get('bp_statdetail_potential_customer_distribution'));
				$excel_class->generateXML(Language::get('bp_statdetail_potential_customer_distribution').date('Y-m-d H-i-s',time()));
				exit();
			}else {
				//得到统计图数据
				$stat_json = getStatData_Column2D(Language::get('bp_statdetail_potential_customer_distribution'),Language::get('bp_statdetail_customer_num'),$stat_data,'integer');
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
		Tpl::output('stat_json',$stat_json);
		Tpl::output('customerstat',$customerstat_new);
		Tpl::output('title',Language::get('bp_statdetail_potential_customer_distribution'));
		//左侧菜单
		parent::setleftmenu('cus_potentialvalue');
		Tpl::showpage('statd_customer_simple');
	}
	/**
	 * 会员省市分布
	 */
	public function statcustomer_cusprovince(){
		$model = Model();
		$field = 'cc_province,count(*) as num';
		$customerlist = $model->table('customer')->field($field)->where($this->commonwhere)->group('cc_province')->select();
		$customerlist_new = array();
		if (!empty($customerlist)){
			foreach ((array)$customerlist as $k=>$v){
				if (empty($v['cc_province'])){
					$k_new = Language::get('bp_statdetail_other');
				}else {
					$k_new = $v['cc_province'];
				}
				$customerlist_new[$k_new]['countnum'] += intval($v['num']);
			}
		}
		$stat_json = '';
		if (!empty($customerlist_new)){
			//构造颜色数组
			$color_arr = getColorArr(50);
			$i = 0;
			foreach ((array)$customerlist_new as $k=>$v){
				$stat_data[] = array("color"=>$color_arr[$i],"label"=>$k,"value"=>$customerlist_new[$k]['countnum']);
				$i++;
			}
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_area'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_num'));
				//data
				foreach ((array)$customerlist_new as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$k);
					$tmp[] = array('format'=>'Number','data'=>($v['countnum']>0?$v['countnum']:0));
					$excel_data[] = $tmp;
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet(Language::get('bp_statdetail_customer_area_distribution'));
				$excel_class->generateXML(Language::get('bp_statdetail_customer_area_distribution').date('Y-m-d H-i-s',time()));
				exit();
			}else {
				$stat_json = getStatData_Pie2D(Language::get('bp_statdetail_customer_area_distribution'),$stat_data);
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
  		Tpl::output('stat_json',$stat_json);
		Tpl::output('customerlist',$customerlist_new);
		//左侧菜单
		$this->setleftmenu('cus_province');
		Tpl::showpage('statd_customer_province');
	}
	/**
	 * 会员top20销售额统计
	 */
	public function statcustomer_cusamounttop(){
		$ordercustomerlist = $this->getyearcustomersalesstat('amount','top');
		$this->getyearcustomersalesstatshowdata('amount','top',$ordercustomerlist);
	}
	/**
	 * 会员top20毛利润统计
	 */
	public function statcustomer_cusprofittop(){
		$ordercustomerlist = $this->getyearcustomersalesstat('profit','top');
		$this->getyearcustomersalesstatshowdata('profit','top',$ordercustomerlist);
	}
	/**
	 * 获得某年会员销售统计展示数据
	 *
	 * @param unknown_type $year
	 * @param unknown_type $type
	 * @param unknown_type $order
	 */
	private function getyearcustomersalesstatshowdata($type,$order,$customerlist){
		$stat_json = '';
		$caption = '';
		$type_desc = '';
		$dataformat = 'money';
		switch ($type){
			case 'amount':
				$type_desc = Language::get('bp_statdetail_sale_amount_s');
				break;
			case 'profit':
				$type_desc = Language::get('bp_statdetail_sale_profit_s');
				break;
			case 'action':
				$type_desc = Language::get('bp_statdetail_action_history');
				$dataformat = 'integer';
				break;
		}
		if ($order == 'top'){
			$caption = Language::get('bp_statdetail_customer').$type_desc.Language::get('bp_statdetail_top20');
		}else{
			$caption = Language::get('bp_statdetail_customer').$type_desc.Language::get('bp_statdetail_last20');
		}
		if(!empty($customerlist)){
			$stat_data = array();
			$customerlistnew = array();
			foreach ((array)$customerlist as $k=>$v){
				$stat_data[] = array('value'=>$v[$type],'label'=>$v['cc_name']);
				$v['statvalue'] = $v[$type];
				$customerlistnew[] = $v;
			}
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_sort'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_customer_name'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>$type_desc);
				//data
				foreach ((array)$customerlistnew as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$v['order']);
					$tmp[] = array('data'=>$v['cc_name']);
					$tmp[] = array('format'=>'Number','data'=>$v['statvalue']);
					$excel_data[] = $tmp;
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet($caption);
				$excel_class->generateXML($caption.date('Y-m-d H-i-s',time()));
				exit();
			}else {
  				$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data,$dataformat);
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
		Tpl::output('stat_json',$stat_json);
		Tpl::output('customerlist',$customerlistnew);
		Tpl::output('type_desc',$type_desc);
		Tpl::output('caption',$caption);
		//左侧菜单
		$this->setleftmenu('cus_'.$type.$order);
		if ($_GET['device'] == 'phone'){
			Tpl::showpage('statd_phone_customer_sales','null_layout');
		} else {
			Tpl::showpage('statd_customer_sales');
		}
	}
	/**
	 * 获得会员销售统计数据
	 * $year 为统计的年份
	 * $type 为查询数据类型包括销售额(amount)，毛利润(profit)
	 * $order 为查询数据排序方式包含top，lower
	 */
	private function getyearcustomersalesstat($type,$order){
		$model = Model();
		$where = array();
		$where['co_status'] = array('in',array(0,1,2));
		//添加自定义搜索条件
		if ($_SESSION['shop_id']){//如果员工负责某店铺
			$where['shop_id'] = $_SESSION['shop_id'];
		} elseif (intval($_GET['shopid']) > 0){
			$where['shop_id'] = intval($_GET['shopid']);
		}
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime > 0 && $etime>0){
			$where['co_addtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($stime > 0){
			$where['co_addtime'] = array('egt',"$stime");
		}elseif($etime>0){
			$where['co_addtime'] = array('elt',"$etime");
		}
		$where['co_code'] = array('exp','co_id in (select co_id from '.C('tablepre').'orders group by co_code)');
		$field = 'orders.cc_id,customer.cc_name';
		switch ($type){
			case 'amount':
				$field .=",sum(co_final_price) as amount";
				$orderby = 'amount';
				break;
			case 'profit':
				$field .=",sum(co_final_price - co_cost_price) as profit";
				$orderby = 'profit';
				break;
		}
		if ($order == 'lower'){
			$orderby .= ' asc';
		}else {
			$orderby .= ' desc';
		}
		$on = 'orders.cc_id=customer.cc_id';
		$ordercustomerlist = $model->table('orders,customer')->field($field)->join('left')->on($on)->where($where)->group('orders.cc_id')->order($orderby)->limit(20)->select();
		$ordercustomerlistnew = array();
		if(!empty($ordercustomerlist)){
			$i=1;
			foreach((array)$ordercustomerlist as $k=>$v){
				$v['amount'] = ncPriceFormat($v['amount']);
				$v['profit'] = ncPriceFormat($v['profit']);
				$v['order'] = $i;
				$i++;
				$ordercustomerlistnew[$v['cc_id']] = $v;
			}
		}
		return $ordercustomerlistnew;
	}
	/**
	 * 会员日程行动历史前20名
	 */
	public function statcustomer_cusactiontop(){
		$model = Model();
		$where = array();
		//添加自定义搜索条件
		if ($_SESSION['shop_id']){//如果员工负责某店铺
			$where['shop_id'] = $_SESSION['shop_id'];
		} elseif (intval($_GET['shopid']) > 0){
			$where['shop_id'] = intval($_GET['shopid']);
		}
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime > 0 && $etime>0){
			$where['cca_addtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($stime > 0){
			$where['cca_addtime'] = array('egt',"$stime");
		}elseif($etime>0){
			$where['cca_addtime'] = array('elt',"$etime");
		}
		$field = 'customer_action.cc_id,customer.cc_name,count(*) as allnum';
		if ($order == 'lower'){
			$orderby = ' allnum asc ';
		}else {
			$orderby = ' allnum desc ';
		}
		$on = 'customer_action.cc_id=customer.cc_id';
		$actionlist = $model->table('customer_action,customer')->field($field)->join('left')->on($on)->where($where)->group('customer_action.cc_id')->order($orderby)->limit(20)->select();
		$actionlistnew = array();
		if(!empty($actionlist)){
			$i=1;
			foreach((array)$actionlist as $k=>$v){
				$v['action'] = $v['allnum'];
				$v['order'] = $i;
				$i++;
				$actionlistnew[$v['cc_id']] = $v;
			}
		}
		$this->getyearcustomersalesstatshowdata('action','top',$actionlistnew);
	}
	/**
	 * 计算RF
	 */
	public function statcustomer_cusrf(){
		//处理RF参数
		$rf_param =C('cusrfparam')?unserialize(C('cusrfparam')):'';
		if (empty($rf_param)){
			showDialog(Language::get('bp_statdetail_viewanalysis_after_paramsetting'),'index.php?act=statdetail&op=statdetail_customer&type=rfsetting','error');
		}
		$model = Model();
		$shopid = intval($_GET['shopid']);
		$where = array();
		$where['cc_isdel'] = 0;//未删除会员
		if ($shopid){
			$where['shop_id'] = $shopid;
		}
		//会员总数
		$cuscount = $model->table('customer')->where($where)->count();
		unset($where);
		//查询订单
		$where = array();
		$where['co_status'] = array('neq',3);
		if ($shopid){
			$where['shop_id'] = $shopid;
		}
		$where['co_code'] = array('exp','co_id in (select co_id from '.C('tablepre').'orders group by co_code)');
		$orderslist = $model->table('orders')->field("cc_id,count(*) as ordercount,co_addtime,sum(co_final_price) as amount")->where($where)->group('cc_id')->order('co_addtime desc')->select();
		$stat = array();
		$allprice = 0;
		if (!empty($orderslist)){
			foreach ($orderslist as $k=>$v){
				$allprice += $v['amount'];
				
				if ($v['ordercount'] >= intval($rf_param['f_max']) && $v['co_addtime'] >= time()-86400*($rf_param['r_min'])){
					$stat[1][1]['cusnum'] = intval($stat[1][1]['cusnum'])+1;
					$stat[1][1]['orderamount'] = floatval($stat[1][1]['orderamount'])+$v['amount'];
				}
				if ($v['ordercount'] >= intval($rf_param['f_max']) && ($v['co_addtime'] >= time()-86400*($rf_param['r_between2']) && $v['co_addtime'] <= time()-86400*($rf_param['r_between1']))){
					$stat[1][2]['cusnum'] = intval($stat[1][2]['cusnum'])+1;
					$stat[1][2]['orderamount'] = floatval($stat[1][2]['orderamount'])+$v['amount']; 
				}
				if ($v['ordercount'] >= intval($rf_param['f_max']) && $v['co_addtime'] <= time()-86400*($rf_param['r_max'])){
					$stat[1][3]['cusnum'] = intval($stat[1][3]['cusnum'])+1;
					$stat[1][3]['orderamount'] = floatval($stat[1][3]['orderamount'])+$v['amount'];
				}
				
				if (($v['ordercount'] >= intval($rf_param['f_between1']) && $v['ordercount'] <= intval($rf_param['f_between2'])) && $v['co_addtime'] >= time()-86400*($rf_param['r_min'])){
					$stat[2][1]['cusnum'] = intval($stat[2][1]['cusnum'])+1;
					$stat[2][1]['orderamount'] = floatval($stat[2][1]['orderamount'])+$v['amount'];
				}
				if (($v['ordercount'] >= intval($rf_param['f_between1']) && $v['ordercount'] <= intval($rf_param['f_between2'])) && ($v['co_addtime'] >= time()-86400*($rf_param['r_between2']) && $v['co_addtime'] <= time()-86400*($rf_param['r_between1']))){
					$stat[2][2]['cusnum'] = intval($stat[2][2]['cusnum'])+1;
					$stat[2][2]['orderamount'] = floatval($stat[2][2]['orderamount'])+$v['amount'];
				}
				if (($v['ordercount'] >= intval($rf_param['f_between1']) && $v['ordercount'] <= intval($rf_param['f_between2'])) && $v['co_addtime'] <= time()-86400*($rf_param['r_max'])){
					$stat[2][3]['cusnum'] = intval($stat[2][3]['cusnum'])+1;
					$stat[2][3]['orderamount'] = floatval($stat[2][3]['orderamount'])+$v['amount']; 
				}
				
				if ($v['ordercount'] <= intval($rf_param['f_min']) && $v['co_addtime'] >= time()-86400*($rf_param['r_min'])){
					$stat[3][1]['cusnum'] = intval($stat[3][1]['cusnum'])+1;
					$stat[3][1]['orderamount'] = floatval($stat[3][1]['orderamount'])+$v['amount'];
				}
				if ($v['ordercount'] <= intval($rf_param['f_min']) && ($v['co_addtime'] >= time()-86400*($rf_param['r_between2']) && $v['co_addtime'] <= time()-86400*($rf_param['r_between1']))){
					$stat[3][2]['cusnum'] = intval($stat[3][2]['cusnum'])+1; 
					$stat[3][2]['orderamount'] = floatval($stat[3][2]['orderamount'])+$v['amount'];
				}
				if ($v['ordercount'] <= intval($rf_param['f_min']) && $v['co_addtime'] <= time()-86400*($rf_param['r_max'])){
					$stat[3][3]['cusnum'] = intval($stat[3][3]['cusnum'])+1;
					$stat[3][3]['orderamount'] = floatval($stat[3][3]['orderamount'])+$v['amount'];
				}
			}
			$col_arr = array();
			//计算各项值
			foreach ((array)$stat as $k=>$v){
				foreach ($v as $col_k=>$col_v){
					//单元格数据
					$col_v['cellcusrate'] = round($col_v['cusnum']/$cuscount,4);
					$col_v['cellorderrate'] = round($col_v['orderamount']/$allprice,4);
					
					//行总和
					$v['rowcuscount'] = intval($v['rowcuscount']) + $col_v['cusnum'];
					$v['rowcusrate'] = round($v['rowcuscount']/$cuscount,4);
					$v['roworderamount'] = floatval($v['roworderamount']) + $col_v['orderamount'];
					$v['roworderrate'] = round($v['roworderamount']/$allprice,4);
					$v[$col_k] = $col_v;
					//列总和
					$col_arr[$col_k]['cuscount'] = intval($col_arr[$col_k]['cuscount'])+$col_v['cusnum'];
					$col_arr[$col_k]['cusrate'] = round($col_arr[$col_k]['cuscount']/$cuscount,4);
					$col_arr[$col_k]['orderamount'] = floatval($col_arr[$col_k]['orderamount'])+$col_v['orderamount'];
					$col_arr[$col_k]['orderrate'] = round($col_arr[$col_k]['orderamount']/$allprice,4);
					
					$all_arr['cuscount'] = intval($all_arr['cuscount'])+$col_v['cusnum'];
					$all_arr['cusrate'] = round($all_arr['cuscount']/$cuscount,4);
					$all_arr['orderamount'] = floatval($all_arr['orderamount'])+$col_v['orderamount'];
					$all_arr['orderrate'] = round($all_arr['orderamount']/$allprice,4);
				}
				$stat[$k] = $v;
			}
		}
		Tpl::output('cuscount',$cuscount);
		Tpl::output('allprice',$allprice);
		Tpl::output('col_arr',$col_arr);
		Tpl::output('stat',$stat);
		Tpl::output('all_arr',$all_arr);
		Tpl::output('rf_param',$rf_param);
		
		//左侧菜单
		$this->setleftmenu('cus_rf');
		Tpl::showpage('statd_customer_rf');
	}
	/**
	 * 设置RF参数
	 */
	public function statcustomer_rfsetting(){
		$model_setting = Model('setting');
		if (chksubmit()){
			$update_array = array();
			$update_array['cusrfparam']   = serialize($_POST['param']);
			$result = $model_setting->updateSetting($update_array);
			if ($result == true){
				H('setting',true);
				showDialog(Language::get('bp_statdetail_rf_analysis_param_savesucc'),'index.php?act=statdetail&op=statdetail_customer&type=rfsetting','succ');
			}else {
				showDialog(Language::get('bp_statdetail_rf_analysis_param_savefailed'),'','error');
			}
		}
		$list_setting = $model_setting->getListSetting();
		$rfsetting = $list_setting['cusrfparam']?unserialize($list_setting['cusrfparam']):array();
		Tpl::output('rfsetting',$rfsetting);
		//左侧菜单
		$this->setleftmenu('cus_rf');
		Tpl::showpage('statd_customer_rfsetting');
	}
}