<?php
/**
 * 统计图表功能
 * 
 * 
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class statdetail_chanceControl extends statdetailControl{
	private $commonwhere= array();
	public function __construct(){
		parent::__construct();
		$model = Model();
		//查询岗位信息
		$jobpost_info = $model->table('jobpost')->where(array('jp_id'=>$_SESSION['jp_id']))->find();
		//获得所有查询共有条件
		if($jobpost_info['jp_isleader'] == 1 || $_SESSION['member_id'] == 1){
			$tree_arr = ($t = F('department')) ? $t : H('department',true,'file');
			$d_idarr = array();
			//从缓存查询子部门
			$d_info = $tree_arr[$_SESSION['dp_id']];
			if (!empty($tree_arr[$_SESSION['dp_id']]['son'])){
				$d_idarr = explode(',',$tree_arr[$_SESSION['dp_id']]['son']);
			}
			$d_idarr[] = $_SESSION['dp_id'];
			$this->commonwhere['cha_departmentid'] = array('in',$d_idarr);
		}else{
			$this->commonwhere['cha_userid'] = $_SESSION['member_id'];
		}
	}
	/*
	 * 机会发现时间月份统计
	 */
	public function statchance_discovery(){
		$this->statShowByMonth('discovery');
	}
	/**
	 * 机会预计签单时间月份统计
	 */
	public function statchance_predictdate(){
		$this->statShowByMonth('predictdate');
	}
	/**
	 * 按照月份显示统计信息
	 */
	private function statShowByMonth($type){
		$year = intval($_GET['year']);
		if($year <= 0){
			$year = date('Y',time());
		}
		$model = Model();
		//添加自定义搜索条件
		$caption = '';
		$type_desc = '';
		$field = ' count(*) as allnum'; 
		$timequantum = gettimequantum($year);
		$where = $this->commonwhere;
		switch ($type){
			case 'discovery':
				$where['cha_discoverydate'] = array(array('egt',"{$timequantum['stime']}"),array('elt',"{$timequantum['etime']}"),'and');
				$field .= ',MONTH(FROM_UNIXTIME(cha_discoverydate)) as monthval ';
				$caption = Language::get('bp_statdetail_month_chancefind_timestat');
				$type_desc = Language::get('bp_statdetail_chance_num');
				break;
			case 'predictdate':
				$where['cha_predictdate'] = array(array('egt',"{$timequantum['stime']}"),array('elt',"{$timequantum['etime']}"),'and');
				$field .= ',MONTH(FROM_UNIXTIME(cha_predictdate)) as monthval ';
				$caption = Language::get('bp_statdetail_month_order_timestat');
				$type_desc = Language::get('bp_statdetail_chance_num');
				break;
		}
		$chancelist = $model->table('chance')->field($field)->where($where)->group('monthval')->select();
		$statlist = array();
		if (!empty($chancelist)){
			foreach((array)$chancelist as $k=>$v){
				$v['value'] = $v['allnum'];
				$statlist[$v['monthval']] = $v;
			}
		}
		$stat_json = '';
		if (!empty($statlist)){
			$stat_data = array();
			for($i=1;$i<=12;$i++){
				$tmp = array();
				if(isset($statlist[$i])){
					$tmp['value'] = $statlist[$i]['value'];
				}else{
					$tmp['value'] = 0;
				}
				$stat_data[] = array('value'=>$tmp['value'],'label'=>$i.Language::get('bp_month'));
				$statlist[$i] = $tmp;
			}
			ksort($statlist);
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_month'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>$type_desc);
				//data
				foreach ((array)$statlist as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$k);
					$tmp[] = array('format'=>'Number','data'=>$v['value']);
					$excel_data[] = $tmp;
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet($caption);
				$excel_class->generateXML($caption.date('Y-m-d H-i-s',time()));
				exit();
			}else {
				$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data,'integer');
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
		Tpl::output('caption',$caption);
		Tpl::output('type_desc',$type_desc);
		Tpl::output('stat_json',$stat_json);
		Tpl::output('statlist',$statlist);
		Tpl::output('currentyear',$year);
		Tpl::output('tableheader',array('valuetitle'=>$type_desc));
		//年
		$year_arr = getSystemYearArr();
		Tpl::output('year_arr',$year_arr);
		//左侧菜单
		parent::setleftmenu('cha_'.$type);
		Tpl::showpage('statd_monthstat');
	}
	/**
	 * 机会状态统计
	 */
	public function statchance_state(){
		$model = Model();
		$where = $this->commonwhere;
		//添加时间搜索
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime > 0 && $etime>0){
			$where['cha_addtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($stime > 0){
			$where['cha_addtime'] = array('egt',"$stime");
		}elseif($etime>0){
			$where['cha_addtime'] = array('elt',"$etime");
		}
		$chancestat = $model->table('chance')->field("cha_state,count(*) as allnum")->where($where)->group('cha_state')->select();
		$stat_json = '';
		if(!empty($chancestat)){
			$chancestat_new = array();
			foreach((array)$chancestat as $k=>$v){
				$chancestat_new[$v['cha_state']] = $v;
			}
			for ($i=0;$i<=4;$i++){
				if (isset($chancestat_new[$i])){
					$tmp['value'] = $chancestat_new[$i]['allnum'];
				}else {
					$tmp['value'] = 0;
				}
				switch($i){
					case 0:
						$tmp['text'] = Language::get('bp_statdetail_track');
						break;
					case 1:
						$tmp['text'] = Language::get('bp_statdetail_success');
						break;
					case 2:
						$tmp['text'] = Language::get('bp_statdetail_failure');
						break;
					case 3:
						$tmp['text'] = Language::get('bp_statdetail_lay_aside');
						break;
					case 4:
						$tmp['text'] = Language::get('bp_statdetail_abate');
						break;
				}
				$chancestat_new[$i] = $tmp;
				$stat_data[] = array('value'=>$tmp['value'],'label'=>$tmp['text']);
			}
			ksort($chancestat_new);
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_status'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_num'));
				//data
				foreach ((array)$chancestat_new as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$v['text']);
					$tmp[] = array('format'=>'Number','data'=>$v['value']);
					$excel_data[] = $tmp;
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet(Language::get('bp_statdetail_chance_status_distribution'));
				$excel_class->generateXML(Language::get('bp_statdetail_chance_status_distribution').date('Y-m-d H-i-s',time()));
				exit();
			}else {
				//得到统计图数据
				$stat_json = getStatData_Column2D(Language::get('bp_statdetail_chance_status_distribution'),Language::get('bp_statdetail_chance_num'),$stat_data,'integer');
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
		Tpl::output('stat_json',$stat_json);
		Tpl::output('statlist',$chancestat_new);
		Tpl::output('caption',Language::get('bp_statdetail_chance_status_distribution'));
		Tpl::output('tableheader',array('typetitle'=>Language::get('bp_statdetail_status'),'valuetitle'=>Language::get('bp_statdetail_num')));
		//左侧菜单
		parent::setleftmenu('cha_state');
		Tpl::showpage('statd_simple');
	}
	/**
	 * 机会类型统计
	 */
	public function statchance_chatype(){
		$this->dictionarystat('chancetype','cha_chatype');
	}
	/**
	 * 机会来源统计
	 */
	public function statchance_source(){
		$this->dictionarystat('chancesource','cha_source');
	}
	/**
	 * 机会阶段统计
	 */
	public function statchance_stage(){
		$this->dictionarystat('chancestage','cha_stage');
	}
	/**
	 * 机会可能性统计
	 */
	public function statchance_probability(){
		$this->dictionarystat('chanceprobability','cha_probability');
	}
	/**
	 * 机会数据字典相关数据统计
	 */
	private function dictionarystat($dic_key,$menukey){
		$model = Model();
		//从缓存中调取数据字典信息
		$dic_array = H('dictionary');
		if (empty($dic_array[$dic_key])){
			showDialog(Language::get('bp_statdetail_dicinfo_error_cannot_viewstat'),'','error');
		}
		$table = 'chance';
		//数据字典字段与数据库字段对应
		switch ($dic_key){
			case 'chancetype':
				$data_key = 'cha_type';
				break;
			case 'chancesource':
				$data_key = 'cha_source';
				break;
			case 'chancestage':
				$data_key = 'cha_stage';
				break;
			case 'chanceprobability':
				$data_key = 'cha_probability';
				break;
		}
		//搜索条件
		$where = $this->commonwhere;
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime > 0 && $etime>0){
			$where['cha_addtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($stime > 0){
			$where['cha_addtime'] = array('egt',"$stime");
		}elseif($etime>0){
			$where['cha_addtime'] = array('elt',"$etime");
		}
		if (empty($join)){
			$chancestat = $model->table($table)->field("$data_key,count(*) as allnum")->where($where)->group($data_key)->select();
		}else {
			$chancestat = $model->table($table)->field("$data_key,count(*) as allnum")->join($join)->on($on)->where($where)->group($data_key)->select();
		}
		$stat_json = '';
		$caption = $dic_array[$dic_key]['class']['cd_name'].Language::get('bp_statdetail_distribution');
		if(!empty($chancestat)){
			$chancestat_new = array();
			foreach((array)$chancestat as $k=>$v){
				if (empty($v[$data_key])){
					$chancestat_new[0] = array('text'=>Language::get('bp_statdetail_null'),'value'=>$v['allnum']);
					$stat_data[] = array('value'=>$v['allnum'],'label'=>Language::get('bp_statdetail_null'));
				}else {
					$chancestat_new[$v[$data_key]] = $v;
				}
			}
			foreach ((array)$dic_array[$dic_key]['child_option'] as $k=>$v){
				$tmp = array();
				$tmp['text'] = $v['cd_name'];
				if (isset($chancestat_new[$k])){
					$tmp['value'] = $chancestat_new[$k]['allnum'];
				}else{
					$tmp['value'] = 0;
				}
				$chancestat_new[$k] = $tmp;
				$stat_data[] = array('value'=>$tmp['value'],'label'=>$tmp['text']);
			}
			ksort($chancestat_new);
			if ($_GET['exporttype'] == 'excel'){
				//导出Excel
				import('excel#class');
				$excel_class = new ExcelXML(C('exportfilefont'));
				$excel_data = array();
				//设置样式
				$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_type'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_statdetail_num'));
				//data
				foreach ((array)$chancestat_new as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$v['text']);
					$tmp[] = array('format'=>'Number','data'=>$v['value']);
					$excel_data[] = $tmp;
				}
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet($caption);
				$excel_class->generateXML($caption.date('Y-m-d H-i-s',time()));
				exit();
			}else {
				//得到统计图数据
				$stat_json = getStatData_Column2D($caption,Language::get('bp_statdetail_chance_num'),$stat_data,'integer');
			}
		}
		if ($_GET['exporttype'] == 'excel'){
			showDialog(Language::get('bp_statdetail_nodata_cannot_exportexcel'),'','error');
		}
		Tpl::output('stat_json',$stat_json);
		Tpl::output('statlist',$chancestat_new);
		Tpl::output('caption',$caption);
		Tpl::output('tableheader',array('typetitle'=>Language::get('bp_statdetail_type'),'valuetitle'=>Language::get('bp_statdetail_num')));
		//左侧菜单
		parent::setleftmenu($menukey);
		Tpl::showpage('statd_simple');
	}
}