<?php
/**
 * 解决方案管理
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class solutionControl extends BaseHomeControl{
	private $commonwhere=array();
	public function __construct(){
		parent::__construct();
		$model = Model();
		//查询岗位信息
		$jobpost_info = $model->table('jobpost')->where(array('jp_id'=>$_SESSION['jp_id']))->find();
		//获得所有查询共有条件
		if($jobpost_info['jp_isleader'] == 1 || $_SESSION['member_id'] == 1){
			$tree_arr = ($t = F('department')) ? $t : H('department',true,'file');
			$d_idarr = array();
			//从缓存查询子部门
			$d_info = $tree_arr[$_SESSION['dp_id']];
			if (!empty($tree_arr[$_SESSION['dp_id']]['son'])){
				$d_idarr = explode(',',$tree_arr[$_SESSION['dp_id']]['son']);
			}
			$d_idarr[] = $_SESSION['dp_id'];
			$this->commonwhere['sol_departmentid'] = array('in',$d_idarr);
		}else{
			$this->commonwhere['sol_userid'] = $_SESSION['member_id'];
		}
		Language::read('solution');
	}
	/**
	 * 解决方案列表
	 */
	public function solutionlistOp(){
		$model = Model();
		$where = $this->commonwhere;
		if (!empty($_GET['search_content'])){
			$where['sol_title|sol_content'] = array(array('like',"%{$_GET['search_content']}%"));
		}
		if (!empty($_GET['search_cname'])){
			$where['sol_customername'] = array('like',"%{$_GET['search_cname']}%");
		}
		if (!empty($_GET['search_chance'])){
			$where['sol_chancetitle'] = array('like',"%{$_GET['search_chance']}%");
		}
		$sol_list = $model->table('solution')->where($where)->order('sol_id desc')->page(10)->select();
		Tpl::output('show_page',$model->showpage(2));
		Tpl::output('sol_list',$sol_list);
		//左侧菜单
		$this->setleftmenu('solutionlist');
		Tpl::showpage('solutionlist');
	}
	/**
	 * 新添加解决方案
	 */
	public function solutionaddOp(){
		//实例化模型
		$model = Model();
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["sol_cid"],"require"=>"true","message"=>Language::get('bp_solution_pls_add_customer'));
			$validate_arr[] = array("input"=>$_POST["sol_title"],"require"=>"true","message"=>Language::get('bp_solution_pls_add_title'));
			$validate_arr[] = array("input"=>$_POST["sol_content"],"require"=>"true","message"=>Language::get('bp_solution_pls_add_content'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//查询会员信息
			$customer_info = $model->table('customer')->where(array('cc_id'=>intval($_POST["sol_cid"]),'cc_isdel'=>0,'cc_insea'=>0))->find();
			if(empty($customer_info)){
				showDialog(Language::get('bp_solution_customer_info_notexist'),'','error');
			}
			$insert_array = array();
			$insert_array['sol_customerid'] = $customer_info['cc_id'];
			$insert_array['sol_customername'] = $customer_info['cc_name'];
			if(intval($_POST['sol_chance']) > 0){
				$insert_array['sol_chanceid'] = intval($_POST['sol_chance']);
				$insert_array['sol_chancetitle'] = $_POST['sol_chancetitle'];
			}
			$insert_array['sol_title'] = trim($_POST['sol_title']);
			$insert_array['sol_adduserid'] = $_SESSION['member_id'];
			$insert_array['sol_addusername'] = $_SESSION['truename'];
			$insert_array['sol_adddepartmentid'] = $_SESSION['dp_id'];
			$insert_array['sol_userid'] = $_SESSION['member_id'];
			$insert_array['sol_username'] = $_SESSION['truename'];
			$insert_array['sol_departmentid'] = $_SESSION['dp_id'];
			$insert_array['sol_addtime'] = time();
			$insert_array['sol_content'] = trim($_POST['sol_content']);
			$insert_array['sol_feedback'] = trim($_POST['sol_feedback']);
			
			$rs = $model->table('solution')->insert($insert_array);
			
			$url = 'index.php?act=solution&op=solutionlist';
			if ($_POST['source'] == 'chance'){
				$url = 'index.php?act=chance&op=chanceview&cid='.$insert_array['sol_chanceid'];
			}elseif ($_POST['source'] == 'customer'){
				$url = 'index.php?act=customer&op=customer_view&cc_id='.$insert_array['sol_customerid'];
			}
			if($rs){
				showDialog(Language::get('bp_solution_addsucc'),$url,'succ');
			}else{
				showDialog(Language::get('bp_solution_addfailed'),'','error');
			}
		}else{
			//如果来自会员详情页面则调取该会员信息
			if(intval($_GET['cc_id']) > 0){
				$cc_id = intval($_GET['cc_id']);
				$cc_info  = $model->table('customer')->where(array('cc_id'=>$cc_id,'cc_isdel'=>0))->find();
				if(empty($cc_info)){
					showMessage(Language::get('bp_solution_customer_info_notexist'));
				}else{
					//查询销售机会信息
					$chancelist = $model->table('chance')->where(array('cha_customerid'=>$cc_info['cc_id'],'cha_istrash'=>0))->select();
					Tpl::output('cc_info',$cc_info);
					Tpl::output('chancelist',$chancelist);
				}
			}elseif (intval($_GET['chance_id']) > 0){
				$chance_id = intval($_GET['chance_id']);
				//查询销售机会详细
				$chance_info = $model->table('chance')->where(array('cha_id'=>$chance_id,'cha_istrash'=>0))->find();
				if(empty($chance_info)){
					showMessage(Language::get('bp_solution_chance_info_notexist'));
				}else{
					//查询会员
					$cc_info  = $model->table('customer')->where(array('cc_id'=>$chance_info['cha_customerid'],'cc_isdel'=>0))->find();
					if(empty($cc_info)){
						showMessage(Language::get('bp_solution_chance_info_error'));
					}
					Tpl::output('chance_info',$chance_info);
				}
			}
			$source = '';
			if(intval($_GET['cc_id']) > 0){
				$source = 'customer';
			}elseif (intval($_GET['chance_id']) > 0){
				$source = 'chance';
			}
			Tpl::output('source',$source);
			//左侧菜单
			$this->setleftmenu('solutionlist');
			//模板输出
			Tpl::showpage('solutionadd');
		}
	}
	/*
	 * 解决方案编辑
	 */
	public function solutioneditOp(){
		$solid = intval($_GET['solid']);
		if ($solid<=0){
			$solid = intval($_POST['solid']);
		}
		if ($solid<=0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		//实例化模型
		$model = Model();
		$where = array();
		$where = $this->commonwhere;
		$where['sol_id'] = $solid;
		$sol_info = $model->table('solution')->where($where)->find();
		if(empty($sol_info)){
			showDialog(Language::get('bp_solution_info_error'),'','error');
		}
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["sol_title"],"require"=>"true","message"=>Language::get('bp_solution_pls_add_title'));
			$validate_arr[] = array("input"=>$_POST["sol_content"],"require"=>"true","message"=>Language::get('bp_solution_pls_add_content'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			$update_arr = array();
			$update_arr['sol_title'] = trim($_POST['sol_title']);
			$update_arr['sol_content'] = trim($_POST['sol_content']);
			$update_arr['sol_feedback'] = trim($_POST['sol_feedback']);
			$rs = $model->table('solution')->where(array('sol_id'=>$sol_info['sol_id']))->update($update_arr);
			$url = 'index.php?act=solution&op=solutionlist';
			if ($_POST['source'] == 'chance'){
				$url = 'index.php?act=chance&op=chanceview&cid='.$sol_info['sol_chanceid'];
			}elseif ($_POST['source'] == 'customer'){
				$url = 'index.php?act=customer&op=customer_view&cc_id='.$sol_info['sol_customerid'];
			}
			if($rs){
				showDialog(Language::get('bp_solution_editsucc'),$url,'succ');
			}else{
				showDialog(Language::get('bp_solution_editfailed'),'','error');
			}
		}else{
			$source = '';
			if(intval($_GET['cc_id']) > 0){
				$source = 'customer';
			}elseif (intval($_GET['chance_id']) > 0){
				$source = 'chance';
			}
			Tpl::output('source',$source);
			Tpl::output('sol_info',$sol_info);
			//左侧菜单
			$this->setleftmenu('solutionlist');
			//模板输出
			Tpl::showpage('solutionadd');
		}
	}
	/**
	 * 删除方案
	 */
	public function solutiondelOp(){
		$solid = $_GET['solid'];
		if (empty($solid)){
			$solid = $_POST['solid'];
		}
		if (empty($solid)){
			showDialog(Language::read('wrong_argument'),'','error');
		}
		$model = Model();
		$where = array();
		$where = $this->commonwhere;
		if (is_array($solid)){
			$where['sol_id'] = array('in',$solid);
		}else {
			$where['sol_id'] = $solid;
		}
		$rs = $model->table('solution')->where($where)->delete();
		$url = 'index.php?act=solution&op=solutionlist';
		if(intval($_GET['cc_id']) > 0){
			$url = 'index.php?act=customer&op=customer_view&cc_id='.intval($_GET['cc_id']);
		}elseif (intval($_GET['chance_id']) > 0){
			$url = 'index.php?act=chance&op=chanceview&cid='.intval($_GET['chance_id']);
		}
		if ($rs){
			showDialog(Language::get('bp_common_del_succ'),$url,'succ');
		} else {
			showDialog(Language::get('bp_common_del_fail'),'','error');
		}
	}
	/*
	 * 解决方案查看
	 */
	public function solutionviewOp(){
		$solid = intval($_GET['solid']);
		if ($solid<=0){
			showDialog(Language::read('wrong_argument'),'','error');
		}
		//实例化模型
		$model = Model();
		$sol_info = $model->table('solution')->where(array('sol_id'=>$solid))->find();
		if(empty($sol_info)){
			showDialog(Language::get('bp_solution_info_error'),'','error');
		}
		$source = '';
		if(intval($_GET['cc_id']) > 0){
			$source = 'customer';
		}elseif (intval($_GET['chance_id']) > 0){
			$source = 'chance';
		}
		$url = 'index.php?act=solution&op=solutionlist';
		if ($source == 'chance'){
			$url = 'index.php?act=chance&op=chanceview&cid='.$sol_info['sol_chanceid'];
		}elseif ($source == 'customer'){
			$url = 'index.php?act=customer&op=customer_view&cc_id='.$sol_info['sol_customerid'];
		}
		Tpl::output('backurl',$url);
		Tpl::output('source',$source);
		Tpl::output('sol_info',$sol_info);
		//左侧菜单
		$this->setleftmenu('solutionlist');
		//模板输出
		Tpl::showpage('solutionview','windowopen_layout');
	}
	/*
	 * 左侧菜单
	 */
	private function setleftmenu($menu_key=''){
		$arr = array();
		//两级菜单
		$arr[0] = array('menu_name'=>Language::get('bp_home_sale_chance'),	'linktype'=>'2');
		$arr[0]['submenu'][0] = array('menu_key'=>'chancelist','menu_name'=>Language::get('bp_home_chance_manage'),'menu_act'=>'chance','menu_op'=>'chancelist','linktype'=>'0');
		$arr[0]['submenu'][1] = array('menu_key'=>'chancetransfer','menu_name'=>Language::get('bp_home_chance_transfer'),'menu_act'=>'chance','menu_op'=>'chancetransfer','linktype'=>'0');
		$arr[0]['submenu'][2] = array('menu_key'=>'chancetransferlog','menu_name'=>Language::get('bp_home_chance_transfer_log'),'menu_act'=>'chance','menu_op'=>'chancetransfer','menu_url'=>'index.php?act=chance&op=chancetransfer&type=log','linktype'=>'0');
		$arr[0]['submenu'][3] = array('menu_key'=>'chancefiller','menu_name'=>Language::get('bp_home_sale_filler'),'menu_act'=>'chance','menu_op'=>'chancefiller','linktype'=>'0');
		
		$arr[1] = array('menu_name'=>Language::get('bp_home_sale_track'),	'linktype'=>'2');
		$arr[1]['submenu'][0] = array('menu_key'=>'requirementlist','menu_name'=>Language::get('bp_home_member_need'),'menu_act'=>'requirement','menu_op'=>'requirementlist','linktype'=>'0');
		$arr[1]['submenu'][1] = array('menu_key'=>'solutionlist','menu_name'=>Language::get('bp_home_solution'),'menu_act'=>'solution','menu_op'=>'solutionlist','linktype'=>'0');
		$arr[1]['submenu'][2] = array('menu_key'=>'quotedpricelist','menu_name'=>Language::get('bp_home_quote'),'menu_act'=>'quotedprice','menu_op'=>'quotedpricelist','linktype'=>'0');
		$arr[1]['submenu'][3] = array('menu_key'=>'competitorlist','menu_name'=>Language::get('bp_home_competitor'),'menu_act'=>'competitor','menu_op'=>'competitorlist','linktype'=>'0');
		
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}