<?php
/**
 * 模板设置
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class settingtemplateControl extends settingControl{
	/**
	 * 分类列表
	 */
	public function template_clist($rtype){
		$model = Model();
		$where = array();
		$where['tc_type'] = $rtype?$rtype:'sms';//活动类型 'sms'为短信,'email'为邮件
		if(!empty($_GET['search_name'])){
			$where['tc_name'] = array('like',"%{$_GET['search_name']}%");
		}
		$tc_list = $model->table('templateclass')->where($where)->order('tc_id desc')->page(20)->select();
		Tpl::output('tc_list',$tc_list);
		Tpl::output('show_page',$model->showpage(2));
		Tpl::output('pagetype',$rtype);
		parent::setleftmenu('tplclass'.$rtype);
		Tpl::showpage('template_classlist');
	}
	/**
	 * 分类新增
	 */
	public function template_cadd($rtype){
		$model = Model();
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["tc_name"],"require"=>"true","message"=>Language::get('bp_setting_pls_add_class_name'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			$insert_arr = array();
			$insert_arr['tc_name'] = $_POST['tc_name'];
			$insert_arr['tc_type'] = $rtype;
			$insert_arr['tc_remark'] = $_POST['tc_remark'];
			$insert_arr['tc_addtime'] = time();
			$rs = $model->table('templateclass')->insert($insert_arr);
			if ($rs){
				showDialog(Language::get('bp_setting_class_addsucc'),'index.php?act=setting&op='.$rtype.'tpl&type=clist','succ');
			} else {
				showDialog(Language::get('bp_setting_class_addfailed'),'','error');
			}
		}else{
			//左侧菜单
			$rtype?$rtype:'sms';//活动类型 'sms'为短信,'email'为邮件
			$this->setleftmenu('tplclass'.$rtype);
			Tpl::output('pagetype',$rtype);
			Tpl::showpage('template_classadd');
		}
	}
	/**
	 * 查询分类名称是否存在
	 */
	public function template_checkclassname($rtype){
		//分类查询信息
		$model = Model();
		$where = array();
		$where['tc_type'] = $rtype;
		$where['tc_name'] = $_GET['cname'];
		$tc_info = $model->table('templateclass')->where($where)->find();
		if (empty($tc_info)){
			echo 'true'; die;
		}else{
			if ($tc_info['tc_id'] == $_GET['tcid']){
				echo 'true'; die;
			} else {
				echo 'false'; die;
			}
		}
	}
	/**
	 * 分类编辑
	 */
	public function template_cedit($rtype){
		$tcid = $_GET['tcid'];
		if ($tcid <= 0){
			$tcid = $_POST['tcid'];
		}
		if ($tcid <= 0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["tc_name"],"require"=>"true","message"=>Language::get('bp_setting_pls_add_class_name'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			$update_arr = array();
			$update_arr['tc_name'] = $_POST['tc_name'];
			$update_arr['tc_remark'] = $_POST['tc_remark'];
			$rs = $model->table('templateclass')->where(array('tc_id'=>$tcid))->update($update_arr);
			if ($rs){
				showDialog(Language::get('bp_setting_class_editsucc'),'index.php?act=setting&op='.$rtype.'tpl&type=clist','succ');
			} else {
				showDialog(Language::get('bp_setting_class_editfailed'),'','error');
			}
		}else{
			//查询分类信息
			$tc_info = $model->table('templateclass')->where(array('tc_id'=>$tcid,'tc_type'=>$rtype))->find();
			Tpl::output('tc_info',$tc_info);
			//左侧菜单
			$rtype?$rtype:'sms';//活动类型 'sms'为短信,'email'为邮件
			$this->setleftmenu('tplclass'.$rtype);
			Tpl::output('pagetype',$rtype);
			Tpl::showpage('template_classadd');
		}
	}
	/*
	 * 删除分组
	 */
	public function template_cdel($rtype){
		$tcid = $_GET['tcid'];
		if (empty($tcid)){
			$tcid = $_POST['tcid'];
		}
		if (empty($tcid)){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		if (is_array($tcid)){
			$where['tc_id'] = array('in',$tcid);
		}else{
			$where['tc_id'] = $tcid;
		}
		$rs = $model->table('templateclass')->where($where)->delete();
		if ($rs){
			showDialog(Language::get('bp_setting_class_delsucc'),'index.php?act=setting&op='.$rtype.'tpl&type=clist','succ');
		}else{
			showDialog(Language::get('bp_setting_class_delfailed'),'','error');
		}
	}
	/**
	 * 短信模板列表
	 */
	public function template_list($rtype){
		$model = Model();
		$where = array();
		$where['tpl_type'] = $rtype?$rtype:'sms';//活动类型 'sms'为短信,'email'为邮件
		if(!empty($_GET['search_name'])){
			$where['tpl_name'] = array('like',"%{$_GET['search_name']}%");
		}
		$tpl_list = $model->table('template')->where($where)->order('tpl_id desc')->page(20)->select();
		foreach ((array)$tpl_list as $k=>$v){
			$v['tpl_content'] = replaceHtmlAndJs(html_entity_decode($v['tpl_content']));
			$tpl_list[$k] = $v;
		}
		Tpl::output('tpl_list',$tpl_list);
		//查询模板分类
		$tc_list = $model->table('templateclass')->where(array('tc_type'=>$rtype))->select();
		$tc_listnew = array();
		if(!empty($tc_list)){
			foreach($tc_list as $k=>$v){
				$tc_listnew[$v['tc_id']] = $v;
			}
		}
		Tpl::output('tc_list',$tc_listnew);
		Tpl::output('show_page',$model->showpage(2));
		Tpl::output('pagetype',$rtype);
		parent::setleftmenu('tpl'.$rtype);
		Tpl::showpage('template_list');
	}
	/**
	 * 短信模板新增
	 */
	public function template_add($rtype){
		$model = Model();
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["classsel"],"require"=>"true","message"=>Language::get('bp_setting_pls_choose_template_class'));
			$validate_arr[] = array("input"=>$_POST["tpl_name"],"require"=>"true","message"=>Language::get('bp_setting_pls_add_template_title'));
			$validate_arr[] = array("input"=>$_POST["tpl_content"],"require"=>"true","message"=>Language::get('bp_setting_pls_add_template_content'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			$insert_arr = array();
			$insert_arr['tpl_name'] = $_POST['tpl_name'];
			$insert_arr['tpl_type'] = $rtype;
			$insert_arr['tpl_cid'] = $_POST['classsel'];
			$insert_arr['tpl_content'] = $_POST['tpl_content'];
			$insert_arr['tpl_addtime'] = time();
			$insert_arr['tpl_state'] = 1;
			$insert_arr['tpl_userid'] = $_SESSION['member_id'];
			$rs = $model->table('template')->insert($insert_arr);
			if ($rs){
				showDialog(Language::get('bp_setting_template_addsucc'),'index.php?act=setting&op='.$rtype.'tpl&type=list','succ');
			} else {
				showDialog(Language::get('bp_setting_template_addfailed'),'','error');
			}
		}else{
			//查询模板分类
			$tc_list = $model->table('templateclass')->where(array('tc_type'=>$rtype))->select();
			Tpl::output('tc_list',$tc_list);
			//左侧菜单
			$rtype?$rtype:'sms';//活动类型 'sms'为短信,'email'为邮件
			$this->setleftmenu('tpl'.$rtype);
			Tpl::output('pagetype',$rtype);
			Tpl::showpage('template_add');
		}
	}
	/**
	 * 查询模板是否存在
	 */
	public function template_checkname($rtype){
		//分类查询信息
		$model = Model();
		$where = array();
		$where['tpl_type'] = $rtype;
		$where['tpl_name'] = $_GET['tplname'];
		$tpl_info = $model->table('template')->where($where)->find();
		if (empty($tpl_info)){
			echo 'true'; die;
		}else{
			if ($tpl_info['tpl_id'] == $_GET['tplid']){
				echo 'true'; die;
			} else {
				echo 'false'; die;
			}
		}
	}
	/**
	 * 短信模板编辑
	 */
	public function template_edit($rtype){
		$tplid = $_GET['tplid'];
		if ($tplid <= 0){
			$tplid = $_POST['tplid'];
		}
		if ($tplid <= 0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["classsel"],"require"=>"true","message"=>Language::get('bp_setting_pls_choose_template_class'));
			$validate_arr[] = array("input"=>$_POST["tpl_name"],"require"=>"true","message"=>Language::get('bp_setting_pls_add_template_title'));
			$validate_arr[] = array("input"=>$_POST["tpl_content"],"require"=>"true","message"=>Language::get('bp_setting_pls_add_template_content'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			$update_arr = array();
			$update_arr['tpl_name'] = $_POST['tpl_name'];
			$update_arr['tpl_cid'] = $_POST['classsel'];
			$update_arr['tpl_content'] = $_POST['tpl_content'];
			$rs = $model->table('template')->where(array('tpl_id'=>$tplid))->update($update_arr);
			if ($rs){
				showDialog(Language::get('bp_setting_template_editsucc'),'index.php?act=setting&op='.$rtype.'tpl&type=list','succ');
			} else {
				showDialog(Language::get('bp_setting_template_editsucc'),'','error');
			}
		}else{
			//查询模板信息
			$tpl_info = $model->table('template')->where(array('tpl_id'=>$tplid))->find();
			Tpl::output('tpl_info',$tpl_info);
			//查询模板分类
			$tc_list = $model->table('templateclass')->where(array('tc_type'=>$rtype))->select();
			Tpl::output('tc_list',$tc_list);
			//左侧菜单
			$rtype?$rtype:'sms';//活动类型 'sms'为短信,'email'为邮件
			$this->setleftmenu('tpl'.$rtype);
			Tpl::output('pagetype',$rtype);
			Tpl::showpage('template_add');
		}
	}
	/*
	 * 删除模板
	 */
	public function template_del($rtype){
		$tplid = $_GET['tplid'];
		if (empty($tplid)){
			$tplid = $_POST['tplid'];
		}
		if (empty($tplid)){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		if (is_array($tplid)){
			$where['tpl_id'] = array('in',$tplid);
		}else{
			$where['tpl_id'] = $tplid;
		}
		$rs = $model->table('template')->where($where)->delete();
		if ($rs){
			showDialog(Language::get('bp_setting_template_delsucc'),'index.php?act=setting&op='.$rtype.'tpl&type=list','succ');
		}else{
			showDialog(Language::get('bp_setting_template_delfailed'),'','error');
		}
	}
}