<?php
/**
 * 系统设置
 *
 *
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class settingControl extends BaseHomeControl{
	public function __construct(){
		parent::__construct();
		Language::read('setting');
	}
	/**
	 * 基本信息保存
	 */
	public function base_settingOp(){
		/**
		 * 实例化模型
		 */
		$model_setting = Model('setting');
		$monthandday_arr = array(1=>31,2=>28,3=>31,4=>30,5=>31,6=>30,7=>31,8=>31,9=>30,10=>31,11=>30,12=>31);
		/**
		 * 保存信息
		 */
		if (chksubmit()){
			$update_array = array();
			if($_POST['system_logo'] != ''){
				$update_array['system_logo']    = trim($_POST['system_logo']);
			}
			$update_array['system_name']       = trim($_POST['system_name']);
			$update_array['timezone']          = trim($_POST['timezone']);
			$update_array['shopnc_apiurl']     = trim($_POST['shopnc_apiurl']);
			$update_array['shopnc_signkey']    = trim($_POST['shopnc_signkey']);
			$update_array['shopnc_storeid']    = trim($_POST['shopnc_storeid']);
			$update_array['shopnc_syncopen']   = trim($_POST['shopnc_syncopen']);
			if (in_array($_POST['annualinventorydate_month'],array_keys($monthandday_arr))){
				$update_array['annualinventorydate_month'] = $_POST['annualinventorydate_month'];
			}else {
				$update_array['annualinventorydate_month'] = 12;
			}
			if ($_POST['annualinventorydate_day'] >0 && $_POST['annualinventorydate_day'] <= $monthandday_arr[$update_array['annualinventorydate_month']]){
				$update_array['annualinventorydate_day'] = $_POST['annualinventorydate_day'];
			}else {
				$update_array['annualinventorydate_day'] = $monthandday_arr[$update_array['annualinventorydate_month']];
			}
			$update_array['taobao_account']    = trim($_POST['taobao_account']);
			$update_array['taobao_authcode']   = trim($_POST['taobao_authcode']);
			$update_array['taobao_storetype']  = trim($_POST['taobao_storetype']);
			$result = $model_setting->updateSetting($update_array);
			if ($result == true){
				H('setting',true);
				showDialog(Language::get('bp_setting_base_savesucc'),'index.php?act=setting&op=base_setting','succ');
			}else {
				showDialog(Language::get('bp_setting_base_savefail'),'','error');
			}
		}
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('base_setting');
		/**
		 * 读取设置内容 $list_setting
		 */
		$list_setting = $model_setting->getListSetting();
		/**
		 * 模板输出
		 */
		Tpl::output('list_setting',$list_setting);
		Tpl::showpage('base_setting');
	}
	/**
	 * 上传系统Logo图片
	*/
	public function ajax_upload_logoOp(){
		$upload = new UploadFile();
		$upload->set('default_dir',ATTACH_COMMON);
		/**
		 * 系统图标上传
		 */
		if (!empty($_FILES['tmp_system_logo']['name'])){
			$upload->set('file_name', '');
			$upload->set('thumb_width',	0);
			$upload->set('thumb_height',0);
			$upload->set('thumb_ext',	false);
			$result = $upload->upfile('tmp_system_logo');
			if ($result){
				$system_logo = $upload->file_name;
			}
		}
		/*
		 * 构造更新数据数组
		 */
		if ($system_logo != ''){
			echo json_encode(array('done'=>true,'logo'=>$system_logo));
		}else{
			echo json_encode(array('done'=>false,'logo'=>''));
		}
	}
	/**
	 * 会员公海设置
	 */
	public function sea_settingOp(){
		/**
		 * 实例化模型
		 */
		$model_setting = Model('setting');
		/**
		 * 保存信息
		 */
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["return_days"],"require"=>"true","validator"=>"Number","message"=>Language::get('bp_setting_returnday_mustaddnum'));
			$validate_arr[] = array("input"=>$_POST["max_scnum"],"require"=>"true","validator"=>"Number","message"=>Language::get('bp_setting_getcustomerseanum_mustaddnum'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			$update_array = array();
			$update_array['use_sea']    	= intval($_POST['use_sea']);
			$update_array['return_days']    = intval($_POST['return_days']);
			$update_array['max_scnum']  	= intval($_POST['max_scnum']);
			$update_array['auto_gotosea']   = intval($_POST['auto_gotosea']);
			$result = $model_setting->updateSetting($update_array);
			H('setting',true);
			if ($result == true){
				showDialog(Language::get('bp_setting_customersea_settingsucc'),'index.php?act=setting&op=sea_setting','succ');
			}else {
				showDialog(Language::get('bp_setting_customersea_settingfailed'),'','error');
			}
		}
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('sea_setting');
		/**
		 * 读取设置内容 $list_setting
		 */
		$list_setting = $model_setting->getListSetting();
		/**
		 * 模板输出
		 */
		Tpl::output('list_setting',$list_setting);
		Tpl::showpage('sea_setting');
	}
	/**
	 * 首页设置
	 */
	public function index_settingOp(){
		Language::read('index');
		/**
		 * 实例化模型
		 */
		$model_setting = Model('setting');
		/**
		 * 保存信息
		 */
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["index_mission_maxnum"],"require"=>"true","validator"=>"Number","message"=>Language::read('bp_setting_maxmissionnum_shouldbe_num'));
			$validate_arr[] = array("input"=>$_POST["index_order_maxnum"],"require"=>"true","validator"=>"Number","message"=>Language::read('bp_setting_maxordernum_shouldbe_num'));
			$validate_arr[] = array("input"=>$_POST["index_np_maxnum"],"require"=>"true","validator"=>"Number","message"=>Language::read('bp_setting_maxnotepadnum_shouldbe_num'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			$update_array = array();
			$update_array['index_mission_maxnum'] = intval($_POST['index_mission_maxnum']);
			$update_array['index_order_maxnum']   = intval($_POST['index_order_maxnum']);
			$update_array['index_np_maxnum']      = intval($_POST['index_np_maxnum']);
			$result = $model_setting->updateSetting($update_array);
			H('setting',true);
			if ($result == true){
				showDialog(Language::read('bp_setting_indexsetting_succ'),'index.php?act=setting&op=index_setting','succ');
			}else {
				showDialog(Language::read('bp_setting_indexsetting_failed'),'','error');
			}
		}
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('index_setting');
		/**
		 * 读取设置内容 $list_setting
		 */
		$list_setting = $model_setting->getListSetting();
		/**
		 * 模板输出
		 */
		Tpl::output('list_setting',$list_setting);
		Tpl::showpage('index_setting');
	}
	/**
	 * 所得税税率设置 
	 */
	public function personaltax_settingOp(){
		Language::read('index');
		$model_setting = Model('setting');
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["startmoney"],"require"=>"true","validator"=>"Number","message"=>Language::get('bp_setting_pls_add_incometax_start_value'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			$update_array = array();
			$update_array['personaltax_start'] = $_POST['startmoney'];
			if (empty($_POST['rateinfo'])){
				$update_array['personaltax_rateinfo'] = '';
			}else {
				$update_array['personaltax_rateinfo']   = serialize($_POST['rateinfo']);
			}
			$result = $model_setting->updateSetting($update_array);
			H('setting',true);
			if ($result == true){
				showDialog(Language::get('bp_setting_incometax_setting_succ'),'index.php?act=setting&op=personaltax_setting','succ');
			}else {
				showDialog(Language::get('bp_setting_incometax_setting_failed'),'','error');
			}
		}
		$this->setleftmenu('personaltax_setting');
		$list_setting = $model_setting->getListSetting();
		if (!empty($list_setting['personaltax_rateinfo'])){
			$list_setting['personaltax_rateinfo'] = unserialize($list_setting['personaltax_rateinfo']);
		}
		Tpl::output('list_setting',$list_setting);
		Tpl::showpage('personaltax_setting');
	}
	/**
	 * 销售提成设置 
	 */
	public function salepercentage_settingOp(){
		
		$model_setting = Model('setting');
		if (chksubmit()){
			$update_array = array();
			$update_array['salepercentage_type'] = $_POST['salepercentage_type'];
			if ($_POST['salepercentage_type'] == 1){
				if (empty($_POST['salepercentage_list'])){
					$update_array['salepercentage_value'] = '';
				}else {
					$update_array['salepercentage_value']   = serialize($_POST['salepercentage_list']);
				}
			}else {
				$update_array['salepercentage_value'] = $_POST['salepercentage_value'];
			}
			$result = $model_setting->updateSetting($update_array);
			H('setting',true);
			if ($result == true){
				showDialog(Language::get('bp_setting_salepercentage_setting_succ'),'index.php?act=setting&op=salepercentage_setting','succ');
			}else {
				showDialog(Language::get('bp_setting_salepercentage_setting_failed'),'','error');
			}
		}
		$this->setleftmenu('salepercentage_setting');
		$list_setting = $model_setting->getListSetting();
		if ($list_setting['salepercentage_type'] == 1 && !empty($list_setting['salepercentage_value'])){
			$list_setting['salepercentage_list'] = unserialize($list_setting['salepercentage_value']);
		}else{
			$list_setting['salepercentage_one'] = $list_setting['salepercentage_value'];
		}
		Tpl::output('list_setting',$list_setting);
		Tpl::showpage('salepercentage_setting');
	}
	/**
	 * 快递单打印设置
	 */
//	public function express_settingOp(){
//		/**
//		 * 实例化模型
//		 */
//		$model_setting = Model('setting');
//		/**
//		 * 保存信息
//		 */
//		if (chksubmit()){
//			$obj_validate = new Validate();
//			$validate_arr[] = array("input"=>$_POST["express_contact"],"require"=>"true","message"=>"发件人联系人不能为空");
//			$validate_arr[] = array("input"=>$_POST["express_phone"],"require"=>"true","message"=>"发件人电话不能为空");
//			$obj_validate -> validateparam = $validate_arr;
//			$error = $obj_validate->validate();
//			if ($error != ''){
//				showDialog($error,'','error');
//			}
//			$update_array = array();
//			$update_array['express_coname'] = trim($_POST['express_coname']);
//			$update_array['express_contact'] = trim($_POST['express_contact']);
//			$update_array['express_phone'] = trim($_POST['express_phone']);
//			$update_array['express_address'] = trim($_POST['express_address']);
//			$update_array['express_postcode'] = trim($_POST['express_postcode']);
//			$update_array['express_sign'] = trim($_POST['express_sign']);
//			$result = $model_setting->updateSetting($update_array);
//			H('setting',true);
//			if ($result == true){
//				showDialog('快递单打印设置保存成功!','index.php?act=setting&op=express_setting','succ');
//			}else {
//				showDialog('快递单打印设置保存失败,请重试','','error');
//			}
//		}
//		/**
//		 * 左侧菜单
//		 */
//		$this->setleftmenu('express_setting');
//		/**
//		 * 读取设置内容 $list_setting
//		 */
//		$list_setting = $model_setting->getListSetting();
//		/**
//		 * 模板输出
//		 */
//		Tpl::output('list_setting',$list_setting);
//		Tpl::showpage('express_setting');
//	}
	/**
	 * 会员等级规则
	 */
	public function ccgraderulesOp(){
		if (!empty($_GET['type'])){
			$funname = "ccgraderules_".$_GET['type'];
			if(method_exists($this,$funname)){
				$this->$funname();
			}
		}else{
			$this->ccgraderules_list();
		}
	}
	/**
	 * 会员等级规则
	 */
	public function ccgraderules_list(){
		$model = Model();
		$where = array();
		if (!empty($_GET['search_name'])){
			$where['cg_name'] = array('like',"%{$_GET['search_name']}%");
		}
		//从缓存中调取店铺信息
		$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
		if ($_SESSION['shop_id']){//如果员工负责某店铺
			$where['cg_shopid'] = $_SESSION['shop_id'];
		} elseif (intval($_GET['search_shop']) > 0){
			$where['cg_shopid'] = intval($_GET['search_shop']);
		} elseif ($_GET['search_shop'] == 'all') {
		} else {
			//无所属店铺则找出默认店铺并进行优先显示
			$default_shop = 0;
			if(!empty($shop_list)){
				foreach ($shop_list as $k=>$v){
					if($v['shop_default'] == 1){
						$default_shop = $v['shop_id'];
						break;
					}
				}
				if ($default_shop > 0){
					$where['cg_shopid'] = intval($default_shop);
				}
				$_GET['search_shop'] = $default_shop;
			}
		}
		if (intval($_GET['search_state']) > 0){
			$where['cg_state'] = intval($_GET['search_state']) - 1;
		}
		$gradelist = $model->table('customergrade,shop')->join('left')->on('customergrade.cg_shopid=shop.shop_id')->where($where)->order('cg_ordernum')->select();
		foreach ((array)$gradelist as $k=>$v){
			$v['cg_amountlimits_arr'] = $v['cg_amountlimits']?unserialize($v['cg_amountlimits']):'';
			if ($v['cg_amountlimits_arr']['type'] == 'unlimited'){
				$v['cg_amountlimits_str'] = Language::get('bp_setting_no_limit');
			}else{
				if ($v['cg_amountlimits_arr']['end'] > 0){
					$v['cg_amountlimits_str'] = Language::get('bp_setting_between').Language::get('bp_colon').$v['cg_amountlimits_arr']['start'].Language::get('bp_setting_currency_unit_long').$v['cg_amountlimits_arr']['end'].Language::get('bp_setting_currency_unit');
				}else{
					$v['cg_amountlimits_str'] = Language::get('bp_setting_bigger_than').Language::get('bp_colon').$v['cg_amountlimits_arr']['start'].Language::get('bp_setting_currency_unit');
				}
			}
			$v['cg_timeslimits_arr'] = $v['cg_timeslimits']?unserialize($v['cg_timeslimits']):'';
			if ($v['cg_timeslimits_arr']['type'] == 'unlimited'){
				$v['cg_timeslimits_str'] = Language::get('bp_setting_no_limit');
			}else{
				if ($v['cg_timeslimits_arr']['end'] > 0){
					$v['cg_timeslimits_str'] = Language::get('bp_setting_between').Language::get('bp_colon').$v['cg_timeslimits_arr']['start'].Language::get('bp_setting_times_long').$v['cg_timeslimits_arr']['end'].Language::get('bp_setting_times');
				}else{
					$v['cg_timeslimits_str'] = Language::get('bp_setting_bigger_than').Language::get('bp_colon').$v['cg_timeslimits_arr']['start'].Language::get('bp_setting_times');
				}
			}
			$gradelist[$k] = $v;
		}
		Tpl::output('gradelist',$gradelist);
		$shop_list = $model->table('shop')->where(array('shop_isuse'=>1))->select();
		Tpl::output('shop_list',$shop_list);
		//左侧菜单
		$this->setleftmenu('ccgraderules');
		Tpl::showpage('setting_ccgraderuleslist');
	}
	/**
	 * 新增会员等级规则
	 */
	public function ccgraderules_add(){
		$model = Model();
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["shopsel"],"require"=>"true","message"=>Language::get('bp_setting_pls_choose_fit_shop'));
			$validate_arr[] = array("input"=>$_POST["g_name"],"require"=>"true","message"=>Language::get('bp_setting_pls_add_degree_name'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if (empty($_POST['filter']['amount'])){
				$error .= Language::get('bp_setting_pls_choose_consume_price_condition');
			}elseif ($_POST['filter']['amount']['type']=='between' && intval($_POST['filter']['amount']['start']) <= 0) {
				$error .= Language::get('bp_setting_consume_price_must_bigerthan10');
			}
			if (empty($_POST['filter']['times'])){
				$error .= Language::get('bp_setting_pls_choose_consume_times_condition');
			}elseif ($_POST['filter']['times']['type']=='between' && intval($_POST['filter']['times']['start']) <= 0) {
				$error .= Language::get('bp_setting_consume_times_must_bigerthan10');
			}
			if ($error != ''){
				showDialog($error,'','error');
			}
			$insert_arr = array();
			$insert_arr['cg_name'] = $_POST['g_name'];
			$insert_arr['cg_amountlimits'] = serialize($_POST['filter']['amount']);
			$insert_arr['cg_timeslimits'] = serialize($_POST['filter']['times']);
			$insert_arr['cg_shopid'] = $_POST['shopsel'];
			$insert_arr['cg_isdefault'] = $_POST['g_default'];
			$insert_arr['cg_ordernum'] = $_POST['g_ordernum'];
			$insert_arr['cg_updatetime'] = time();
			$insert_arr['cg_state'] = 1;
			$rs = $model->table('customergrade')->insert($insert_arr);
			if ($rs == true){
				if ($_POST['g_default'] == 1){//每个店铺只能有一个默认等级
					$model->table('customergrade')->where(array('cg_shopid'=>$_POST['shopsel'],'cg_id'=>array('neq',$rs)))->update(array('cg_isdefault'=>0));
				}
				showDialog(Language::get('bp_setting_customer_degree_addsucc'),'index.php?act=setting&op=ccgraderules&type=list','succ');
			}else{
				showDialog(Language::get('bp_setting_customer_degree_addfailed'),'','error');
			}
		} else {
			$shop_list = $model->table('shop')->where(array('shop_isuse'=>1))->select();
			Tpl::output('shop_list',$shop_list);
			//左侧菜单
			$this->setleftmenu('ccgraderules');
			//模板输出
			Tpl::showpage('setting_ccgraderulesadd');
		}
	}
	/**
	 * 检验会员等级是否存在
	 */
	public function ccgraderules_checkname(){
		//查询采购单信息
		$model = Model();
		$cg_info = $model->table('customergrade')->where(array('cg_name'=>$_GET['gname'],'cg_shopid'=>$_GET['shopid']))->find();
		if (empty($pur_info)){
			echo 'true'; die;
		}else{
			if ($cg_info['cg_id'] == $_GET['cgid']){
				echo 'true'; die;
			}else {
				echo 'false'; die;
			}
		}
	}
	/**
	 * 编辑会员等级规则
	 */
	public function ccgraderules_edit(){
		$cgid = $_GET['cgid'];
		if ($cgid <= 0){
			$cgid = $_POST['cgid'];
		}
		if ($cgid <= 0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["shopsel"],"require"=>"true","message"=>Language::get('bp_setting_pls_choose_fit_shop'));
			$validate_arr[] = array("input"=>$_POST["g_name"],"require"=>"true","message"=>Language::get('bp_setting_pls_add_degree_name'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if (empty($_POST['filter']['amount'])){
				$error .= Language::get('bp_setting_pls_choose_consume_price_condition');
			}elseif ($_POST['filter']['amount']['type']=='between' && intval($_POST['filter']['amount']['start']) <= 0) {
				$error .= Language::get('bp_setting_consume_price_must_bigerthan10');
			}
			if (empty($_POST['filter']['times'])){
				$error .= Language::get('bp_setting_pls_choose_consume_times_condition');
			}elseif ($_POST['filter']['times']['type']=='between' && intval($_POST['filter']['times']['start']) <= 0) {
				$error .= Language::get('bp_setting_consume_times_must_bigerthan10');
			}
			if ($error != ''){
				showDialog($error,'','error');
			}
			$update_arr = array();
			$update_arr['cg_name'] = $_POST['g_name'];
			$update_arr['cg_amountlimits'] = serialize($_POST['filter']['amount']);
			$update_arr['cg_timeslimits'] = serialize($_POST['filter']['times']);
			$update_arr['cg_shopid'] = $_POST['shopsel'];
			$update_arr['cg_isdefault'] = $_POST['g_default'];
			$update_arr['cg_ordernum'] = $_POST['g_ordernum'];
			$update_arr['cg_updatetime'] = time();
			$rs = $model->table('customergrade')->where(array('cg_id'=>$cgid))->update($update_arr);
			if ($rs == true){
				if ($_POST['g_default'] == 1){//每个店铺只能有一个默认等级
					$model->table('customergrade')->where(array('cg_shopid'=>$_POST['shopsel'],'cg_id'=>array('neq',$cgid)))->update(array('cg_isdefault'=>0));
				}
				showDialog(Language::get('bp_setting_customer_degree_editsucc'),'index.php?act=setting&op=ccgraderules&type=list','succ');
			}else{
				showDialog(Language::get('bp_setting_customer_degree_editfailed'),'','error');
			}
		} else {
			$shop_list = $model->table('shop')->where(array('shop_isuse'=>1))->select();
			Tpl::output('shop_list',$shop_list);
			//查询等级信息
			$cg_info = $model->table('customergrade')->where(array('cg_id'=>$cgid))->find();
			$cg_info['cg_amountlimits_arr'] =  $cg_info['cg_amountlimits']?unserialize($cg_info['cg_amountlimits']):'';
			$cg_info['cg_timeslimits_arr'] =  $cg_info['cg_timeslimits']?unserialize($cg_info['cg_timeslimits']):'';
			Tpl::output('cg_info',$cg_info);
			//左侧菜单
			$this->setleftmenu('ccgraderules');
			//模板输出
			Tpl::showpage('setting_ccgraderulesadd');
		}
	}
	/**
	 * 编辑会员等级规则排序
	 */
	public function ccgraderules_order(){
		$cgid = intval($_GET['cgid']);
		if ($cgid <= 0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		$rs = $model->table('customergrade')->where(array('cg_id'=>$cgid))->update(array('cg_ordernum'=>$_GET['ordernum']));
		if ($rs){
			showDialog(Language::get('bp_setting_sort_succ'),'','succ');
		}else{
			showDialog(Language::get('bp_setting_sort_failed'),'','error');
		}
	}
	/**
	 * 删除会员等级规则排序
	 */
	public function ccgraderules_del(){
		$cgid = $_GET['cgid'];
		if (empty($cgid)){
			$cgid = $_POST['cgid'];
		}
		if (empty($cgid)){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		$where = array();
		if (is_array($cgid)){
			$where['cg_id'] = array('in',$cgid);
		}else{
			$where['cg_id'] = $cgid;
		}
		$rs = $model->table('customergrade')->where($where)->delete();
		if ($rs){			
			showDialog(Language::get('bp_setting_delete_succ'),'index.php?act=setting&op=ccgraderules','succ');
		}else{
			showDialog(Language::get('bp_setting_delete_failed'),'','error');
		}
	}
	/**
	 * 店铺列表
	 */
	public function shop_listOp(){
		$model = Model();
		$where_condition = array();
		if(trim($_GET['search_content']) != ''){
			$where_condition['shop_name'] = array('like','%'.trim($_GET['search_content']).'%');
			Tpl::output('search_content',trim($_GET['search_content']));
		}
		if(intval($_GET['shop_platform']) > 0){
			$where_condition['shop_platform'] = intval($_GET['shop_platform']);
		}
		if(intval($_GET['shop_class']) > 0){
			$where_condition['shop_class'] = intval($_GET['shop_class']);
		}
		//调取店铺列表
		$shop_list = $model->table('shop')->where($where_condition)->page(10)->order('shop_addtime desc')->select();
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		//处理数组信息
		if(!empty($shop_list)){
			foreach ($shop_list as $k=>$v){
				$shop_list[$k]['shop_class'] = $dic_array['shop_class']['child_option'][$v['shop_class']]['cd_name'];
			}
		}
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		Tpl::output('dic_array',$dic_array);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('shop_list');
		/**
		 * 模板输出
		 */
		Tpl::output('shop_list',$shop_list);
		Tpl::output('show_page',$model->showpage(2));
		Tpl::showpage('shop_list');
	}
	/**
	 * 新增店铺
	 */
	public function shop_addOp(){
		$model = Model();
		if(chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["shop_name"],"require"=>"true","message"=>Language::get('bp_setting_pls_add_shopname'));
			$validate_arr[] = array("input"=>$_POST["shop_platform"],"require"=>"true","message"=>Language::get('bp_setting_pls_choose_platform'));
			$validate_arr[] = array("input"=>$_POST["shop_url"],"require"=>"true","message"=>Language::get('bp_setting_pls_add_shopurl'));
			$validate_arr[] = array("input"=>$_POST["shop_contact"],"require"=>"true","message"=>Language::get('bp_setting_pls_add_contact'));
			$validate_arr[] = array("input"=>$_POST["shop_default"],"require"=>"true","message"=>Language::get('bp_setting_pls_choose_whether_defaultshop'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			$insert_array = array();
			$insert_array['shop_name'] = trim($_POST['shop_name']);
			$insert_array['shop_platform'] = intval($_POST['shop_platform']);
			$insert_array['shop_class'] = intval($_POST['shop_class']);
			$insert_array['shop_url'] = trim($_POST['shop_url']);
			$insert_array['shop_province'] = trim($_POST['shop_province']);
			$insert_array['shop_city'] = trim($_POST['shop_city']);
			$insert_array['shop_district'] = trim($_POST['shop_district']);
			$insert_array['shop_address'] = trim($_POST['shop_address']);
			$insert_array['shop_postcode'] = trim($_POST['shop_postcode']);
			$insert_array['shop_contact'] = trim($_POST['shop_contact']);
			$insert_array['shop_phone'] = trim($_POST['shop_phone']);
			$insert_array['shop_mobilephone'] = trim($_POST['shop_mobilephone']);
			$insert_array['shop_default'] = intval($_POST['shop_default']);
			$insert_array['shop_isuse'] = intval($_POST['shop_isuse']);
			$insert_array['shop_addstaff'] = $_SESSION['member_id'];
			$insert_array['shop_addtime'] = time();
			//处理默认店铺
			if(intval($_POST['shop_default']) == 1){
				$model->table('shop')->where(true)->update(array('shop_default'=>0));
			}
			$rs = $model->table('shop')->insert($insert_array);
			if($rs){
				H('shop',true);
				showDialog(Language::get('bp_setting_shop_addsucc'),'index.php?act=setting&op=shop_list','succ');
			}else{
				showDialog(Language::get('bp_setting_shop_addfailed'),'','error');
			}
		}
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		Tpl::output('dic_array',$dic_array);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('shop_list');
		/**
		 * 模板输出
		 */
		Tpl::showpage('shop_add');
	}
	/**
	 * 编辑店铺
	 */
	public function shop_editOp(){
		$model = Model();
		if(chksubmit()){
			if(intval($_POST['shop_id']) <= 0){
				showDialog(Language::get('wrong_argument'));
			}
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["shop_name"],"require"=>"true","message"=>Language::get('bp_setting_pls_add_shopname'));
			$validate_arr[] = array("input"=>$_POST["shop_platform"],"require"=>"true","message"=>Language::get('bp_setting_pls_choose_platform'));
			$validate_arr[] = array("input"=>$_POST["shop_url"],"require"=>"true","message"=>Language::get('bp_setting_pls_add_shopurl'));
			$validate_arr[] = array("input"=>$_POST["shop_contact"],"require"=>"true","message"=>Language::get('bp_setting_pls_add_contact'));
			$validate_arr[] = array("input"=>$_POST["shop_default"],"require"=>"true","message"=>Language::get('bp_setting_pls_choose_whether_defaultshop'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			$update_array = array();
			$update_array['shop_name'] = trim($_POST['shop_name']);
			$update_array['shop_platform'] = intval($_POST['shop_platform']);
			$update_array['shop_class'] = intval($_POST['shop_class']);
			$update_array['shop_url'] = trim($_POST['shop_url']);
			$update_array['shop_province'] = trim($_POST['shop_province']);
			$update_array['shop_city'] = trim($_POST['shop_city']);
			$update_array['shop_district'] = trim($_POST['shop_district']);
			$update_array['shop_address'] = trim($_POST['shop_address']);
			$update_array['shop_postcode'] = trim($_POST['shop_postcode']);
			$update_array['shop_contact'] = trim($_POST['shop_contact']);
			$update_array['shop_phone'] = trim($_POST['shop_phone']);
			$update_array['shop_mobilephone'] = trim($_POST['shop_mobilephone']);
			$update_array['shop_default'] = intval($_POST['shop_default']);
			$update_array['shop_isuse'] = intval($_POST['shop_isuse']);
			//处理默认店铺
			if(intval($_POST['shop_default']) == 1){
				$model->table('shop')->where(true)->update(array('shop_default'=>0));
			}
			$rs = $model->table('shop')->where(array('shop_id'=>intval($_POST['shop_id'])))->update($update_array);
			if($rs){
				H('shop',true);
				showDialog(Language::get('bp_setting_shop_editsucc'),'index.php?act=setting&op=shop_list','succ');
			}else{
				showDialog(Language::get('bp_setting_shop_editfailed'),'','error');
			}
		}
		$shop_id = intval($_GET['shop_id']);
		if($shop_id<0){
			showDialog(Language::get('wrong_argument'));
		}
		$shop_info = $model->table('shop')->where(array('shop_id'=>$shop_id))->find();
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		Tpl::output('dic_array',$dic_array);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('shop_list');
		/**
		 * 模板输出
		 */
		Tpl::output('shop_info',$shop_info);
		Tpl::showpage('shop_edit');
	}
	/**
	 * 查看店铺
	 */
	public function shop_viewOp(){
		$model = Model();
		$shop_id = intval($_GET['shop_id']);
		if($shop_id<0){
			showDialog(Language::get('wrong_argument'));
		}
		$shop_info = $model->field('shop.*,user.user_truename')->table('shop,user')->join('left')->on('shop.shop_addstaff=user.user_id')->where(array('shop_id'=>$shop_id))->find();
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		$shop_info['shop_class'] = $dic_array['shop_class']['child_option'][$shop_info['shop_class']]['cd_name'];
		/**
		 * 模板输出
		 */
		Tpl::output('shop_info',$shop_info);
		Tpl::output('html_title',Language::get('bp_setting_shop_detailinfo'));
		Tpl::showpage('shop_view','windowopen_layout');
	}
	/**
	 * 设置为默认店铺
	 */
	public function shop_setdefaultOp(){
		$model = Model();
		$shop_id = intval($_GET['shop_id']);
		if($shop_id<0){
			showDialog(Language::get('wrong_argument'));
		}
		$model->table('shop')->where(true)->update(array('shop_default'=>0));
		$rs = $model->table('shop')->where(array('shop_id'=>$shop_id))->update(array('shop_default'=>1));
		if($rs){
			H('shop',true);
			showDialog(Language::get('bp_setting_default_shop_settingsucc'),'index.php?act=setting&op=shop_list','succ');
		}else{
			showDialog(Language::get('bp_setting_default_shop_settingfailed'),'','error');
		}
	}
	/**
	 * 解除店铺绑定
	 */
	public function shop_unconnectOp(){
		$model = Model();
		$shop_id = intval($_GET['shop_id']);
		if($shop_id<0){
			showDialog(Language::get('wrong_argument'));
		}
		$rs = $model->table('shop')->where(array('shop_id'=>$shop_id))->update(array('shop_connect'=>0,'shop_platinfo'=>''));
		if($rs){
			H('shop',true);
			showDialog(Language::get('bp_setting_shop_unconnect_succ'),'index.php?act=setting&op=shop_list','succ');
		}else{
			showDialog(Language::get('bp_setting_shop_unconnect_failed'),'','error');
		}
	}
	/**
	 * 绑定店铺
	 */
	public function shop_connectOp(){
		$model = Model();
		$shop_id = intval($_GET['shop_id']);
		if($shop_id<0){
			showDialog(Language::get('wrong_argument'));
		}
		if(trim($_GET['exc']) == 'ok'){
			switch (trim($_GET['type'])){
				case 'tb':
					$rs = $model->table('shop')->where(array('shop_id'=>$shop_id))->update(array('shop_connect'=>1,'shop_platinfo'=>serialize(array('shop_type'=>intval($_GET['shop_type']),'tb_account'=>trim($_GET['tb_account']),'session'=>trim($_GET['session']),'refresh_token'=>trim($_GET['refresh_token'])))));
					break;
				case 'shopnc':
					$rs = $model->table('shop')->where(array('shop_id'=>$shop_id))->update(array('shop_connect'=>1,'shop_platinfo'=>serialize(array('shopnc_apiurl'=>trim($_GET['shopnc_apiurl']),'shopnc_sid'=>trim($_GET['shopnc_sid']),'shopnc_sk'=>trim($_GET['shopnc_sk'])))));
					break;
				case 'shopex':
					$rs = $model->table('shop')->where(array('shop_id'=>$shop_id))->update(array('shop_connect'=>1,'shop_platinfo'=>serialize(array('shopex_apiurl'=>trim($_GET['shopex_apiurl'])))));
					break;
			}
			if($rs){
				H('shop',true);
				echo json_encode(array('done'=>true));die;
			}else{
				echo json_encode(array('done'=>false));die;
			}
		}
		//调取店铺平台信息
		$shop_info = $model->field('shop_id,shop_name,shop_connect,shop_platform')->table('shop')->where(array('shop_id'=>$shop_id))->find();
		if(empty($shop_info)){
			showDialog(Language::get('bp_setting_cannot_find_shopinfo'));
		}
		if($shop_info['shop_connect'] == 1){
			showDialog(Language::get('bp_setting_shop_have_connected'));
		}
		Tpl::output('shop_info',$shop_info);
		switch ($shop_info['shop_platform']){
			case 1:
				$tpl_name = 'shop_connect_shopnc';
				break;
			case 2:
				$tpl_name = 'shop_connect_tb';
				break;
			case 3:
				$tpl_name = 'shop_connect_shopex';
				break;
			case 4:
				break;
		}
		Tpl::showpage($tpl_name,'windowopen_layout');
	}
	/**
	 * 短信配置
	 */
	public function smstplOp(){
		include('setting_template.php');
		$settingtemplate_class = new settingtemplateControl();
		if (!empty($_GET['type'])){
			$funname = "template_".$_GET['type'];
			if (method_exists($settingtemplate_class,$funname)){
				$settingtemplate_class->$funname('sms');
			}
		}else{
			$settingtemplate_class->template_clist('sms');
		}
	}
	/**
	 * 邮件配置
	 */
	public function emailtplOp(){
		include('setting_template.php');
		$settingtemplate_class = new settingtemplateControl();
		if (!empty($_GET['type'])){
			$funname = "template_".$_GET['type'];
			if (method_exists($settingtemplate_class,$funname)){
				$settingtemplate_class->$funname('email');
			}
		}else{
			$settingtemplate_class->template_clist('email');
		}
	}
	/**
	 * 设置左菜单
	 */
	public function setleftmenu($menu_key=''){
		$arr = array();
		$arr[0] = array('menu_name'=>Language::get('bp_setting_system_setting'),	'menu_url'=>'#');
		$arr[0]['submenu'][0] = array('menu_key'=>'shop_list','menu_name'=>Language::get('bp_home_shop_manage'),'menu_act'=>'setting','menu_op'=>'shop_list');
		$arr[0]['submenu'][1] = array('menu_key'=>'base_setting','menu_name'=>Language::get('bp_home_basic_setting'),'menu_act'=>'setting','menu_op'=>'base_setting');
		$arr[0]['submenu'][2] = array('menu_key'=>'sea_setting','menu_name'=>Language::get('bp_setting_customersea_setting'),'menu_act'=>'setting','menu_op'=>'sea_setting');
		$arr[0]['submenu'][3] = array('menu_key'=>'index_setting','menu_name'=>Language::get('bp_setting_index_setting'),'menu_act'=>'setting','menu_op'=>'index_setting');
		$arr[0]['submenu'][4] = array('menu_key'=>'personaltax_setting','menu_name'=>Language::get('bp_setting_incometax_setting'),'menu_act'=>'setting','menu_op'=>'personaltax_setting');
		$arr[0]['submenu'][5] = array('menu_key'=>'salepercentage_setting','menu_name'=>Language::get('bp_setting_salepercentage_setting'),'menu_act'=>'setting','menu_op'=>'salepercentage_setting');
		$arr[1] = array('menu_name'=>Language::get('bp_home_active_setting'),	'menu_url'=>'#');
		$arr[1]['submenu'][0] = array('menu_key'=>'ccgraderules','menu_name'=>Language::get('bp_setting_customer_degree'),'menu_act'=>'setting','menu_op'=>'ccgraderules');
		$arr[2] = array('menu_name'=>Language::get('bp_home_sms_setting'),	'menu_url'=>'#');
		$arr[2]['submenu'][0] = array('menu_key'=>'tplsms','menu_name'=>Language::get('bp_setting_sms_template'),'menu_act'=>'setting','menu_op'=>'smstpl','menu_url'=>'index.php?act=setting&op=smstpl&type=list','linktype'=>'0');
		$arr[2]['submenu'][1] = array('menu_key'=>'tplclasssms','menu_name'=>Language::get('bp_setting_template_class'),'menu_act'=>'setting','menu_op'=>'smstpl','menu_url'=>'index.php?act=setting&op=smstpl&type=clist','linktype'=>'0');
		$arr[3] = array('menu_name'=>Language::get('bp_home_edm_setting'),	'menu_url'=>'#');
		$arr[3]['submenu'][0] = array('menu_key'=>'tplemail','menu_name'=>Language::get('bp_setting_edm_template'),'menu_act'=>'setting','menu_op'=>'emailtpl','menu_url'=>'index.php?act=setting&op=emailtpl&type=list','linktype'=>'0');
		$arr[3]['submenu'][1] = array('menu_key'=>'tplclassemail','menu_name'=>Language::get('bp_setting_edm_class'),'menu_act'=>'setting','menu_op'=>'emailtpl','menu_url'=>'index.php?act=setting&op=emailtpl&type=clist','linktype'=>'0');
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}