<?php
/**
 * 日程管理
 *
 *
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class scheduleControl extends BaseHomeControl{
	public function __construct(){
		parent::__construct();
		Language::read('schedule');
	}
	/**
	 * 日程列表
	 */
	public function schedule_listOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 调取日程信息
		 */
		//处理搜索表单
		$search_where = '';
		if(trim($_GET['search_content'])){
			$search_where .= " and schedule.cs_subject like '%".trim($_GET['search_content'])."%'";
			Tpl::output('search_content',trim($_GET['search_content']));
		}
		$search_where .= " and schedule.cs_staff_id=".$_SESSION['member_id'];
		$search_where = substr($search_where,5);
		$schedule_list = $model->field('schedule.*,customer.cc_name,user.user_truename')->table('schedule,customer,user')->join('left')->on('schedule.cc_id=customer.cc_id,schedule.cs_staff_id=user.user_id')->where($search_where)->page(10)->order('schedule.cs_addtime desc')->select();
		Tpl::output('schedule_list',$schedule_list);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('schedule_list');
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		/**
		 * 模板输出
		 */
		Tpl::output('show_page',$model->showpage(2));
		Tpl::output('dic_array',$dic_array);
		Tpl::showpage('schedule_list');
	}
	/**
	 * 新添加日程
	 */
	public function schedule_addOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 添加日程
		 */
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["cs_subject"],"require"=>"true","message"=>Language::get('bp_schedule_pls_addsubject'));
			$validate_arr[] = array("input"=>$_POST["start_date"],"require"=>"true","message"=>Language::get('bp_schedule_pls_choose_startdate'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			$insert_array = array();
			$insert_array['cc_id'] = intval($_POST['cc_id']);
			if($_POST['chance_id'] != ''){
				$insert_array['cs_chanceid'] = intval($_POST['chance_id']);
			}
			$insert_array['cs_subject'] = trim($_POST['cs_subject']);
			$insert_array['cs_staff_id'] = $_SESSION['member_id'];
			$insert_array['cs_addtime'] = time();
			$insert_array['cs_start_time'] = strtotime(trim($_POST['start_date']).' '.trim($_POST['start_time']));
			$insert_array['cs_end_time'] = trim($_POST['end_date'])!=''?strtotime(trim($_POST['end_date']).' '.trim($_POST['end_time'])):0;
			$insert_array['cs_note'] = trim($_POST['cs_content']);
			$insert_array['cs_type'] = intval($_POST['cs_type']);
			//处理部门信息
			$insert_array['cs_dp_id'] = $_SESSION['dp_id'];
			//插入到行动历史表中
			if(intval($_POST['cc_id'])>0){
				$insert_action_array = array();
				$insert_action_array['cc_id'] = intval($_POST['cc_id']);
				$insert_action_array['cca_addstaff'] = $_SESSION['member_id'];
				$insert_action_array['cca_addtime'] = time();
				$insert_action_array['cca_content'] = trim($_POST['cs_subject']).Language::get('nc_colon').trim($_POST['cs_content']);
				$insert_action_array['cca_start_time'] = strtotime(trim($_POST['start_date']).' '.trim($_POST['start_time']));
				$insert_action_array['cca_end_time'] = trim($_POST['end_date'])!=''?strtotime(trim($_POST['end_date']).' '.trim($_POST['end_time'])):0;
				$insert_action_array['cca_excstaff'] = $_SESSION['member_id'];
				$insert_action_array['cca_chanceid'] = intval($_POST['chance_id']);
				$insert_action_array['cca_dp_id']    = $_SESSION['dp_id'];
				$model->table('customer_action')->insert($insert_action_array);
			}
			$rs = $model->table('schedule')->insert($insert_array);
			$url = 'index.php?act=schedule&op=schedule_list';
			if ($_POST['source'] == 'chance'){
				$url = 'index.php?act=chance&op=chanceview&cid='.$insert_array['cs_chanceid'];
			}elseif ($_POST['source'] == 'customer'){
				$url = 'index.php?act=customer&op=customer_view&cc_id='.$insert_array['cc_id'];
			}
			if($rs != false){
				showDialog(Language::get('bp_schedule_pls_addsucc'),$url,'succ');
			}else{
				showDialog(Language::get('bp_schedule_pls_addfailed'),'','error');
			}
		}
		//如果来自会员详情页面则调取该会员信息
		if(intval($_GET['cc_id']) > 0){
			$cc_info  = $model->table('customer')->where(array('cc_id'=>intval($_GET['cc_id']),'cc_isdel'=>0))->find();
			if(empty($cc_info)){
				showMessage(Language::get('bp_schedule_member_info_notexist'));
			}else{
				Tpl::output('cc_info',$cc_info);
			}
		}elseif (intval($_GET['chance_id']) > 0){
			$chance_id = intval($_GET['chance_id']);
			//查询销售机会详细
			$chance_info = $model->table('chance')->where(array('cha_id'=>$chance_id,'cha_istrash'=>0))->find();
			if(empty($chance_info)){
				showMessage(Language::get('bp_schedule_sale_info_notexist'));
			}else{
				//查询会员
				$cc_info  = $model->table('customer')->where(array('cc_id'=>$chance_info['cha_customerid'],'cc_isdel'=>0))->find();
				if(empty($cc_info)){
					showMessage(Language::get('bp_schedule_sale_info_error'));
				}
				Tpl::output('chance_info',$chance_info);
			}
		}
		$source = '';
		if(intval($_GET['cc_id']) > 0){
			$source = 'customer';
		}elseif (intval($_GET['chance_id']) > 0){
			$source = 'chance';
		}
		Tpl::output('source',$source);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('schedule_list');
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		/**
		 * 模板输出
		 */
		Tpl::output('dic_array',$dic_array);
		Tpl::showpage('schedule_add');
	}
	/**
	 * 编辑日程
	 */
	public function schedule_editOp(){
		//调取日程信息
		$cs_id = intval($_GET['cs_id']);
		if($cs_id <= 0){
			$cs_id = intval($_POST['cs_id']);
		}
		if($cs_id <= 0){
			showMessage(Language::get('wrong_argument'));
		}
		$model = Model();
		$cs_info = $model->table('schedule')->where(array('cs_id'=>$cs_id))->find();
		if(empty($cs_info)){
			showMessage(Language::get('bp_schedule_cannot_find_scheinfo_cannotedit'));
		}
		/**
		 * 编辑日程
		 */
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["cs_subject"],"require"=>"true","message"=>Language::get('bp_schedule_pls_addsubject'));
			$validate_arr[] = array("input"=>$_POST["start_date"],"require"=>"true","message"=>Language::get('bp_schedule_pls_choose_startdate'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			$update_array = array();
			$update_array['cs_subject'] = trim($_POST['cs_subject']);
			$update_array['cs_start_time'] = strtotime(trim($_POST['start_date']).' '.trim($_POST['start_time']));
			$update_array['cs_end_time'] = trim($_POST['end_date'])!=''?strtotime(trim($_POST['end_date']).' '.trim($_POST['end_time'])):0;
			$update_array['cs_note'] = trim($_POST['cs_content']);
			$update_array['cs_type'] = intval($_POST['cs_type']);
			$rs = $model->table('schedule')->where(array('cs_id'=>$_POST['cs_id']))->update($update_array);			
			$url = 'index.php?act=schedule&op=schedule_list';
			if ($_POST['source'] == 'chance'){
				$url = 'index.php?act=chance&op=chanceview&cid='.$cs_info['cs_chanceid'];
			}elseif ($_POST['source'] == 'customer'){
				$url = 'index.php?act=customer&op=customer_view&cc_id='.$cs_info['cc_id'];
			}
			if($rs != false){
				showDialog(Language::get('bp_schedule_editsucc'),$url,'succ');
			}else{
				showDialog(Language::get('bp_schedule_editfailed'),'','error');
			}
		}else {
			//如果选择了会员则调取该会员信息
			if($cs_info['cc_id'] > 0){
				$cc_info  = $model->table('customer')->where(array('cc_id'=>$cs_info['cc_id']))->find();
				if(!empty($cc_info)){
					Tpl::output('cc_info',$cc_info);
				}
			}
			//如果选择了销售机会查询销售机会信息
			if($cs_info['cs_chanceid'] > 0){
				$chance_info  = $model->table('chance')->where(array('cha_id'=>$cs_info['cs_chanceid']))->find();
				if(!empty($chance_info)){
					Tpl::output('chance_info',$chance_info);
				}
			}
			$source = '';
			if(intval($_GET['cc_id']) > 0){
				$source = 'customer';
			}elseif (intval($_GET['chance_id']) > 0){
				$source = 'chance';
			}
			Tpl::output('source',$source);
			Tpl::output('cs_info',$cs_info);
			//左侧菜单
			$this->setleftmenu('schedule_list');
			//从缓存中调取数据字典信息
			$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
			/**
			 * 模板输出
			 */
			Tpl::output('dic_array',$dic_array);
			Tpl::showpage('schedule_edit');
		}
	}
	/**
	 * 删除日程信息
	 */
	public function schedule_delOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		$cs_id = intval($_GET['cs_id']);
		if($cs_id <= 0){
			showMessage(Language::get('wrong_argument'));
		}
		$rs = $model->table('schedule')->where(array('cs_id'=>$cs_id))->delete();
		if(intval($_GET['chance_id']) > 0){
			$jump_url = $url = 'index.php?act=chance&op=chanceview&cid='.intval($_GET['chance_id']);
		}elseif (intval($_GET['cc_id']) > 0){
			$jump_url = 'index.php?act=customer&op=customer_view&cc_id='.intval($_GET['cc_id']);
		}else{
			$jump_url = 'index.php?act=schedule&op=schedule_list';
		}
		if($rs != false){
			showDialog(Language::get('bp_schedule_delsucc'),$jump_url,'succ');
		}else{
			showDialog(Language::get('bp_schedule_delfailed'),'','error');
		}
	}
	/**
	 * 查看日程信息
	 */
	public function schedule_viewOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		
		$cs_id = intval($_GET['cs_id']);
		$cs_info = $model->field('schedule.*,customer.cc_name,customer.cc_dept_id,customer.cc_staff_id,user.user_truename')->table('schedule,customer,user')->join('left')->on('schedule.cc_id=customer.cc_id,schedule.cs_staff_id=user.user_id')->where('schedule.cs_id='.$cs_id)->find();
		if(empty($cs_info)){
			showMessage(Language::get('bp_schedule_cannot_find_scheinfo'),'','exception','error',1,0);
		}
		/*判断当前用户是否有查看权限*/
		if($_SESSION['member_id'] != $cs_info['cs_staff_id']){
			showMessage(Language::get('bp_schedule_noright_to_view'),'','exception','error',1,0);
		}
		Tpl::output('cs_info',$cs_info);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('schedule_list');
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		/**
		 * 模板输出
		 */
		Tpl::output('dic_array',$dic_array);
		Tpl::output('html_title',Language::get('bp_schedule_detail'));
		Tpl::showpage('schedule_view','windowopen_layout');
	}
	/**
	 * 设置左菜单
	 */
	private function setleftmenu($menu_key){
		$arr = array();
		$arr[0] = array('menu_name'=>Language::get('bp_home_mission'),	'menu_url'=>'#');
		$arr[0]['submenu'][0] = array('menu_key'=>'calendar_show','menu_name'=>Language::get('bp_home_calendar'),'menu_act'=>'work_calendar','menu_op'=>'calendar_show');
		$arr[0]['submenu'][1] = array('menu_key'=>'mission_list','menu_name'=>Language::get('bp_home_mission_manage'),'menu_act'=>'mission','menu_op'=>'mission_list');
		$arr[0]['submenu'][2] = array('menu_key'=>'schedule_list','menu_name'=>Language::get('bp_home_schedule_manage'),'menu_act'=>'schedule','menu_op'=>'schedule_list');
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}